<?php

use App\Models\Tournament;
use App\Models\User;

uses(\Illuminate\Foundation\Testing\RefreshDatabase::class);

test('can create tournament', function () {
    $tournament = Tournament::factory()->create([
        'name' => 'Test Tournament',
        'type' => 'single_elimination',
        'status' => 'draft',
    ]);

    expect($tournament->name)->toBe('Test Tournament');
    expect($tournament->type)->toBe('single_elimination');
    expect($tournament->status)->toBe('draft');
});

test('tournament can have players', function () {
    $tournament = Tournament::factory()->create();
    $user = User::factory()->create();
    
    $player = $tournament->players()->create([
        'user_id' => $user->id,
        'display_name' => 'Test Player',
        'status' => 'registered',
    ]);

    expect($tournament->players)->toHaveCount(1);
    expect($tournament->players->first()->display_name)->toBe('Test Player');
});

test('tournament can have teams', function () {
    $tournament = Tournament::factory()->create();
    $user = User::factory()->create();
    
    $team = $tournament->teams()->create([
        'name' => 'Test Team',
        'captain_id' => $user->id,
        'status' => 'active',
    ]);

    expect($tournament->teams)->toHaveCount(1);
    expect($tournament->teams->first()->name)->toBe('Test Team');
});
