<?php

use App\Models\Tournament;
use Illuminate\Foundation\Testing\RefreshDatabase;

uses(RefreshDatabase::class);

test('team registration page loads with tournament entry fee', function () {
    // Create an active tournament with entry fee
    $tournament = Tournament::factory()->create([
        'status' => 'active',
        'entry_fee' => 2500.00,
        'currency' => 'KES'
    ]);

    $response = $this->get('/register-team');

    $response->assertStatus(200);
    $response->assertInertia(fn ($page) => 
        $page->component('frontend/auth/RegisterTeam')
            ->has('registration_fee', 2500)
            ->has('tournament')
    );
});

test('team registration uses config fee when no active tournament', function () {
    // Create a tournament that is not active
    Tournament::factory()->create([
        'status' => 'draft',
        'entry_fee' => 2500.00
    ]);

    $response = $this->get('/register-team');

    $response->assertStatus(200);
    $response->assertInertia(fn ($page) => 
        $page->component('frontend/auth/RegisterTeam')
            ->has('registration_fee', 1000) // Default from config
    );
}); 