<!DOCTYPE html>
<html lang="en" xmlns="http://www.w3.org/1999/xhtml" xmlns:v="urn:schemas-microsoft-com:vml" xmlns:o="urn:schemas-microsoft-com:office:office">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="format-detection" content="telephone=no">
    <title><?php echo $__env->yieldContent('title', 'Milimus Tournament'); ?></title>
    
    <!--[if mso]>
    <noscript>
        <xml>
            <o:OfficeDocumentSettings>
                <o:PixelsPerInch>96</o:PixelsPerInch>
            </o:OfficeDocumentSettings>
        </xml>
    </noscript>
    <![endif]-->
    
    <style>
        /* Reset styles */
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            margin: 0 !important;
            padding: 0 !important;
            background-color: #f8fafc !important;
            font-family: 'Segoe UI', system-ui, -apple-system, BlinkMacSystemFont, 'Roboto', 'Helvetica Neue', Arial, sans-serif !important;
            line-height: 1.6 !important;
            color: #374151 !important;
            -webkit-text-size-adjust: 100% !important;
            -ms-text-size-adjust: 100% !important;
        }
        
        table {
            border-collapse: collapse !important;
            mso-table-lspace: 0pt !important;
            mso-table-rspace: 0pt !important;
        }
        
        img {
            border: 0 !important;
            height: auto !important;
            line-height: 100% !important;
            outline: none !important;
            text-decoration: none !important;
            -ms-interpolation-mode: bicubic !important;
        }
        
        /* Main container */
        .email-container {
            max-width: 600px !important;
            margin: 0 auto !important;
            background-color: #ffffff !important;
        }
        
        /* Header styles */
        .email-header {
            background: linear-gradient(135deg, #16a34a 0%, #22c55e 50%, #4ade80 100%) !important;
            padding: 40px 30px !important;
            text-align: center !important;
            position: relative !important;
        }
        
        .email-header::before {
            content: '' !important;
            position: absolute !important;
            top: 0 !important;
            left: 0 !important;
            right: 0 !important;
            bottom: 0 !important;
            background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><defs><pattern id="grain" width="100" height="100" patternUnits="userSpaceOnUse"><circle cx="25" cy="25" r="1" fill="rgba(255,255,255,0.1)"/><circle cx="75" cy="75" r="1" fill="rgba(255,255,255,0.1)"/><circle cx="50" cy="10" r="0.5" fill="rgba(255,255,255,0.05)"/></pattern></defs><rect width="100" height="100" fill="url(%23grain)"/></svg>') !important;
            opacity: 0.3 !important;
        }
        
        .logo-container {
            position: relative !important;
            z-index: 2 !important;
            margin-bottom: 20px !important;
        }
        
        .logo {
            width: 60px !important;
            height: 60px !important;
            background-color: rgba(255, 255, 255, 0.2) !important;
            border-radius: 50% !important;
            display: inline-flex !important;
            align-items: center !important;
            justify-content: center !important;
            font-size: 24px !important;
            font-weight: bold !important;
            color: #ffffff !important;
            margin-bottom: 15px !important;
            backdrop-filter: blur(10px) !important;
            border: 2px solid rgba(255, 255, 255, 0.3) !important;
        }
        
        .email-title {
            color: #ffffff !important;
            font-size: 28px !important;
            font-weight: 700 !important;
            margin: 0 !important;
            position: relative !important;
            z-index: 2 !important;
            text-shadow: 0 2px 4px rgba(0, 0, 0, 0.1) !important;
        }
        
        .email-subtitle {
            color: rgba(255, 255, 255, 0.9) !important;
            font-size: 16px !important;
            margin: 8px 0 0 0 !important;
            position: relative !important;
            z-index: 2 !important;
        }
        
        /* Content styles */
        .email-content {
            padding: 40px 30px !important;
            background-color: #ffffff !important;
        }
        
        .content-section {
            margin-bottom: 30px !important;
        }
        
        .content-section:last-child {
            margin-bottom: 0 !important;
        }
        
        .section-title {
            color: #16a34a !important;
            font-size: 22px !important;
            font-weight: 600 !important;
            margin: 0 0 15px 0 !important;
        }
        
        .section-text {
            color: #374151 !important;
            font-size: 16px !important;
            line-height: 1.6 !important;
            margin: 0 0 15px 0 !important;
        }
        
        /* OTP Code styles */
        .otp-container {
            text-align: center !important;
            margin: 30px 0 !important;
        }
        
        .otp-code {
            background: linear-gradient(135deg, #dc2626 0%, #ef4444 100%) !important;
            color: #ffffff !important;
            font-size: 36px !important;
            font-weight: 700 !important;
            padding: 25px 40px !important;
            border-radius: 16px !important;
            letter-spacing: 8px !important;
            display: inline-block !important;
            box-shadow: 0 10px 25px rgba(220, 38, 38, 0.3) !important;
            border: 3px solid rgba(255, 255, 255, 0.2) !important;
            text-shadow: 0 2px 4px rgba(0, 0, 0, 0.2) !important;
        }
        
        /* Info box styles */
        .info-box {
            background: linear-gradient(135deg, #f0f9ff 0%, #e0f2fe 100%) !important;
            border: 1px solid #bae6fd !important;
            border-radius: 12px !important;
            padding: 20px !important;
            margin: 20px 0 !important;
            position: relative !important;
        }
        
        .info-box::before {
            content: 'ℹ️' !important;
            position: absolute !important;
            top: 20px !important;
            left: 20px !important;
            font-size: 20px !important;
        }
        
        .info-box-content {
            padding-left: 35px !important;
        }
        
        .info-title {
            color: #0369a1 !important;
            font-weight: 600 !important;
            margin: 0 0 8px 0 !important;
        }
        
        .info-text {
            color: #075985 !important;
            font-size: 14px !important;
            margin: 0 !important;
        }
        
        /* Warning box styles */
        .warning-box {
            background: linear-gradient(135deg, #fef3c7 0%, #fde68a 100%) !important;
            border: 1px solid #f59e0b !important;
            border-radius: 12px !important;
            padding: 20px !important;
            margin: 20px 0 !important;
        }
        
        .warning-text {
            color: #92400e !important;
            font-size: 14px !important;
            margin: 0 !important;
        }
        
        /* Button styles */
        .btn {
            display: inline-block !important;
            padding: 15px 30px !important;
            background: linear-gradient(135deg, #16a34a 0%, #22c55e 100%) !important;
            color: #ffffff !important;
            text-decoration: none !important;
            border-radius: 50px !important;
            font-weight: 600 !important;
            font-size: 16px !important;
            text-align: center !important;
            box-shadow: 0 4px 15px rgba(22, 163, 74, 0.3) !important;
            transition: all 0.3s ease !important;
        }
        
        .btn:hover {
            box-shadow: 0 6px 20px rgba(22, 163, 74, 0.4) !important;
            transform: translateY(-2px) !important;
        }
        
        /* List styles */
        .styled-list {
            list-style: none !important;
            padding: 0 !important;
            margin: 15px 0 !important;
        }
        
        .styled-list li {
            position: relative !important;
            padding: 8px 0 8px 30px !important;
            color: #374151 !important;
            font-size: 15px !important;
        }
        
        .styled-list li::before {
            content: '✓' !important;
            position: absolute !important;
            left: 0 !important;
            top: 8px !important;
            color: #16a34a !important;
            font-weight: bold !important;
            font-size: 16px !important;
        }
        
        /* Footer styles */
        .email-footer {
            background-color: #f9fafb !important;
            padding: 30px !important;
            text-align: center !important;
            border-top: 1px solid #e5e7eb !important;
        }
        
        .footer-text {
            color: #6b7280 !important;
            font-size: 14px !important;
            margin: 0 0 10px 0 !important;
        }
        
        .footer-links {
            margin: 15px 0 !important;
        }
        
        .footer-link {
            color: #16a34a !important;
            text-decoration: none !important;
            font-size: 13px !important;
            margin: 0 10px !important;
        }
        
        .social-links {
            margin: 20px 0 10px 0 !important;
        }
        
        .social-link {
            display: inline-block !important;
            width: 32px !important;
            height: 32px !important;
            background-color: #16a34a !important;
            color: #ffffff !important;
            text-decoration: none !important;
            border-radius: 50% !important;
            margin: 0 5px !important;
            line-height: 32px !important;
            text-align: center !important;
            font-size: 14px !important;
        }
        
        /* Responsive styles */
        @media only screen and (max-width: 600px) {
            .email-container {
                width: 100% !important;
                max-width: 100% !important;
            }
            
            .email-header,
            .email-content,
            .email-footer {
                padding: 20px !important;
            }
            
            .email-title {
                font-size: 24px !important;
            }
            
            .otp-code {
                font-size: 28px !important;
                padding: 20px 25px !important;
                letter-spacing: 4px !important;
            }
            
            .section-title {
                font-size: 20px !important;
            }
        }
        
        /* Dark mode support */
        @media (prefers-color-scheme: dark) {
            .email-container {
                background-color: #1f2937 !important;
            }
            
            .email-content {
                background-color: #1f2937 !important;
            }
            
            .section-text {
                color: #d1d5db !important;
            }
            
            .email-footer {
                background-color: #111827 !important;
            }
        }
    </style>
</head>
<body>
    <div style="background-color: #f8fafc; padding: 20px 0;">
        <table role="presentation" cellspacing="0" cellpadding="0" border="0" width="100%">
            <tr>
                <td align="center">
                    <div class="email-container">
                        <!-- Header -->
                        <div class="email-header">
                            <div class="logo-container">
                                <div class="logo">M</div>
                            </div>
                            <h1 class="email-title"><?php echo $__env->yieldContent('header-title', 'Milimus Tournament'); ?></h1>
                            <p class="email-subtitle"><?php echo $__env->yieldContent('header-subtitle', 'Community Football Excellence'); ?></p>
                        </div>
                        
                        <!-- Content -->
                        <div class="email-content">
                            <?php echo $__env->yieldContent('content'); ?>
                        </div>
                        
                        <!-- Footer -->
                        <div class="email-footer">
                            <p class="footer-text">
                                <strong>Milimus Tournament</strong><br>
                                Building community through football excellence
                            </p>
                            
                            <div class="social-links">
                                <a href="#" class="social-link">f</a>
                                <a href="#" class="social-link">t</a>
                                <a href="#" class="social-link">i</a>
                                <a href="#" class="social-link">@</a>
                            </div>
                            
                            <div class="footer-links">
                                <a href="#" class="footer-link">UNSUBSCRIBE</a>
                                <a href="#" class="footer-link">PRIVACY POLICY</a>
                                <a href="#" class="footer-link">WEB</a>
                            </div>
                            
                            <p class="footer-text" style="margin-top: 15px;">
                                This is an automated message from Milimus Tournament System.<br>
                                Please do not reply to this email.
                            </p>
                        </div>
                    </div>
                </td>
            </tr>
        </table>
    </div>
</body>
</html><?php /**PATH D:\E - STARTUPS\WORK FOLDERS\PERSONAL\the-milimus-tournament\resources\views\emails\layouts\modern.blade.php ENDPATH**/ ?>