<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Player Participation Certificate</title>
    <style>
        @font-face {
            font-family: 'Montserrat-SemiBold';
            src: url('<?php echo e(public_path('fonts/Montserrat-SemiBold.ttf')); ?>') format('truetype');
            font-weight: 600;
            font-style: normal;
        }
        @font-face {
            font-family: 'Montserrat-Bold';
            src: url('<?php echo e(public_path('fonts/Montserrat-Bold.ttf')); ?>') format('truetype');
            font-weight: 700;
            font-style: normal;
        }
        @font-face {
            font-family: 'Montserrat-Regular';
            src: url('<?php echo e(public_path('fonts/Montserrat-Regular.ttf')); ?>') format('truetype');
            font-weight: 400;
            font-style: normal;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Montserrat-Regular', Arial, sans-serif;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            background-color: #f5f5f5;
            padding: 20px;
        }

        .certificate-container {
            width: 842px; /* A4 landscape width */
            height: 595px; /* A4 landscape height */
            position: relative;
            background-image: url("/Certificate.jpg");
            background-size: cover;
            background-position: center;
            background-repeat: no-repeat;
            box-shadow: 0 15px 35px rgba(0, 0, 0, 0.2);
            border-radius: 8px;
            overflow: hidden;
        }

        /* Text overlay styles */
        .text-overlay {
            position: absolute;
            width: 100%;
            height: 100%;
            z-index: 10;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
        }

        /* Certificate title */
        .certificate-title {
            font-family: 'Montserrat-Bold', sans-serif;
            font-size: 28px;
            color: #ffffff;
            text-transform: uppercase;
            letter-spacing: 3px;
            text-align: center;
            margin-bottom: 8px;
            text-shadow: 2px 2px 4px rgba(0, 0, 0, 0.5);
            position: absolute;
            top: 80px;
            left: 50%;
            transform: translateX(-50%);
        }

        .certificate-subtitle {
            font-family: 'Montserrat-Bold', sans-serif;
            font-size: 20px;
            color: #ffffff;
            text-transform: uppercase;
            letter-spacing: 2px;
            text-align: center;
            text-shadow: 2px 2px 4px rgba(0, 0, 0, 0.5);
            position: absolute;
            top: 120px;
            left: 50%;
            transform: translateX(-50%);
        }

        /* Main content area */
        .main-content {
            position: absolute;
            top: 70%;
            left: 50%;
            transform: translate(-50%, -50%);
            text-align: center;
            width: 80%;
            max-width: 600px;
        }

        /* "This is to certify that" text */
        .certify-text {
            font-family: 'Montserrat-Bold', sans-serif;
            font-size: 18px;
            color: #4f585a;
            text-transform: uppercase;
            letter-spacing: 1px;
            margin-bottom: 20px;
            text-shadow: 1px 1px 2px rgba(255, 255, 255, 0.8);
        }

        /* Player name */
        .player-name {
            font-family: 'Segoe UI', cursive;
            font-size: 40px;
            color: #2b672f;
            font-weight: bold;
            margin: 20px 0;
            text-shadow: 2px 2px 4px rgba(255, 255, 255, 0.8);
            line-height: 1.1;
        }

        /* Team info */
        .team-info {
            font-family: 'Montserrat-SemiBold', sans-serif;
            font-size: 16px;
            color: #4f585a;
            margin: 10px 0;
            text-shadow: 1px 1px 2px rgba(255, 255, 255, 0.8);
        }

        /* Description text */
        .description-text {
            font-family: 'Segoe UI', sans-serif;
            font-size: 15px;
            color: #4f585a;
            line-height: 1.6;
            margin: 30px 0;
            text-shadow: 1px 1px 2px rgba(255, 255, 255, 0.8);
            max-width: 500px;
            margin-left: auto;
            margin-right: auto;
        }

        /* Player stats section */
        .player-stats {
            position: absolute;
            top: 200px;
            left: 50%;
            transform: translateX(-50%);
            display: flex;
            gap: 20px;
            flex-wrap: wrap;
            justify-content: center;
            z-index: 15;
        }

        .stat-item {
            text-align: center;
            background: rgba(255, 255, 255, 0.9);
            padding: 8px 12px;
            border-radius: 6px;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        }

        .stat-value {
            font-family: 'Montserrat-Bold', sans-serif;
            font-size: 18px;
            color: #2b672f;
            font-weight: bold;
        }

        .stat-label {
            font-family: 'Montserrat-Regular', sans-serif;
            font-size: 10px;
            color: #4f585a;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        /* Footer section */
        .footer-section {
            position: absolute;
            bottom: 40px;
            width: 100%;
            display: flex;
            justify-content: space-between;
            padding: 0 60px;
            z-index: 15;
        }

        .certificate-id-text, .generated-date-text {
            font-family: 'Montserrat-Regular', sans-serif;
            font-size: 14px;
            line-height: 1.4;
            text-shadow: 1px 1px 2px rgba(255, 255, 255, 0.8);
        }

        .certificate-id-label {
            font-family: 'Montserrat-Bold', sans-serif;
            color: #d52f20;
            font-weight: 700;
        }

        .certificate-id-value {
            font-family: 'Montserrat-Regular', sans-serif;
            color: #50585a;
        }

        .generated-date-label {
            font-family: 'Montserrat-Bold', sans-serif;
            color: #2b672f;
            font-weight: 700;
        }

        .generated-date-value {
            font-family: 'Montserrat-Regular', sans-serif;
            color: #50585a;
        }

        /* Print styles */
        @media print {
            body {
                background: white;
                padding: 0;
            }
            
            .certificate-container {
                box-shadow: none;
                border-radius: 0;
                width: 100%;
                height: 100vh;
            }
        }
    </style>
</head>
<body>
    <div class="certificate-container">
        <div class="text-overlay">
            <!-- Certificate Title -->
            <h1 class="certificate-title">Certificate of Participation</h1>
            <h2 class="certificate-subtitle">Player Achievement</h2>

            <!-- Player Statistics -->
            <div class="player-stats">
                <div class="stat-item">
                    <div class="stat-value"><?php echo e($player_stats['matches_played'] ?? 0); ?></div>
                    <div class="stat-label">Matches</div>
                </div>
                <div class="stat-item">
                    <div class="stat-value"><?php echo e($player_stats['matches_won'] ?? 0); ?></div>
                    <div class="stat-label">Wins</div>
                </div>
                <div class="stat-item">
                    <div class="stat-value"><?php echo e($player_stats['win_rate'] ?? 0); ?>%</div>
                    <div class="stat-label">Win Rate</div>
                </div>
                <div class="stat-item">
                    <div class="stat-value"><?php echo e($player_stats['current_streak'] ?? 0); ?></div>
                    <div class="stat-label">Streak</div>
                </div>
                <div class="stat-item">
                    <div class="stat-value"><?php echo e($player_stats['global_rating'] ?? 0); ?></div>
                    <div class="stat-label">Rating</div>
                </div>
                <div class="stat-item">
                    <div class="stat-value"><?php echo e($player_stats['tournaments_won'] ?? 0); ?></div>
                    <div class="stat-label">Titles</div>
                </div>
            </div>
            
            <!-- Main Content -->
            <div class="main-content">
                <p class="certify-text">This is to certify that</p>
                <h2 class="player-name"><?php echo e($player_name ?? 'Player Name'); ?></h2>
                <p class="team-info"><?php echo e($position ?? 'Player'); ?> - <?php echo e($team_name ?? 'Team Name'); ?></p>
                <p class="description-text">
                    <?php echo e($description ?? 'has successfully participated in the tournament league and has demonstrated exceptional sportsmanship, skill, and dedication throughout the competition.'); ?>

                </p>
            </div>
            
            <!-- Footer Section -->
            <div class="footer-section">
                <div class="certificate-id-text">
                    <div class="certificate-id-label">Certificate ID:</div>
                    <div class="certificate-id-value"><?php echo e($digital_id ?? 'PID-000001-ABC12345'); ?></div>
                </div>
                <div class="generated-date-text">
                    <div class="generated-date-label">Generated on</div>
                    <div class="generated-date-value"><?php echo e($issued_date ?? now()->format('F j, Y')); ?></div>
                </div>
            </div>
        </div>
    </div>
</body>
</html>
<?php /**PATH D:\E - STARTUPS\WORK FOLDERS\PERSONAL\the-milimus-tournament\resources\views\certificates\player.blade.php ENDPATH**/ ?>