<!-- Tournament Management Documentation -->

<div class="section-card">
    <h2 class="text-4xl font-bold mb-6">🏆 Tournament Management Workflow</h2>
    
    <div class="bg-blue-50 border-l-4 border-blue-500 p-6 rounded-r-lg mb-6">
        <p class="text-lg text-blue-900 font-semibold">📖 What You'll Learn</p>
        <ul class="mt-3 space-y-2 text-blue-800">
            <li>✅ Complete tournament lifecycle from creation to completion</li>
            <li>✅ Tournament status transitions and decision logic</li>
            <li>✅ Registration management (open/close/full)</li>
            <li>✅ Team approval process for tournaments</li>
            <li>✅ Bracket generation and match scheduling</li>
            <li>✅ All notifications sent during tournament events</li>
        </ul>
    </div>
</div>

<!-- Overview -->
<div class="section-card">
    <h3 class="text-2xl font-bold mb-4 flex items-center">
        <span class="step-number">1</span>
        Overview
    </h3>
    
    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
        <div>
            <h4 class="font-bold text-lg mb-3 text-blue-600">🏆 What is Tournament Management?</h4>
            <p class="text-gray-700 leading-relaxed">
                Tournament management encompasses the complete lifecycle of tournaments from initial creation 
                by admins through registration periods, bracket generation, match execution, and final completion 
                with awards and certificates.
            </p>
        </div>

        <div>
            <h4 class="font-bold text-lg mb-3 text-green-600">👥 Who Manages Tournaments?</h4>
            <ul class="space-y-2 text-gray-700">
                <li class="flex items-start">
                    <span class="text-green-500 mr-2">•</span>
                    <span><strong>Admins:</strong> Create and configure tournaments</span>
                </li>
                <li class="flex items-start">
                    <span class="text-green-500 mr-2">•</span>
                    <span><strong>Organizers:</strong> Manage registration and brackets</span>
                </li>
                <li class="flex items-start">
                    <span class="text-green-500 mr-2">•</span>
                    <span><strong>System:</strong> Auto-schedule matches, send notifications</span>
                </li>
            </ul>
        </div>

        <div>
            <h4 class="font-bold text-lg mb-3 text-purple-600">🏷️ Tournament Types</h4>
            <ul class="space-y-2 text-gray-700">
                <li class="flex items-start">
                    <span class="text-purple-500 mr-2">•</span>
                    <span><strong>Knockout:</strong> Single elimination</span>
                </li>
                <li class="flex items-start">
                    <span class="text-purple-500 mr-2">•</span>
                    <span><strong>Double Elimination:</strong> Loser's bracket</span>
                </li>
                <li class="flex items-start">
                    <span class="text-purple-500 mr-2">•</span>
                    <span><strong>Round Robin:</strong> Everyone plays everyone</span>
                </li>
                <li class="flex items-start">
                    <span class="text-purple-500 mr-2">•</span>
                    <span><strong>Group Stage:</strong> Groups then knockout</span>
                </li>
            </ul>
        </div>

        <div>
            <h4 class="font-bold text-lg mb-3 text-orange-600">⏱️ Typical Timeline</h4>
            <ul class="space-y-2 text-gray-700">
                <li class="flex justify-between">
                    <span>Draft to Published:</span>
                    <span class="font-semibold">1-3 days</span>
                </li>
                <li class="flex justify-between">
                    <span>Registration Period:</span>
                    <span class="font-semibold">1-4 weeks</span>
                </li>
                <li class="flex justify-between">
                    <span>Tournament Duration:</span>
                    <span class="font-semibold">1-2 weeks</span>
                </li>
                <li class="flex justify-between">
                    <span>Post-Tournament:</span>
                    <span class="font-semibold">1-2 days</span>
                </li>
            </ul>
        </div>
    </div>
</div>

<!-- Tournament Lifecycle Diagram -->
<div class="section-card">
    <h3 class="text-2xl font-bold mb-4 flex items-center">
        <span class="step-number">2</span>
        Complete Tournament Lifecycle
    </h3>

    <div class="mermaid bg-white p-6 rounded-lg shadow-inner">
flowchart TD
    Start([👨‍💼 Admin Creates Tournament])
    Start --> StatusDraft[Status: DRAFT<br/>• Basic info entered<br/>• Configuration set<br/>• Not visible to public]
    
    StatusDraft --> AdminReview{Admin Reviews<br/>& Approves?}
    AdminReview -->|No| ModifyDraft[Admin Modifies<br/>Tournament Details]
    ModifyDraft --> StatusDraft
    
    AdminReview -->|Yes| Publish[Publish Tournament<br/>• published_at timestamp set<br/>• Now visible to public]
    
    Publish --> NotifyPublished[📧 Send Notifications:<br/>• TournamentPublishedNotification all users<br/>• TournamentPublishedAdminNotification]
    
    NotifyPublished --> RegStatus{Registration<br/>Status?}
    RegStatus -->|Closed| StatusPublished[Status: PUBLISHED<br/>Registration: CLOSED<br/>• Visible but can't register]
    RegStatus -->|Open| OpenReg[Status: PUBLISHED<br/>Registration: OPEN<br/>• Teams can register]
    
    StatusPublished --> OpenRegLater{Open Registration<br/>Date Reached?}
    OpenRegLater -->|No| Wait[Wait for<br/>Registration Date]
    Wait --> OpenRegLater
    OpenRegLater -->|Yes| OpenRegistration[Open Registration<br/>• registration_status: open]
    
    OpenRegistration --> NotifyRegOpen[📧 Send Notifications:<br/>• TournamentRegistrationOpenedNotification<br/>to all users]
    
    OpenReg --> NotifyRegOpen
    NotifyRegOpen --> AcceptTeams[Accept Team Registrations<br/>• Teams register<br/>• Payments processed<br/>• Approval workflow]
    
    AcceptTeams --> CheckFull{Max Teams<br/>Reached?}
    CheckFull -->|Yes| MarkFull[Registration: FULL<br/>• No more teams accepted]
    CheckFull -->|No| CheckDeadline{Registration<br/>Deadline?}
    CheckDeadline -->|No| AcceptTeams
    CheckDeadline -->|Yes| CloseReg[Close Registration<br/>• registration_status: closed]
    
    MarkFull --> CloseReg
    CloseReg --> NotifyRegClosed[📧 Send Notifications:<br/>• TournamentRegistrationClosedNotification<br/>to participants]
    
    NotifyRegClosed --> GenerateBrackets[Generate Brackets<br/>• Seed teams<br/>• Create match schedule<br/>• Assign venues/times]
    
    GenerateBrackets --> StartTournament[Start Tournament<br/>• status: active<br/>• started_at timestamp]
    
    StartTournament --> NotifyStarted[📧 Send Notifications:<br/>• TournamentStartedNotification<br/>to all participants<br/>• TournamentStartedAdminNotification]
    
    NotifyStarted --> PlayMatches[Matches Played<br/>• Track progress<br/>• Update brackets<br/>• Record results]
    
    PlayMatches --> CheckComplete{All Matches<br/>Complete?}
    CheckComplete -->|No| PlayMatches
    CheckComplete -->|Yes| Complete[Complete Tournament<br/>• status: completed<br/>• completed_at timestamp<br/>• Winners determined]
    
    Complete --> NotifyCompleted[📧 Send Notifications:<br/>• TournamentCompletedNotification<br/>• FeaturedTournamentCompletedNotification if featured<br/>• ParticipationCertificateAvailableNotification]
    
    NotifyCompleted --> GenerateCerts[Generate Certificates<br/>• Winner certificates<br/>• Participation certificates<br/>• PDF generation]
    
    GenerateCerts --> End([Tournament Completed])
    
    %% Cancellation Path
    StatusDraft -->|Admin Cancels| Cancel[Cancel Tournament]
    StatusPublished -->|Admin Cancels| Cancel
    OpenReg -->|Admin Cancels| Cancel
    StartTournament -->|Admin Cancels| Cancel
    
    Cancel --> StatusCancelled[Status: CANCELLED<br/>• cancelled_at timestamp<br/>• Reason recorded]
    StatusCancelled --> NotifyCancelled[📧 Send Notifications:<br/>• TournamentCancelledNotification<br/>• TournamentRefundEligibleNotification]
    NotifyCancelled --> ProcessRefunds[Process Refunds<br/>for Paid Teams]
    ProcessRefunds --> End
    
    style Start fill:#4CAF50,stroke:#2E7D32,color:#fff
    style StatusDraft fill:#9E9E9E,stroke:#616161,color:#fff
    style Publish fill:#2196F3,stroke:#1565C0,color:#fff
    style OpenReg fill:#FFC107,stroke:#F57C00,color:#000
    style StartTournament fill:#4CAF50,stroke:#2E7D32,color:#fff
    style Complete fill:#4CAF50,stroke:#2E7D32,color:#fff
    style StatusCancelled fill:#f44336,stroke:#c62828,color:#fff
    style End fill:#4CAF50,stroke:#2E7D32,color:#fff
    </div>
</div>

<!-- Tournament Status Flow -->
<div class="section-card">
    <h3 class="text-2xl font-bold mb-4 flex items-center">
        <span class="step-number">3</span>
        Tournament Status Transitions
    </h3>

    <div class="overflow-x-auto">
        <table class="w-full bg-white rounded-lg shadow">
            <thead class="bg-gray-100">
                <tr>
                    <th class="px-4 py-3 text-left font-semibold">Status</th>
                    <th class="px-4 py-3 text-left font-semibold">Description</th>
                    <th class="px-4 py-3 text-left font-semibold">Available Actions</th>
                    <th class="px-4 py-3 text-left font-semibold">Next Status</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-gray-200">
                <tr class="hover:bg-gray-50">
                    <td class="px-4 py-3">
                        <span class="bg-gray-100 px-3 py-1 rounded font-semibold">DRAFT</span>
                    </td>
                    <td class="px-4 py-3">Tournament being configured, not visible to public</td>
                    <td class="px-4 py-3 text-sm">Edit details, set dates, configure brackets</td>
                    <td class="px-4 py-3 text-sm">Published or Cancelled</td>
                </tr>
                <tr class="hover:bg-gray-50">
                    <td class="px-4 py-3">
                        <span class="bg-blue-100 px-3 py-1 rounded font-semibold">PUBLISHED</span>
                    </td>
                    <td class="px-4 py-3">Visible to public, may accept registrations</td>
                    <td class="px-4 py-3 text-sm">Open/close registration, approve teams</td>
                    <td class="px-4 py-3 text-sm">Active or Cancelled</td>
                </tr>
                <tr class="hover:bg-gray-50">
                    <td class="px-4 py-3">
                        <span class="bg-green-100 px-3 py-1 rounded font-semibold">ACTIVE</span>
                    </td>
                    <td class="px-4 py-3">Tournament in progress, matches being played</td>
                    <td class="px-4 py-3 text-sm">Schedule matches, record results, update brackets</td>
                    <td class="px-4 py-3 text-sm">Completed or Cancelled</td>
                </tr>
                <tr class="hover:bg-gray-50">
                    <td class="px-4 py-3">
                        <span class="bg-purple-100 px-3 py-1 rounded font-semibold">COMPLETED</span>
                    </td>
                    <td class="px-4 py-3">All matches finished, winners determined</td>
                    <td class="px-4 py-3 text-sm">Generate certificates, distribute prizes</td>
                    <td class="px-4 py-3 text-sm">Final state</td>
                </tr>
                <tr class="hover:bg-gray-50">
                    <td class="px-4 py-3">
                        <span class="bg-red-100 px-3 py-1 rounded font-semibold">CANCELLED</span>
                    </td>
                    <td class="px-4 py-3">Tournament cancelled by admin</td>
                    <td class="px-4 py-3 text-sm">Process refunds, notify participants</td>
                    <td class="px-4 py-3 text-sm">Final state</td>
                </tr>
            </tbody>
        </table>
    </div>

    <div class="screenshot-placeholder mt-4">
        <p class="text-2xl text-gray-400 mb-2">📸</p>
        <p class="text-gray-600 font-mono text-lg">[screenshot-tournament-dashboard.png]</p>
        <p class="text-sm text-gray-500 mt-2">Tournament management dashboard with status overview</p>
    </div>
</div>

<!-- Registration Management -->
<div class="section-card">
    <h3 class="text-2xl font-bold mb-4 flex items-center">
        <span class="step-number">4</span>
        Registration Management
    </h3>

    <div class="mermaid bg-white p-6 rounded-lg shadow-inner">
graph LR
    A[Registration: CLOSED] --> B{Admin Opens<br/>Registration?}
    B -->|Yes| C[Registration: OPEN<br/>📧 Notify all users]
    C --> D{Teams<br/>Registering}
    D --> E{Max Teams<br/>Reached?}
    E -->|Yes| F[Registration: FULL<br/>📧 Notify participants]
    E -->|No| G{Deadline<br/>Reached?}
    G -->|No| D
    G -->|Yes| H[Registration: CLOSED<br/>📧 Notify participants]
    F --> I[Start Team Approval<br/>Process]
    H --> I
    I --> J[Generate Brackets]
    
    style A fill:#9E9E9E,stroke:#616161,color:#fff
    style C fill:#4CAF50,stroke:#2E7D32,color:#fff
    style F fill:#FFC107,stroke:#F57C00,color:#000
    style H fill:#f44336,stroke:#c62828,color:#fff
    style J fill:#2196F3,stroke:#1565C0,color:#fff
    </div>

    <div class="decision-box mt-6">
        <p class="font-bold text-blue-800 mb-3">🤔 Registration Decision Logic</p>
        
        <div class="space-y-3">
            <div class="bg-white rounded-lg p-4">
                <p class="font-semibold text-blue-700 mb-2">Can Team Register?</p>
                <ol class="text-sm space-y-1 text-gray-700 list-decimal list-inside">
                    <li>Registration status must be "open"</li>
                    <li>Current date within registration period</li>
                    <li>Max teams limit not reached</li>
                    <li>Team meets minimum requirements</li>
                    <li>Team payment completed (if required)</li>
                </ol>
            </div>

            <div class="bg-white rounded-lg p-4">
                <p class="font-semibold text-green-700 mb-2">Auto-Accept vs Manual Approval</p>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-3 mt-2">
                    <div class="bg-green-50 rounded p-3 text-sm">
                        <strong>Auto-Accept ON:</strong>
                        <p class="text-gray-600 mt-1">Teams approved instantly if requirements met</p>
                    </div>
                    <div class="bg-yellow-50 rounded p-3 text-sm">
                        <strong>Auto-Accept OFF:</strong>
                        <p class="text-gray-600 mt-1">All teams require manual admin approval</p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="screenshot-placeholder-sm mt-4">
        <p class="text-xl text-gray-400 mb-2">📸</p>
        <p class="text-gray-600 font-mono">[screenshot-tournament-registration.png]</p>
        <p class="text-xs text-gray-500 mt-2">Tournament registration management interface</p>
    </div>
</div>

<!-- Bracket Generation -->
<div class="section-card">
    <h3 class="text-2xl font-bold mb-4 flex items-center">
        <span class="step-number">5</span>
        Bracket Generation & Match Scheduling
    </h3>

    <div class="bg-blue-50 rounded-lg p-6 mb-6">
        <h4 class="font-bold text-blue-900 mb-3">🎯 Bracket Generation Process</h4>
        
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
            <div class="bg-white rounded-lg p-4">
                <p class="font-semibold text-gray-800 mb-3">Seeding Methods:</p>
                <ul class="space-y-2 text-sm text-gray-700">
                    <li class="flex items-start">
                        <span class="text-blue-500 mr-2">•</span>
                        <span><strong>Balanced:</strong> Top teams spread evenly</span>
                    </li>
                    <li class="flex items-start">
                        <span class="text-blue-500 mr-2">•</span>
                        <span><strong>Random:</strong> Random bracket positions</span>
                    </li>
                    <li class="flex items-start">
                        <span class="text-blue-500 mr-2">•</span>
                        <span><strong>Rating-Based:</strong> By team ratings</span>
                    </li>
                    <li class="flex items-start">
                        <span class="text-blue-500 mr-2">•</span>
                        <span><strong>Manual:</strong> Admin assigns positions</span>
                    </li>
                </ul>
            </div>

            <div class="bg-white rounded-lg p-4">
                <p class="font-semibold text-gray-800 mb-3">Match Scheduling:</p>
                <ol class="space-y-2 text-sm text-gray-700 list-decimal list-inside">
                    <li>Calculate total rounds needed</li>
                    <li>Determine matches per round</li>
                    <li>Assign dates and times</li>
                    <li>Allocate venues (if applicable)</li>
                    <li>Assign referees (if available)</li>
                    <li>Send notifications to all participants</li>
                </ol>
            </div>
        </div>
    </div>

    <div class="screenshot-placeholder">
        <p class="text-2xl text-gray-400 mb-2">📸</p>
        <p class="text-gray-600 font-mono text-lg">[screenshot-bracket-view.png]</p>
        <p class="text-sm text-gray-500 mt-2">Tournament bracket visualization with match schedule</p>
    </div>
</div>

<!-- Tournament Notifications -->
<div class="section-card">
    <h3 class="text-2xl font-bold mb-4 flex items-center">
        <span class="step-number">6</span>
        Tournament Notification Matrix
    </h3>
    
    <div class="overflow-x-auto">
        <table class="w-full bg-white rounded-lg shadow">
            <thead class="bg-gray-100">
                <tr>
                    <th class="px-4 py-3 text-left font-semibold">Event</th>
                    <th class="px-4 py-3 text-left font-semibold">Recipient</th>
                    <th class="px-4 py-3 text-left font-semibold">Notification</th>
                    <th class="px-4 py-3 text-center font-semibold">When Sent</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-gray-200">
                <tr class="hover:bg-gray-50">
                    <td class="px-4 py-3">Tournament Created</td>
                    <td class="px-4 py-3">Admins</td>
                    <td class="px-4 py-3"><code class="text-xs">TournamentCreatedAdminNotification</code></td>
                    <td class="px-4 py-3 text-center text-sm">On creation</td>
                </tr>
                <tr class="hover:bg-gray-50 bg-blue-50">
                    <td class="px-4 py-3">Tournament Published</td>
                    <td class="px-4 py-3">All Users</td>
                    <td class="px-4 py-3"><code class="text-xs">TournamentPublishedNotification</code></td>
                    <td class="px-4 py-3 text-center text-sm">On publish</td>
                </tr>
                <tr class="hover:bg-gray-50 bg-blue-50">
                    <td class="px-4 py-3">Tournament Published</td>
                    <td class="px-4 py-3">Admins</td>
                    <td class="px-4 py-3"><code class="text-xs">TournamentPublishedAdminNotification</code></td>
                    <td class="px-4 py-3 text-center text-sm">On publish</td>
                </tr>
                <tr class="hover:bg-gray-50 bg-green-50">
                    <td class="px-4 py-3">Registration Opened</td>
                    <td class="px-4 py-3">All Users</td>
                    <td class="px-4 py-3"><code class="text-xs">TournamentRegistrationOpenedNotification</code></td>
                    <td class="px-4 py-3 text-center text-sm">Registration opens</td>
                </tr>
                <tr class="hover:bg-gray-50 bg-green-50">
                    <td class="px-4 py-3">Registration Opened</td>
                    <td class="px-4 py-3">Admins</td>
                    <td class="px-4 py-3"><code class="text-xs">TournamentRegistrationOpenedAdminNotification</code></td>
                    <td class="px-4 py-3 text-center text-sm">Registration opens</td>
                </tr>
                <tr class="hover:bg-gray-50">
                    <td class="px-4 py-3">Registration Closed</td>
                    <td class="px-4 py-3">Participants</td>
                    <td class="px-4 py-3"><code class="text-xs">TournamentRegistrationClosedNotification</code></td>
                    <td class="px-4 py-3 text-center text-sm">Registration closes</td>
                </tr>
                <tr class="hover:bg-gray-50 bg-yellow-50">
                    <td class="px-4 py-3">Tournament Started</td>
                    <td class="px-4 py-3">Participants</td>
                    <td class="px-4 py-3"><code class="text-xs">TournamentStartedNotification</code></td>
                    <td class="px-4 py-3 text-center text-sm">Tournament starts</td>
                </tr>
                <tr class="hover:bg-gray-50 bg-yellow-50">
                    <td class="px-4 py-3">Tournament Started</td>
                    <td class="px-4 py-3">Admins</td>
                    <td class="px-4 py-3"><code class="text-xs">TournamentStartedAdminNotification</code></td>
                    <td class="px-4 py-3 text-center text-sm">Tournament starts</td>
                </tr>
                <tr class="hover:bg-gray-50 bg-purple-50">
                    <td class="px-4 py-3">Tournament Completed</td>
                    <td class="px-4 py-3">Participants</td>
                    <td class="px-4 py-3"><code class="text-xs">TournamentCompletedNotification</code></td>
                    <td class="px-4 py-3 text-center text-sm">All matches done</td>
                </tr>
                <tr class="hover:bg-gray-50 bg-purple-50">
                    <td class="px-4 py-3">Certificates Available</td>
                    <td class="px-4 py-3">Participants</td>
                    <td class="px-4 py-3"><code class="text-xs">ParticipationCertificateAvailableNotification</code></td>
                    <td class="px-4 py-3 text-center text-sm">Certificates ready</td>
                </tr>
                <tr class="hover:bg-gray-50 bg-red-50">
                    <td class="px-4 py-3">Tournament Cancelled</td>
                    <td class="px-4 py-3">Participants</td>
                    <td class="px-4 py-3"><code class="text-xs">TournamentCancelledNotification</code></td>
                    <td class="px-4 py-3 text-center text-sm">On cancellation</td>
                </tr>
                <tr class="hover:bg-gray-50 bg-red-50">
                    <td class="px-4 py-3">Refund Eligible</td>
                    <td class="px-4 py-3">Paid Participants</td>
                    <td class="px-4 py-3"><code class="text-xs">TournamentRefundEligibleNotification</code></td>
                    <td class="px-4 py-3 text-center text-sm">On cancellation</td>
                </tr>
                <tr class="hover:bg-gray-50">
                    <td class="px-4 py-3">Tournament Updated</td>
                    <td class="px-4 py-3">Participants</td>
                    <td class="px-4 py-3"><code class="text-xs">TournamentUpdatedNotification</code></td>
                    <td class="px-4 py-3 text-center text-sm">On changes</td>
                </tr>
                <tr class="hover:bg-gray-50">
                    <td class="px-4 py-3">Dates Changed</td>
                    <td class="px-4 py-3">Participants</td>
                    <td class="px-4 py-3"><code class="text-xs">TournamentDatesChangedNotification</code></td>
                    <td class="px-4 py-3 text-center text-sm">Date updates</td>
                </tr>
                <tr class="hover:bg-gray-50">
                    <td class="px-4 py-3">Venue Changed</td>
                    <td class="px-4 py-3">Participants</td>
                    <td class="px-4 py-3"><code class="text-xs">TournamentVenueChangedNotification</code></td>
                    <td class="px-4 py-3 text-center text-sm">Venue updates</td>
                </tr>
                <tr class="hover:bg-gray-50">
                    <td class="px-4 py-3">Rules Updated</td>
                    <td class="px-4 py-3">Participants</td>
                    <td class="px-4 py-3"><code class="text-xs">TournamentRulesUpdatedNotification</code></td>
                    <td class="px-4 py-3 text-center text-sm">Rule changes</td>
                </tr>
                <tr class="hover:bg-gray-50">
                    <td class="px-4 py-3">Streaming Announced</td>
                    <td class="px-4 py-3">All Users</td>
                    <td class="px-4 py-3"><code class="text-xs">TournamentStreamingAnnouncedNotification</code></td>
                    <td class="px-4 py-3 text-center text-sm">Stream enabled</td>
                </tr>
            </tbody>
        </table>
    </div>

    <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mt-4">
        <div class="screenshot-placeholder-sm">
            <p class="text-xl text-gray-400 mb-2">📸</p>
            <p class="text-gray-600 font-mono">[screenshot-tournament-create-form.png]</p>
            <p class="text-xs text-gray-500 mt-2">Tournament creation form</p>
        </div>
        <div class="screenshot-placeholder-sm">
            <p class="text-xl text-gray-400 mb-2">📸</p>
            <p class="text-gray-600 font-mono">[screenshot-tournament-settings.png]</p>
            <p class="text-xs text-gray-500 mt-2">Tournament configuration settings</p>
        </div>
    </div>
</div>

<!-- Tournament Completion -->
<div class="section-card">
    <h3 class="text-2xl font-bold mb-4 flex items-center">
        <span class="step-number">7</span>
        Tournament Completion & Certificates
    </h3>

    <div class="bg-purple-50 rounded-lg p-6">
        <p class="text-gray-700 mb-4">When tournament completes, system automatically:</p>
        
        <div class="space-y-3">
            <div class="flex items-start bg-white rounded-lg p-3">
                <span class="text-2xl mr-3">🏆</span>
                <div>
                    <p class="font-semibold text-gray-800">Determine Winners</p>
                    <p class="text-sm text-gray-600">System records 1st, 2nd, 3rd place teams</p>
                </div>
            </div>

            <div class="flex items-start bg-white rounded-lg p-3">
                <span class="text-2xl mr-3">🎓</span>
                <div>
                    <p class="font-semibold text-gray-800">Generate Certificates</p>
                    <p class="text-sm text-gray-600">Create participation and winner certificates as PDF</p>
                </div>
            </div>

            <div class="flex items-start bg-white rounded-lg p-3">
                <span class="text-2xl mr-3">📧</span>
                <div>
                    <p class="font-semibold text-gray-800">Send Notifications</p>
                    <p class="text-sm text-gray-600">Notify all participants and distribute certificates</p>
                </div>
            </div>

            <div class="flex items-start bg-white rounded-lg p-3">
                <span class="text-2xl mr-3">📊</span>
                <div>
                    <p class="font-semibold text-gray-800">Update Statistics</p>
                    <p class="text-sm text-gray-600">Record tournament statistics and player ratings</p>
                </div>
            </div>
        </div>
    </div>

    <div class="screenshot-placeholder mt-4">
        <p class="text-2xl text-gray-400 mb-2">📸</p>
        <p class="text-gray-600 font-mono text-lg">[screenshot-tournament-results.png]</p>
        <p class="text-sm text-gray-500 mt-2">Tournament results and winners display</p>
    </div>
</div>

<!-- Summary -->
<div class="section-card bg-gradient-to-r from-orange-50 to-purple-50">
    <h3 class="text-2xl font-bold mb-4">📚 Quick Reference Summary</h3>
    
    <div class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-6">
        <div class="bg-white rounded-lg p-4 shadow">
            <p class="text-3xl font-bold text-blue-600 mb-2">5</p>
            <p class="text-gray-700">Tournament Statuses</p>
        </div>
        <div class="bg-white rounded-lg p-4 shadow">
            <p class="text-3xl font-bold text-green-600 mb-2">~18</p>
            <p class="text-gray-700">Notification Types</p>
        </div>
        <div class="bg-white rounded-lg p-4 shadow">
            <p class="text-3xl font-bold text-purple-600 mb-2">4</p>
            <p class="text-gray-700">Tournament Types</p>
        </div>
        <div class="bg-white rounded-lg p-4 shadow">
            <p class="text-3xl font-bold text-orange-600 mb-2">Auto</p>
            <p class="text-gray-700">Bracket Generation</p>
        </div>
    </div>

    <div class="bg-white rounded-lg p-6">
        <p class="font-semibold text-gray-800 mb-3">🎯 Key Takeaways:</p>
        <ul class="space-y-2 text-gray-700">
            <li class="flex items-start">
                <span class="text-green-500 mr-2">•</span>
                <span>Tournaments progress through well-defined states with automatic notifications at each transition</span>
            </li>
            <li class="flex items-start">
                <span class="text-blue-500 mr-2">•</span>
                <span>Registration can be auto-accept or manual approval based on tournament configuration</span>
            </li>
            <li class="flex items-start">
                <span class="text-purple-500 mr-2">•</span>
                <span>Bracket generation and match scheduling happen automatically after registration closes</span>
            </li>
            <li class="flex items-start">
                <span class="text-orange-500 mr-2">•</span>
                <span>Certificates are auto-generated and distributed upon tournament completion</span>
            </li>
        </ul>
    </div>
</div>

<?php /**PATH D:\E - STARTUPS\WORK FOLDERS\PERSONAL\the-milimus-tournament\resources\views\documentation\partials\tournament-management.blade.php ENDPATH**/ ?>