<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Certificate of Participation - <?php echo e($player_name ?? 'Player'); ?></title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Montserrat-Regular', Arial, sans-serif;
            margin: 0;
            padding: 0;
            background-color: #f5f5f5;
        }

        .certificate-container {
            width: 842px; /* A4 landscape width */
            height: 595px; /* A4 landscape height */
            position: relative;
            background-image: url("<?php echo e(asset('Certificate.jpg')); ?>");
            background-size: cover;
            background-position: center;
            background-repeat: no-repeat;
            overflow: hidden;
            margin: 0 auto;
        }

        /* Table-based layout for easier styling */
        .certificate-table {
            width: 100%;
            height: 100%;
            border-collapse: collapse;
            table-layout: fixed;
        }

        /* Header section - Top 20% of certificate */
        .header-row {
            height: 20%;
        }

        .header-cell {
            text-align: center;
            vertical-align: middle;
            padding: 20px;
        }

        .certificate-title {
            font-family: 'Montserrat-Bold', sans-serif;
            font-size: 28px;
            color: #ffffff;
            text-transform: uppercase;
            letter-spacing: 3px;
            text-shadow: 2px 2px 4px rgba(0, 0, 0, 0.5);
            margin-bottom: 8px;
        }

        .certificate-subtitle {
            font-family: 'Montserrat-Bold', sans-serif;
            font-size: 20px;
            color: #ffffff;
            text-transform: uppercase;
            letter-spacing: 2px;
            text-shadow: 2px 2px 4px rgba(0, 0, 0, 0.5);
        }

        /* Main content section - Middle 60% of certificate */
        .main-content-row {
            height: 60%;
        }

        .main-content-cell {
            text-align: center;
            vertical-align: middle;
            padding: 40px;
        }

        .certify-text {
            font-family: 'Montserrat-Bold', sans-serif;
            font-size: 18px;
            color: #4f585a;
            text-transform: uppercase;
            letter-spacing: 1px;
            margin-bottom: 20px;
            text-shadow: 1px 1px 2px rgba(255, 255, 255, 0.8);
        }

        .recipient-name {
            font-family: 'Segoe UI', cursive;
            font-size: 40px;
            color: #2b672f;
            font-weight: bold;
            margin: 20px 0;
            text-shadow: 2px 2px 4px rgba(255, 255, 255, 0.8);
            line-height: 1.1;
        }

        .team-name {
            font-family: 'Montserrat-SemiBold', sans-serif;
            font-size: 18px;
            color: #4f585a;
            margin: 10px 0;
            text-shadow: 1px 1px 2px rgba(255, 255, 255, 0.8);
        }

        .description-text {
            font-family: 'Segoe UI', sans-serif;
            font-size: 15px;
            color: #4f585a;
            line-height: 1.6;
            margin: 30px 0;
            text-shadow: 1px 1px 2px rgba(255, 255, 255, 0.8);
            max-width: 500px;
            margin-left: auto;
            margin-right: auto;
        }

        /* Footer section - Bottom 20% of certificate */
        .footer-row {
            height: 20%;
        }

        .footer-cell {
            text-align: center;
            vertical-align: bottom;
            padding: 20px 60px;
        }

        .footer-content {
            display: flex;
            justify-content: space-between;
            align-items: flex-end;
            width: 100%;
        }

        .certificate-id-text, .generated-date-text {
            font-family: 'Montserrat-Regular', sans-serif;
            font-size: 14px;
            line-height: 1.4;
            text-shadow: 1px 1px 2px rgba(255, 255, 255, 0.8);
        }

        .certificate-id-label {
            font-family: 'Montserrat-Bold', sans-serif;
            color: #d52f20;
            font-weight: 700;
        }

        .certificate-id-value {
            font-family: 'Montserrat-Regular', sans-serif;
            color: #50585a;
        }

        .generated-date-label {
            font-family: 'Montserrat-Bold', sans-serif;
            color: #2b672f;
            font-weight: 700;
        }

        .generated-date-value {
            font-family: 'Montserrat-Regular', sans-serif;
            color: #50585a;
        }

        /* QR Code section - positioned within footer */
        .qr-section {
            text-align: center;
            margin-bottom: 20px;
        }

        .qr-code {
            width: 80px;
            height: 80px;
            background: white;
            border: 2px solid #ddd;
            border-radius: 8px;
            padding: 5px;
            margin: 0 auto 8px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
        }

        .qr-code img {
            width: 100%;
            height: 100%;
            object-fit: contain;
        }

        .qr-text {
            font-family: 'Montserrat-Regular', sans-serif;
            font-size: 10px;
            color: #666666;
            text-shadow: 1px 1px 2px rgba(255, 255, 255, 0.8);
        }

        /* Print styles for PDF generation */
        @media print {
            body {
                background: white;
                padding: 0;
                margin: 0;
            }
            
            .certificate-container {
                width: 100%;
                height: 100vh;
            }
        }

        /* Responsive adjustments */
        @media (max-width: 768px) {
            .certificate-container {
                width: 100%;
                max-width: 100%;
                height: auto;
                aspect-ratio: 842/595;
            }
            
            .certificate-title {
                font-size: 24px;
            }
            
            .certificate-subtitle {
                font-size: 16px;
            }
            
            .recipient-name {
                font-size: 32px;
            }
            
            .footer-content {
                flex-direction: column;
                gap: 10px;
                align-items: center;
            }
        }
    </style>
</head>
<body>
    <div class="certificate-container">
        <table class="certificate-table">
            <!-- Header Section -->
            <tr class="header-row" style="text-align: left;">
                <td class="header-cell" style="text-align: left;">
                    <div class="certificate-title">Certificate of Participation</div>
                    <div class="certificate-subtitle">The Milimus Tournament</div>
                </td>
            </tr>
            
            <!-- Main Content Section -->
            <tr class="main-content-row">
                <td class="main-content-cell">
                    <div class="certify-text" style="text-align: left;">This is to certify that</div>
                    <h2 class="recipient-name"><?php echo e($player_name ?? 'Player Name'); ?></h2>
                    <?php if(isset($team_name) && $team_name): ?>
                        <div class="team-name"><?php echo e($team_name); ?></div>
                    <?php endif; ?>
                    <p class="description-text">
                        <?php echo e($description ?? 'Has successfully participated in The Milimus Tournament and demonstrated exceptional skill and sportsmanship throughout the competition.'); ?>

                    </p>
                    
                    <!-- QR Code Section -->
                    <div class="qr-section" style="display: none;">
                        <div class="qr-code">
                            <img src="<?php echo e($qr_code_url ?? 'https://api.qrserver.com/v1/create-qr-code/?size=100x100&data=Certificate'); ?>" alt="QR Code" />
                        </div>
                        <div class="qr-text">Certificate Verification</div>
                    </div>
                </td>
            </tr>
            
            <!-- Footer Section -->
            <tr class="footer-row">
                <td class="footer-cell">
                    <div class="footer-content">
                        <div class="certificate-id-text">
                            <div class="certificate-id-label">Certificate ID:</div>
                            <div class="certificate-id-value"><?php echo e($digital_id ?? 'CERT-000075-770DE884'); ?></div>
                        </div>
                        <div class="generated-date-text">
                            <div class="generated-date-label">Generated on</div>
                            <div class="generated-date-value"><?php echo e($issued_date ?? now()->format('F j, Y')); ?></div>
                        </div>
                    </div>
                </td>
            </tr>
        </table>
    </div>
</body>
</html>
<?php /**PATH D:\E - STARTUPS\WORK FOLDERS\PERSONAL\the-milimus-tournament\resources\views\players\certificate-table-template.blade.php ENDPATH**/ ?>