<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>System Logs - System Maintenance</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100">
    <div class="min-h-screen py-8">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <!-- Header -->
            <div class="bg-white shadow rounded-lg p-6 mb-6">
                <div class="flex justify-between items-center">
                    <div>
                        <h1 class="text-3xl font-bold text-gray-900">📋 System Logs</h1>
                        <p class="mt-2 text-gray-600">Viewing: <?php echo e($logType); ?>.log</p>
                    </div>
                    <a href="<?php echo e(route('system.maintenance.index')); ?>" class="bg-blue-500 hover:bg-blue-600 text-white px-4 py-2 rounded transition">
                        ← Back to Dashboard
                    </a>
                </div>
            </div>

            <!-- Log Info -->
            <div class="grid grid-cols-1 md:grid-cols-3 gap-4 mb-6">
                <div class="bg-blue-100 rounded-lg p-6">
                    <div class="text-blue-800 text-sm font-bold">File Path</div>
                    <div class="text-sm font-mono text-blue-900 mt-2 break-all"><?php echo e($file); ?></div>
                </div>
                <div class="bg-green-100 rounded-lg p-6">
                    <div class="text-green-800 text-sm font-bold">Total Lines</div>
                    <div class="text-3xl font-bold text-green-900 mt-2"><?php echo e(number_format($lines)); ?></div>
                </div>
                <div class="bg-purple-100 rounded-lg p-6">
                    <div class="text-purple-800 text-sm font-bold">File Size</div>
                    <div class="text-3xl font-bold text-purple-900 mt-2"><?php echo e(number_format($size / 1024, 2)); ?> KB</div>
                </div>
            </div>

            <!-- Log Type Selector -->
            <div class="bg-white shadow rounded-lg p-6 mb-6">
                <h2 class="text-xl font-bold mb-4">📂 Select Log File</h2>
                <div class="grid grid-cols-2 md:grid-cols-4 gap-2">
                    <a href="<?php echo e(route('system.maintenance.logs')); ?>?type=cron-queue" 
                       class="px-4 py-2 rounded text-center <?php echo e($logType === 'cron-queue' ? 'bg-blue-500 text-white' : 'bg-gray-200 hover:bg-gray-300'); ?> transition">
                        Cron Queue
                    </a>
                    <a href="<?php echo e(route('system.maintenance.logs')); ?>?type=laravel" 
                       class="px-4 py-2 rounded text-center <?php echo e($logType === 'laravel' ? 'bg-blue-500 text-white' : 'bg-gray-200 hover:bg-gray-300'); ?> transition">
                        Laravel
                    </a>
                    <a href="<?php echo e(route('system.maintenance.logs')); ?>?type=cron-test-<?php echo e(date('Y-m-d')); ?>" 
                       class="px-4 py-2 rounded text-center <?php echo e(str_contains($logType, 'cron-test') ? 'bg-blue-500 text-white' : 'bg-gray-200 hover:bg-gray-300'); ?> transition">
                        Cron Test
                    </a>
                    <a href="<?php echo e(route('system.maintenance.logs')); ?>?type=queue" 
                       class="px-4 py-2 rounded text-center <?php echo e($logType === 'queue' ? 'bg-blue-500 text-white' : 'bg-gray-200 hover:bg-gray-300'); ?> transition">
                        Queue
                    </a>
                </div>
            </div>

            <!-- Log Content -->
            <div class="bg-white shadow rounded-lg p-6">
                <div class="flex justify-between items-center mb-4">
                    <h2 class="text-2xl font-bold">📄 Log Content</h2>
                    <button onclick="copyToClipboard()" class="bg-gray-500 hover:bg-gray-600 text-white px-4 py-2 rounded transition">
                        📋 Copy to Clipboard
                    </button>
                </div>
                <div id="logContent" class="bg-gray-900 text-green-400 p-4 rounded font-mono text-sm overflow-x-auto max-h-[600px] overflow-y-auto whitespace-pre-wrap"><?php echo e($content); ?></div>
                <?php if($lines === 0): ?>
                <div class="bg-yellow-50 border border-yellow-200 rounded p-4 mt-4">
                    <p class="text-yellow-800">
                        ℹ️ No log entries found. This could mean:
                    </p>
                    <ul class="list-disc list-inside mt-2 text-yellow-700 text-sm">
                        <li>The log file hasn't been created yet</li>
                        <li>No events have been logged</li>
                        <li>The cron job hasn't run yet</li>
                    </ul>
                </div>
                <?php endif; ?>
            </div>

            <!-- Auto-refresh -->
            <div class="bg-blue-50 border border-blue-200 rounded-lg p-4 mt-6">
                <div class="flex items-center justify-between">
                    <div class="flex items-center">
                        <input type="checkbox" id="autoRefresh" class="mr-2">
                        <label for="autoRefresh" class="text-blue-900 font-bold">Auto-refresh every 5 seconds</label>
                    </div>
                    <button onclick="location.reload()" class="bg-blue-500 hover:bg-blue-600 text-white px-4 py-2 rounded transition">
                        🔄 Refresh Now
                    </button>
                </div>
            </div>

            <!-- Actions -->
            <div class="mt-6 flex gap-4">
                <a href="<?php echo e(route('system.maintenance.test-cron')); ?>" class="bg-green-500 hover:bg-green-600 text-white px-6 py-3 rounded transition">
                    🧪 Run Cron Test
                </a>
                <a href="<?php echo e(route('system.maintenance.optimize')); ?>" class="bg-purple-500 hover:bg-purple-600 text-white px-6 py-3 rounded transition">
                    ⚡ Optimize System
                </a>
            </div>
        </div>
    </div>

    <script>
        // Auto-refresh functionality
        let refreshInterval = null;
        const autoRefreshCheckbox = document.getElementById('autoRefresh');
        
        autoRefreshCheckbox.addEventListener('change', function() {
            if (this.checked) {
                refreshInterval = setInterval(() => {
                    location.reload();
                }, 5000);
            } else {
                if (refreshInterval) {
                    clearInterval(refreshInterval);
                    refreshInterval = null;
                }
            }
        });

        // Copy to clipboard
        function copyToClipboard() {
            const logContent = document.getElementById('logContent').textContent;
            navigator.clipboard.writeText(logContent).then(() => {
                alert('Log content copied to clipboard!');
            });
        }
    </script>
</body>
</html>

<?php /**PATH D:\E - STARTUPS\WORK FOLDERS\PERSONAL\the-milimus-tournament\resources\views\system\maintenance\logs.blade.php ENDPATH**/ ?>