<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" class="<?php echo \Illuminate\Support\Arr::toCssClasses(['dark' => ($appearance ?? 'system') == 'dark']); ?>">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">

        
        <script>
            (function() {
                const appearance = '<?php echo e($appearance ?? "system"); ?>';

                if (appearance === 'system') {
                    const prefersDark = window.matchMedia('(prefers-color-scheme: dark)').matches;

                    if (prefersDark) {
                        document.documentElement.classList.add('dark');
                    }
                }
            })();
        </script>

        
        <script>
            (function() {
                // Force light mode - remove dark class if present
                document.documentElement.classList.remove('dark');
                
                // Override localStorage to force light mode
                const originalSetItem = localStorage.setItem;
                localStorage.setItem = function(key, value) {
                    if (key === 'appearance') {
                        // Force light mode in localStorage
                        originalSetItem.call(this, key, 'light');
                    } else {
                        originalSetItem.call(this, key, value);
                    }
                };
                
                // Set appearance to light in localStorage
                localStorage.setItem('appearance', 'light');
                
                // Prevent dark mode from being added back
                const originalAddClass = document.documentElement.classList.add;
                document.documentElement.classList.add = function(...classes) {
                    const filteredClasses = classes.filter(cls => cls !== 'dark');
                    if (filteredClasses.length > 0) {
                        originalAddClass.apply(this, filteredClasses);
                    }
                };
                
                // Override the applyTheme function if it exists
                if (window.applyTheme) {
                    const originalApplyTheme = window.applyTheme;
                    window.applyTheme = function(appearance) {
                        // Always force light mode regardless of input
                        document.documentElement.classList.remove('dark');
                    };
                }
                
                // Override initializeTheme function
                window.initializeTheme = function() {
                    // Force light mode and prevent dark mode
                    document.documentElement.classList.remove('dark');
                    localStorage.setItem('appearance', 'light');
                };
                
                // Override matchMedia for prefers-color-scheme to always return false
                const originalMatchMedia = window.matchMedia;
                window.matchMedia = function(query) {
                    if (query === '(prefers-color-scheme: dark)') {
                        return {
                            matches: false,
                            addEventListener: function() {},
                            removeEventListener: function() {}
                        };
                    }
                    return originalMatchMedia.call(this, query);
                };
            })();
        </script>

        
        <style>
            html {
                background-color: oklch(1 0 0);
            }

            html.dark {
                background-color: oklch(0.145 0 0);
            }
        </style>

        <title inertia>The Milimus Tournament</title>

        <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

        
        <?php if (isset($component)) { $__componentOriginal1046d4305118cfc8e826df54ec472816 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal1046d4305118cfc8e826df54ec472816 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.app-settings','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-settings'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal1046d4305118cfc8e826df54ec472816)): ?>
<?php $attributes = $__attributesOriginal1046d4305118cfc8e826df54ec472816; ?>
<?php unset($__attributesOriginal1046d4305118cfc8e826df54ec472816); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal1046d4305118cfc8e826df54ec472816)): ?>
<?php $component = $__componentOriginal1046d4305118cfc8e826df54ec472816; ?>
<?php unset($__componentOriginal1046d4305118cfc8e826df54ec472816); ?>
<?php endif; ?>

        <link rel="preconnect" href="https://fonts.bunny.net">
        <link href="https://fonts.bunny.net/css?family=instrument-sans:400,500,600" rel="stylesheet" />

        <?php echo app('Tighten\Ziggy\BladeRouteGenerator')->generate(); ?>
        <?php echo app('Illuminate\Foundation\Vite')->reactRefresh(); ?>
        <?php echo app('Illuminate\Foundation\Vite')(['resources/js/app.tsx', "resources/js/pages/{$page['component']}.tsx"]); ?>
        <?php if (!isset($__inertiaSsrDispatched)) { $__inertiaSsrDispatched = true; $__inertiaSsrResponse = app(\Inertia\Ssr\Gateway::class)->dispatch($page); }  if ($__inertiaSsrResponse) { echo $__inertiaSsrResponse->head; } ?>
    </head>
    <body class="font-sans antialiased">
        <?php if (!isset($__inertiaSsrDispatched)) { $__inertiaSsrDispatched = true; $__inertiaSsrResponse = app(\Inertia\Ssr\Gateway::class)->dispatch($page); }  if ($__inertiaSsrResponse) { echo $__inertiaSsrResponse->body; } else { ?><div id="app" data-page="<?php echo e(json_encode($page)); ?>"></div><?php } ?>
    </body>
</html>
<?php /**PATH D:\E - STARTUPS\WORK FOLDERS\PERSONAL\the-milimus-tournament\resources\views\app.blade.php ENDPATH**/ ?>