<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Bulk Certificates - <?php echo e($tournament->name); ?></title>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Playfair+Display:wght@400;700&family=Inter:wght@300;400;500;600&display=swap');
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Inter', sans-serif;
            background: #ffffff;
        }
        
        .page-break {
            page-break-after: always;
        }
        
        .certificate {
            width: 1056px;
            height: 700px;
            background: #ffffff;
            position: relative;
            border: 15px solid #f8f9fa;
            overflow: hidden;
            page-break-inside: avoid;
            margin: auto;
        }
        
        .certificate::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: 
                radial-gradient(circle at 20% 20%, rgba(102, 126, 234, 0.1) 0%, transparent 50%),
                radial-gradient(circle at 80% 80%, rgba(118, 75, 162, 0.1) 0%, transparent 50%),
                radial-gradient(circle at 40% 60%, rgba(255, 215, 0, 0.05) 0%, transparent 50%);
            pointer-events: none;
        }
        
        .certificate-border {
            position: absolute;
            top: 10px;
            left: 10px;
            right: 10px;
            bottom: 10px;
            border: 3px solid #d4af37;
            border-radius: 8px;
        }
        
        .certificate-inner-border {
            position: absolute;
            top: 20px;
            left: 20px;
            right: 20px;
            bottom: 20px;
            border: 1px solid #e9ecef;
            border-radius: 4px;
        }
        
        .header {
            text-align: center;
            padding: 25px 0 15px;
            position: relative;
            z-index: 2;
        }
        
        .logo {
            width: 60px;
            height: 60px;
            margin: 0 auto 15px;
            background: linear-gradient(135deg, #667eea, #764ba2);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 18px;
            font-weight: bold;
            box-shadow: 0 8px 25px rgba(102, 126, 234, 0.3);
        }
        
        .tournament-name {
            font-family: 'Playfair Display', serif;
            font-size: 20px;
            font-weight: 700;
            color: #2d3748;
            margin-bottom: 8px;
            text-transform: uppercase;
            letter-spacing: 1.5px;
        }
        
        .certificate-title {
            font-family: 'Playfair Display', serif;
            font-size: 36px;
            font-weight: 700;
            color: #d4af37;
            margin: 20px 0;
            text-shadow: 2px 2px 4px rgba(0, 0, 0, 0.1);
            letter-spacing: 2px;
        }
        
        .certificate-subtitle {
            font-size: 16px;
            color: #4a5568;
            margin-bottom: 25px;
            font-weight: 300;
            letter-spacing: 1px;
        }
        
        .content {
            text-align: center;
            padding: 0 60px;
            position: relative;
            z-index: 2;
        }
        
        .presented-to {
            font-size: 14px;
            color: #718096;
            margin-bottom: 12px;
            font-weight: 400;
            text-transform: uppercase;
            letter-spacing: 1.5px;
        }
        
        .team-name {
            font-family: 'Playfair Display', serif;
            font-size: 28px;
            font-weight: 700;
            color: #2d3748;
            margin-bottom: 15px;
            padding: 12px 0;
            border-bottom: 3px solid #d4af37;
            display: inline-block;
            min-width: 350px;
        }
        
        .participation-text {
            font-size: 14px;
            color: #4a5568;
            line-height: 1.6;
            margin: 20px 0;
            max-width: 550px;
            margin-left: auto;
            margin-right: auto;
        }
        
        .footer {
            position: absolute;
            bottom: 30px;
            left: 60px;
            right: 60px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .seal {
            width: 90px;
            height: 90px;
            background: radial-gradient(circle, #d4af37 0%, #b8941f 50%, #a67c1a 100%);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-weight: bold;
            font-size: 9px;
            text-align: center;
            line-height: 1.3;
            box-shadow: 
                0 8px 25px rgba(212, 175, 55, 0.4),
                inset 0 2px 4px rgba(255, 255, 255, 0.3),
                inset 0 -2px 4px rgba(0, 0, 0, 0.2);
            border: 4px solid #f7fafc;
            position: relative;
            font-family: 'Playfair Display', serif;
        }
        
        .seal::before {
            content: '';
            position: absolute;
            top: -8px;
            left: -8px;
            right: -8px;
            bottom: -8px;
            border: 2px solid #d4af37;
            border-radius: 50%;
            background: linear-gradient(45deg, transparent 30%, rgba(212, 175, 55, 0.1) 50%, transparent 70%);
        }
        
        .seal::after {
            content: '';
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            width: 60px;
            height: 60px;
            border: 1px solid rgba(255, 255, 255, 0.3);
            border-radius: 50%;
        }
        
        .seal-content {
            position: relative;
            z-index: 2;
        }
        
        .seal-title {
            font-size: 8px;
            font-weight: 700;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            margin-bottom: 2px;
        }
        
        .seal-subtitle {
            font-size: 7px;
            font-weight: 600;
            margin-bottom: 2px;
        }
        
        .seal-year {
            font-size: 8px;
            font-weight: 700;
        }
        
        .certificate-info {
            text-align: right;
            font-size: 11px;
            color: #718096;
        }
        
        .certificate-id {
            font-weight: 600;
            color: #4a5568;
            margin-bottom: 4px;
        }
        
        .date {
            color: #718096;
        }
        
        .decorative-elements {
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            pointer-events: none;
            z-index: 1;
        }
        
        .decorative-corner {
            position: absolute;
            width: 40px;
            height: 40px;
            background: linear-gradient(45deg, #d4af37, transparent);
            opacity: 0.3;
        }
        
        .decorative-corner.top-left {
            top: 30px;
            left: 30px;
            border-radius: 0 0 100% 0;
        }
        
        .decorative-corner.top-right {
            top: 30px;
            right: 30px;
            border-radius: 0 0 0 100%;
        }
        
        .decorative-corner.bottom-left {
            bottom: 30px;
            left: 30px;
            border-radius: 0 100% 0 0;
        }
        
        .decorative-corner.bottom-right {
            bottom: 30px;
            right: 30px;
            border-radius: 100% 0 0 0;
        }
        
        .watermark {
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%) rotate(-45deg);
            font-size: 100px;
            color: rgba(212, 175, 55, 0.05);
            font-weight: bold;
            z-index: 0;
            pointer-events: none;
        }
    </style>
</head>
<body>
    <?php $__currentLoopData = $teams; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $team): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <div class="certificate">
        <div class="certificate-border"></div>
        <div class="certificate-inner-border"></div>
        
        <div class="decorative-elements">
            <div class="decorative-corner top-left"></div>
            <div class="decorative-corner top-right"></div>
            <div class="decorative-corner bottom-left"></div>
            <div class="decorative-corner bottom-right"></div>
            <div class="watermark">CERTIFIED</div>
        </div>
        
        <div class="header">
            <img src="<?php echo e(asset('/logo.png')); ?>" alt="Logo" class="logo">
            <div class="tournament-name"><?php echo e($tournament->name); ?></div>
        </div>
        
        <div class="content">
            <h1 class="certificate-title">CERTIFICATE</h1>
            <p class="certificate-subtitle">of Participation</p>
            
            <p class="presented-to">This is to certify that</p>
            <h2 class="team-name"><?php echo e($team->name); ?></h2>
            
            <p class="participation-text">
                has successfully participated in the <?php echo e($tournament->name); ?> tournament
                <?php if($tournament->start_date && $tournament->end_date): ?>
                    held from <?php echo e(\Carbon\Carbon::parse($tournament->start_date)->format('F j, Y')); ?>

                    to <?php echo e(\Carbon\Carbon::parse($tournament->end_date)->format('F j, Y')); ?>

                <?php endif; ?>
                and has demonstrated exceptional sportsmanship, skill, and dedication throughout the competition.
            </p>
        </div>
        
        <div class="footer">
            <div class="certificate-info">
                <div class="certificate-id">Certificate ID: CERT-<?php echo e($tournament->id); ?>-<?php echo e($team->id); ?>-<?php echo e(now()->format('Ymd')); ?></div>
                <div class="date">Generated on <?php echo e(now()->format('F j, Y')); ?></div>
            </div>
        </div>
    </div>
    
    <?php if(!$loop->last): ?>
    <div class="page-break"></div>
    <?php endif; ?>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</body>
</html><?php /**PATH D:\E - STARTUPS\WORK FOLDERS\PERSONAL\the-milimus-tournament\resources\views\certificates\bulk-participation.blade.php ENDPATH**/ ?>