<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cron Test Results - System Maintenance</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100">
    <div class="min-h-screen py-8">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <!-- Header -->
            <div class="bg-white shadow rounded-lg p-6 mb-6">
                <div class="flex justify-between items-center">
                    <div>
                        <h1 class="text-3xl font-bold text-gray-900">🧪 Cron Job Test Results</h1>
                        <p class="mt-2 text-gray-600">Executed at <?php echo e($timestamp); ?></p>
                    </div>
                    <a href="<?php echo e(route('system.maintenance.index')); ?>" class="bg-blue-500 hover:bg-blue-600 text-white px-4 py-2 rounded transition">
                        ← Back to Dashboard
                    </a>
                </div>
            </div>

            <!-- Execution Summary -->
            <div class="grid grid-cols-1 md:grid-cols-3 gap-4 mb-6">
                <div class="bg-green-100 rounded-lg p-6">
                    <div class="text-green-800 text-sm font-bold">Tests Passed</div>
                    <div class="text-3xl font-bold text-green-900 mt-2">
                        <?php echo e(collect($output)->where('status', 'pass')->count()); ?>

                    </div>
                </div>
                <div class="bg-yellow-100 rounded-lg p-6">
                    <div class="text-yellow-800 text-sm font-bold">Warnings</div>
                    <div class="text-3xl font-bold text-yellow-900 mt-2">
                        <?php echo e(collect($output)->where('status', 'warning')->count()); ?>

                    </div>
                </div>
                <div class="bg-red-100 rounded-lg p-6">
                    <div class="text-red-800 text-sm font-bold">Failed</div>
                    <div class="text-3xl font-bold text-red-900 mt-2">
                        <?php echo e(collect($output)->where('status', 'fail')->count()); ?>

                    </div>
                </div>
            </div>

            <!-- Test Results -->
            <div class="bg-white shadow rounded-lg p-6 mb-6">
                <h2 class="text-2xl font-bold mb-4">📋 Test Results</h2>
                <div class="space-y-4">
                    <?php $__currentLoopData = $output; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $test): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="border rounded-lg p-4 <?php echo e($test['status'] === 'pass' ? 'bg-green-50 border-green-200' : 
                        ($test['status'] === 'warning' ? 'bg-yellow-50 border-yellow-200' : 'bg-red-50 border-red-200')); ?>">
                        <div class="flex justify-between items-start">
                            <div class="flex-1">
                                <div class="font-bold <?php echo e($test['status'] === 'pass' ? 'text-green-900' : 
                                    ($test['status'] === 'warning' ? 'text-yellow-900' : 'text-red-900')); ?>">
                                    <?php if($test['status'] === 'pass'): ?> ✅ <?php elseif($test['status'] === 'warning'): ?> ⚠️ <?php else: ?> ❌ <?php endif; ?>
                                    <?php echo e($test['test']); ?>

                                </div>
                                <div class="mt-2 text-sm font-mono <?php echo e($test['status'] === 'pass' ? 'text-green-700' : 
                                    ($test['status'] === 'warning' ? 'text-yellow-700' : 'text-red-700')); ?>">
                                    <?php echo e($test['details']); ?>

                                </div>
                            </div>
                            <span class="px-3 py-1 rounded text-sm font-bold <?php echo e($test['status'] === 'pass' ? 'bg-green-200 text-green-800' : 
                                ($test['status'] === 'warning' ? 'bg-yellow-200 text-yellow-800' : 'bg-red-200 text-red-800')); ?>">
                                <?php echo e(strtoupper($test['status'])); ?>

                            </span>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>

            <?php if(count($errors) > 0): ?>
            <!-- Errors -->
            <div class="bg-red-50 border border-red-200 rounded-lg p-6 mb-6">
                <h2 class="text-2xl font-bold text-red-900 mb-4">❌ Errors</h2>
                <div class="space-y-2">
                    <?php $__currentLoopData = $errors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="bg-red-100 p-3 rounded text-red-800 font-mono text-sm">
                        <?php echo e($error); ?>

                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
            <?php endif; ?>

            <!-- Execution Info -->
            <div class="bg-blue-50 border border-blue-200 rounded-lg p-6">
                <div class="flex justify-between items-center">
                    <div>
                        <div class="text-blue-900 font-bold">Execution Time</div>
                        <div class="text-2xl font-bold text-blue-800 mt-1"><?php echo e($executionTime); ?> seconds</div>
                    </div>
                    <div class="text-right">
                        <div class="text-blue-900 font-bold">Total Tests</div>
                        <div class="text-2xl font-bold text-blue-800 mt-1"><?php echo e(count($output)); ?></div>
                    </div>
                </div>
            </div>

            <!-- Recommendations -->
            <?php if(collect($output)->where('status', '!=', 'pass')->count() > 0): ?>
            <div class="bg-yellow-50 border border-yellow-200 rounded-lg p-6 mt-6">
                <h2 class="text-2xl font-bold text-yellow-900 mb-4">💡 Recommendations</h2>
                <ul class="list-disc list-inside space-y-2 text-yellow-800">
                    <?php if(collect($output)->where('test', 'Queue Connection')->where('status', 'warning')->count() > 0): ?>
                    <li>Set QUEUE_CONNECTION=database or redis in .env for better performance</li>
                    <?php endif; ?>
                    <?php if(collect($output)->where('status', 'fail')->count() > 0): ?>
                    <li>Fix failed tests before setting up cron job</li>
                    <li>Check file permissions: chmod -R 775 storage bootstrap/cache</li>
                    <li>Verify database connection in .env file</li>
                    <?php endif; ?>
                </ul>
            </div>
            <?php endif; ?>

            <!-- Actions -->
            <div class="mt-6 flex gap-4">
                <a href="<?php echo e(route('system.maintenance.test-cron')); ?>" class="bg-blue-500 hover:bg-blue-600 text-white px-6 py-3 rounded transition">
                    🔄 Run Test Again
                </a>
                <a href="<?php echo e(route('system.maintenance.logs')); ?>?type=cron-test-<?php echo e(date('Y-m-d')); ?>" class="bg-gray-500 hover:bg-gray-600 text-white px-6 py-3 rounded transition">
                    📋 View Log File
                </a>
            </div>
        </div>
    </div>
</body>
</html>

<?php /**PATH D:\E - STARTUPS\WORK FOLDERS\PERSONAL\the-milimus-tournament\resources\views\system\maintenance\test-cron.blade.php ENDPATH**/ ?>