<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>System Walkthrough - The Milimus Tournament</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdn.jsdelivr.net/npm/mermaid@10/dist/mermaid.min.js"></script>
    <style>
        @media print {
            .no-print { display: none; }
            .tab-content { display: block !important; }
        }
        
        .tab-btn {
            @apply w-full text-left px-4 py-3 rounded-lg transition-all duration-200;
        }
        
        .tab-btn:hover {
            @apply bg-gray-100;
        }
        
        .tab-btn.active {
            @apply bg-blue-500 text-white font-semibold shadow-lg;
        }
        
        .tab-content {
            display: none;
        }
        
        .tab-content.active {
            display: block;
            animation: fadeIn 0.3s ease-in;
        }
        
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(10px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        .sticky-sidebar {
            position: sticky;
            top: 20px;
            max-height: calc(100vh - 40px);
            overflow-y: auto;
        }
        
        .screenshot-placeholder {
            @apply bg-gray-200 border-2 border-dashed border-gray-400 rounded-lg p-12 text-center my-6 hover:bg-gray-300 transition-colors;
        }
        
        .screenshot-placeholder-sm {
            @apply bg-gray-200 border-2 border-dashed border-gray-400 rounded-lg p-6 text-center my-4 hover:bg-gray-300 transition-colors;
        }
        
        .section-card {
            @apply bg-white shadow-lg rounded-lg p-6 mb-6;
        }
        
        .decision-box {
            @apply bg-blue-50 border-l-4 border-blue-500 p-4 my-4 rounded-r-lg;
        }
        
        .notification-box {
            @apply bg-green-50 border-l-4 border-green-500 p-4 my-4 rounded-r-lg;
        }
        
        .warning-box {
            @apply bg-yellow-50 border-l-4 border-yellow-500 p-4 my-4 rounded-r-lg;
        }
        
        .step-number {
            @apply inline-flex items-center justify-center w-8 h-8 rounded-full bg-blue-500 text-white font-bold mr-3;
        }
    </style>
</head>
<body class="bg-gray-100">
    <div class="min-h-screen py-8">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <!-- Header -->
            <div class="bg-white shadow-lg rounded-lg p-6 mb-6 no-print">
                <h1 class="text-4xl font-bold text-gray-900">📚 System Walkthrough Documentation</h1>
                <p class="mt-2 text-gray-600">Visual guide to understanding system workflows and processes</p>
                <div class="mt-4 flex flex-wrap gap-4 text-sm">
                    <span class="text-gray-500">🎯 Interactive</span>
                    <span class="text-gray-500">📊 Flow Diagrams</span>
                    <span class="text-gray-500">🖼️ Screenshots</span>
                    <span class="text-gray-500">📝 No Code</span>
                    <span class="text-gray-500">🖨️ Print-Ready</span>
                    <span class="font-semibold text-green-600">✅ 7 Complete Sections</span>
                </div>
            </div>

            <div class="flex flex-col lg:flex-row gap-6">
                <!-- Main Content Area -->
                <div class="flex-1 order-2 lg:order-1">
                    
                    <!-- Tab Content: Team Registration -->
                    <div id="tab-team-registration" class="tab-content active">
                        <?php echo $__env->make('documentation.partials.team-registration', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                    </div>

                    <!-- Tab Content: Team Management -->
                    <div id="tab-team-management" class="tab-content">
                        <?php echo $__env->make('documentation.partials.team-management', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                    </div>

                    <!-- Tab Content: Tournament Categories -->
                    <div id="tab-tournament-categories" class="tab-content">
                        <?php echo $__env->make('documentation.partials.tournament-categories', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                    </div>

                    <!-- Tab Content: Notification System -->
                    <div id="tab-notification-system" class="tab-content">
                        <?php echo $__env->make('documentation.partials.notification-system', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                    </div>

                    <!-- Tab Content: Payment Processing -->
                    <div id="tab-payment-processing" class="tab-content">
                        <?php echo $__env->make('documentation.partials.payment-processing', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                    </div>

                    <!-- Tab Content: Player Management -->
                    <div id="tab-player-management" class="tab-content">
                        <?php echo $__env->make('documentation.partials.player-management', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                    </div>

                    <!-- Tab Content: Tournament Management -->
                    <div id="tab-tournament-management" class="tab-content">
                        <?php echo $__env->make('documentation.partials.tournament-management', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                    </div>

                    <!-- Tab Content: Match Management -->
                    <div id="tab-match-management" class="tab-content">
                        <?php echo $__env->make('documentation.partials.match-management', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                    </div>

                </div>

                <!-- Tab Navigation Sidebar -->
                <div class="lg:w-64 order-1 lg:order-2 no-print">
                    <div class="sticky-sidebar bg-white shadow-lg rounded-lg p-4">
                        <h3 class="font-bold text-lg mb-4 text-gray-700">📑 Documentation Sections</h3>
                        <div class="space-y-2">
                            <button onclick="switchTab('team-registration')" class="tab-btn active" id="btn-team-registration">
                                <span class="text-xl">📝</span>
                                <span class="ml-2">Team Registration</span>
                            </button>
                            <button onclick="switchTab('team-management')" class="tab-btn" id="btn-team-management">
                                <span class="text-xl">👥</span>
                                <span class="ml-2">Team Management</span>
                            </button>
                            <button onclick="switchTab('tournament-categories')" class="tab-btn" id="btn-tournament-categories">
                                <span class="text-xl">🏆</span>
                                <span class="ml-2">Tournament Categories</span>
                            </button>
                            <button onclick="switchTab('notification-system')" class="tab-btn" id="btn-notification-system">
                                <span class="text-xl">🔔</span>
                                <span class="ml-2">Notification System</span>
                            </button>
                            <button onclick="switchTab('payment-processing')" class="tab-btn" id="btn-payment-processing">
                                <span class="text-xl">💳</span>
                                <span class="ml-2">Payment Processing</span>
                            </button>
                            <button onclick="switchTab('player-management')" class="tab-btn" id="btn-player-management">
                                <span class="text-xl">⚽</span>
                                <span class="ml-2">Player Management</span>
                            </button>
                            <button onclick="switchTab('tournament-management')" class="tab-btn" id="btn-tournament-management">
                                <span class="text-xl">🏆</span>
                                <span class="ml-2">Tournament Management</span>
                            </button>
                            <button onclick="switchTab('match-management')" class="tab-btn" id="btn-match-management">
                                <span class="text-xl">🎮</span>
                                <span class="ml-2">Match Management</span>
                            </button>
                        </div>

                        <div class="mt-6 pt-6 border-t border-gray-200">
                            <h4 class="font-semibold text-sm text-gray-600 mb-3">Quick Actions</h4>
                            <div class="space-y-2">
                                <button onclick="window.print()" class="w-full text-left px-3 py-2 text-sm bg-gray-100 hover:bg-gray-200 rounded transition">
                                    🖨️ Print Documentation
                                </button>
                                <a href="/" class="block w-full text-left px-3 py-2 text-sm bg-gray-100 hover:bg-gray-200 rounded transition">
                                    🏠 Back to Home
                                </a>
                            </div>
                        </div>

                        <div class="mt-6 pt-6 border-t border-gray-200 text-xs text-gray-500">
                            <p><strong>Last Updated:</strong> <?php echo e(date('F d, Y')); ?></p>
                            <p class="mt-2"><strong>Version:</strong> 1.0</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        // Initialize Mermaid
        mermaid.initialize({ 
            startOnLoad: true,
            theme: 'default',
            flowchart: {
                useMaxWidth: true,
                htmlLabels: true,
                curve: 'basis'
            }
        });

        // Tab switching functionality
        function switchTab(tabName) {
            // Hide all tab contents
            document.querySelectorAll('.tab-content').forEach(content => {
                content.classList.remove('active');
            });

            // Remove active class from all buttons
            document.querySelectorAll('.tab-btn').forEach(btn => {
                btn.classList.remove('active');
            });

            // Show selected tab content
            document.getElementById('tab-' + tabName).classList.add('active');
            
            // Activate selected button
            document.getElementById('btn-' + tabName).classList.add('active');

            // Scroll to top smoothly
            window.scrollTo({ top: 0, behavior: 'smooth' });

            // Re-render mermaid diagrams
            mermaid.contentLoaded();
        }

        // Smooth scroll for internal links
        document.querySelectorAll('a[href^="#"]').forEach(anchor => {
            anchor.addEventListener('click', function (e) {
                e.preventDefault();
                const target = document.querySelector(this.getAttribute('href'));
                if (target) {
                    target.scrollIntoView({ behavior: 'smooth', block: 'start' });
                }
            });
        });

        // Add copy buttons to code blocks
        document.querySelectorAll('pre').forEach(block => {
            const button = document.createElement('button');
            button.className = 'absolute top-2 right-2 bg-gray-700 text-white px-3 py-1 rounded text-xs hover:bg-gray-600 transition';
            button.textContent = 'Copy';
            button.onclick = () => {
                navigator.clipboard.writeText(block.textContent);
                button.textContent = 'Copied!';
                setTimeout(() => button.textContent = 'Copy', 2000);
            };
            block.style.position = 'relative';
            block.appendChild(button);
        });
    </script>
</body>
</html>

<?php /**PATH D:\E - STARTUPS\WORK FOLDERS\PERSONAL\the-milimus-tournament\resources\views\documentation\system-walkthrough.blade.php ENDPATH**/ ?>