

<?php $__env->startSection('title', 'Account Verification - Email Confirmation'); ?>

<?php $__env->startSection('header-title', 'Account Verification'); ?>
<?php $__env->startSection('header-subtitle', 'Secure Your Tournament Account'); ?>

<?php $__env->startSection('content'); ?>
    <div class="content-section">
        <h2 class="section-title">Hello <?php echo e($user->name); ?>! 🎉</h2>
        <p class="section-text">
            Welcome to the Milimus Tournament community! We're excited to have you join our growing family of football enthusiasts.
        </p>
    </div>

    <div class="info-box">
        <div class="info-box-content">
            <h3 class="info-title">Account Information</h3>
            <div class="info-text">
                <strong>Name:</strong> <?php echo e($user->name); ?><br>
                <strong>Email:</strong> <?php echo e($user->email); ?><br>
                <strong>Registration Date:</strong> <?php echo e(now()->format('F j, Y')); ?><br>
                <strong>Account Type:</strong> Tournament Participant
            </div>
        </div>
    </div>

    <div class="content-section">
        <h3 class="section-title">Verify Your Email Address</h3>
        <p class="section-text">
            To secure your account and access all tournament features, please verify your email address using the OTP code below:
        </p>
        
        <div class="otp-container">
            <div class="otp-code"><?php echo e($otp); ?></div>
        </div>
        
        <p class="section-text" style="text-align: center; font-size: 14px; color: #6b7280;">
            Enter this code on the verification page to activate your account
        </p>
    </div>

    <div class="warning-box">
        <h4 style="color: #92400e; margin: 0 0 10px 0; font-weight: 600;">🔐 Security Notice</h4>
        <ul class="styled-list" style="margin: 0;">
            <li style="color: #92400e;">This verification code expires in <strong>24 hours</strong></li>
            <li style="color: #92400e;">Keep this code confidential and do not share it</li>
            <li style="color: #92400e;">Email verification is required for account security</li>
            <li style="color: #92400e;">Contact support if you didn't request this verification</li>
        </ul>
    </div>

    <div class="content-section">
        <h3 class="section-title">What You Can Do After Verification</h3>
        <ul class="styled-list">
            <li>Register your team for the tournament</li>
            <li>Access match schedules and results</li>
            <li>View tournament standings and statistics</li>
            <li>Receive important tournament updates</li>
            <li>Connect with other teams and players</li>
            <li>Download certificates and awards</li>
        </ul>
    </div>

    <div class="info-box" style="background: linear-gradient(135deg, #fef3c7 0%, #fde68a 100%); border-color: #f59e0b;">
        <div class="info-box-content">
            <h3 class="info-title" style="color: #92400e;">🏆 About Milimus Tournament</h3>
            <p class="info-text" style="color: #92400e;">
                Founded in 2021 in memory of a community leader, our tournament has grown from 500 to over 2,000 spectators. 
                We're dedicated to developing youth talent, supporting education, and building stronger communities through football.
            </p>
        </div>
    </div>

    <div class="content-section" style="text-align: center;">
        <a href="#" class="btn" style="display: inline-block; margin: 20px 0;">
            Complete Verification →
        </a>
    </div>

    <div class="content-section" style="text-align: center; margin-top: 30px;">
        <p class="section-text" style="color: #6b7280; font-size: 14px;">
            Need assistance? Contact our support team at 
            <a href="tel:0729565643" style="color: #16a34a; text-decoration: none; font-weight: 600;">0729565643</a>
            or visit our <a href="#" style="color: #16a34a; text-decoration: none;">help center</a>
        </p>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('emails.layouts.modern', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\E - STARTUPS\WORK FOLDERS\PERSONAL\the-milimus-tournament\resources\views\emails\user-otp.blade.php ENDPATH**/ ?>