
<div class="space-y-8">
    
    <div class="bg-gradient-to-r from-purple-600 to-blue-600 text-white p-8 rounded-lg shadow-lg">
        <h1 class="text-4xl font-bold mb-4">🏆 Tournament Categories System</h1>
        <p class="text-lg opacity-90">
            Multi-category tournaments with age and gender-specific divisions, custom registration fees, and location restrictions
        </p>
        <div class="mt-4 flex flex-wrap gap-3">
            <span class="bg-white/20 backdrop-blur-sm px-4 py-2 rounded-full text-sm">5 Categories</span>
            <span class="bg-white/20 backdrop-blur-sm px-4 py-2 rounded-full text-sm">Custom Fees</span>
            <span class="bg-white/20 backdrop-blur-sm px-4 py-2 rounded-full text-sm">Location Restrictions</span>
            <span class="bg-white/20 backdrop-blur-sm px-4 py-2 rounded-full text-sm">Strict Validation</span>
            <span class="bg-white/20 backdrop-blur-sm px-4 py-2 rounded-full text-sm">Separate Brackets</span>
        </div>
    </div>

    
    <section id="categories-overview">
        <h2 class="text-3xl font-bold text-gray-900 mb-4 flex items-center gap-3">
            <span class="bg-purple-100 text-purple-600 w-10 h-10 rounded-full flex items-center justify-center text-xl">📋</span>
            Overview
        </h2>
        
        <div class="bg-white rounded-lg shadow-md p-6 border-l-4 border-purple-500">
            <p class="text-gray-700 text-lg mb-4">
                The tournament system supports <strong>multiple categories</strong> within a single tournament, allowing different divisions based on age and gender requirements.
            </p>
            
            <div class="grid md:grid-cols-2 gap-4 mt-6">
                <div class="bg-blue-50 p-4 rounded-lg">
                    <h4 class="font-semibold text-blue-900 mb-2">✨ Key Features</h4>
                    <ul class="space-y-2 text-sm text-blue-800">
                        <li>✓ One tournament = Multiple divisions</li>
                        <li>✓ Category-specific registration fees</li>
                        <li>✓ Category-based location restrictions</li>
                        <li>✓ Age and gender validation</li>
                        <li>✓ Automatic player eligibility checking</li>
                        <li>✓ Separate brackets per category</li>
                    </ul>
                </div>
                
                <div class="bg-green-50 p-4 rounded-lg">
                    <h4 class="font-semibold text-green-900 mb-2">🎯 Benefits</h4>
                    <ul class="space-y-2 text-sm text-green-800">
                        <li>✓ Fair competition within age/gender groups</li>
                        <li>✓ Flexible pricing per category</li>
                        <li>✓ Automatic compliance enforcement</li>
                        <li>✓ Streamlined registration process</li>
                        <li>✓ Clear category identification</li>
                    </ul>
                </div>
            </div>
        </div>
    </section>

    
    <section id="available-categories">
        <h2 class="text-3xl font-bold text-gray-900 mb-4 flex items-center gap-3">
            <span class="bg-blue-100 text-blue-600 w-10 h-10 rounded-full flex items-center justify-center text-xl">🏅</span>
            Available Categories
        </h2>
        
        <div class="grid md:grid-cols-2 lg:grid-cols-3 gap-4">
            
            <div class="bg-gradient-to-br from-blue-500 to-blue-600 text-white rounded-lg shadow-lg p-6">
                <div class="text-5xl mb-3">👨</div>
                <h3 class="text-2xl font-bold mb-2">Men</h3>
                <div class="space-y-2 text-sm opacity-90">
                    <p><strong>Age:</strong> 18+ years</p>
                    <p><strong>Gender:</strong> Male (Required)</p>
                    <p><strong>Default Fee:</strong> KES 1,000</p>
                </div>
                <div class="mt-4 pt-4 border-t border-white/30">
                    <p class="text-xs">Open division for adult male players</p>
                </div>
            </div>

            
            <div class="bg-gradient-to-br from-pink-500 to-pink-600 text-white rounded-lg shadow-lg p-6">
                <div class="text-5xl mb-3">👩</div>
                <h3 class="text-2xl font-bold mb-2">Women</h3>
                <div class="space-y-2 text-sm opacity-90">
                    <p><strong>Age:</strong> 18+ years</p>
                    <p><strong>Gender:</strong> Female (Required)</p>
                    <p><strong>Default Fee:</strong> KES 800</p>
                </div>
                <div class="mt-4 pt-4 border-t border-white/30">
                    <p class="text-xs">Open division for adult female players</p>
                </div>
            </div>

            
            <div class="bg-gradient-to-br from-purple-500 to-purple-600 text-white rounded-lg shadow-lg p-6">
                <div class="text-5xl mb-3">🧑</div>
                <h3 class="text-2xl font-bold mb-2">Youth Male</h3>
                <div class="space-y-2 text-sm opacity-90">
                    <p><strong>Age:</strong> 13-17 years</p>
                    <p><strong>Gender:</strong> Male (Required)</p>
                    <p><strong>Default Fee:</strong> KES 500</p>
                </div>
                <div class="mt-4 pt-4 border-t border-white/30">
                    <p class="text-xs">Youth division for teenage male players</p>
                </div>
            </div>

            
            <div class="bg-gradient-to-br from-purple-400 to-purple-500 text-white rounded-lg shadow-lg p-6">
                <div class="text-5xl mb-3">👧</div>
                <h3 class="text-2xl font-bold mb-2">Youth Female</h3>
                <div class="space-y-2 text-sm opacity-90">
                    <p><strong>Age:</strong> 13-17 years</p>
                    <p><strong>Gender:</strong> Female (Required)</p>
                    <p><strong>Default Fee:</strong> KES 500</p>
                </div>
                <div class="mt-4 pt-4 border-t border-white/30">
                    <p class="text-xs">Youth division for teenage female players</p>
                </div>
            </div>

            
            <div class="bg-gradient-to-br from-green-500 to-green-600 text-white rounded-lg shadow-lg p-6">
                <div class="text-5xl mb-3">🧒</div>
                <h3 class="text-2xl font-bold mb-2">Children</h3>
                <div class="space-y-2 text-sm opacity-90">
                    <p><strong>Age:</strong> Under 13 years</p>
                    <p><strong>Gender:</strong> Any</p>
                    <p><strong>Default Fee:</strong> KES 300</p>
                </div>
                <div class="mt-4 pt-4 border-t border-white/30">
                    <p class="text-xs">Mixed division for young players</p>
                </div>
            </div>
        </div>
    </section>

    
    <section id="category-selection-flow">
        <h2 class="text-3xl font-bold text-gray-900 mb-4 flex items-center gap-3">
            <span class="bg-green-100 text-green-600 w-10 h-10 rounded-full flex items-center justify-center text-xl">🔄</span>
            Category Selection Process
        </h2>
        
        <div class="bg-white rounded-lg shadow-md p-6">
            <div class="mermaid">
graph TD
    A[Team Manager Starts Registration] --> B[Select Tournament]
    B --> C{Categories Enabled?}
    
    C -->|Yes| D[View Available Categories]
    C -->|No| Z[Continue to Team Info<br/>Default: Men Category]
    
    D --> E[See Requirements & Fees]
    E --> F[Select ONE Category]
    
    F --> G{All Categories}
    
    G --> H1[Men: 18+ Male<br/>KES 1,000]
    G --> H2[Women: 18+ Female<br/>KES 800]
    G --> H3[Youth Male: 13-17 Male<br/>KES 500]
    G --> H4[Youth Female: 13-17 Female<br/>KES 500]
    G --> H5[Children: &lt;13 Any<br/>KES 300]
    
    H1 --> I[Confirm Selection]
    H2 --> I
    H3 --> I
    H4 --> I
    H5 --> I
    
    I --> J[Add Team Details]
    J --> K[Add Players]
    K --> L{Validate Each Player}
    
    L -->|Age Match| M{Gender Match}
    L -->|Age Mismatch| ERROR1[❌ BLOCK: Age Requirement Not Met]
    
    M -->|Gender Match| PASS[✅ Player Valid]
    M -->|Gender Mismatch| ERROR2[❌ BLOCK: Gender Requirement Not Met]
    
    PASS --> N{All Players Valid?}
    ERROR1 --> FIX[Show Error - Fix Required]
    ERROR2 --> FIX
    
    FIX --> K
    
    N -->|Yes| O[Calculate Category-Specific Fee]
    N -->|No| FIX
    
    O --> P[Create Payment]
    P --> Q[Submit Registration]
    
    style D fill:#e1f5ff
    style F fill:#fff4e1
    style PASS fill:#d4edda
    style ERROR1 fill:#f8d7da
    style ERROR2 fill:#f8d7da
    style O fill:#d1ecf1
    style Q fill:#d4edda
            </div>
            
            <div class="mt-6 p-4 bg-yellow-50 border-l-4 border-yellow-500">
                <p class="text-sm text-yellow-800">
                    <strong>⚠️ Important:</strong> Once a category is selected and players are added, the category cannot be changed without clearing all players and restarting the process.
                </p>
            </div>
        </div>
    </section>

    
    <section id="validation-rules">
        <h2 class="text-3xl font-bold text-gray-900 mb-4 flex items-center gap-3">
            <span class="bg-red-100 text-red-600 w-10 h-10 rounded-full flex items-center justify-center text-xl">🛡️</span>
            Validation Rules
        </h2>
        
        <div class="bg-white rounded-lg shadow-md overflow-hidden">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Category</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Age Requirement</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Gender Requirement</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Enforcement</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    <tr>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-blue-100 text-blue-800">
                                👨 Men
                            </span>
                        </td>
                        <td class="px-6 py-4">18+ years</td>
                        <td class="px-6 py-4">Male (Strictly Required)</td>
                        <td class="px-6 py-4 text-red-600 font-semibold">❌ BLOCKS Female/Other</td>
                    </tr>
                    <tr class="bg-gray-50">
                        <td class="px-6 py-4 whitespace-nowrap">
                            <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-pink-100 text-pink-800">
                                👩 Women
                            </span>
                        </td>
                        <td class="px-6 py-4">18+ years</td>
                        <td class="px-6 py-4">Female (Strictly Required)</td>
                        <td class="px-6 py-4 text-red-600 font-semibold">❌ BLOCKS Male/Other</td>
                    </tr>
                    <tr>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-purple-100 text-purple-800">
                                🧑 Youth Male
                            </span>
                        </td>
                        <td class="px-6 py-4">13-17 years</td>
                        <td class="px-6 py-4">Male (Strictly Required)</td>
                        <td class="px-6 py-4 text-red-600 font-semibold">❌ BLOCKS Female/Other</td>
                    </tr>
                    <tr class="bg-gray-50">
                        <td class="px-6 py-4 whitespace-nowrap">
                            <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-purple-100 text-purple-800">
                                👧 Youth Female
                            </span>
                        </td>
                        <td class="px-6 py-4">13-17 years</td>
                        <td class="px-6 py-4">Female (Strictly Required)</td>
                        <td class="px-6 py-4 text-red-600 font-semibold">❌ BLOCKS Male/Other</td>
                    </tr>
                    <tr>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-green-100 text-green-800">
                                🧒 Children
                            </span>
                        </td>
                        <td class="px-6 py-4">Under 13 years</td>
                        <td class="px-6 py-4">Any Gender</td>
                        <td class="px-6 py-4 text-green-600 font-semibold">✅ Mixed Gender Allowed</td>
                    </tr>
                </tbody>
            </table>
        </div>

        
        <div class="mt-6 grid md:grid-cols-2 gap-4">
            <div class="bg-red-50 border border-red-200 rounded-lg p-4">
                <h4 class="font-bold text-red-900 mb-3 flex items-center gap-2">
                    ❌ Blocked Scenarios
                </h4>
                <ul class="space-y-2 text-sm text-red-800">
                    <li>• Male player registering for Women's category</li>
                    <li>• Female player registering for Men's category</li>
                    <li>• 16-year-old registering for Men's category</li>
                    <li>• 18-year-old registering for Youth category</li>
                    <li>• 13-year-old registering for Children's category</li>
                </ul>
            </div>

            <div class="bg-green-50 border border-green-200 rounded-lg p-4">
                <h4 class="font-bold text-green-900 mb-3 flex items-center gap-2">
                    ✅ Allowed Scenarios
                </h4>
                <ul class="space-y-2 text-sm text-green-800">
                    <li>• 25-year-old male for Men's category</li>
                    <li>• 22-year-old female for Women's category</li>
                    <li>• 15-year-old male for Youth Male category</li>
                    <li>• 14-year-old female for Youth Female category</li>
                    <li>• 10-year-old (any gender) for Children's category</li>
                </ul>
            </div>
        </div>
    </section>

    
    <section id="fee-structure">
        <h2 class="text-3xl font-bold text-gray-900 mb-4 flex items-center gap-3">
            <span class="bg-yellow-100 text-yellow-600 w-10 h-10 rounded-full flex items-center justify-center text-xl">💰</span>
            Fee Structure
        </h2>
        
        <div class="bg-white rounded-lg shadow-md p-6">
            <p class="text-gray-700 mb-6">
                Tournament organizers can set custom fees for each category. Default fees are:
            </p>
            
            <div class="grid md:grid-cols-5 gap-4 mb-6">
                <div class="bg-blue-50 border-2 border-blue-200 rounded-lg p-4 text-center">
                    <div class="text-3xl mb-2">👨</div>
                    <div class="text-sm text-gray-600 mb-1">Men</div>
                    <div class="text-2xl font-bold text-blue-600">KES 1,000</div>
                </div>
                <div class="bg-pink-50 border-2 border-pink-200 rounded-lg p-4 text-center">
                    <div class="text-3xl mb-2">👩</div>
                    <div class="text-sm text-gray-600 mb-1">Women</div>
                    <div class="text-2xl font-bold text-pink-600">KES 800</div>
                </div>
                <div class="bg-purple-50 border-2 border-purple-200 rounded-lg p-4 text-center">
                    <div class="text-3xl mb-2">🧑</div>
                    <div class="text-sm text-gray-600 mb-1">Youth Male</div>
                    <div class="text-2xl font-bold text-purple-600">KES 500</div>
                </div>
                <div class="bg-purple-50 border-2 border-purple-200 rounded-lg p-4 text-center">
                    <div class="text-3xl mb-2">👧</div>
                    <div class="text-sm text-gray-600 mb-1">Youth Female</div>
                    <div class="text-2xl font-bold text-purple-600">KES 500</div>
                </div>
                <div class="bg-green-50 border-2 border-green-200 rounded-lg p-4 text-center">
                    <div class="text-3xl mb-2">🧒</div>
                    <div class="text-sm text-gray-600 mb-1">Children</div>
                    <div class="text-2xl font-bold text-green-600">KES 300</div>
                </div>
            </div>

            <div class="bg-blue-50 border-l-4 border-blue-500 p-4">
                <h4 class="font-bold text-blue-900 mb-2">💡 How Fees Work</h4>
                <ul class="space-y-2 text-sm text-blue-800">
                    <li>• Tournament organizers can customize fees per category</li>
                    <li>• Teams pay the fee for their selected category</li>
                    <li>• Payment amount automatically calculated based on category</li>
                    <li>• Different categories can have different prize pools</li>
                    <li>• Youth and children's categories typically have reduced fees</li>
                </ul>
            </div>
        </div>
    </section>

    
    <section id="location-restrictions">
        <h2 class="text-3xl font-bold text-gray-900 mb-4 flex items-center gap-3">
            <span class="bg-orange-100 text-orange-600 w-10 h-10 rounded-full flex items-center justify-center text-xl">📍</span>
            Category Location Restrictions
        </h2>
        
        <div class="bg-white rounded-lg shadow-md p-6">
            <h3 class="text-xl font-bold text-gray-900 mb-4">Location Management by Category</h3>
            
            <p class="text-gray-700 mb-6">
                Administrators can configure location restrictions for each tournament category independently. 
                This allows fine-grained control over where teams can register from.
            </p>

            <div class="grid md:grid-cols-2 gap-6 mb-6">
                <div class="bg-green-50 border-2 border-green-200 rounded-lg p-5">
                    <h4 class="font-bold text-green-900 mb-3 flex items-center gap-2">
                        ✅ Unrestricted Category
                    </h4>
                    <p class="text-sm text-green-800 mb-3">
                        When location restriction is <strong>OFF</strong>:
                    </p>
                    <ul class="space-y-2 text-sm text-green-800">
                        <li>• Teams can enter ANY location (text input)</li>
                        <li>• No validation on location field</li>
                        <li>• Maximum flexibility for team managers</li>
                        <li>• Useful for open/national tournaments</li>
                    </ul>
                </div>

                <div class="bg-orange-50 border-2 border-orange-200 rounded-lg p-5">
                    <h4 class="font-bold text-orange-900 mb-3 flex items-center gap-2">
                        🔒 Restricted Category
                    </h4>
                    <p class="text-sm text-orange-800 mb-3">
                        When location restriction is <strong>ON</strong>:
                    </p>
                    <ul class="space-y-2 text-sm text-orange-800">
                        <li>• Teams select from dropdown of allowed locations</li>
                        <li>• Strict validation enforced</li>
                        <li>• Admin-controlled location list</li>
                        <li>• Useful for regional tournaments</li>
                    </ul>
                </div>
            </div>

            <div class="bg-blue-50 border-l-4 border-blue-500 p-4">
                <h4 class="font-bold text-blue-900 mb-2">🎯 Example Configurations</h4>
                <ul class="space-y-2 text-sm text-blue-800">
                    <li>• <strong>Men's Category:</strong> Restricted to Nairobi, Mombasa, Kisumu (major cities only)</li>
                    <li>• <strong>Women's Category:</strong> Unrestricted (any location allowed)</li>
                    <li>• <strong>Youth Categories:</strong> Restricted to specific training centers</li>
                    <li>• <strong>Children's Category:</strong> Unrestricted (maximum accessibility)</li>
                </ul>
            </div>
        </div>
    </section>

    
    <section id="tournament-configuration">
        <h2 class="text-3xl font-bold text-gray-900 mb-4 flex items-center gap-3">
            <span class="bg-indigo-100 text-indigo-600 w-10 h-10 rounded-full flex items-center justify-center text-xl">⚙️</span>
            Tournament Configuration
        </h2>
        
        <div class="bg-white rounded-lg shadow-md p-6">
            <h3 class="text-xl font-bold text-gray-900 mb-4">For Tournament Organizers</h3>
            
            <div class="space-y-4">
                <div class="border-l-4 border-indigo-500 pl-4">
                    <h4 class="font-bold text-gray-900 mb-2">Step 1: Enable Categories</h4>
                    <p class="text-gray-700 text-sm">
                        Toggle "Enable Categories" switch when creating or editing a tournament to activate multi-category support.
                    </p>
                </div>

                <div class="border-l-4 border-purple-500 pl-4">
                    <h4 class="font-bold text-gray-900 mb-2">Step 2: Select Available Categories</h4>
                    <p class="text-gray-700 text-sm">
                        Use switches to enable/disable specific categories. Only enabled categories will be shown to teams during registration.
                    </p>
                </div>

                <div class="border-l-4 border-blue-500 pl-4">
                    <h4 class="font-bold text-gray-900 mb-2">Step 3: Set Category Fees</h4>
                    <p class="text-gray-700 text-sm">
                        Configure custom registration fees for each enabled category. Fee inputs automatically show/hide when category is toggled.
                    </p>
                </div>

                <div class="border-l-4 border-orange-500 pl-4">
                    <h4 class="font-bold text-gray-900 mb-2">Step 4: Configure Location Restrictions (Optional)</h4>
                    <p class="text-gray-700 text-sm">
                        In Tournament Settings, toggle location restrictions for each category and specify allowed locations if needed.
                    </p>
                </div>

                <div class="border-l-4 border-green-500 pl-4">
                    <h4 class="font-bold text-gray-900 mb-2">Step 5: Teams Register</h4>
                    <p class="text-gray-700 text-sm">
                        Teams select their category during registration. System automatically validates player eligibility and location restrictions.
                    </p>
                </div>
            </div>
        </div>
    </section>

    
    <section id="categories-summary">
        <h2 class="text-3xl font-bold text-gray-900 mb-4 flex items-center gap-3">
            <span class="bg-gray-100 text-gray-600 w-10 h-10 rounded-full flex items-center justify-center text-xl">📊</span>
            System Summary
        </h2>
        
        <div class="grid md:grid-cols-4 gap-6">
            <div class="bg-gradient-to-br from-blue-500 to-blue-600 text-white rounded-lg p-6 shadow-lg">
                <div class="text-4xl font-bold mb-2">5</div>
                <div class="text-lg font-semibold">Categories</div>
                <div class="text-sm opacity-80 mt-1">Men, Women, Youth Male, Youth Female, Children</div>
            </div>

            <div class="bg-gradient-to-br from-green-500 to-green-600 text-white rounded-lg p-6 shadow-lg">
                <div class="text-4xl font-bold mb-2">100%</div>
                <div class="text-lg font-semibold">Validation</div>
                <div class="text-sm opacity-80 mt-1">Strict age and gender enforcement</div>
            </div>

            <div class="bg-gradient-to-br from-purple-500 to-purple-600 text-white rounded-lg p-6 shadow-lg">
                <div class="text-4xl font-bold mb-2">∞</div>
                <div class="text-lg font-semibold">Flexibility</div>
                <div class="text-sm opacity-80 mt-1">Custom fees per category per tournament</div>
            </div>

            <div class="bg-gradient-to-br from-orange-500 to-orange-600 text-white rounded-lg p-6 shadow-lg">
                <div class="text-4xl font-bold mb-2">📍</div>
                <div class="text-lg font-semibold">Locations</div>
                <div class="text-sm opacity-80 mt-1">Optional category-based restrictions</div>
            </div>
        </div>

        <div class="mt-6 bg-gradient-to-r from-blue-50 to-purple-50 border border-blue-200 rounded-lg p-6">
            <h3 class="text-xl font-bold text-gray-900 mb-3">✨ Key Takeaways</h3>
            <ul class="grid md:grid-cols-2 gap-3 text-sm text-gray-700">
                <li class="flex items-start gap-2">
                    <span class="text-green-600 mt-0.5">✓</span>
                    <span>Single tournament can have all 5 categories</span>
                </li>
                <li class="flex items-start gap-2">
                    <span class="text-green-600 mt-0.5">✓</span>
                    <span>Each category has specific age/gender rules</span>
                </li>
                <li class="flex items-start gap-2">
                    <span class="text-green-600 mt-0.5">✓</span>
                    <span>Automatic player eligibility validation</span>
                </li>
                <li class="flex items-start gap-2">
                    <span class="text-green-600 mt-0.5">✓</span>
                    <span>Custom registration fees per category</span>
                </li>
                <li class="flex items-start gap-2">
                    <span class="text-green-600 mt-0.5">✓</span>
                    <span>Location restrictions per category (optional)</span>
                </li>
                <li class="flex items-start gap-2">
                    <span class="text-green-600 mt-0.5">✓</span>
                    <span>Dynamic location input (dropdown/text)</span>
                </li>
                <li class="flex items-start gap-2">
                    <span class="text-green-600 mt-0.5">✓</span>
                    <span>Separate brackets for each category</span>
                </li>
                <li class="flex items-start gap-2">
                    <span class="text-green-600 mt-0.5">✓</span>
                    <span>Strict enforcement prevents invalid registrations</span>
                </li>
            </ul>
        </div>
    </section>
</div>

<script src="https://cdn.jsdelivr.net/npm/mermaid@10/dist/mermaid.min.js"></script>
<script>
    mermaid.initialize({ 
        startOnLoad: true,
        theme: 'default',
        flowchart: {
            useMaxWidth: true,
            htmlLabels: true,
            curve: 'basis'
        }
    });
</script>

<?php /**PATH D:\E - STARTUPS\WORK FOLDERS\PERSONAL\the-milimus-tournament\resources\views\documentation\partials\tournament-categories.blade.php ENDPATH**/ ?>