<!-- Payment Processing Documentation -->

<div class="section-card">
    <h2 class="text-4xl font-bold mb-6">💳 Payment Processing Workflow</h2>
    
    <div class="bg-blue-50 border-l-4 border-blue-500 p-6 rounded-r-lg mb-6">
        <p class="text-lg text-blue-900 font-semibold">📖 What You'll Learn</p>
        <ul class="mt-3 space-y-2 text-blue-800">
            <li>✅ Complete payment lifecycle from initiation to completion</li>
            <li>✅ M-Pesa integration and payment gateway flow</li>
            <li>✅ Decision logic for payment status changes</li>
            <li>✅ Retry mechanism for failed payments</li>
            <li>✅ Refund processing workflow</li>
            <li>✅ All notifications triggered during payment events</li>
        </ul>
    </div>
</div>

<!-- Overview -->
<div class="section-card">
    <h3 class="text-2xl font-bold mb-4 flex items-center">
        <span class="step-number">1</span>
        Overview
    </h3>
    
    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
        <div>
            <h4 class="font-bold text-lg mb-3 text-blue-600">💰 What is Payment Processing?</h4>
            <p class="text-gray-700 leading-relaxed">
                Payment processing handles all financial transactions in the system including tournament entry fees, 
                team registration payments, and other charges. The system supports M-Pesa integration with real-time 
                status updates and automatic verification.
            </p>
        </div>

        <div>
            <h4 class="font-bold text-lg mb-3 text-green-600">👥 Who Makes Payments?</h4>
            <ul class="space-y-2 text-gray-700">
                <li class="flex items-start">
                    <span class="text-green-500 mr-2">•</span>
                    <span><strong>Team Captains:</strong> Tournament entry fees</span>
                </li>
                <li class="flex items-start">
                    <span class="text-green-500 mr-2">•</span>
                    <span><strong>Team Managers:</strong> Additional team payments</span>
                </li>
                <li class="flex items-start">
                    <span class="text-green-500 mr-2">•</span>
                    <span><strong>Players:</strong> Individual registration fees</span>
                </li>
            </ul>
        </div>

        <div>
            <h4 class="font-bold text-lg mb-3 text-purple-600">🏷️ Payment Types</h4>
            <ul class="space-y-2 text-gray-700">
                <li class="flex items-start">
                    <span class="text-purple-500 mr-2">•</span>
                    <span><strong>Tournament Entry Fee:</strong> Required for team registration</span>
                </li>
                <li class="flex items-start">
                    <span class="text-purple-500 mr-2">•</span>
                    <span><strong>Additional Fees:</strong> Late registration, modifications</span>
                </li>
                <li class="flex items-start">
                    <span class="text-purple-500 mr-2">•</span>
                    <span><strong>Refunds:</strong> Tournament cancellations</span>
                </li>
            </ul>
        </div>

        <div>
            <h4 class="font-bold text-lg mb-3 text-orange-600">⏱️ Processing Timeline</h4>
            <ul class="space-y-2 text-gray-700">
                <li class="flex justify-between">
                    <span>Initiation:</span>
                    <span class="font-semibold">Instant</span>
                </li>
                <li class="flex justify-between">
                    <span>M-Pesa Prompt:</span>
                    <span class="font-semibold">2-5 seconds</span>
                </li>
                <li class="flex justify-between">
                    <span>Completion:</span>
                    <span class="font-semibold">10-30 seconds</span>
                </li>
                <li class="flex justify-between">
                    <span>Refund:</span>
                    <span class="font-semibold">1-3 business days</span>
                </li>
            </ul>
        </div>
    </div>
</div>

<!-- Payment Lifecycle Diagram -->
<div class="section-card">
    <h3 class="text-2xl font-bold mb-4 flex items-center">
        <span class="step-number">2</span>
        Complete Payment Lifecycle
    </h3>

    <div class="mermaid bg-white p-6 rounded-lg shadow-inner">
flowchart TD
    Start([💳 Payment Record Created])
    Start --> StatusPending[Status: PENDING<br/>• Reference number generated<br/>• Amount and details stored]
    
    StatusPending --> UserAction{User Initiates<br/>Payment?}
    UserAction -->|No| Reminder[🔔 Send Reminder<br/>after 24 hours]
    Reminder --> UserAction
    
    UserAction -->|Yes| InitiateMpesa[📱 Initiate M-Pesa Payment<br/>• Generate transaction ID<br/>• Send STK push to phone]
    
    InitiateMpesa --> StatusProcessing[Status: PROCESSING<br/>• User receives M-Pesa prompt<br/>• Awaiting PIN entry]
    
    StatusProcessing --> NotifyProcessing[📧 Send Notifications:<br/>• PaymentProcessingNotification]
    
    NotifyProcessing --> UserResponds{User Enters<br/>PIN?}
    UserResponds -->|Timeout/Cancel| StatusFailed[Status: FAILED<br/>• Transaction cancelled<br/>• User can retry]
    UserResponds -->|PIN Entered| ValidatePayment{M-Pesa Gateway<br/>Validates?}
    
    ValidatePayment -->|Invalid| StatusFailed
    ValidatePayment -->|Valid| ProcessPayment[Process Payment<br/>• Deduct from account<br/>• Generate M-Pesa code]
    
    ProcessPayment --> StatusCompleted[Status: COMPLETED<br/>• M-Pesa code received<br/>• Transaction confirmed]
    
    StatusCompleted --> NotifyCompleted[📧 Send Notifications:<br/>• PaymentCompletedNotification<br/>• TeamPaymentCompletedNotification<br/>• PaymentCompletedAdminNotification]
    
    NotifyCompleted --> UpdateRecords[Update Related Records<br/>• Team payment_status: completed<br/>• User payment_status: completed]
    
    UpdateRecords --> GenerateReceipt[Generate Receipt<br/>• PDF receipt created<br/>• Email sent]
    
    StatusFailed --> NotifyFailed[📧 Send Notifications:<br/>• PaymentFailedNotification<br/>• Show retry option]
    
    NotifyFailed --> RetryOption{User Retries?}
    RetryOption -->|Yes| InitiateMpesa
    RetryOption -->|No| PaymentAbandoned[Payment Abandoned<br/>• Team cannot proceed]
    
    GenerateReceipt --> RefundRequest{Refund<br/>Requested?}
    RefundRequest -->|No| End([Payment Complete])
    RefundRequest -->|Yes| ProcessRefund[Process Refund<br/>• Admin approval required<br/>• M-Pesa reversal]
    
    ProcessRefund --> StatusRefunded[Status: REFUNDED<br/>• Amount returned<br/>• Transaction reversed]
    
    StatusRefunded --> NotifyRefunded[📧 Send Notifications:<br/>• PaymentRefundedNotification<br/>• TeamPaymentRefundedNotification]
    
    NotifyRefunded --> End
    PaymentAbandoned --> End
    
    style Start fill:#4CAF50,stroke:#2E7D32,color:#fff
    style StatusPending fill:#FFC107,stroke:#F57C00,color:#000
    style StatusProcessing fill:#2196F3,stroke:#1565C0,color:#fff
    style StatusCompleted fill:#4CAF50,stroke:#2E7D32,color:#fff
    style StatusFailed fill:#f44336,stroke:#c62828,color:#fff
    style StatusRefunded fill:#9C27B0,stroke:#6A1B9A,color:#fff
    style End fill:#4CAF50,stroke:#2E7D32,color:#fff
    </div>
</div>

<!-- Step-by-Step Walkthrough -->
<div class="section-card">
    <h3 class="text-2xl font-bold mb-6 flex items-center">
        <span class="step-number">3</span>
        Detailed Step-by-Step Walkthrough
    </h3>

    <!-- Step 1: Payment Creation -->
    <div class="mb-8">
        <h4 class="text-xl font-bold mb-4 text-blue-600">Step 1: Payment Record Creation</h4>
        
        <div class="bg-yellow-50 rounded-lg p-4">
            <p class="text-gray-700 mb-4">Payment record is automatically created during team registration.</p>
            
            <div class="bg-white rounded-lg p-4 space-y-2 font-mono text-sm">
                <div class="flex justify-between">
                    <span class="text-gray-600">Amount:</span>
                    <span class="font-bold">KES 1,000</span>
                </div>
                <div class="flex justify-between">
                    <span class="text-gray-600">Status:</span>
                    <span class="text-yellow-600 font-bold">pending</span>
                </div>
                <div class="flex justify-between">
                    <span class="text-gray-600">Payment Method:</span>
                    <span class="font-bold">Mpesa</span>
                </div>
                <div class="flex justify-between">
                    <span class="text-gray-600">Reference:</span>
                    <span class="font-bold">PAY_abc123xyz</span>
                </div>
                <div class="flex justify-between">
                    <span class="text-gray-600">Description:</span>
                    <span class="font-bold">Tournament Registration Fee</span>
                </div>
            </div>
        </div>

        <div class="notification-box mt-4">
            <p class="font-bold text-green-800 mb-2">📧 Notifications Sent:</p>
            <div class="grid grid-cols-1 md:grid-cols-3 gap-3">
                <div class="bg-white rounded p-3">
                    <p class="font-semibold text-sm">To User:</p>
                    <code class="text-xs">PaymentInitiatedNotification</code>
                </div>
                <div class="bg-white rounded p-3">
                    <p class="font-semibold text-sm">To Team Manager:</p>
                    <code class="text-xs">TeamPaymentInitiatedNotification</code>
                </div>
                <div class="bg-white rounded p-3">
                    <p class="font-semibold text-sm">To Admins:</p>
                    <code class="text-xs">PaymentInitiatedAdminNotification</code>
                </div>
            </div>
        </div>

        <div class="screenshot-placeholder-sm mt-4">
            <p class="text-xl text-gray-400 mb-2">📸</p>
            <p class="text-gray-600 font-mono">[screenshot-payment-dashboard.png]</p>
            <p class="text-xs text-gray-500 mt-2">Payment dashboard showing pending payment</p>
        </div>
    </div>

    <!-- Step 2: Payment Initiation -->
    <div class="mb-8">
        <h4 class="text-xl font-bold mb-4 text-blue-600">Step 2: M-Pesa Payment Initiation</h4>
        
        <div class="decision-box">
            <p class="font-bold text-blue-800 mb-2">🤔 User Action Required</p>
            <p class="text-blue-800 mb-3">User navigates to payment page and clicks "Complete Payment" button.</p>
            
            <div class="bg-white rounded-lg p-4">
                <p class="font-semibold mb-3">System Actions:</p>
                <ol class="space-y-2 list-decimal list-inside text-gray-700">
                    <li>Generate unique transaction ID</li>
                    <li>Update payment status to "processing"</li>
                    <li>Send STK push request to M-Pesa API</li>
                    <li>User's phone receives payment prompt</li>
                    <li>Wait for user to enter PIN</li>
                </ol>
            </div>
        </div>

        <div class="notification-box mt-4">
            <p class="font-bold text-green-800 mb-2">📧 Notification Sent:</p>
            <div class="bg-white rounded p-3 inline-block">
                <p class="font-semibold text-sm">To User:</p>
                <code class="text-xs">PaymentProcessingNotification</code>
            </div>
        </div>

        <div class="screenshot-placeholder mt-4">
            <p class="text-2xl text-gray-400 mb-2">📸</p>
            <p class="text-gray-600 font-mono text-lg">[screenshot-mpesa-integration.png]</p>
            <p class="text-sm text-gray-500 mt-2">M-Pesa STK push prompt on user's phone</p>
        </div>
    </div>

    <!-- Step 3: Payment Completion or Failure -->
    <div class="mb-8">
        <h4 class="text-xl font-bold mb-4 text-blue-600">Step 3: Payment Result</h4>
        
        <div class="decision-box">
            <p class="font-bold text-blue-800 mb-2">🤔 Decision Point: Payment Successful?</p>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mt-4">
                <!-- Success Path -->
                <div class="bg-green-50 rounded-lg p-4 border-2 border-green-300">
                    <p class="font-semibold text-green-700 mb-3">✅ SUCCESS: Payment Completed</p>
                    <div class="space-y-2 text-sm text-gray-700">
                        <div class="bg-white rounded p-2">
                            <strong>1.</strong> M-Pesa confirms transaction
                        </div>
                        <div class="bg-white rounded p-2">
                            <strong>2.</strong> Update status to "completed"
                        </div>
                        <div class="bg-white rounded p-2">
                            <strong>3.</strong> Store M-Pesa transaction code
                        </div>
                        <div class="bg-white rounded p-2">
                            <strong>4.</strong> Update team payment_status
                        </div>
                        <div class="bg-white rounded p-2">
                            <strong>5.</strong> Generate receipt PDF
                        </div>
                        <div class="bg-white rounded p-2">
                            <strong>6.</strong> Send confirmation emails
                        </div>
                    </div>
                </div>

                <!-- Failure Path -->
                <div class="bg-red-50 rounded-lg p-4 border-2 border-red-300">
                    <p class="font-semibold text-red-700 mb-3">❌ FAILURE: Payment Failed</p>
                    <div class="space-y-2 text-sm text-gray-700">
                        <div class="bg-white rounded p-2">
                            <strong>Reasons:</strong> Timeout, insufficient funds, cancelled
                        </div>
                        <div class="bg-white rounded p-2">
                            <strong>1.</strong> Update status to "failed"
                        </div>
                        <div class="bg-white rounded p-2">
                            <strong>2.</strong> Log failure reason
                        </div>
                        <div class="bg-white rounded p-2">
                            <strong>3.</strong> Send failure notification
                        </div>
                        <div class="bg-white rounded p-2">
                            <strong>4.</strong> Show retry button to user
                        </div>
                        <div class="bg-white rounded p-2">
                            <strong>5.</strong> Team remains in pending state
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mt-4">
            <div class="notification-box">
                <p class="font-bold text-green-800 mb-2">📧 Success Notifications:</p>
                <div class="space-y-2">
                    <div class="bg-white rounded p-2 text-sm">
                        <code class="text-xs">PaymentCompletedNotification</code> → User
                    </div>
                    <div class="bg-white rounded p-2 text-sm">
                        <code class="text-xs">TeamPaymentCompletedNotification</code> → Manager
                    </div>
                    <div class="bg-white rounded p-2 text-sm">
                        <code class="text-xs">PaymentCompletedAdminNotification</code> → Admins
                    </div>
                </div>
            </div>

            <div class="warning-box">
                <p class="font-bold text-yellow-800 mb-2">📧 Failure Notifications:</p>
                <div class="space-y-2">
                    <div class="bg-white rounded p-2 text-sm">
                        <code class="text-xs">PaymentFailedNotification</code> → User
                    </div>
                    <div class="bg-white rounded p-2 text-sm">
                        <code class="text-xs">PaymentFailedAdminNotification</code> → Admins
                    </div>
                </div>
            </div>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mt-4">
            <div class="screenshot-placeholder-sm">
                <p class="text-xl text-gray-400 mb-2">📸</p>
                <p class="text-gray-600 font-mono">[screenshot-payment-receipt.png]</p>
                <p class="text-xs text-gray-500 mt-2">Payment receipt view</p>
            </div>
            <div class="screenshot-placeholder-sm">
                <p class="text-xl text-gray-400 mb-2">📸</p>
                <p class="text-gray-600 font-mono">[screenshot-payment-failed.png]</p>
                <p class="text-xs text-gray-500 mt-2">Failed payment with retry option</p>
            </div>
        </div>
    </div>

    <!-- Step 4: Refund Process -->
    <div class="mb-8">
        <h4 class="text-xl font-bold mb-4 text-blue-600">Step 4: Refund Processing (If Applicable)</h4>
        
        <div class="bg-purple-50 rounded-lg p-4">
            <p class="text-gray-700 mb-4">Refunds are processed when tournaments are cancelled or upon admin approval.</p>
            
            <div class="bg-white rounded-lg p-4">
                <p class="font-semibold mb-3">Refund Process:</p>
                <ol class="space-y-2 list-decimal list-inside text-gray-700">
                    <li>Tournament cancelled or refund request submitted</li>
                    <li>Admin reviews and approves refund request</li>
                    <li>System initiates M-Pesa reversal</li>
                    <li>Payment status updated to "refunded"</li>
                    <li>User receives funds (1-3 business days)</li>
                    <li>Notifications sent to all parties</li>
                </ol>
            </div>
        </div>

        <div class="notification-box mt-4">
            <p class="font-bold text-green-800 mb-2">📧 Refund Notifications:</p>
            <div class="grid grid-cols-1 md:grid-cols-3 gap-3">
                <div class="bg-white rounded p-3">
                    <p class="font-semibold text-sm">To User:</p>
                    <code class="text-xs">PaymentRefundedNotification</code>
                </div>
                <div class="bg-white rounded p-3">
                    <p class="font-semibold text-sm">To Team Manager:</p>
                    <code class="text-xs">TeamPaymentRefundedNotification</code>
                </div>
                <div class="bg-white rounded p-3">
                    <p class="font-semibold text-sm">To Admins:</p>
                    <code class="text-xs">PaymentRefundedAdminNotification</code>
                </div>
            </div>
        </div>

        <div class="screenshot-placeholder-sm mt-4">
            <p class="text-xl text-gray-400 mb-2">📸</p>
            <p class="text-gray-600 font-mono">[screenshot-refund-interface.png]</p>
            <p class="text-xs text-gray-500 mt-2">Refund request and processing interface</p>
        </div>
    </div>
</div>

<!-- Payment Status Table -->
<div class="section-card">
    <h3 class="text-2xl font-bold mb-4 flex items-center">
        <span class="step-number">4</span>
        Payment Status Reference
    </h3>
    
    <div class="overflow-x-auto">
        <table class="w-full bg-white rounded-lg shadow">
            <thead class="bg-gray-100">
                <tr>
                    <th class="px-4 py-3 text-left font-semibold">Status</th>
                    <th class="px-4 py-3 text-left font-semibold">Description</th>
                    <th class="px-4 py-3 text-left font-semibold">User Action</th>
                    <th class="px-4 py-3 text-left font-semibold">Notifications Sent</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-gray-200">
                <tr class="hover:bg-gray-50">
                    <td class="px-4 py-3">
                        <span class="bg-yellow-100 px-3 py-1 rounded font-semibold">PENDING</span>
                    </td>
                    <td class="px-4 py-3">Payment created but not yet initiated by user</td>
                    <td class="px-4 py-3">Click "Complete Payment" button</td>
                    <td class="px-4 py-3 text-sm">PaymentInitiated (3)</td>
                </tr>
                <tr class="hover:bg-gray-50">
                    <td class="px-4 py-3">
                        <span class="bg-blue-100 px-3 py-1 rounded font-semibold">PROCESSING</span>
                    </td>
                    <td class="px-4 py-3">M-Pesa prompt sent, awaiting PIN entry</td>
                    <td class="px-4 py-3">Enter M-Pesa PIN on phone</td>
                    <td class="px-4 py-3 text-sm">PaymentProcessing (1)</td>
                </tr>
                <tr class="hover:bg-gray-50">
                    <td class="px-4 py-3">
                        <span class="bg-green-100 px-3 py-1 rounded font-semibold">COMPLETED</span>
                    </td>
                    <td class="px-4 py-3">Payment successful, transaction confirmed</td>
                    <td class="px-4 py-3">None - automatic</td>
                    <td class="px-4 py-3 text-sm">PaymentCompleted (3)</td>
                </tr>
                <tr class="hover:bg-gray-50">
                    <td class="px-4 py-3">
                        <span class="bg-red-100 px-3 py-1 rounded font-semibold">FAILED</span>
                    </td>
                    <td class="px-4 py-3">Payment failed (timeout, cancelled, insufficient funds)</td>
                    <td class="px-4 py-3">Click "Retry Payment" button</td>
                    <td class="px-4 py-3 text-sm">PaymentFailed (2)</td>
                </tr>
                <tr class="hover:bg-gray-50">
                    <td class="px-4 py-3">
                        <span class="bg-purple-100 px-3 py-1 rounded font-semibold">REFUNDED</span>
                    </td>
                    <td class="px-4 py-3">Payment refunded to user account</td>
                    <td class="px-4 py-3">None - admin initiated</td>
                    <td class="px-4 py-3 text-sm">PaymentRefunded (3)</td>
                </tr>
                <tr class="hover:bg-gray-50">
                    <td class="px-4 py-3">
                        <span class="bg-orange-100 px-3 py-1 rounded font-semibold">DISPUTED</span>
                    </td>
                    <td class="px-4 py-3">Payment under dispute/investigation</td>
                    <td class="px-4 py-3">Wait for admin resolution</td>
                    <td class="px-4 py-3 text-sm">PaymentDispute (1 - admin only)</td>
                </tr>
            </tbody>
        </table>
    </div>
</div>

<!-- Summary -->
<div class="section-card bg-gradient-to-r from-yellow-50 to-green-50">
    <h3 class="text-2xl font-bold mb-4">📚 Quick Reference Summary</h3>
    
    <div class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-6">
        <div class="bg-white rounded-lg p-4 shadow">
            <p class="text-3xl font-bold text-blue-600 mb-2">6</p>
            <p class="text-gray-700">Payment Statuses</p>
        </div>
        <div class="bg-white rounded-lg p-4 shadow">
            <p class="text-3xl font-bold text-green-600 mb-2">~12</p>
            <p class="text-gray-700">Notifications Types</p>
        </div>
        <div class="bg-white rounded-lg p-4 shadow">
            <p class="text-3xl font-bold text-purple-600 mb-2">10-30s</p>
            <p class="text-gray-700">Avg Processing Time</p>
        </div>
        <div class="bg-white rounded-lg p-4 shadow">
            <p class="text-3xl font-bold text-orange-600 mb-2">100%</p>
            <p class="text-gray-700">Automated</p>
        </div>
    </div>

    <div class="bg-white rounded-lg p-6">
        <p class="font-semibold text-gray-800 mb-3">🎯 Key Takeaways:</p>
        <ul class="space-y-2 text-gray-700">
            <li class="flex items-start">
                <span class="text-green-500 mr-2">•</span>
                <span>Payments are created automatically during team registration with "pending" status</span>
            </li>
            <li class="flex items-start">
                <span class="text-blue-500 mr-2">•</span>
                <span>M-Pesa integration provides real-time payment processing with instant confirmation</span>
            </li>
            <li class="flex items-start">
                <span class="text-purple-500 mr-2">•</span>
                <span>Failed payments can be retried immediately without creating a new payment record</span>
            </li>
            <li class="flex items-start">
                <span class="text-orange-500 mr-2">•</span>
                <span>Refunds are processed through admin approval and M-Pesa reversal within 1-3 business days</span>
            </li>
        </ul>
    </div>
</div>

<?php /**PATH D:\E - STARTUPS\WORK FOLDERS\PERSONAL\the-milimus-tournament\resources\views\documentation\partials\payment-processing.blade.php ENDPATH**/ ?>