

<?php $__env->startSection('title', 'Email Configuration Test - Success'); ?>

<?php $__env->startSection('header-title', 'Email Test Successful'); ?>
<?php $__env->startSection('header-subtitle', 'Your email configuration is working perfectly'); ?>

<?php $__env->startSection('content'); ?>
    <div class="content-section" style="text-align: center;">
        <div style="width: 80px; height: 80px; background: linear-gradient(135deg, #16a34a 0%, #22c55e 100%); border-radius: 50%; display: inline-flex; align-items: center; justify-content: center; margin-bottom: 20px; box-shadow: 0 10px 25px rgba(22, 163, 74, 0.3);">
            <span style="color: white; font-size: 40px; font-weight: bold;">✓</span>
        </div>
        <h2 class="section-title" style="text-align: center; margin-bottom: 10px;">Configuration Test Passed!</h2>
        <p class="section-text" style="text-align: center; font-size: 18px;">
            Congratulations! Your email settings are working properly and ready for production use.
        </p>
        
        <div style="display: inline-block; background: linear-gradient(135deg, #16a34a 0%, #22c55e 100%); color: white; padding: 8px 20px; border-radius: 25px; font-size: 14px; font-weight: 600; margin-top: 15px;">
            ✅ TEST PASSED
        </div>
    </div>

    <div class="info-box">
        <div class="info-box-content">
            <h3 class="info-title">Test Configuration Details</h3>
            <div class="info-text">
                <strong>Recipient:</strong> <?php echo e($to_name); ?><br>
                <strong>Test Time:</strong> <?php echo e($test_time); ?><br>
                <strong>Application:</strong> <?php echo e($app_name); ?>

            </div>
        </div>
    </div>

    <div class="content-section">
        <h3 class="section-title">Email Server Configuration</h3>
        <div style="background-color: #f9fafb; border-radius: 12px; padding: 20px; border: 1px solid #e5e7eb;">
            <div style="display: grid; gap: 15px;">
                <div style="display: flex; justify-content: space-between; padding: 10px 0; border-bottom: 1px solid #e5e7eb;">
                    <span style="font-weight: 600; color: #374151;">Mail Driver:</span>
                    <span style="color: #6b7280;"><?php echo e($settings_used['mail_driver'] ?? 'Default'); ?></span>
                </div>
                
                <?php if(isset($settings_used['mail_host'])): ?>
                <div style="display: flex; justify-content: space-between; padding: 10px 0; border-bottom: 1px solid #e5e7eb;">
                    <span style="font-weight: 600; color: #374151;">SMTP Host:</span>
                    <span style="color: #6b7280;"><?php echo e($settings_used['mail_host']); ?></span>
                </div>
                <?php endif; ?>
                
                <?php if(isset($settings_used['mail_port'])): ?>
                <div style="display: flex; justify-content: space-between; padding: 10px 0; border-bottom: 1px solid #e5e7eb;">
                    <span style="font-weight: 600; color: #374151;">SMTP Port:</span>
                    <span style="color: #6b7280;"><?php echo e($settings_used['mail_port']); ?></span>
                </div>
                <?php endif; ?>
                
                <?php if(isset($settings_used['mail_encryption'])): ?>
                <div style="display: flex; justify-content: space-between; padding: 10px 0; border-bottom: 1px solid #e5e7eb;">
                    <span style="font-weight: 600; color: #374151;">Encryption:</span>
                    <span style="color: #6b7280;"><?php echo e(strtoupper($settings_used['mail_encryption'])); ?></span>
                </div>
                <?php endif; ?>
                
                <div style="display: flex; justify-content: space-between; padding: 10px 0;">
                    <span style="font-weight: 600; color: #374151;">From Address:</span>
                    <span style="color: #6b7280;"><?php echo e($settings_used['mail_from_address'] ?? 'Not configured'); ?></span>
                </div>
            </div>
        </div>
    </div>

    <div class="content-section">
        <h3 class="section-title">What This Means</h3>
        <ul class="styled-list">
            <li>Your SMTP configuration is correctly set up</li>
            <li>Emails can be sent successfully from your application</li>
            <li>User registration emails will work properly</li>
            <li>OTP verification emails will be delivered</li>
            <li>Tournament notifications will reach participants</li>
            <li>System alerts and updates will be sent reliably</li>
        </ul>
    </div>

    <div class="warning-box">
        <h4 style="color: #92400e; margin: 0 0 10px 0; font-weight: 600;">📧 Next Steps</h4>
        <p style="color: #92400e; margin: 0; font-size: 14px;">
            Your email system is ready for production. You can now enable user registrations, 
            OTP verifications, and automated tournament notifications with confidence.
        </p>
    </div>

    <div class="content-section" style="text-align: center; margin-top: 40px;">
        <p class="section-text" style="color: #6b7280; font-size: 14px;">
            This test email was automatically generated by the Milimus Tournament system.<br>
            If you received this unexpectedly, please contact your system administrator.
        </p>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('emails.layouts.modern', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\E - STARTUPS\WORK FOLDERS\PERSONAL\the-milimus-tournament\resources\views\emails\test-email.blade.php ENDPATH**/ ?>