<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>System Maintenance - The Milimus Tournament</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100">
    <div class="min-h-screen py-8">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <!-- Header -->
            <div class="bg-white shadow rounded-lg p-6 mb-6">
                <h1 class="text-3xl font-bold text-gray-900">🛠️ System Maintenance Dashboard</h1>
                <p class="mt-2 text-gray-600">Monitor and optimize your application</p>
            </div>

            <!-- Quick Actions -->
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4 mb-6">
                <a href="<?php echo e(route('system.maintenance.test-cron')); ?>" class="bg-blue-500 hover:bg-blue-600 text-white rounded-lg p-6 text-center transition">
                    <div class="text-4xl mb-2">🧪</div>
                    <div class="font-bold">Test Cron Job</div>
                    <div class="text-sm mt-1">Verify cron setup</div>
                </a>

                <a href="<?php echo e(route('system.maintenance.optimize')); ?>" class="bg-green-500 hover:bg-green-600 text-white rounded-lg p-6 text-center transition">
                    <div class="text-4xl mb-2">⚡</div>
                    <div class="font-bold">Quick Optimize</div>
                    <div class="text-sm mt-1">Clear & cache</div>
                </a>

                <a href="<?php echo e(route('system.maintenance.full-optimize')); ?>" class="bg-purple-500 hover:bg-purple-600 text-white rounded-lg p-6 text-center transition">
                    <div class="text-4xl mb-2">🚀</div>
                    <div class="font-bold">Full Optimize</div>
                    <div class="text-sm mt-1">Complete optimization</div>
                </a>

                <a href="<?php echo e(route('system.maintenance.logs')); ?>" class="bg-orange-500 hover:bg-orange-600 text-white rounded-lg p-6 text-center transition">
                    <div class="text-4xl mb-2">📋</div>
                    <div class="font-bold">View Logs</div>
                    <div class="text-sm mt-1">Check log files</div>
                </a>
            </div>

            <!-- Test Email Section -->
            <div class="bg-white shadow rounded-lg p-6 mb-6">
                <h2 class="text-2xl font-bold mb-4">📧 Email Troubleshooting</h2>
                <p class="text-gray-600 mb-4">Send a test email to verify your email configuration is working correctly.</p>
                
                <form method="POST" action="<?php echo e(route('system.maintenance.test-email')); ?>" class="flex gap-4">
                    <?php echo csrf_field(); ?>
                    <div class="flex-1">
                        <input 
                            type="email" 
                            name="email" 
                            placeholder="Enter email address" 
                            value="<?php echo e(auth()->user()->email ?? 'test@example.com'); ?>"
                            class="w-full px-4 py-2 border border-gray-300 rounded focus:outline-none focus:ring-2 focus:ring-blue-500"
                            required
                        >
                    </div>
                    <button type="submit" class="bg-blue-500 hover:bg-blue-600 text-white px-6 py-2 rounded transition">
                        📧 Send Test Email
                    </button>
                </form>

                <div class="mt-4 text-sm text-gray-600">
                    <p class="font-bold mb-2">What this tests:</p>
                    <ul class="list-disc list-inside space-y-1">
                        <li>SMTP connection & credentials</li>
                        <li>Email sending speed (shows execution time)</li>
                        <li>Mail driver configuration</li>
                        <li>From address setup</li>
                    </ul>
                </div>
            </div>

            <!-- System Status -->
            <div class="bg-white shadow rounded-lg p-6">
                <h2 class="text-2xl font-bold mb-4">📊 System Status</h2>
                
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <!-- PHP & Environment -->
                    <div>
                        <h3 class="font-bold text-lg mb-3">Environment</h3>
                        <div class="space-y-2">
                            <div class="flex justify-between">
                                <span>PHP Version:</span>
                                <span class="font-mono <?php echo e($status['php_ok'] ? 'text-green-600' : 'text-red-600'); ?>">
                                    <?php echo e($status['php_version']); ?> <?php echo e($status['php_ok'] ? '✅' : '❌'); ?>

                                </span>
                            </div>
                            <div class="flex justify-between">
                                <span>Laravel Version:</span>
                                <span class="font-mono"><?php echo e($status['laravel_version']); ?></span>
                            </div>
                            <div class="flex justify-between">
                                <span>Environment:</span>
                                <span class="font-mono <?php echo e($status['environment'] === 'production' ? 'text-green-600' : 'text-yellow-600'); ?>">
                                    <?php echo e($status['environment']); ?>

                                </span>
                            </div>
                            <div class="flex justify-between">
                                <span>Debug Mode:</span>
                                <span class="font-mono <?php echo e(!$status['debug'] ? 'text-green-600' : 'text-red-600'); ?>">
                                    <?php echo e($status['debug'] ? 'Enabled ⚠️' : 'Disabled ✅'); ?>

                                </span>
                            </div>
                        </div>
                    </div>

                    <!-- Drivers -->
                    <div>
                        <h3 class="font-bold text-lg mb-3">Drivers</h3>
                        <div class="space-y-2">
                            <div class="flex justify-between">
                                <span>Cache Driver:</span>
                                <span class="font-mono <?php echo e($status['cache_driver'] === 'redis' ? 'text-green-600' : 'text-yellow-600'); ?>">
                                    <?php echo e($status['cache_driver']); ?>

                                </span>
                            </div>
                            <div class="flex justify-between">
                                <span>Session Driver:</span>
                                <span class="font-mono <?php echo e($status['session_driver'] === 'redis' ? 'text-green-600' : 'text-yellow-600'); ?>">
                                    <?php echo e($status['session_driver']); ?>

                                </span>
                            </div>
                            <div class="flex justify-between">
                                <span>Queue Connection:</span>
                                <span class="font-mono <?php echo e($status['queue_connection'] !== 'sync' ? 'text-green-600' : 'text-red-600'); ?>">
                                    <?php echo e($status['queue_connection']); ?>

                                </span>
                            </div>
                        </div>
                    </div>

                    <!-- Cache Status -->
                    <div>
                        <h3 class="font-bold text-lg mb-3">Cache Status</h3>
                        <div class="space-y-2">
                            <div class="flex justify-between">
                                <span>Config Cached:</span>
                                <span class="<?php echo e($status['config_cached'] ? 'text-green-600' : 'text-red-600'); ?>">
                                    <?php echo e($status['config_cached'] ? '✅ Yes' : '❌ No'); ?>

                                </span>
                            </div>
                            <div class="flex justify-between">
                                <span>Routes Cached:</span>
                                <span class="<?php echo e($status['routes_cached'] ? 'text-green-600' : 'text-red-600'); ?>">
                                    <?php echo e($status['routes_cached'] ? '✅ Yes' : '❌ No'); ?>

                                </span>
                            </div>
                            <div class="flex justify-between">
                                <span>Views Cached:</span>
                                <span class="<?php echo e($status['views_cached'] ? 'text-green-600' : 'text-red-600'); ?>">
                                    <?php echo e($status['views_cached'] ? '✅ Yes' : '❌ No'); ?>

                                </span>
                            </div>
                            <div class="flex justify-between">
                                <span>OPcache:</span>
                                <span class="<?php echo e($status['opcache_enabled'] ? 'text-green-600' : 'text-yellow-600'); ?>">
                                    <?php echo e($status['opcache_enabled'] ? '✅ Enabled' : '⚠️ Disabled'); ?>

                                </span>
                            </div>
                        </div>
                    </div>

                    <!-- Database & Resources -->
                    <div>
                        <h3 class="font-bold text-lg mb-3">Database & Resources</h3>
                        <div class="space-y-2">
                            <div class="flex justify-between">
                                <span>Database:</span>
                                <span class="<?php echo e($status['database_connected'] ? 'text-green-600' : 'text-red-600'); ?>">
                                    <?php echo e($status['database_connected'] ? '✅ Connected' : '❌ Disconnected'); ?>

                                </span>
                            </div>
                            <?php if($status['database_connected']): ?>
                            <div class="flex justify-between">
                                <span>Database Name:</span>
                                <span class="font-mono text-sm"><?php echo e($status['database_name']); ?></span>
                            </div>
                            <?php endif; ?>
                            <?php if(isset($status['redis_connected'])): ?>
                            <div class="flex justify-between">
                                <span>Redis:</span>
                                <span class="<?php echo e($status['redis_connected'] ? 'text-green-600' : 'text-red-600'); ?>">
                                    <?php echo e($status['redis_connected'] ? '✅ Connected' : '❌ Disconnected'); ?>

                                </span>
                            </div>
                            <?php endif; ?>
                            <div class="flex justify-between">
                                <span>Disk Usage:</span>
                                <span class="font-mono <?php echo e($status['disk_used_percent'] > 80 ? 'text-red-600' : 'text-green-600'); ?>">
                                    <?php echo e($status['disk_used_percent']); ?>%
                                </span>
                            </div>
                            <div class="flex justify-between">
                                <span>Memory Limit:</span>
                                <span class="font-mono"><?php echo e($status['memory_limit']); ?></span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Clear Cache Actions -->
            <div class="bg-white shadow rounded-lg p-6 mt-6">
                <h2 class="text-2xl font-bold mb-4">🗑️ Clear Cache</h2>
                <div class="grid grid-cols-2 md:grid-cols-5 gap-4">
                    <form method="POST" action="<?php echo e(route('system.maintenance.clear-cache')); ?>">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="type" value="all">
                        <button type="submit" class="w-full bg-red-500 hover:bg-red-600 text-white px-4 py-2 rounded transition">
                            Clear All
                        </button>
                    </form>
                    <form method="POST" action="<?php echo e(route('system.maintenance.clear-cache')); ?>">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="type" value="config">
                        <button type="submit" class="w-full bg-gray-500 hover:bg-gray-600 text-white px-4 py-2 rounded transition">
                            Config
                        </button>
                    </form>
                    <form method="POST" action="<?php echo e(route('system.maintenance.clear-cache')); ?>">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="type" value="route">
                        <button type="submit" class="w-full bg-gray-500 hover:bg-gray-600 text-white px-4 py-2 rounded transition">
                            Routes
                        </button>
                    </form>
                    <form method="POST" action="<?php echo e(route('system.maintenance.clear-cache')); ?>">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="type" value="view">
                        <button type="submit" class="w-full bg-gray-500 hover:bg-gray-600 text-white px-4 py-2 rounded transition">
                            Views
                        </button>
                    </form>
                    <form method="POST" action="<?php echo e(route('system.maintenance.clear-cache')); ?>">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="type" value="cache">
                        <button type="submit" class="w-full bg-gray-500 hover:bg-gray-600 text-white px-4 py-2 rounded transition">
                            Cache
                        </button>
                    </form>
                </div>
            </div>

            <?php if(session('success')): ?>
            <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mt-4">
                <?php echo e(session('success')); ?>

            </div>
            <?php endif; ?>
        </div>
    </div>
</body>
</html>

<?php /**PATH D:\E - STARTUPS\WORK FOLDERS\PERSONAL\the-milimus-tournament\resources\views\system\maintenance\index.blade.php ENDPATH**/ ?>