<!-- Notification System Documentation -->

<div class="section-card">
    <h2 class="text-4xl font-bold mb-6">🔔 Notification Control System</h2>
    
    <div class="bg-blue-50 border-l-4 border-blue-500 p-6 rounded-r-lg mb-6">
        <p class="text-lg text-blue-900 font-semibold">📖 What You'll Learn</p>
        <ul class="mt-3 space-y-2 text-blue-800">
            <li>✅ How the notification control system works</li>
            <li>✅ Admin interface for global notification management</li>
            <li>✅ User interface for personal preferences</li>
            <li>✅ Role-based filtering and permission hierarchy</li>
        </ul>
    </div>
</div>

<!-- Overview -->
<div class="section-card">
    <h3 class="text-2xl font-bold mb-4 flex items-center">
        <span class="step-number">1</span>
        System Overview
    </h3>
    
    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
        <div class="bg-purple-50 rounded-lg p-6">
            <h4 class="font-bold text-lg mb-3 text-purple-800">🎯 Purpose</h4>
            <p class="text-gray-700 leading-relaxed">
                The notification control system provides comprehensive management of 141+ notifications 
                with both system-wide (admin) control and user-level preferences, ensuring users only 
                receive relevant notifications based on their role and preferences.
            </p>
        </div>

        <div class="bg-green-50 rounded-lg p-6">
            <h4 class="font-bold text-lg mb-3 text-green-800">✨ Key Features</h4>
            <ul class="space-y-2 text-gray-700">
                <li class="flex items-start">
                    <span class="text-green-500 mr-2">•</span>
                    <span>Two-level control (System + User)</span>
                </li>
                <li class="flex items-start">
                    <span class="text-green-500 mr-2">•</span>
                    <span>Role-based automatic filtering</span>
                </li>
                <li class="flex items-start">
                    <span class="text-green-500 mr-2">•</span>
                    <span>Category and individual toggles</span>
                </li>
                <li class="flex items-start">
                    <span class="text-green-500 mr-2">•</span>
                    <span>Real-time updates</span>
                </li>
            </ul>
        </div>
    </div>
</div>

<!-- Permission Hierarchy -->
<div class="section-card">
    <h3 class="text-2xl font-bold mb-4 flex items-center">
        <span class="step-number">2</span>
        Permission Hierarchy
    </h3>
    
    <div class="mermaid bg-white p-6 rounded-lg shadow-inner">
flowchart TD
    Start([Notification Triggered])
    Start --> Check1{System-Wide<br/>Setting Enabled?}
    Check1 -->|No| Block1[❌ Block Notification]
    Check1 -->|Yes| Check2{User Has<br/>Relevant Role?}
    Check2 -->|No| Block2[❌ Block Notification]
    Check2 -->|Yes| Check3{User Category<br/>Preference Enabled?}
    Check3 -->|No| Check4{Individual<br/>Override Enabled?}
    Check4 -->|No| Block3[❌ Block Notification]
    Check4 -->|Yes| Send1[✅ Send Notification]
    Check3 -->|Yes| Check5{Individual<br/>Preference Set?}
    Check5 -->|Yes, Disabled| Block4[❌ Block Notification]
    Check5 -->|Yes, Enabled| Send2[✅ Send Notification]
    Check5 -->|No Preference| Send3[✅ Send Notification]
    
    Block1 --> End([No Notification Sent])
    Block2 --> End
    Block3 --> End
    Block4 --> End
    Send1 --> End2([✉️ Notification Sent])
    Send2 --> End2
    Send3 --> End2
    
    style Check1 fill:#FFC107,stroke:#FF6F00
    style Check2 fill:#2196F3,stroke:#1565C0
    style Check3 fill:#4CAF50,stroke:#2E7D32
    style Block1 fill:#f44336,stroke:#c62828,color:#fff
    style Block2 fill:#f44336,stroke:#c62828,color:#fff
    style Block3 fill:#f44336,stroke:#c62828,color:#fff
    style Block4 fill:#f44336,stroke:#c62828,color:#fff
    style Send1 fill:#4CAF50,stroke:#2E7D32,color:#fff
    style Send2 fill:#4CAF50,stroke:#2E7D32,color:#fff
    style Send3 fill:#4CAF50,stroke:#2E7D32,color:#fff
    style End2 fill:#4CAF50,stroke:#2E7D32,color:#fff
    </div>

    <div class="mt-6 bg-blue-50 border-l-4 border-blue-500 p-4 rounded-r-lg">
        <p class="font-bold text-blue-900 mb-2">🔐 Hierarchy Summary:</p>
        <ol class="space-y-2 text-blue-800">
            <li><strong>1. System-Wide Setting</strong> (Highest Priority) - Admin controlled</li>
            <li><strong>2. Role-Based Filtering</strong> - Automatic based on user role</li>
            <li><strong>3. User Category Preference</strong> - User's category-level setting</li>
            <li><strong>4. User Individual Preference</strong> - Overrides category setting</li>
        </ol>
    </div>
</div>

<!-- Notification Categories -->
<div class="section-card">
    <h3 class="text-2xl font-bold mb-4 flex items-center">
        <span class="step-number">3</span>
        Notification Categories (12 Total)
    </h3>
    
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
        <div class="bg-blue-50 rounded-lg p-4 border-l-4 border-blue-500">
            <div class="flex items-center mb-2">
                <span class="text-2xl mr-2">🔐</span>
                <span class="font-bold text-blue-800">Auth (5)</span>
            </div>
            <p class="text-sm text-gray-700">Authentication & security notifications</p>
        </div>

        <div class="bg-green-50 rounded-lg p-4 border-l-4 border-green-500">
            <div class="flex items-center mb-2">
                <span class="text-2xl mr-2">👥</span>
                <span class="font-bold text-green-800">Team (28)</span>
            </div>
            <p class="text-sm text-gray-700">Team management notifications</p>
        </div>

        <div class="bg-purple-50 rounded-lg p-4 border-l-4 border-purple-500">
            <div class="flex items-center mb-2">
                <span class="text-2xl mr-2">⚽</span>
                <span class="font-bold text-purple-800">Player (8)</span>
            </div>
            <p class="text-sm text-gray-700">Player management notifications</p>
        </div>

        <div class="bg-yellow-50 rounded-lg p-4 border-l-4 border-yellow-500">
            <div class="flex items-center mb-2">
                <span class="text-2xl mr-2">💳</span>
                <span class="font-bold text-yellow-800">Payment (6)</span>
            </div>
            <p class="text-sm text-gray-700">Payment operations</p>
        </div>

        <div class="bg-orange-50 rounded-lg p-4 border-l-4 border-orange-500">
            <div class="flex items-center mb-2">
                <span class="text-2xl mr-2">🏆</span>
                <span class="font-bold text-orange-800">Tournament (18)</span>
            </div>
            <p class="text-sm text-gray-700">Tournament lifecycle notifications</p>
        </div>

        <div class="bg-red-50 rounded-lg p-4 border-l-4 border-red-500">
            <div class="flex items-center mb-2">
                <span class="text-2xl mr-2">🎮</span>
                <span class="font-bold text-red-800">Match (9)</span>
            </div>
            <p class="text-sm text-gray-700">Match management notifications</p>
        </div>

        <div class="bg-indigo-50 rounded-lg p-4 border-l-4 border-indigo-500">
            <div class="flex items-center mb-2">
                <span class="text-2xl mr-2">👔</span>
                <span class="font-bold text-indigo-800">Official (10)</span>
            </div>
            <p class="text-sm text-gray-700">Officials & staff notifications</p>
        </div>

        <div class="bg-gray-50 rounded-lg p-4 border-l-4 border-gray-500">
            <div class="flex items-center mb-2">
                <span class="text-2xl mr-2">👤</span>
                <span class="font-bold text-gray-800">User (5)</span>
            </div>
            <p class="text-sm text-gray-700">User account notifications</p>
        </div>

        <div class="bg-slate-50 rounded-lg p-4 border-l-4 border-slate-500">
            <div class="flex items-center mb-2">
                <span class="text-2xl mr-2">⚙️</span>
                <span class="font-bold text-slate-800">Admin (50)</span>
            </div>
            <p class="text-sm text-gray-700">Admin-only notifications</p>
        </div>

        <div class="bg-teal-50 rounded-lg p-4 border-l-4 border-teal-500">
            <div class="flex items-center mb-2">
                <span class="text-2xl mr-2">🎓</span>
                <span class="font-bold text-teal-800">Certificate (1)</span>
            </div>
            <p class="text-sm text-gray-700">Certificates & achievements</p>
        </div>

        <div class="bg-pink-50 rounded-lg p-4 border-l-4 border-pink-500">
            <div class="flex items-center mb-2">
                <span class="text-2xl mr-2">✉️</span>
                <span class="font-bold text-pink-800">Invitation (0)</span>
            </div>
            <p class="text-sm text-gray-700">Invitation notifications</p>
        </div>

        <div class="bg-cyan-50 rounded-lg p-4 border-l-4 border-cyan-500">
            <div class="flex items-center mb-2">
                <span class="text-2xl mr-2">🔔</span>
                <span class="font-bold text-cyan-800">System (1)</span>
            </div>
            <p class="text-sm text-gray-700">System-wide announcements</p>
        </div>
    </div>
</div>

<!-- Role-Based Filtering -->
<div class="section-card">
    <h3 class="text-2xl font-bold mb-4 flex items-center">
        <span class="step-number">4</span>
        Role-Based Filtering
    </h3>
    
    <div class="overflow-x-auto">
        <table class="w-full bg-white rounded-lg shadow">
            <thead class="bg-gray-100">
                <tr>
                    <th class="px-4 py-3 text-left font-semibold">User Role</th>
                    <th class="px-4 py-3 text-left font-semibold">Visible Categories</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-gray-200">
                <tr class="hover:bg-gray-50">
                    <td class="px-4 py-3 font-semibold">Admin / Super Admin / Organizer</td>
                    <td class="px-4 py-3">
                        <span class="bg-green-100 text-green-800 px-2 py-1 rounded text-sm">All Categories</span>
                    </td>
                </tr>
                <tr class="hover:bg-gray-50">
                    <td class="px-4 py-3 font-semibold">Team Manager</td>
                    <td class="px-4 py-3 text-sm">
                        Auth, Team, Player, Payment, Tournament, Match, Certificate, Invitation, System
                    </td>
                </tr>
                <tr class="hover:bg-gray-50">
                    <td class="px-4 py-3 font-semibold">Player</td>
                    <td class="px-4 py-3 text-sm">
                        Auth, Team, Player, Payment, Tournament, Match, Certificate, Invitation, System
                    </td>
                </tr>
                <tr class="hover:bg-gray-50">
                    <td class="px-4 py-3 font-semibold">Referee</td>
                    <td class="px-4 py-3 text-sm">
                        Auth, Match, Official, Tournament, System
                    </td>
                </tr>
                <tr class="hover:bg-gray-50">
                    <td class="px-4 py-3 font-semibold">Spectator</td>
                    <td class="px-4 py-3 text-sm">
                        Auth, Tournament, System
                    </td>
                </tr>
            </tbody>
        </table>
    </div>

    <div class="mt-4 bg-purple-50 border-l-4 border-purple-500 p-4 rounded-r-lg">
        <p class="text-purple-900">
            <strong>🎭 Automatic Filtering:</strong> Users only see notifications relevant to their role. 
            For example, a Spectator will never see Team or Player notifications in their preferences.
        </p>
    </div>
</div>

<!-- Admin Interface Walkthrough -->
<div class="section-card">
    <h3 class="text-2xl font-bold mb-4 flex items-center">
        <span class="step-number">5</span>
        Admin Interface Walkthrough
    </h3>
    
    <div class="space-y-6">
        <div>
            <h4 class="font-bold text-lg mb-3 text-blue-600">Access & Overview</h4>
            <div class="bg-blue-50 rounded-lg p-4">
                <p class="text-gray-700 mb-3">
                    <strong>URL:</strong> <code class="bg-white px-2 py-1 rounded">/admin/settings/notifications</code>
                </p>
                <p class="text-gray-700">
                    <strong>Required Role:</strong> <span class="bg-orange-100 px-2 py-1 rounded">admin</span> or 
                    <span class="bg-red-100 px-2 py-1 rounded">super_admin</span>
                </p>
            </div>
        </div>

        <div class="screenshot-placeholder">
            <p class="text-3xl text-gray-400 mb-2">📸</p>
            <p class="text-gray-600 font-mono text-lg">[screenshot-admin-notifications-dashboard.png]</p>
            <p class="text-sm text-gray-500 mt-2">Admin notification management dashboard</p>
        </div>

        <div>
            <h4 class="font-bold text-lg mb-3 text-green-600">Key Features</h4>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <div class="bg-white border-2 border-green-200 rounded-lg p-4">
                    <p class="font-semibold text-green-700 mb-2">📊 Statistics Dashboard</p>
                    <ul class="text-sm space-y-1 text-gray-700">
                        <li>• Total notifications count</li>
                        <li>• Enabled/disabled breakdown</li>
                        <li>• Categories overview</li>
                    </ul>
                </div>
                <div class="bg-white border-2 border-blue-200 rounded-lg p-4">
                    <p class="font-semibold text-blue-700 mb-2">🔍 Search & Filter</p>
                    <ul class="text-sm space-y-1 text-gray-700">
                        <li>• Search by notification type</li>
                        <li>• Filter by category</li>
                        <li>• Real-time filtering</li>
                    </ul>
                </div>
                <div class="bg-white border-2 border-purple-200 rounded-lg p-4">
                    <p class="font-semibold text-purple-700 mb-2">📁 Category Management</p>
                    <ul class="text-sm space-y-1 text-gray-700">
                        <li>• Toggle entire categories</li>
                        <li>• Expand/collapse details</li>
                        <li>• Visual indicators</li>
                    </ul>
                </div>
                <div class="bg-white border-2 border-orange-200 rounded-lg p-4">
                    <p class="font-semibold text-orange-700 mb-2">⚙️ Individual Control</p>
                    <ul class="text-sm space-y-1 text-gray-700">
                        <li>• Toggle specific notifications</li>
                        <li>• Batch save changes</li>
                        <li>• Pending changes indicator</li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="screenshot-placeholder-sm">
            <p class="text-xl text-gray-400 mb-2">📸</p>
            <p class="text-gray-600 font-mono">[screenshot-admin-category-expanded.png]</p>
            <p class="text-xs text-gray-500 mt-2">Expanded category view with individual notification toggles</p>
        </div>
    </div>
</div>

<!-- User Interface Walkthrough -->
<div class="section-card">
    <h3 class="text-2xl font-bold mb-4 flex items-center">
        <span class="step-number">6</span>
        User Interface Walkthrough
    </h3>
    
    <div class="space-y-6">
        <div>
            <h4 class="font-bold text-lg mb-3 text-purple-600">Access & Overview</h4>
            <div class="bg-purple-50 rounded-lg p-4">
                <p class="text-gray-700 mb-3">
                    <strong>URL:</strong> <code class="bg-white px-2 py-1 rounded">/settings/notifications</code>
                </p>
                <p class="text-gray-700">
                    <strong>Required Role:</strong> <span class="bg-blue-100 px-2 py-1 rounded">Any authenticated user</span>
                </p>
            </div>
        </div>

        <div class="screenshot-placeholder">
            <p class="text-3xl text-gray-400 mb-2">📸</p>
            <p class="text-gray-600 font-mono text-lg">[screenshot-user-notification-preferences.png]</p>
            <p class="text-sm text-gray-500 mt-2">User notification preferences interface</p>
        </div>

        <div>
            <h4 class="font-bold text-lg mb-3 text-blue-600">Key Features</h4>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <div class="bg-white border-2 border-blue-200 rounded-lg p-4">
                    <p class="font-semibold text-blue-700 mb-2">👤 Role-Based Filtering</p>
                    <p class="text-sm text-gray-700">
                        Only shows notifications relevant to user's role. Automatic and transparent.
                    </p>
                </div>
                <div class="bg-white border-2 border-red-200 rounded-lg p-4">
                    <p class="font-semibold text-red-700 mb-2">🔐 Respects Admin Settings</p>
                    <p class="text-sm text-gray-700">
                        Admin-disabled notifications are hidden and cannot be enabled by users.
                    </p>
                </div>
                <div class="bg-white border-2 border-green-200 rounded-lg p-4">
                    <p class="font-semibold text-green-700 mb-2">📁 Category Toggles</p>
                    <p class="text-sm text-gray-700">
                        Enable/disable entire categories with one click.
                    </p>
                </div>
                <div class="bg-white border-2 border-purple-200 rounded-lg p-4">
                    <p class="font-semibold text-purple-700 mb-2">🎛️ Individual Overrides</p>
                    <p class="text-sm text-gray-700">
                        Override category settings for specific notifications.
                    </p>
                </div>
            </div>
        </div>

        <div class="screenshot-placeholder-sm">
            <p class="text-xl text-gray-400 mb-2">📸</p>
            <p class="text-gray-600 font-mono">[screenshot-user-category-toggle.png]</p>
            <p class="text-xs text-gray-500 mt-2">User toggling category preferences</p>
        </div>
    </div>
</div>

<!-- Example Scenarios -->
<div class="section-card">
    <h3 class="text-2xl font-bold mb-4 flex items-center">
        <span class="step-number">7</span>
        Real-World Scenarios
    </h3>
    
    <div class="space-y-6">
        <!-- Scenario 1 -->
        <div class="border-2 border-red-200 rounded-lg p-6">
            <h4 class="font-bold text-lg text-red-700 mb-3">Scenario 1: Admin Disables Payment Notifications</h4>
            
            <div class="space-y-4">
                <div class="flex items-start">
                    <span class="text-2xl mr-3">👨‍💼</span>
                    <div>
                        <p class="font-semibold text-gray-800">Admin Action:</p>
                        <p class="text-gray-700">Admin toggles "payment" category OFF in admin interface</p>
                    </div>
                </div>
                
                <div class="flex items-start">
                    <span class="text-2xl mr-3">⚙️</span>
                    <div>
                        <p class="font-semibold text-gray-800">System Behavior:</p>
                        <ul class="text-gray-700 space-y-1">
                            <li>• Payment category disabled system-wide</li>
                            <li>• All 6 payment notifications blocked</li>
                            <li>• No payment notifications sent to anyone</li>
                        </ul>
                    </div>
                </div>
                
                <div class="flex items-start">
                    <span class="text-2xl mr-3">👥</span>
                    <div>
                        <p class="font-semibold text-gray-800">User Impact:</p>
                        <p class="text-gray-700">Payment category hidden from all user preferences. Users cannot re-enable it.</p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Scenario 2 -->
        <div class="border-2 border-green-200 rounded-lg p-6">
            <h4 class="font-bold text-lg text-green-700 mb-3">Scenario 2: User Disables Team Notifications</h4>
            
            <div class="space-y-4">
                <div class="flex items-start">
                    <span class="text-2xl mr-3">👤</span>
                    <div>
                        <p class="font-semibold text-gray-800">User Action:</p>
                        <p class="text-gray-700">User toggles "team" category OFF in their preferences</p>
                    </div>
                </div>
                
                <div class="flex items-start">
                    <span class="text-2xl mr-3">⚙️</span>
                    <div>
                        <p class="font-semibold text-gray-800">System Behavior:</p>
                        <ul class="text-gray-700 space-y-1">
                            <li>• Team notifications blocked for this user only</li>
                            <li>• Other users still receive team notifications</li>
                            <li>• User can re-enable anytime</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>

        <!-- Scenario 3 -->
        <div class="border-2 border-purple-200 rounded-lg p-6">
            <h4 class="font-bold text-lg text-purple-700 mb-3">Scenario 3: User Overrides Category Setting</h4>
            
            <div class="space-y-4">
                <div class="flex items-start">
                    <span class="text-2xl mr-3">👤</span>
                    <div>
                        <p class="font-semibold text-gray-800">User Actions:</p>
                        <ol class="text-gray-700 space-y-1 list-decimal list-inside">
                            <li>Disable "payment" category</li>
                            <li>Enable "payment_completed_notification" individually</li>
                        </ol>
                    </div>
                </div>
                
                <div class="flex items-start">
                    <span class="text-2xl mr-3">✅</span>
                    <div>
                        <p class="font-semibold text-gray-800">Result:</p>
                        <p class="text-gray-700">User receives ONLY payment completed notifications. All other payment notifications are blocked. Individual setting overrides category!</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Summary -->
<div class="section-card bg-gradient-to-r from-blue-50 to-purple-50">
    <h3 class="text-2xl font-bold mb-4">📚 Quick Reference</h3>
    
    <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-6">
        <div class="bg-white rounded-lg p-4 shadow">
            <p class="text-3xl font-bold text-blue-600 mb-2">141</p>
            <p class="text-gray-700">Total Notifications</p>
        </div>
        <div class="bg-white rounded-lg p-4 shadow">
            <p class="text-3xl font-bold text-green-600 mb-2">12</p>
            <p class="text-gray-700">Categories</p>
        </div>
        <div class="bg-white rounded-lg p-4 shadow">
            <p class="text-3xl font-bold text-purple-600 mb-2">2</p>
            <p class="text-gray-700">Control Levels</p>
        </div>
    </div>

    <div class="bg-white rounded-lg p-6">
        <p class="font-semibold text-gray-800 mb-3">🎯 Key Features:</p>
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
            <ul class="space-y-2 text-gray-700">
                <li class="flex items-start">
                    <span class="text-blue-500 mr-2">•</span>
                    <span>System-wide admin control</span>
                </li>
                <li class="flex items-start">
                    <span class="text-green-500 mr-2">•</span>
                    <span>User-level preferences</span>
                </li>
                <li class="flex items-start">
                    <span class="text-purple-500 mr-2">•</span>
                    <span>Role-based automatic filtering</span>
                </li>
            </ul>
            <ul class="space-y-2 text-gray-700">
                <li class="flex items-start">
                    <span class="text-orange-500 mr-2">•</span>
                    <span>Category and individual toggles</span>
                </li>
                <li class="flex items-start">
                    <span class="text-red-500 mr-2">•</span>
                    <span>Real-time updates</span>
                </li>
                <li class="flex items-start">
                    <span class="text-cyan-500 mr-2">•</span>
                    <span>Performance optimized</span>
                </li>
            </ul>
        </div>
    </div>
</div>

<?php /**PATH D:\E - STARTUPS\WORK FOLDERS\PERSONAL\the-milimus-tournament\resources\views\documentation\partials\notification-system.blade.php ENDPATH**/ ?>