<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Digital ID - <?php echo e($player->display_name); ?></title>
    <style>
        /* Use system fonts for reliability in DomPDF */
        :root {
            --primary: #2563eb;
            --primary-foreground: #ffffff;
            --muted: #f1f5f9;
            --muted-foreground: #64748b;
            --border: #e2e8f0;
            --background: #ffffff;
            --foreground: #0f172a;
        }
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: Arial, Helvetica, sans-serif; color: var(--foreground); background: var(--background); }
		.page { width: 310mm; height: 210mm; padding: 10mm 12mm; display: table; }
		.page-center { display: table-cell; vertical-align: middle; }

        /* Layout: two cards (front/back) side-by-side on one A4 page */
		.two-up { display: table; width: 98%; table-layout: fixed; border-spacing: 10px; margin: 0 auto; }
        .half { display: table-cell; vertical-align: top; width: 50%; }

        /* Card container that fits comfortably on one A4 landscape page */
        .card {
            border: 1px solid var(--border);
            border-radius: 8px;
            padding: 14px;
            background: #fff;
        }

        .header {
            background: var(--primary);
            color: var(--primary-foreground);
            border-radius: 6px;
            padding: 14px 16px;
            margin-bottom: 18px;
        }
        .header-top { display: table; width: 100%; }
        .header-top .left { display: table-cell; vertical-align: middle; }
        .header-top .right { display: table-cell; text-align: right; vertical-align: middle; }
        .title { font-size: 20px; font-weight: bold; letter-spacing: 0.5px; }
        .subtitle { font-size: 12px; opacity: 0.9; }
        .digital-id-number { font-family: 'Courier New', monospace; font-size: 14px; font-weight: bold; }

        /* Two-column layout: left details, right QR & photo */
        .row { display: table; width: 100%; table-layout: fixed; }
        .col { display: table-cell; vertical-align: top; }
        .col-left { padding-right: 14px; width: 65%; }
        .col-right { padding-left: 14px; width: 35%; border-left: 1px solid var(--border); }

        .identity { display: table; width: 100%; margin-bottom: 12px; }
        .identity .photo-wrap { display: table-cell; width: 90px; vertical-align: top; }
        .photo {
            width: 80px; height: 80px; border-radius: 50%; border: 3px solid #bfdbfe;
            background: #e5edff; overflow: hidden; text-align: center; line-height: 80px; font-size: 36px; color: #1e40af;
        }
        .identity .who { display: table-cell; vertical-align: middle; padding-left: 12px; }
        .player-name { font-size: 18px; font-weight: 700; }
        .player-real-name { font-size: 12px; color: var(--muted-foreground); }

        .grid { width: 100%; border-collapse: collapse; margin-top: 6px; }
        .grid td { font-size: 12px; padding: 6px 8px; border-bottom: 1px solid var(--border); }
        .grid td.label { color: var(--muted-foreground); width: 36%; text-transform: uppercase; font-weight: 600; letter-spacing: 0.3px; }

        .badge { font-size: 11px; font-weight: 700; padding: 2px 6px; border-radius: 4px; }
        .badge-blue { background: #dbeafe; color: #1e40af; }
        .badge-amber { background: #fef3c7; color: #92400e; }
        .badge-green { background: #dcfce7; color: #166534; }

        .qr-block { text-align: center; }
        .qr-code { width: 110px; height: 110px; margin: 0 auto 8px; }
        .qr-caption { font-size: 10px; color: var(--muted-foreground); }

        .meta { margin-top: 14px; padding-top: 10px; border-top: 1px solid var(--border); font-size: 11px; color: var(--muted-foreground); display: table; width: 100%; }
        .meta .left { display: table-cell; }
        .meta .right { display: table-cell; text-align: right; }

        @page { margin: 0; }
    </style>
</head>
<body>
    <div class="page">
        <div class="page-center">
        <div class="two-up">
            <!-- Front Side -->
            <div class="half">
                <div class="card">
                    <div class="header">
                        <div class="header-top">
                            <div class="left">
                                <!-- <div class="title">PLAYER DIGITAL ID</div> -->
                                <!-- <div class="subtitle">Official Tournament Management System</div> -->
                            </div>
                            <div class="right">
                                <div class="digital-id-number"><?php echo e($digital_id); ?></div>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col col-left">
                            <div class="identity">
                                <div class="photo-wrap">
                                    <div class="photo">
                                        <?php if($player->user->profile_image): ?>
                                            <img src="<?php echo e($player->user->profile_image); ?>" alt="<?php echo e($player->display_name); ?>" style="width: 100%; height: 100%; object-fit: cover; border-radius: 50%;">
                                        <?php else: ?>
                                            👤
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <div class="who">
                                    <div class="player-name"><?php echo e($player->display_name); ?></div>
                                    <div class="player-real-name"><?php echo e($player->user->name); ?></div>
                                </div>
                            </div>

                            <table class="grid">
                                <tr>
                                    <td class="label">Tournament</td>
                                    <td><?php echo e($player->tournament->name ?? 'N/A'); ?></td>
                                </tr>
                                <tr>
                                    <td class="label">Email</td>
                                    <td><?php echo e($player->user->email); ?></td>
                                </tr>
                                <tr>
                                    <td class="label">Phone</td>
                                    <td><?php echo e($player->phone ?: 'Not provided'); ?></td>
                                </tr>
                                <tr>
                                    <td class="label">Player Type</td>
                                    <td><span class="badge badge-blue"><?php echo e(strtoupper(str_replace('_', ' ', $player->player_type))); ?></span></td>
                                </tr>
                                <tr>
                                    <td class="label">Verification</td>
                                    <td><span class="badge badge-amber"><?php echo e(ucfirst($player->verification_status)); ?></span></td>
                                </tr>
                                <tr>
                                    <td class="label">Status</td>
                                    <td><span class="badge badge-green"><?php echo e(ucfirst($player->status)); ?></span></td>
                                </tr>
                            </table>
                        </div>

                        <div class="col col-right">
                            <div class="qr-block">
                                <img class="qr-code" src="<?php echo e($qr_code); ?>" alt="QR Code" />
                                <div class="qr-caption">Scan to verify Digital ID</div>
                            </div>
                        </div>
                    </div>

                    <div class="meta">
                        <div class="left">Generated: <?php echo e($generated_at); ?></div>
                        <div class="right">Valid Until: <?php echo e($valid_until); ?></div>
                    </div>
                </div>
            </div>

            <!-- Back Side -->
            <div class="half">
                <div class="card">
                    <div class="header" style="background:#475569;">
                        <div class="header-top">
                            <div class="left">
                                <div class="title"></div>
                                <!-- <div class="subtitle">Official Tournament Management System</div> -->
                            </div>
                            <div class="right">
                                <div class="digital-id-number"><?php echo e($digital_id); ?></div>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col" style="padding-right:12px;">
                            <div style="font-size:13px; font-weight:700; margin-bottom:8px;">Security Features</div>
                            <table class="grid">
                                <tr><td class="label">Unique Identifier</td><td>Each ID is globally unique</td></tr>
                                <tr><td class="label">QR Verification</td><td>Verify authenticity via QR</td></tr>
                                <tr><td class="label">Encrypted Data</td><td>Secure data at rest and in transit</td></tr>
                                <tr><td class="label">Validation</td><td>Real-time validation on scan</td></tr>
                            </table>
                        </div>
                        <div class="col" style="padding-left:12px;">
                            <div style="font-size:13px; font-weight:700; margin-bottom:8px;">Tournament Info</div>
                            <table class="grid">
                                <tr><td class="label">Tournament</td><td><?php echo e($player->tournament->name); ?></td></tr>
                                <tr><td class="label">Registration</td><td><?php echo e(\Carbon\Carbon::parse($player->registered_at)->format('M j, Y')); ?></td></tr>
                                <tr><td class="label">Player ID</td><td class="font-mono"><?php echo e($player->id); ?></td></tr>
                                <tr><td class="label">Digital ID</td><td class="font-mono"><?php echo e($digital_id); ?></td></tr>
                                <tr><td class="label">Validity</td><td>2 Years</td></tr>
                            </table>
                        </div>
                    </div>

                    <div class="meta">
                        <div class="left">Generated: <?php echo e($generated_at); ?></div>
                        <div class="right">Valid Until: <?php echo e($valid_until); ?></div>
                    </div>
                </div>
            </div>
        </div>
        </div>
    </div>
</body>
</html><?php /**PATH D:\E - STARTUPS\WORK FOLDERS\PERSONAL\the-milimus-tournament\resources\views\players\digital-id-pdf.blade.php ENDPATH**/ ?>