<!-- Match Management Documentation -->

<div class="section-card">
    <h2 class="text-4xl font-bold mb-6">🎮 Match Management Workflow</h2>
    
    <div class="bg-blue-50 border-l-4 border-blue-500 p-6 rounded-r-lg mb-6">
        <p class="text-lg text-blue-900 font-semibold">📖 What You'll Learn</p>
        <ul class="mt-3 space-y-2 text-blue-800">
            <li>✅ Match lifecycle from scheduling to completion</li>
            <li>✅ Match status transitions and progression logic</li>
            <li>✅ Referee assignment and management</li>
            <li>✅ Score recording and result verification</li>
            <li>✅ Match rescheduling and cancellation processes</li>
            <li>✅ All notifications sent during match events</li>
        </ul>
    </div>
</div>

<!-- Overview -->
<div class="section-card">
    <h3 class="text-2xl font-bold mb-4 flex items-center">
        <span class="step-number">1</span>
        Overview
    </h3>
    
    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
        <div>
            <h4 class="font-bold text-lg mb-3 text-blue-600">🎮 What is Match Management?</h4>
            <p class="text-gray-700 leading-relaxed">
                Match management handles the complete match lifecycle including scheduling, participant notifications, 
                live match tracking, score recording, result verification, and post-match statistics. Matches can be 
                team vs team or individual vs individual.
            </p>
        </div>

        <div>
            <h4 class="font-bold text-lg mb-3 text-green-600">👥 Who Manages Matches?</h4>
            <ul class="space-y-2 text-gray-700">
                <li class="flex items-start">
                    <span class="text-green-500 mr-2">•</span>
                    <span><strong>System:</strong> Auto-schedules during bracket generation</span>
                </li>
                <li class="flex items-start">
                    <span class="text-green-500 mr-2">•</span>
                    <span><strong>Admins/Organizers:</strong> Modify schedules, record scores</span>
                </li>
                <li class="flex items-start">
                    <span class="text-green-500 mr-2">•</span>
                    <span><strong>Referees:</strong> Verify results, manage live matches</span>
                </li>
            </ul>
        </div>

        <div>
            <h4 class="font-bold text-lg mb-3 text-purple-600">⚽ Match Types</h4>
            <ul class="space-y-2 text-gray-700">
                <li class="flex items-start">
                    <span class="text-purple-500 mr-2">•</span>
                    <span><strong>Individual:</strong> Player vs Player</span>
                </li>
                <li class="flex items-start">
                    <span class="text-purple-500 mr-2">•</span>
                    <span><strong>Team:</strong> Team vs Team</span>
                </li>
                <li class="flex items-start">
                    <span class="text-purple-500 mr-2">•</span>
                    <span><strong>Special:</strong> Finals, semi-finals, group stage</span>
                </li>
            </ul>
        </div>

        <div>
            <h4 class="font-bold text-lg mb-3 text-orange-600">⏱️ Match Progression</h4>
            <ul class="space-y-2 text-gray-700">
                <li class="flex justify-between">
                    <span>Scheduling:</span>
                    <span class="font-semibold">Instant</span>
                </li>
                <li class="flex justify-between">
                    <span>Warmup:</span>
                    <span class="font-semibold">5-10 minutes</span>
                </li>
                <li class="flex justify-between">
                    <span>Match Duration:</span>
                    <span class="font-semibold">45-90 minutes</span>
                </li>
                <li class="flex justify-between">
                    <span>Verification:</span>
                    <span class="font-semibold">1-5 minutes</span>
                </li>
            </ul>
        </div>
    </div>
</div>

<!-- Match Lifecycle Diagram -->
<div class="section-card">
    <h3 class="text-2xl font-bold mb-4 flex items-center">
        <span class="step-number">2</span>
        Complete Match Lifecycle
    </h3>

    <div class="mermaid bg-white p-6 rounded-lg shadow-inner">
flowchart TD
    Start([⚙️ Match Created<br/>During Bracket Generation])
    Start --> StatusScheduled[Status: SCHEDULED<br/>Progress: NOT_STARTED<br/>• Participants assigned<br/>• Date & time set<br/>• Venue allocated<br/>• Match code generated]
    
    StatusScheduled --> NotifyScheduled[📧 Send Notifications:<br/>• MatchScheduledNotification to participants<br/>• MatchScheduledAdminNotification<br/>• MatchRefereeAssignedNotification if ref assigned]
    
    NotifyScheduled --> WaitForTime{Scheduled<br/>Time Reached?}
    WaitForTime -->|No| WaitState[Waiting State<br/>• Countdown timer<br/>• Reminder notifications]
    WaitState --> WaitForTime
    
    WaitForTime -->|Yes| StartWarmup[Start Warmup Phase<br/>Progress: WARMUP<br/>• 5-10 minute warmup<br/>• Players/teams prepare]
    
    StartWarmup --> WarmupComplete{Warmup<br/>Complete?}
    WarmupComplete -->|No| WarmupActive[Warmup in Progress]
    WarmupActive --> WarmupComplete
    
    WarmupComplete -->|Yes| StartMatch[Start Match<br/>Status: IN_PROGRESS<br/>Progress: IN_PROGRESS<br/>• started_at timestamp]
    
    StartMatch --> NotifyStarted[📧 Send Notifications:<br/>• MatchStartedNotification<br/>• MatchStreamingStartedNotification if streamed]
    
    NotifyStarted --> MatchActive{Match<br/>In Progress}
    
    MatchActive -->|Pause| PauseMatch[Progress: PAUSED<br/>• paused_at timestamp<br/>• Reason recorded]
    PauseMatch -->|Resume| ResumeMatch[Progress: RESUMED<br/>• resumed_at timestamp]
    ResumeMatch --> MatchActive
    
    MatchActive -->|Complete| RecordScore[Record Final Score<br/>• Winner determined<br/>• Stats recorded<br/>• Duration calculated]
    
    RecordScore --> StatusCompleted[Status: COMPLETED<br/>Progress: COMPLETED<br/>• completed_at timestamp<br/>• Result type set]
    
    StatusCompleted --> NotifyCompleted[📧 Send Notifications:<br/>• MatchCompletedNotification<br/>• MatchResultUpdatedNotification<br/>• MatchCompletedAdminNotification]
    
    NotifyCompleted --> VerifyResult{Referee/Admin<br/>Verifies?}
    VerifyResult -->|Disputed| MarkDisputed[Verification: DISPUTED<br/>• Under review<br/>• Admin investigates]
    MarkDisputed --> AdminReview{Admin<br/>Decision}
    AdminReview -->|Modify| UpdateResult[Update Match Result]
    UpdateResult --> VerifyResult
    
    VerifyResult -->|Verified| MarkVerified[Verification: VERIFIED<br/>• verified_at timestamp<br/>• verified_by recorded]
    
    MarkVerified --> NotifyVerified[📧 Send Notification:<br/>• MatchVerificationUpdatedNotification]
    
    NotifyVerified --> UpdateStats[Update Statistics<br/>• Player ratings<br/>• Team stats<br/>• Tournament progress]
    
    UpdateStats --> AdvanceBracket[Advance Bracket<br/>• Winner moves forward<br/>• Next match scheduled]
    
    %% Rescheduling Path
    StatusScheduled -->|Reschedule| RescheduleMatch[Reschedule Match<br/>• New date/time<br/>• Reason recorded]
    RescheduleMatch --> NotifyRescheduled[📧 MatchRescheduledNotification<br/>to participants]
    NotifyRescheduled --> StatusScheduled
    
    %% Cancellation Path
    StatusScheduled -->|Cancel| CancelMatch[Cancel Match<br/>• status: cancelled<br/>• Reason recorded]
    MatchActive -->|Cancel| CancelMatch
    CancelMatch --> NotifyCancelled[📧 MatchCancelledNotification<br/>to participants]
    NotifyCancelled --> EndCancelled([Match Cancelled])
    
    AdvanceBracket --> End([Match Complete])
    
    style Start fill:#4CAF50,stroke:#2E7D32,color:#fff
    style StatusScheduled fill:#FFC107,stroke:#F57C00,color:#000
    style StartMatch fill:#2196F3,stroke:#1565C0,color:#fff
    style StatusCompleted fill:#9C27B0,stroke:#6A1B9A,color:#fff
    style MarkVerified fill:#4CAF50,stroke:#2E7D32,color:#fff
    style CancelMatch fill:#f44336,stroke:#c62828,color:#fff
    style End fill:#4CAF50,stroke:#2E7D32,color:#fff
    style EndCancelled fill:#f44336,stroke:#c62828,color:#fff
    </div>
</div>

<!-- Match Status Reference -->
<div class="section-card">
    <h3 class="text-2xl font-bold mb-4 flex items-center">
        <span class="step-number">3</span>
        Match Status & Progress Reference
    </h3>

    <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
        <div>
            <h4 class="font-bold text-lg mb-3 text-blue-600">Match Status</h4>
            <div class="space-y-2">
                <div class="bg-yellow-50 border-l-4 border-yellow-500 p-3 rounded-r">
                    <p class="font-semibold">SCHEDULED</p>
                    <p class="text-sm text-gray-600">Match created, waiting for scheduled time</p>
                </div>
                <div class="bg-blue-50 border-l-4 border-blue-500 p-3 rounded-r">
                    <p class="font-semibold">IN_PROGRESS</p>
                    <p class="text-sm text-gray-600">Match currently being played</p>
                </div>
                <div class="bg-green-50 border-l-4 border-green-500 p-3 rounded-r">
                    <p class="font-semibold">COMPLETED</p>
                    <p class="text-sm text-gray-600">Match finished, awaiting verification</p>
                </div>
                <div class="bg-red-50 border-l-4 border-red-500 p-3 rounded-r">
                    <p class="font-semibold">CANCELLED</p>
                    <p class="text-sm text-gray-600">Match cancelled, won't be played</p>
                </div>
            </div>
        </div>

        <div>
            <h4 class="font-bold text-lg mb-3 text-purple-600">Progress Status</h4>
            <div class="space-y-2">
                <div class="bg-gray-50 border-l-4 border-gray-500 p-3 rounded-r">
                    <p class="font-semibold">NOT_STARTED</p>
                    <p class="text-sm text-gray-600">Before scheduled time</p>
                </div>
                <div class="bg-orange-50 border-l-4 border-orange-500 p-3 rounded-r">
                    <p class="font-semibold">WARMUP</p>
                    <p class="text-sm text-gray-600">5-10 minute preparation period</p>
                </div>
                <div class="bg-blue-50 border-l-4 border-blue-500 p-3 rounded-r">
                    <p class="font-semibold">IN_PROGRESS</p>
                    <p class="text-sm text-gray-600">Match actively being played</p>
                </div>
                <div class="bg-yellow-50 border-l-4 border-yellow-500 p-3 rounded-r">
                    <p class="font-semibold">PAUSED</p>
                    <p class="text-sm text-gray-600">Temporarily paused (injury, technical issue)</p>
                </div>
                <div class="bg-green-50 border-l-4 border-green-500 p-3 rounded-r">
                    <p class="font-semibold">COMPLETED</p>
                    <p class="text-sm text-gray-600">Match finished</p>
                </div>
            </div>
        </div>
    </div>

    <div class="screenshot-placeholder">
        <p class="text-2xl text-gray-400 mb-2">📸</p>
        <p class="text-gray-600 font-mono text-lg">[screenshot-match-scheduling.png]</p>
        <p class="text-sm text-gray-500 mt-2">Match scheduling and creation interface</p>
    </div>
</div>

<!-- Score Recording & Verification -->
<div class="section-card">
    <h3 class="text-2xl font-bold mb-4 flex items-center">
        <span class="step-number">4</span>
        Score Recording & Verification
    </h3>

    <div class="mermaid bg-white p-6 rounded-lg shadow-inner">
graph TD
    A[Match Completed] --> B[Referee/Admin<br/>Enters Score]
    B --> C{Score Valid?}
    C -->|No| D[Show Validation Error]
    D --> B
    C -->|Yes| E[Record Score<br/>• Final scores<br/>• Game-by-game if applicable<br/>• Winner determined]
    E --> F[Calculate Stats<br/>• Match duration<br/>• Performance metrics<br/>• Rating changes]
    F --> G{Auto-Verify<br/>Enabled?}
    G -->|Yes| H[Verification: VERIFIED<br/>Automatically approved]
    G -->|No| I[Verification: PENDING<br/>Awaits referee confirmation]
    I --> J{Referee/Admin<br/>Confirms?}
    J -->|Disputed| K[Verification: DISPUTED<br/>Admin review required]
    J -->|Verified| H
    K --> L{Admin<br/>Decision}
    L -->|Modify Score| B
    L -->|Approve| H
    H --> M[📧 Send Notifications<br/>Update Brackets<br/>Schedule Next Match]
    M --> N[Update Rankings<br/>& Statistics]
    
    style E fill:#2196F3,stroke:#1565C0,color:#fff
    style H fill:#4CAF50,stroke:#2E7D32,color:#fff
    style K fill:#f44336,stroke:#c62828,color:#fff
    style N fill:#9C27B0,stroke:#6A1B9A,color:#fff
    </div>

    <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mt-4">
        <div class="screenshot-placeholder-sm">
            <p class="text-xl text-gray-400 mb-2">📸</p>
            <p class="text-gray-600 font-mono">[screenshot-score-entry.png]</p>
            <p class="text-xs text-gray-500 mt-2">Match score entry interface</p>
        </div>
        <div class="screenshot-placeholder-sm">
            <p class="text-xl text-gray-400 mb-2">📸</p>
            <p class="text-gray-600 font-mono">[screenshot-match-verification.png]</p>
            <p class="text-xs text-gray-500 mt-2">Match result verification interface</p>
        </div>
    </div>
</div>

<!-- Live Match Tracking -->
<div class="section-card">
    <h3 class="text-2xl font-bold mb-4 flex items-center">
        <span class="step-number">5</span>
        Live Match Tracking
    </h3>

    <div class="bg-red-50 rounded-lg p-6">
        <h4 class="font-bold text-red-900 mb-4">🔴 Live Match Features</h4>
        
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
            <div class="bg-white rounded-lg p-4">
                <p class="font-semibold text-gray-800 mb-3">Real-Time Updates:</p>
                <ul class="space-y-2 text-sm text-gray-700">
                    <li class="flex items-start">
                        <span class="text-red-500 mr-2">•</span>
                        <span>Live score updates</span>
                    </li>
                    <li class="flex items-start">
                        <span class="text-red-500 mr-2">•</span>
                        <span>Match timer/clock</span>
                    </li>
                    <li class="flex items-start">
                        <span class="text-red-500 mr-2">•</span>
                        <span>Pause/resume tracking</span>
                    </li>
                    <li class="flex items-start">
                        <span class="text-red-500 mr-2">•</span>
                        <span>Spectator count</span>
                    </li>
                </ul>
            </div>

            <div class="bg-white rounded-lg p-4">
                <p class="font-semibold text-gray-800 mb-3">Streaming Integration:</p>
                <ul class="space-y-2 text-sm text-gray-700">
                    <li class="flex items-start">
                        <span class="text-purple-500 mr-2">•</span>
                        <span>YouTube live stream</span>
                    </li>
                    <li class="flex items-start">
                        <span class="text-purple-500 mr-2">•</span>
                        <span>Twitch integration</span>
                    </li>
                    <li class="flex items-start">
                        <span class="text-purple-500 mr-2">•</span>
                        <span>Custom stream URL</span>
                    </li>
                    <li class="flex items-start">
                        <span class="text-purple-500 mr-2">•</span>
                        <span>Stream key management</span>
                    </li>
                </ul>
            </div>
        </div>
    </div>

    <div class="screenshot-placeholder mt-4">
        <p class="text-2xl text-gray-400 mb-2">📸</p>
        <p class="text-gray-600 font-mono text-lg">[screenshot-live-match-view.png]</p>
        <p class="text-sm text-gray-500 mt-2">Live match tracking interface with real-time updates</p>
    </div>
</div>

<!-- Match Notifications -->
<div class="section-card">
    <h3 class="text-2xl font-bold mb-4 flex items-center">
        <span class="step-number">6</span>
        Match Notification Matrix
    </h3>
    
    <div class="overflow-x-auto">
        <table class="w-full bg-white rounded-lg shadow">
            <thead class="bg-gray-100">
                <tr>
                    <th class="px-4 py-3 text-left font-semibold">Event</th>
                    <th class="px-4 py-3 text-left font-semibold">Recipient</th>
                    <th class="px-4 py-3 text-left font-semibold">Notification</th>
                    <th class="px-4 py-3 text-center font-semibold">Priority</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-gray-200">
                <tr class="hover:bg-gray-50 bg-yellow-50">
                    <td class="px-4 py-3">Match Scheduled</td>
                    <td class="px-4 py-3">Participants</td>
                    <td class="px-4 py-3"><code class="text-xs">MatchScheduledNotification</code></td>
                    <td class="px-4 py-3 text-center"><span class="bg-yellow-100 px-2 py-1 rounded text-xs">High</span></td>
                </tr>
                <tr class="hover:bg-gray-50 bg-yellow-50">
                    <td class="px-4 py-3">Match Scheduled</td>
                    <td class="px-4 py-3">Admins</td>
                    <td class="px-4 py-3"><code class="text-xs">MatchScheduledAdminNotification</code></td>
                    <td class="px-4 py-3 text-center"><span class="bg-blue-100 px-2 py-1 rounded text-xs">Default</span></td>
                </tr>
                <tr class="hover:bg-gray-50">
                    <td class="px-4 py-3">Referee Assigned</td>
                    <td class="px-4 py-3">Referee</td>
                    <td class="px-4 py-3"><code class="text-xs">MatchRefereeAssignedNotification</code></td>
                    <td class="px-4 py-3 text-center"><span class="bg-yellow-100 px-2 py-1 rounded text-xs">High</span></td>
                </tr>
                <tr class="hover:bg-gray-50 bg-blue-50">
                    <td class="px-4 py-3">Match Started</td>
                    <td class="px-4 py-3">Participants</td>
                    <td class="px-4 py-3"><code class="text-xs">MatchStartedNotification</code></td>
                    <td class="px-4 py-3 text-center"><span class="bg-yellow-100 px-2 py-1 rounded text-xs">High</span></td>
                </tr>
                <tr class="hover:bg-gray-50 bg-blue-50">
                    <td class="px-4 py-3">Streaming Started</td>
                    <td class="px-4 py-3">Spectators</td>
                    <td class="px-4 py-3"><code class="text-xs">MatchStreamingStartedNotification</code></td>
                    <td class="px-4 py-3 text-center"><span class="bg-blue-100 px-2 py-1 rounded text-xs">Default</span></td>
                </tr>
                <tr class="hover:bg-gray-50 bg-green-50">
                    <td class="px-4 py-3">Match Completed</td>
                    <td class="px-4 py-3">Participants</td>
                    <td class="px-4 py-3"><code class="text-xs">MatchCompletedNotification</code></td>
                    <td class="px-4 py-3 text-center"><span class="bg-yellow-100 px-2 py-1 rounded text-xs">High</span></td>
                </tr>
                <tr class="hover:bg-gray-50 bg-green-50">
                    <td class="px-4 py-3">Result Updated</td>
                    <td class="px-4 py-3">Participants</td>
                    <td class="px-4 py-3"><code class="text-xs">MatchResultUpdatedNotification</code></td>
                    <td class="px-4 py-3 text-center"><span class="bg-blue-100 px-2 py-1 rounded text-xs">Default</span></td>
                </tr>
                <tr class="hover:bg-gray-50">
                    <td class="px-4 py-3">Result Verified</td>
                    <td class="px-4 py-3">Participants</td>
                    <td class="px-4 py-3"><code class="text-xs">MatchVerificationUpdatedNotification</code></td>
                    <td class="px-4 py-3 text-center"><span class="bg-blue-100 px-2 py-1 rounded text-xs">Default</span></td>
                </tr>
                <tr class="hover:bg-gray-50 bg-orange-50">
                    <td class="px-4 py-3">Match Rescheduled</td>
                    <td class="px-4 py-3">Participants</td>
                    <td class="px-4 py-3"><code class="text-xs">MatchRescheduledNotification</code></td>
                    <td class="px-4 py-3 text-center"><span class="bg-yellow-100 px-2 py-1 rounded text-xs">High</span></td>
                </tr>
                <tr class="hover:bg-gray-50 bg-red-50">
                    <td class="px-4 py-3">Match Cancelled</td>
                    <td class="px-4 py-3">Participants</td>
                    <td class="px-4 py-3"><code class="text-xs">MatchCancelledNotification</code></td>
                    <td class="px-4 py-3 text-center"><span class="bg-yellow-100 px-2 py-1 rounded text-xs">High</span></td>
                </tr>
            </tbody>
        </table>
    </div>

    <div class="screenshot-placeholder-sm mt-4">
        <p class="text-xl text-gray-400 mb-2">📸</p>
        <p class="text-gray-600 font-mono">[screenshot-match-results.png]</p>
        <p class="text-xs text-gray-500 mt-2">Match results and statistics display</p>
    </div>
</div>

<!-- Special Match Scenarios -->
<div class="section-card">
    <h3 class="text-2xl font-bold mb-4 flex items-center">
        <span class="step-number">7</span>
        Special Match Scenarios
    </h3>

    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
        <!-- Rescheduling -->
        <div class="bg-orange-50 rounded-lg p-4 border-2 border-orange-300">
            <h4 class="font-bold text-orange-700 mb-3">🔄 Match Rescheduling</h4>
            <div class="space-y-2 text-sm text-gray-700">
                <div class="bg-white rounded p-3">
                    <strong>Reasons for Rescheduling:</strong>
                    <ul class="mt-2 space-y-1 ml-4">
                        <li>• Participant unavailability</li>
                        <li>• Venue conflicts</li>
                        <li>• Weather conditions</li>
                        <li>• Technical issues</li>
                    </ul>
                </div>
                <div class="bg-white rounded p-3">
                    <strong>Process:</strong>
                    <ol class="mt-2 space-y-1 ml-4 list-decimal">
                        <li>Admin selects new date/time</li>
                        <li>System updates match record</li>
                        <li>Sends reschedule notifications</li>
                        <li>Updates participant calendars</li>
                    </ol>
                </div>
            </div>
        </div>

        <!-- Cancellation -->
        <div class="bg-red-50 rounded-lg p-4 border-2 border-red-300">
            <h4 class="font-bold text-red-700 mb-3">❌ Match Cancellation</h4>
            <div class="space-y-2 text-sm text-gray-700">
                <div class="bg-white rounded p-3">
                    <strong>Reasons for Cancellation:</strong>
                    <ul class="mt-2 space-y-1 ml-4">
                        <li>• Participant withdrawal</li>
                        <li>• Tournament cancelled</li>
                        <li>• Disqualification</li>
                        <li>• Force majeure</li>
                    </ul>
                </div>
                <div class="bg-white rounded p-3">
                    <strong>Process:</strong>
                    <ol class="mt-2 space-y-1 ml-4 list-decimal">
                        <li>Admin cancels match</li>
                        <li>Records cancellation reason</li>
                        <li>Updates bracket (advance opponent)</li>
                        <li>Sends cancellation notifications</li>
                    </ol>
                </div>
            </div>
        </div>

        <!-- Disputes -->
        <div class="bg-purple-50 rounded-lg p-4 border-2 border-purple-300 md:col-span-2">
            <h4 class="font-bold text-purple-700 mb-3">⚖️ Result Disputes</h4>
            <div class="grid grid-cols-1 md:grid-cols-3 gap-3">
                <div class="bg-white rounded p-3 text-sm">
                    <strong>1. Dispute Filed</strong>
                    <p class="text-gray-600 mt-1">Participant contests result within 24 hours</p>
                </div>
                <div class="bg-white rounded p-3 text-sm">
                    <strong>2. Admin Review</strong>
                    <p class="text-gray-600 mt-1">Admin investigates with evidence (screenshots, video)</p>
                </div>
                <div class="bg-white rounded p-3 text-sm">
                    <strong>3. Resolution</strong>
                    <p class="text-gray-600 mt-1">Admin updates result or confirms original, notifications sent</p>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Summary -->
<div class="section-card bg-gradient-to-r from-red-50 to-blue-50">
    <h3 class="text-2xl font-bold mb-4">📚 Quick Reference Summary</h3>
    
    <div class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-6">
        <div class="bg-white rounded-lg p-4 shadow">
            <p class="text-3xl font-bold text-red-600 mb-2">4</p>
            <p class="text-gray-700">Match Statuses</p>
        </div>
        <div class="bg-white rounded-lg p-4 shadow">
            <p class="text-3xl font-bold text-blue-600 mb-2">5</p>
            <p class="text-gray-700">Progress States</p>
        </div>
        <div class="bg-white rounded-lg p-4 shadow">
            <p class="text-3xl font-bold text-green-600 mb-2">~9</p>
            <p class="text-gray-700">Notification Types</p>
        </div>
        <div class="bg-white rounded-lg p-4 shadow">
            <p class="text-3xl font-bold text-purple-600 mb-2">3</p>
            <p class="text-gray-700">Verification States</p>
        </div>
    </div>

    <div class="bg-white rounded-lg p-6">
        <p class="font-semibold text-gray-800 mb-3">🎯 Key Takeaways:</p>
        <ul class="space-y-2 text-gray-700">
            <li class="flex items-start">
                <span class="text-green-500 mr-2">•</span>
                <span>Matches are auto-scheduled during bracket generation with appropriate spacing and venue allocation</span>
            </li>
            <li class="flex items-start">
                <span class="text-blue-500 mr-2">•</span>
                <span>Live match tracking provides real-time updates to participants and spectators via streaming</span>
            </li>
            <li class="flex items-start">
                <span class="text-purple-500 mr-2">•</span>
                <span>All match results must be verified before affecting tournament brackets and player ratings</span>
            </li>
            <li class="flex items-start">
                <span class="text-orange-500 mr-2">•</span>
                <span>Match disputes trigger admin review process with evidence collection and final decision</span>
            </li>
        </ul>
    </div>
</div>

<?php /**PATH D:\E - STARTUPS\WORK FOLDERS\PERSONAL\the-milimus-tournament\resources\views\documentation\partials\match-management.blade.php ENDPATH**/ ?>