<!-- Team Registration Documentation -->

<div class="section-card">
    <h2 class="text-4xl font-bold mb-6">📝 Team Registration Workflow</h2>
    
    <div class="bg-blue-50 border-l-4 border-blue-500 p-6 rounded-r-lg mb-6">
        <p class="text-lg text-blue-900 font-semibold">📖 What You'll Learn</p>
        <ul class="mt-3 space-y-2 text-blue-800">
            <li>✅ Complete team registration process from start to finish</li>
            <li>✅ Decision logic and system behavior at each step</li>
            <li>✅ All notifications triggered during registration</li>
            <li>✅ Post-registration requirements and workflows</li>
        </ul>
    </div>
</div>

<!-- Section 1: Overview -->
<div class="section-card" id="overview">
    <h3 class="text-2xl font-bold mb-4 flex items-center">
        <span class="step-number">1</span>
        Overview
    </h3>
    
    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
        <div>
            <h4 class="font-bold text-lg mb-3 text-blue-600">❓ What is Team Registration?</h4>
            <p class="text-gray-700 leading-relaxed">
                Team registration is the process where a team manager creates an account, registers their team, 
                adds players (11-23), assigns officials (coach, assistant coach, doctor, physiotherapist), 
                and enrolls the team for a tournament. The process includes payment creation and verification steps.
            </p>
        </div>

        <div>
            <h4 class="font-bold text-lg mb-3 text-green-600">👥 Who Can Register?</h4>
            <p class="text-gray-700 leading-relaxed">
                Anyone can register a team by becoming a team manager. The manager will automatically receive 
                a <span class="font-mono bg-gray-100 px-2 py-1 rounded">team_manager</span> role and will be 
                responsible for managing the team, completing payments, and ensuring player profiles are complete.
            </p>
        </div>

        <div>
            <h4 class="font-bold text-lg mb-3 text-purple-600">📋 What's Required?</h4>
            <ul class="space-y-2 text-gray-700">
                <li class="flex items-start">
                    <span class="text-purple-500 mr-2">•</span>
                    <span><strong>Tournament Selection:</strong> Choose tournament to register for</span>
                </li>
                <li class="flex items-start">
                    <span class="text-purple-500 mr-2">•</span>
                    <span><strong>Category Selection:</strong> Select team category (Men, Women, Youth, Children)</span>
                </li>
                <li class="flex items-start">
                    <span class="text-purple-500 mr-2">•</span>
                    <span><strong>Team Information:</strong> Name, email, phone, location (dynamic entry), founding year</span>
                </li>
                <li class="flex items-start">
                    <span class="text-purple-500 mr-2">•</span>
                    <span><strong>Team Manager Details:</strong> Name, email, phone, password</span>
                </li>
                <li class="flex items-start">
                    <span class="text-purple-500 mr-2">•</span>
                    <span><strong>Players:</strong> 11-23 players with basic info, date of birth, gender</span>
                </li>
                <li class="flex items-start">
                    <span class="text-purple-500 mr-2">•</span>
                    <span><strong>Officials:</strong> Team officials (coaches, managers, physio, etc.)</span>
                </li>
            </ul>
        </div>

        <div>
            <h4 class="font-bold text-lg mb-3 text-orange-600">⏱️ Expected Timeline</h4>
            <ul class="space-y-2 text-gray-700">
                <li class="flex justify-between">
                    <span>Form Completion:</span>
                    <span class="font-semibold">10-15 minutes</span>
                </li>
                <li class="flex justify-between">
                    <span>Payment Processing:</span>
                    <span class="font-semibold">Instant - 5 minutes</span>
                </li>
                <li class="flex justify-between">
                    <span>Profile Completion:</span>
                    <span class="font-semibold">1-3 days</span>
                </li>
                <li class="flex justify-between">
                    <span>Admin Review:</span>
                    <span class="font-semibold">1-2 days</span>
                </li>
            </ul>
        </div>
    </div>
</div>

<!-- Section 2: User Journey Map -->
<div class="section-card" id="user-journey">
    <h3 class="text-2xl font-bold mb-4 flex items-center">
        <span class="step-number">2</span>
        User Journey Map
    </h3>
    
    <div class="bg-gradient-to-r from-blue-50 to-purple-50 rounded-lg p-6 mb-6">
        <div class="grid grid-cols-2 md:grid-cols-4 lg:grid-cols-8 gap-3">
            <div class="text-center">
                <div class="text-3xl mb-1">🏠</div>
                <div class="font-semibold text-xs">Visit Site</div>
            </div>
            <div class="text-center text-2xl text-gray-400">→</div>
            <div class="text-center">
                <div class="text-3xl mb-1">🏆</div>
                <div class="font-semibold text-xs">Select Tournament</div>
            </div>
            <div class="text-center text-2xl text-gray-400">→</div>
            <div class="text-center">
                <div class="text-3xl mb-1">🏅</div>
                <div class="font-semibold text-xs">Select Category</div>
            </div>
            <div class="text-center text-2xl text-gray-400">→</div>
            <div class="text-center">
                <div class="text-3xl mb-1">📝</div>
                <div class="font-semibold text-xs">Fill Form</div>
            </div>
            <div class="text-center text-2xl text-gray-400">→</div>
            <div class="text-center">
                <div class="text-3xl mb-1">✅</div>
                <div class="font-semibold text-xs">Submit</div>
            </div>
            <div class="text-center text-2xl text-gray-400">→</div>
            <div class="text-center">
                <div class="text-3xl mb-1">📧</div>
                <div class="font-semibold text-xs">Get Emails</div>
            </div>
            <div class="text-center text-2xl text-gray-400">→</div>
            <div class="text-center">
                <div class="text-3xl mb-1">💰</div>
                <div class="font-semibold text-xs">Pay Fees</div>
            </div>
            <div class="text-center text-2xl text-gray-400">→</div>
            <div class="text-center">
                <div class="text-3xl mb-1">🎉</div>
                <div class="font-semibold text-xs">Complete!</div>
            </div>
        </div>
    </div>

    <div class="screenshot-placeholder">
        <p class="text-2xl text-gray-400 mb-2">📸</p>
        <p class="text-gray-600 font-mono text-lg">[screenshot-user-journey-map.png]</p>
        <p class="text-sm text-gray-500 mt-2">Replace with actual user journey visualization</p>
    </div>
</div>

<!-- Section 3: Complete Decision Flow Diagram -->
<div class="section-card" id="flow-diagram">
    <h3 class="text-2xl font-bold mb-4 flex items-center">
        <span class="step-number">3</span>
        Complete Registration Flow
    </h3>
    
    <div class="bg-yellow-50 border-l-4 border-yellow-500 p-4 rounded-r-lg mb-6">
        <p class="text-yellow-800">
            <strong>💡 Interactive Diagram:</strong> This flowchart shows every decision point and action in the registration process.
        </p>
    </div>

    <div class="mermaid bg-white p-6 rounded-lg shadow-inner">
flowchart TD
    Start([👤 User Visits Registration Page])
    Start --> LoadForm[📄 System Loads Active Tournament<br/>& Entry Fee Information]
    LoadForm --> DisplayForm[🖥️ Display Registration Form]
    
    DisplayForm --> SelectCategory[🏅 Select Category:<br/>• View Available Categories<br/>• See Fees & Requirements<br/>• Choose ONE Category]
    SelectCategory --> UserFills[✍️ User Fills Form:<br/>• Team Details<br/>• Location (dynamic)<br/>• Manager Info<br/>• 11-23 Players<br/>• Officials]
    
    UserFills --> Validate{✅ Form Valid?}
    Validate -->|❌ No| ValidationError[⚠️ Show Validation Errors]
    ValidationError --> UserFills
    
    Validate -->|✔️ Yes| Submit[📤 Submit to Controller]
    
    Submit --> CheckCaptain{🔍 Captain Email<br/>Exists?}
    CheckCaptain -->|✔️ Yes| UseCaptain[👤 Use Existing User]
    CheckCaptain -->|❌ No| CreateCaptain[➕ Create New User<br/>• user_type: team_manager<br/>• profile_complete: false<br/>• payment_status: pending]
    
    CreateCaptain --> AssignRole[🎭 Assign team_manager Role]
    AssignRole --> NotifyCaptain1[📧 Send Notifications:<br/>• UserRegisteredNotification<br/>• UserRegisteredAdminNotification]
    
    UseCaptain --> CaptainReady[✅ Captain Ready]
    NotifyCaptain1 --> CaptainReady
    
    CaptainReady --> CheckTeam{🔍 Team Name<br/>Exists?}
    CheckTeam -->|✔️ Yes| CheckTournamentReg{🏆 Already Registered<br/>for This Tournament?}
    CheckTournamentReg -->|✔️ Yes| ErrorDupe[❌ Error: Team Already Registered]
    CheckTournamentReg -->|❌ No| ReuseTeam[♻️ Reuse Existing Team]
    
    CheckTeam -->|❌ No| CreateTeam[➕ Create New Team<br/>• manager_id<br/>• status: active]
    
    CreateTeam --> NotifyTeam[📧 Send Notifications:<br/>• TeamCreatedNotification<br/>• TeamMemberWelcomeNotification<br/>• TeamCreatedAdminNotification]
    
    ReuseTeam --> TeamReady[✅ Team Ready]
    NotifyTeam --> TeamReady
    
    TeamReady --> RegisterTournament[🏆 Register Team for Tournament<br/>• Store tournament data<br/>• registration_method: public_form]
    
    RegisterTournament --> NotifyTournament[📧 Send Notifications:<br/>• TeamTournamentRegisteredNotification<br/>• TeamTournamentRegisteredAdminNotification]
    
    NotifyTournament --> CreatePayment[💳 Create Payment Record<br/>• amount: tournament entry_fee<br/>• status: pending<br/>• payment_method: Mpesa<br/>• reference_number: PAY_xxxxx]
    
    CreatePayment --> NotifyPayment[📧 Send Notifications:<br/>• PaymentInitiatedNotification<br/>• TeamPaymentInitiatedNotification<br/>• PaymentInitiatedAdminNotification]
    
    NotifyPayment --> StartPlayers[👥 Start Creating Players]
    StartPlayers --> LoopPlayers{📝 For Each Player<br/>11-23 Players}
    
    LoopPlayers -->|Player N| CreatePlayer[➕ Create Player Record<br/>• team_id, tournament_id<br/>• profile_complete: false<br/>• Generate OTP]
    
    CreatePlayer --> NotifyPlayer[📧 Send Notifications:<br/>• PlayerRegisteredNotification<br/>• TeamPlayerAddedNotification<br/>• PlayerRegisteredAdminNotification]
    
    NotifyPlayer --> MorePlayers{More Players?}
    MorePlayers -->|✔️ Yes| LoopPlayers
    MorePlayers -->|❌ No| PlayersComplete[✅ All Players Created]
    
    PlayersComplete --> StartOfficials[👔 Start Creating Officials]
    StartOfficials --> LoopOfficials{📝 For Each Official<br/>Coach, Asst Coach,<br/>Doctor, Physio}
    
    LoopOfficials -->|Official N| CreateOfficial[➕ Create TeamOfficial Record<br/>• team_id, role<br/>• qualifications<br/>• otp_verified: false<br/>• Generate OTP]
    
    CreateOfficial --> NotifyOfficial[📧 Send 5 Notifications:<br/>• OfficialAssignmentNotification<br/>• OfficialOtpNotification<br/>• TeamOfficialAssignedNotification<br/>• OfficialAssignedAdminNotification<br/>• OfficialOtpGeneratedAdminNotification]
    
    NotifyOfficial --> MoreOfficials{More Officials?}
    MoreOfficials -->|✔️ Yes| LoopOfficials
    MoreOfficials -->|❌ No| OfficialsComplete[✅ All Officials Created]
    
    OfficialsComplete --> CommitDB[(💾 Commit All Changes<br/>to Database)]
    CommitDB --> LoginCaptain[🔐 Auto-Login Captain]
    LoginCaptain --> Redirect[🔄 Redirect to Profile<br/>Completion Page]
    
    Redirect --> PostRegState[📊 Post-Registration State:<br/>✅ Team Created<br/>✅ Tournament Registered<br/>⏳ Payment: PENDING<br/>⏳ Player Profiles: INCOMPLETE]
    
    PostRegState --> Dashboard[🏠 Team Manager Dashboard]
    Dashboard --> ShowAlerts[🚨 Show TeamRegistrationAlert<br/>• Pending Payments List<br/>• Incomplete Player Profiles<br/>• Minimum Players Warning]
    
    ShowAlerts --> End([✨ Registration Process Complete])
    ErrorDupe --> End

    style Start fill:#4CAF50,stroke:#2E7D32,color:#fff
    style End fill:#4CAF50,stroke:#2E7D32,color:#fff
    style ErrorDupe fill:#f44336,stroke:#c62828,color:#fff
    style PostRegState fill:#FF9800,stroke:#F57C00,color:#000
    style ShowAlerts fill:#f44336,stroke:#c62828,color:#fff
    style CreateCaptain fill:#2196F3,stroke:#1565C0,color:#fff
    style CreateTeam fill:#2196F3,stroke:#1565C0,color:#fff
    style CreatePayment fill:#9C27B0,stroke:#6A1B9A,color:#fff
    style CommitDB fill:#00BCD4,stroke:#00838F,color:#fff
    </div>
</div>

<!-- Section 4: Step-by-Step Walkthrough -->
<div class="section-card" id="walkthrough">
    <h3 class="text-2xl font-bold mb-6 flex items-center">
        <span class="step-number">4</span>
        Detailed Step-by-Step Walkthrough
    </h3>

    <!-- Step 1 -->
    <div class="mb-8">
        <h4 class="text-xl font-bold mb-4 text-blue-600">Step 1: Access Registration Page</h4>
        
        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <div>
                <p class="text-gray-700 mb-4">User navigates to the registration page to begin the process.</p>
                
                <div class="bg-gray-50 rounded-lg p-4 space-y-2">
                    <div class="flex items-start">
                        <span class="text-blue-500 mr-2">📍</span>
                        <div>
                            <strong>URL:</strong>
                            <code class="ml-2 bg-white px-2 py-1 rounded">/register</code> or
                            <code class="ml-2 bg-white px-2 py-1 rounded">/register/team</code>
                        </div>
                    </div>
                    <div class="flex items-start">
                        <span class="text-green-500 mr-2">✅</span>
                        <div>
                            <strong>System Action:</strong> Load active tournament & entry fee
                        </div>
                    </div>
                    <div class="flex items-start">
                        <span class="text-purple-500 mr-2">🖥️</span>
                        <div>
                            <strong>Display:</strong> Registration form with all required fields
                        </div>
                    </div>
                </div>
            </div>

            <div class="screenshot-placeholder-sm">
                <p class="text-xl text-gray-400 mb-2">📸</p>
                <p class="text-gray-600 font-mono">[screenshot-registration-form.png]</p>
                <p class="text-xs text-gray-500 mt-2">Registration form interface</p>
            </div>
        </div>
    </div>

    <!-- Step 2 -->
    <div class="mb-8">
        <h4 class="text-xl font-bold mb-4 text-blue-600">Step 2: Team Manager/User Creation</h4>
        
        <div class="decision-box">
            <p class="font-bold text-blue-800 mb-2">🤔 Decision Point: Does team manager email exist?</p>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mt-4">
                <div class="bg-white rounded-lg p-4">
                    <p class="font-semibold text-green-600 mb-2">✅ If YES: Use Existing User</p>
                    <ul class="text-sm space-y-1 text-gray-700">
                        <li>• Retrieve user from database</li>
                        <li>• Skip user creation</li>
                        <li>• Proceed to team creation</li>
                    </ul>
                </div>
                <div class="bg-white rounded-lg p-4">
                    <p class="font-semibold text-orange-600 mb-2">➕ If NO: Create New User</p>
                    <ul class="text-sm space-y-1 text-gray-700">
                        <li>• Create user account</li>
                        <li>• Set user_type: <code>team_manager</code></li>
                        <li>• Set profile_complete: <code>false</code></li>
                        <li>• Set payment_status: <code>pending</code></li>
                        <li>• Assign team_manager role</li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="notification-box mt-4">
            <p class="font-bold text-green-800 mb-2">📧 Notifications Sent:</p>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-3">
                <div class="bg-white rounded p-3">
                    <p class="font-semibold text-sm">To Team Manager:</p>
                    <code class="text-xs">UserRegisteredNotification</code>
                </div>
                <div class="bg-white rounded p-3">
                    <p class="font-semibold text-sm">To Admins:</p>
                    <code class="text-xs">UserRegisteredAdminNotification</code>
                </div>
            </div>
        </div>

        <div class="screenshot-placeholder-sm mt-4">
            <p class="text-xl text-gray-400 mb-2">📸</p>
            <p class="text-gray-600 font-mono">[screenshot-manager-form-section.png]</p>
            <p class="text-xs text-gray-500 mt-2">Team Manager information form section</p>
        </div>
    </div>

    <!-- Step 3 -->
    <div class="mb-8">
        <h4 class="text-xl font-bold mb-4 text-blue-600">Step 3: Team Creation/Selection</h4>
        
        <div class="decision-box">
            <p class="font-bold text-blue-800 mb-2">🤔 Decision Point: Does team name exist?</p>
            <div class="grid grid-cols-1 gap-4 mt-4">
                <div class="bg-white rounded-lg p-4">
                    <p class="font-semibold text-green-600 mb-2">✅ If YES: Check Tournament Registration</p>
                    <div class="ml-4 mt-3 space-y-2">
                        <div class="flex items-start">
                            <span class="text-red-500 mr-2">❌</span>
                            <div>
                                <strong>Already Registered:</strong> Show error message
                                <p class="text-sm text-gray-600">Team is already registered for this tournament</p>
                            </div>
                        </div>
                        <div class="flex items-start">
                            <span class="text-green-500 mr-2">✅</span>
                            <div>
                                <strong>Not Registered:</strong> Reuse existing team
                                <p class="text-sm text-gray-600">Proceed with team registration for tournament</p>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="bg-white rounded-lg p-4">
                    <p class="font-semibold text-orange-600 mb-2">➕ If NO: Create New Team</p>
                    <ul class="text-sm space-y-1 text-gray-700">
                        <li>• Create team record in database</li>
                        <li>• Set team name and description</li>
                        <li>• Assign manager_id</li>
                        <li>• Set status: <code>active</code></li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="notification-box mt-4">
            <p class="font-bold text-green-800 mb-2">📧 Notifications Sent:</p>
            <div class="grid grid-cols-1 md:grid-cols-3 gap-3">
                <div class="bg-white rounded p-3">
                    <p class="font-semibold text-sm">To Team Manager:</p>
                    <code class="text-xs">TeamCreatedNotification</code>
                </div>
                <div class="bg-white rounded p-3">
                    <p class="font-semibold text-sm">To Members:</p>
                    <code class="text-xs">TeamMemberWelcomeNotification</code>
                </div>
                <div class="bg-white rounded p-3">
                    <p class="font-semibold text-sm">To Admins:</p>
                    <code class="text-xs">TeamCreatedAdminNotification</code>
                </div>
            </div>
        </div>
    </div>

    <!-- Step 4 -->
    <div class="mb-8">
        <h4 class="text-xl font-bold mb-4 text-blue-600">Step 4: Tournament Registration</h4>
        
        <div class="bg-purple-50 rounded-lg p-4">
            <p class="text-gray-700 mb-4">System registers the team for the selected tournament.</p>
            
            <div class="space-y-3">
                <div class="flex items-start bg-white rounded p-3">
                    <span class="text-purple-500 mr-3">📝</span>
                    <div>
                        <strong>Action:</strong> Create tournament registration record
                        <p class="text-sm text-gray-600 mt-1">Links team to tournament with registration metadata</p>
                    </div>
                </div>
                <div class="flex items-start bg-white rounded p-3">
                    <span class="text-blue-500 mr-3">💾</span>
                    <div>
                        <strong>Store:</strong> Tournament data (method, email, phone, location, year)
                    </div>
                </div>
            </div>
        </div>

        <div class="notification-box mt-4">
            <p class="font-bold text-green-800 mb-2">📧 Notifications Sent:</p>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-3">
                <div class="bg-white rounded p-3">
                    <p class="font-semibold text-sm">To Captain & Members:</p>
                    <code class="text-xs">TeamTournamentRegisteredNotification</code>
                </div>
                <div class="bg-white rounded p-3">
                    <p class="font-semibold text-sm">To Admins:</p>
                    <code class="text-xs">TeamTournamentRegisteredAdminNotification</code>
                </div>
            </div>
        </div>
    </div>

    <!-- Step 5 -->
    <div class="mb-8">
        <h4 class="text-xl font-bold mb-4 text-blue-600">Step 5: Payment Record Creation</h4>
        
        <div class="bg-yellow-50 rounded-lg p-4">
            <p class="text-gray-700 mb-4">System creates a payment record for the tournament entry fee.</p>
            
            <div class="bg-white rounded-lg p-4 space-y-2 font-mono text-sm">
                <div class="flex justify-between">
                    <span class="text-gray-600">Amount:</span>
                    <span class="font-bold">tournament.entry_fee</span>
                </div>
                <div class="flex justify-between">
                    <span class="text-gray-600">Status:</span>
                    <span class="text-yellow-600 font-bold">pending</span>
                </div>
                <div class="flex justify-between">
                    <span class="text-gray-600">Payment Method:</span>
                    <span class="font-bold">Mpesa</span>
                </div>
                <div class="flex justify-between">
                    <span class="text-gray-600">Reference Number:</span>
                    <span class="font-bold">PAY_xxxxx</span>
                </div>
                <div class="flex justify-between">
                    <span class="text-gray-600">Currency:</span>
                    <span class="font-bold">KES</span>
                </div>
            </div>
        </div>

        <div class="notification-box mt-4">
            <p class="font-bold text-green-800 mb-2">📧 Notifications Sent (3):</p>
            <div class="grid grid-cols-1 md:grid-cols-3 gap-3">
                <div class="bg-white rounded p-3">
                    <p class="font-semibold text-sm">To Team Manager:</p>
                    <code class="text-xs">PaymentInitiatedNotification</code>
                </div>
                <div class="bg-white rounded p-3">
                    <p class="font-semibold text-sm">To Team Manager:</p>
                    <code class="text-xs">TeamPaymentInitiatedNotification</code>
                </div>
                <div class="bg-white rounded p-3">
                    <p class="font-semibold text-sm">To Admins:</p>
                    <code class="text-xs">PaymentInitiatedAdminNotification</code>
                </div>
            </div>
        </div>

        <div class="screenshot-placeholder-sm mt-4">
            <p class="text-xl text-gray-400 mb-2">📸</p>
            <p class="text-gray-600 font-mono">[screenshot-payment-pending.png]</p>
            <p class="text-xs text-gray-500 mt-2">Payment pending status in dashboard</p>
        </div>
    </div>

    <!-- Step 6 -->
    <div class="mb-8">
        <h4 class="text-xl font-bold mb-4 text-blue-600">Step 6: Players Creation (Loop)</h4>
        
        <div class="bg-green-50 rounded-lg p-4">
            <p class="text-gray-700 mb-4">
                System creates player records for all 11-23 players submitted in the form.
            </p>
            
            <div class="bg-white rounded-lg p-4">
                <p class="font-semibold mb-3">For Each Player:</p>
                <ol class="space-y-2 list-decimal list-inside text-gray-700">
                    <li>Create player record in database</li>
                    <li>Link to team and tournament</li>
                    <li>Set profile_complete to <code>false</code></li>
                    <li>Generate OTP for verification</li>
                    <li>Send 3 notifications (see below)</li>
                </ol>
            </div>
        </div>

        <div class="notification-box mt-4">
            <p class="font-bold text-green-800 mb-2">📧 Notifications Sent Per Player (3):</p>
            <div class="grid grid-cols-1 md:grid-cols-3 gap-3">
                <div class="bg-white rounded p-3">
                    <p class="font-semibold text-sm">To Player:</p>
                    <code class="text-xs">PlayerRegisteredNotification</code>
                </div>
                <div class="bg-white rounded p-3">
                    <p class="font-semibold text-sm">To Team Manager:</p>
                    <code class="text-xs">TeamPlayerAddedNotification</code>
                </div>
                <div class="bg-white rounded p-3">
                    <p class="font-semibold text-sm">To Admins:</p>
                    <code class="text-xs">PlayerRegisteredAdminNotification</code>
                </div>
            </div>
            <p class="text-sm text-green-700 mt-3">
                <strong>Note:</strong> With 15 players, this step sends 45 notifications total!
            </p>
        </div>
    </div>

    <!-- Step 7 -->
    <div class="mb-8">
        <h4 class="text-xl font-bold mb-4 text-blue-600">Step 7: Officials Creation (Loop)</h4>
        
        <div class="bg-indigo-50 rounded-lg p-4">
            <p class="text-gray-700 mb-4">
                System creates official records for Coach, Assistant Coach, Team Doctor, and Physiotherapist.
            </p>
            
            <div class="bg-white rounded-lg p-4">
                <p class="font-semibold mb-3">For Each Official:</p>
                <ol class="space-y-2 list-decimal list-inside text-gray-700">
                    <li>Create official record with role and qualifications</li>
                    <li>Link to team</li>
                    <li>Set otp_verified to <code>false</code></li>
                    <li>Generate OTP for email verification</li>
                    <li>Send 5 notifications (see below)</li>
                </ol>
            </div>
        </div>

        <div class="notification-box mt-4">
            <p class="font-bold text-green-800 mb-2">📧 Notifications Sent Per Official (5!):</p>
            <div class="grid grid-cols-2 md:grid-cols-3 gap-3">
                <div class="bg-white rounded p-3">
                    <p class="font-semibold text-sm">To Official:</p>
                    <code class="text-xs">OfficialAssignmentNotification</code>
                </div>
                <div class="bg-white rounded p-3">
                    <p class="font-semibold text-sm">To Official:</p>
                    <code class="text-xs">OfficialOtpNotification</code>
                </div>
                <div class="bg-white rounded p-3">
                    <p class="font-semibold text-sm">To Team Manager:</p>
                    <code class="text-xs">TeamOfficialAssignedNotification</code>
                </div>
                <div class="bg-white rounded p-3">
                    <p class="font-semibold text-sm">To Admins:</p>
                    <code class="text-xs">OfficialAssignedAdminNotification</code>
                </div>
                <div class="bg-white rounded p-3 md:col-span-2">
                    <p class="font-semibold text-sm">To Admins:</p>
                    <code class="text-xs">OfficialOtpGeneratedAdminNotification</code>
                </div>
            </div>
            <p class="text-sm text-green-700 mt-3">
                <strong>Note:</strong> With 4 officials, this step sends 20 notifications total!
            </p>
        </div>
    </div>

    <!-- Step 8 -->
    <div class="mb-8">
        <h4 class="text-xl font-bold mb-4 text-blue-600">Step 8: Database Commit & Login</h4>
        
        <div class="bg-cyan-50 rounded-lg p-4">
            <div class="space-y-4">
                <div class="flex items-start">
                    <span class="text-2xl mr-3">💾</span>
                    <div>
                        <p class="font-semibold text-gray-800">Commit Transaction</p>
                        <p class="text-sm text-gray-600">All records saved to database atomically. If any error occurs, complete rollback ensures data integrity.</p>
                    </div>
                </div>
                <div class="flex items-start">
                    <span class="text-2xl mr-3">🔐</span>
                    <div>
                        <p class="font-semibold text-gray-800">Auto-Login Captain</p>
                        <p class="text-sm text-gray-600">Captain is automatically logged in to their new team manager account.</p>
                    </div>
                </div>
                <div class="flex items-start">
                    <span class="text-2xl mr-3">🔄</span>
                    <div>
                        <p class="font-semibold text-gray-800">Redirect to Dashboard</p>
                        <p class="text-sm text-gray-600">User redirected to profile completion page with success message.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Step 9 -->
    <div class="mb-8">
        <h4 class="text-xl font-bold mb-4 text-blue-600">Step 9: Post-Registration State</h4>
        
        <div class="warning-box">
            <p class="font-bold text-yellow-900 mb-3">⚠️ IMPORTANT: Registration Not Complete!</p>
            <p class="text-yellow-800 mb-4">
                After submitting the registration form, the team is created but <strong>NOT ready for review</strong>. 
                The following requirements must be completed:
            </p>
            
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <div class="bg-white rounded-lg p-4">
                    <p class="font-semibold text-red-600 mb-2">❌ Blocking Requirements:</p>
                    <ul class="space-y-2 text-sm text-gray-700">
                        <li class="flex items-start">
                            <span class="text-red-500 mr-2">•</span>
                            <span><strong>Payment Status:</strong> PENDING</span>
                        </li>
                        <li class="flex items-start">
                            <span class="text-red-500 mr-2">•</span>
                            <span><strong>Player Profiles:</strong> INCOMPLETE</span>
                        </li>
                        <li class="flex items-start">
                            <span class="text-red-500 mr-2">•</span>
                            <span><strong>Officials Verified:</strong> NO</span>
                        </li>
                    </ul>
                </div>
                <div class="bg-white rounded-lg p-4">
                    <p class="font-semibold text-green-600 mb-2">✅ What's Complete:</p>
                    <ul class="space-y-2 text-sm text-gray-700">
                        <li class="flex items-start">
                            <span class="text-green-500 mr-2">•</span>
                            <span><strong>Team Created:</strong> YES</span>
                        </li>
                        <li class="flex items-start">
                            <span class="text-green-500 mr-2">•</span>
                            <span><strong>Tournament Registered:</strong> YES</span>
                        </li>
                        <li class="flex items-start">
                            <span class="text-green-500 mr-2">•</span>
                            <span><strong>Players Added:</strong> YES</span>
                        </li>
                        <li class="flex items-start">
                            <span class="text-green-500 mr-2">•</span>
                            <span><strong>Officials Added:</strong> YES</span>
                        </li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="screenshot-placeholder mt-4">
            <p class="text-2xl text-gray-400 mb-2">📸</p>
            <p class="text-gray-600 font-mono text-lg">[screenshot-dashboard-alerts.png]</p>
            <p class="text-sm text-gray-500 mt-2">Dashboard showing TeamRegistrationAlert with pending requirements</p>
        </div>
    </div>
</div>

<!-- Section 5: Notification Summary -->
<div class="section-card" id="notifications">
    <h3 class="text-2xl font-bold mb-4 flex items-center">
        <span class="step-number">5</span>
        Complete Notification Matrix
    </h3>
    
    <div class="bg-blue-50 border-l-4 border-blue-500 p-4 rounded-r-lg mb-6">
        <p class="text-blue-900">
            <strong>📧 Total Notifications:</strong> For a typical registration with 15 players and 4 officials, approximately <strong>75 notifications</strong> are sent!
        </p>
    </div>

    <div class="overflow-x-auto">
        <table class="w-full bg-white rounded-lg shadow">
            <thead class="bg-gray-100">
                <tr>
                    <th class="px-4 py-3 text-left font-semibold">Event</th>
                    <th class="px-4 py-3 text-left font-semibold">Recipient</th>
                    <th class="px-4 py-3 text-left font-semibold">Notification</th>
                    <th class="px-4 py-3 text-center font-semibold">Count</th>
                    <th class="px-4 py-3 text-center font-semibold">Priority</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-gray-200">
                <tr class="hover:bg-gray-50">
                    <td class="px-4 py-3">User Created</td>
                    <td class="px-4 py-3">Captain</td>
                    <td class="px-4 py-3"><code class="text-xs">UserRegisteredNotification</code></td>
                    <td class="px-4 py-3 text-center">1</td>
                    <td class="px-4 py-3 text-center"><span class="bg-blue-100 px-2 py-1 rounded text-xs">Default</span></td>
                </tr>
                <tr class="hover:bg-gray-50">
                    <td class="px-4 py-3">User Created</td>
                    <td class="px-4 py-3">Admins</td>
                    <td class="px-4 py-3"><code class="text-xs">UserRegisteredAdminNotification</code></td>
                    <td class="px-4 py-3 text-center">1</td>
                    <td class="px-4 py-3 text-center"><span class="bg-blue-100 px-2 py-1 rounded text-xs">Default</span></td>
                </tr>
                <tr class="hover:bg-gray-50">
                    <td class="px-4 py-3">Team Created</td>
                    <td class="px-4 py-3">Captain</td>
                    <td class="px-4 py-3"><code class="text-xs">TeamCreatedNotification</code></td>
                    <td class="px-4 py-3 text-center">1</td>
                    <td class="px-4 py-3 text-center"><span class="bg-blue-100 px-2 py-1 rounded text-xs">Default</span></td>
                </tr>
                <tr class="hover:bg-gray-50">
                    <td class="px-4 py-3">Team Created</td>
                    <td class="px-4 py-3">Members</td>
                    <td class="px-4 py-3"><code class="text-xs">TeamMemberWelcomeNotification</code></td>
                    <td class="px-4 py-3 text-center">1</td>
                    <td class="px-4 py-3 text-center"><span class="bg-blue-100 px-2 py-1 rounded text-xs">Default</span></td>
                </tr>
                <tr class="hover:bg-gray-50">
                    <td class="px-4 py-3">Team Created</td>
                    <td class="px-4 py-3">Admins</td>
                    <td class="px-4 py-3"><code class="text-xs">TeamCreatedAdminNotification</code></td>
                    <td class="px-4 py-3 text-center">1</td>
                    <td class="px-4 py-3 text-center"><span class="bg-blue-100 px-2 py-1 rounded text-xs">Default</span></td>
                </tr>
                <tr class="hover:bg-gray-50">
                    <td class="px-4 py-3">Tournament Registered</td>
                    <td class="px-4 py-3">Captain & Members</td>
                    <td class="px-4 py-3"><code class="text-xs">TeamTournamentRegisteredNotification</code></td>
                    <td class="px-4 py-3 text-center">1</td>
                    <td class="px-4 py-3 text-center"><span class="bg-blue-100 px-2 py-1 rounded text-xs">Default</span></td>
                </tr>
                <tr class="hover:bg-gray-50">
                    <td class="px-4 py-3">Tournament Registered</td>
                    <td class="px-4 py-3">Admins</td>
                    <td class="px-4 py-3"><code class="text-xs">TeamTournamentRegisteredAdminNotification</code></td>
                    <td class="px-4 py-3 text-center">1</td>
                    <td class="px-4 py-3 text-center"><span class="bg-blue-100 px-2 py-1 rounded text-xs">Default</span></td>
                </tr>
                <tr class="hover:bg-gray-50">
                    <td class="px-4 py-3">Payment Initiated</td>
                    <td class="px-4 py-3">Captain</td>
                    <td class="px-4 py-3"><code class="text-xs">PaymentInitiatedNotification</code></td>
                    <td class="px-4 py-3 text-center">1</td>
                    <td class="px-4 py-3 text-center"><span class="bg-yellow-100 px-2 py-1 rounded text-xs">High</span></td>
                </tr>
                <tr class="hover:bg-gray-50">
                    <td class="px-4 py-3">Payment Initiated</td>
                    <td class="px-4 py-3">Team Manager</td>
                    <td class="px-4 py-3"><code class="text-xs">TeamPaymentInitiatedNotification</code></td>
                    <td class="px-4 py-3 text-center">1</td>
                    <td class="px-4 py-3 text-center"><span class="bg-yellow-100 px-2 py-1 rounded text-xs">High</span></td>
                </tr>
                <tr class="hover:bg-gray-50">
                    <td class="px-4 py-3">Payment Initiated</td>
                    <td class="px-4 py-3">Admins</td>
                    <td class="px-4 py-3"><code class="text-xs">PaymentInitiatedAdminNotification</code></td>
                    <td class="px-4 py-3 text-center">1</td>
                    <td class="px-4 py-3 text-center"><span class="bg-yellow-100 px-2 py-1 rounded text-xs">High</span></td>
                </tr>
                <tr class="hover:bg-gray-50 bg-green-50">
                    <td class="px-4 py-3">Player Created</td>
                    <td class="px-4 py-3">Each Player</td>
                    <td class="px-4 py-3"><code class="text-xs">PlayerRegisteredNotification</code></td>
                    <td class="px-4 py-3 text-center font-bold">15</td>
                    <td class="px-4 py-3 text-center"><span class="bg-blue-100 px-2 py-1 rounded text-xs">Default</span></td>
                </tr>
                <tr class="hover:bg-gray-50 bg-green-50">
                    <td class="px-4 py-3">Player Created</td>
                    <td class="px-4 py-3">Captain</td>
                    <td class="px-4 py-3"><code class="text-xs">TeamPlayerAddedNotification</code></td>
                    <td class="px-4 py-3 text-center font-bold">15</td>
                    <td class="px-4 py-3 text-center"><span class="bg-blue-100 px-2 py-1 rounded text-xs">Default</span></td>
                </tr>
                <tr class="hover:bg-gray-50 bg-green-50">
                    <td class="px-4 py-3">Player Created</td>
                    <td class="px-4 py-3">Admins</td>
                    <td class="px-4 py-3"><code class="text-xs">PlayerRegisteredAdminNotification</code></td>
                    <td class="px-4 py-3 text-center font-bold">15</td>
                    <td class="px-4 py-3 text-center"><span class="bg-blue-100 px-2 py-1 rounded text-xs">Default</span></td>
                </tr>
                <tr class="hover:bg-gray-50 bg-purple-50">
                    <td class="px-4 py-3">Official Created</td>
                    <td class="px-4 py-3">Each Official</td>
                    <td class="px-4 py-3"><code class="text-xs">OfficialAssignmentNotification</code></td>
                    <td class="px-4 py-3 text-center font-bold">4</td>
                    <td class="px-4 py-3 text-center"><span class="bg-blue-100 px-2 py-1 rounded text-xs">Default</span></td>
                </tr>
                <tr class="hover:bg-gray-50 bg-purple-50">
                    <td class="px-4 py-3">Official OTP</td>
                    <td class="px-4 py-3">Each Official</td>
                    <td class="px-4 py-3"><code class="text-xs">OfficialOtpNotification</code></td>
                    <td class="px-4 py-3 text-center font-bold">4</td>
                    <td class="px-4 py-3 text-center"><span class="bg-yellow-100 px-2 py-1 rounded text-xs">High</span></td>
                </tr>
                <tr class="hover:bg-gray-50 bg-purple-50">
                    <td class="px-4 py-3">Official Created</td>
                    <td class="px-4 py-3">Captain</td>
                    <td class="px-4 py-3"><code class="text-xs">TeamOfficialAssignedNotification</code></td>
                    <td class="px-4 py-3 text-center font-bold">4</td>
                    <td class="px-4 py-3 text-center"><span class="bg-blue-100 px-2 py-1 rounded text-xs">Default</span></td>
                </tr>
                <tr class="hover:bg-gray-50 bg-purple-50">
                    <td class="px-4 py-3">Official Created</td>
                    <td class="px-4 py-3">Admins</td>
                    <td class="px-4 py-3"><code class="text-xs">OfficialAssignedAdminNotification</code></td>
                    <td class="px-4 py-3 text-center font-bold">4</td>
                    <td class="px-4 py-3 text-center"><span class="bg-blue-100 px-2 py-1 rounded text-xs">Default</span></td>
                </tr>
                <tr class="hover:bg-gray-50 bg-purple-50">
                    <td class="px-4 py-3">Official OTP</td>
                    <td class="px-4 py-3">Admins</td>
                    <td class="px-4 py-3"><code class="text-xs">OfficialOtpGeneratedAdminNotification</code></td>
                    <td class="px-4 py-3 text-center font-bold">4</td>
                    <td class="px-4 py-3 text-center"><span class="bg-yellow-100 px-2 py-1 rounded text-xs">High</span></td>
                </tr>
            </tbody>
            <tfoot class="bg-gray-100 font-bold">
                <tr>
                    <td colspan="3" class="px-4 py-3 text-right">TOTAL NOTIFICATIONS:</td>
                    <td class="px-4 py-3 text-center text-lg text-blue-600">~75</td>
                    <td class="px-4 py-3"></td>
                </tr>
            </tfoot>
        </table>
    </div>
</div>

<!-- Section 6: Post-Registration Requirements -->
<div class="section-card" id="post-registration">
    <h3 class="text-2xl font-bold mb-4 flex items-center">
        <span class="step-number">6</span>
        Post-Registration Requirements
    </h3>
    
    <div class="warning-box mb-6">
        <p class="font-bold text-yellow-900 text-lg mb-2">🚫 TEAM REVIEW BLOCKED</p>
        <p class="text-yellow-800">
            The team registration will <strong>NOT be reviewed</strong> by tournament organizers until all requirements below are complete.
        </p>
    </div>

    <!-- Payment Completion -->
    <div class="mb-8">
        <h4 class="text-xl font-bold mb-4 text-green-600">💳 Payment Completion Flow</h4>
        
        <div class="mermaid bg-white p-6 rounded-lg shadow-inner">
graph LR
    A[Payment Status: PENDING] --> B{Manager Takes Action}
    B --> C[Navigate to Payments Page]
    C --> D[Select Pending Payment]
    D --> E[Initiate M-Pesa Payment]
    E --> F{Payment Successful?}
    F -->|Yes| G[Status: COMPLETED]
    F -->|No| H[Status: FAILED]
    H --> I[Show Retry Option]
    I --> E
    G --> J[📧 Send Notifications]
    J --> K[Update Team Status]
    
    style A fill:#FFC107,stroke:#FF6F00,color:#000
    style G fill:#4CAF50,stroke:#2E7D32,color:#fff
    style H fill:#f44336,stroke:#c62828,color:#fff
        </div>

        <div class="notification-box mt-4">
            <p class="font-bold text-green-800 mb-2">📧 Notifications on Payment Completion:</p>
            <div class="grid grid-cols-1 md:grid-cols-3 gap-3">
                <div class="bg-white rounded p-3">
                    <p class="font-semibold text-sm">To User:</p>
                    <code class="text-xs">PaymentCompletedNotification</code>
                </div>
                <div class="bg-white rounded p-3">
                    <p class="font-semibold text-sm">To Manager:</p>
                    <code class="text-xs">TeamPaymentCompletedNotification</code>
                </div>
                <div class="bg-white rounded p-3">
                    <p class="font-semibold text-sm">To Admins:</p>
                    <code class="text-xs">PaymentCompletedAdminNotification</code>
                </div>
            </div>
        </div>

        <div class="screenshot-placeholder-sm mt-4">
            <p class="text-xl text-gray-400 mb-2">📸</p>
            <p class="text-gray-600 font-mono">[screenshot-payment-page.png]</p>
            <p class="text-xs text-gray-500 mt-2">Payment completion interface</p>
        </div>
    </div>

    <!-- Player Profile Completion -->
    <div class="mb-8">
        <h4 class="text-xl font-bold mb-4 text-purple-600">⚽ Player Profile Completion Flow</h4>
        
        <div class="bg-purple-50 rounded-lg p-4 mb-4">
            <p class="text-purple-900 font-semibold mb-3">Required Player Information:</p>
            <div class="grid grid-cols-2 md:grid-cols-3 gap-3">
                <div class="bg-white rounded p-3 flex items-center">
                    <span class="text-green-500 mr-2">✓</span>
                    <span class="text-sm">Full Name</span>
                </div>
                <div class="bg-white rounded p-3 flex items-center">
                    <span class="text-green-500 mr-2">✓</span>
                    <span class="text-sm">Phone Number</span>
                </div>
                <div class="bg-white rounded p-3 flex items-center">
                    <span class="text-green-500 mr-2">✓</span>
                    <span class="text-sm">Date of Birth</span>
                </div>
                <div class="bg-white rounded p-3 flex items-center">
                    <span class="text-green-500 mr-2">✓</span>
                    <span class="text-sm">Gender</span>
                </div>
                <div class="bg-white rounded p-3 flex items-center">
                    <span class="text-green-500 mr-2">✓</span>
                    <span class="text-sm">Playing Position</span>
                </div>
                <div class="bg-white rounded p-3 flex items-center">
                    <span class="text-green-500 mr-2">✓</span>
                    <span class="text-sm">ID Number</span>
                </div>
                <div class="bg-white rounded p-3 flex items-center md:col-span-2">
                    <span class="text-green-500 mr-2">✓</span>
                    <span class="text-sm">ID Photo (Front & Back)</span>
                </div>
            </div>
        </div>

        <div class="notification-box">
            <p class="font-bold text-green-800 mb-2">📧 Notifications on Profile Completion:</p>
            <div class="grid grid-cols-1 md:grid-cols-3 gap-3">
                <div class="bg-white rounded p-3">
                    <p class="font-semibold text-sm">To Player:</p>
                    <code class="text-xs">PlayerVerificationUpdatedNotification</code>
                </div>
                <div class="bg-white rounded p-3">
                    <p class="font-semibold text-sm">To Player:</p>
                    <code class="text-xs">PlayerDigitalIdGeneratedNotification</code>
                    <p class="text-xs text-gray-600 mt-1">(with PDF attachment)</p>
                </div>
                <div class="bg-white rounded p-3">
                    <p class="font-semibold text-sm">To Admins:</p>
                    <code class="text-xs">PlayerDigitalIdGeneratedAdminNotification</code>
                </div>
            </div>
        </div>

        <div class="screenshot-placeholder-sm mt-4">
            <p class="text-xl text-gray-400 mb-2">📸</p>
            <p class="text-gray-600 font-mono">[screenshot-player-profile.png]</p>
            <p class="text-xs text-gray-500 mt-2">Player profile completion form</p>
        </div>
    </div>

    <!-- Official Verification -->
    <div class="mb-8">
        <h4 class="text-xl font-bold mb-4 text-indigo-600">👔 Official Email Verification Flow</h4>
        
        <div class="mermaid bg-white p-6 rounded-lg shadow-inner">
graph LR
    A[Official Receives OTP Email] --> B[Opens Email]
    B --> C[Clicks Verification Link<br/>or Enters OTP]
    C --> D{OTP Valid?}
    D -->|Yes| E[Status: VERIFIED]
    D -->|No| F[Show Error]
    F --> G[Request New OTP]
    G --> A
    E --> H[📧 Send Notifications]
    
    style A fill:#E3F2FD,stroke:#1976D2
    style E fill:#4CAF50,stroke:#2E7D32,color:#fff
    style F fill:#f44336,stroke:#c62828,color:#fff
        </div>

        <div class="notification-box mt-4">
            <p class="font-bold text-green-800 mb-2">📧 Notifications on Official Verification:</p>
            <div class="grid grid-cols-1 md:grid-cols-3 gap-3">
                <div class="bg-white rounded p-3">
                    <p class="font-semibold text-sm">To Official:</p>
                    <code class="text-xs">OfficialVerifiedNotification</code>
                </div>
                <div class="bg-white rounded p-3">
                    <p class="font-semibold text-sm">To Team Manager:</p>
                    <code class="text-xs">TeamOfficialVerifiedNotification</code>
                </div>
                <div class="bg-white rounded p-3">
                    <p class="font-semibold text-sm">To Admins:</p>
                    <code class="text-xs">OfficialVerificationUpdatedAdminNotification</code>
                </div>
            </div>
        </div>
    </div>

    <!-- Ready for Review -->
    <div class="bg-green-100 border-2 border-green-500 rounded-lg p-6">
        <h4 class="text-xl font-bold text-green-800 mb-3 flex items-center">
            <span class="text-3xl mr-3">✅</span>
            Team Ready for Review
        </h4>
        <p class="text-green-800 mb-4">
            Once all requirements are met, the team is ready for admin/organizer review and approval:
        </p>
        <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
            <div class="bg-white rounded-lg p-4">
                <p class="font-semibold text-green-600 mb-2">✓ Payment Complete</p>
                <p class="text-sm text-gray-600">All tournament fees paid</p>
            </div>
            <div class="bg-white rounded-lg p-4">
                <p class="font-semibold text-green-600 mb-2">✓ Players Complete</p>
                <p class="text-sm text-gray-600">All 11+ players with 100% profiles</p>
            </div>
            <div class="bg-white rounded-lg p-4">
                <p class="font-semibold text-green-600 mb-2">✓ Officials Verified</p>
                <p class="text-sm text-gray-600">All officials email verified</p>
            </div>
        </div>
    </div>
</div>

<!-- Section 7: Screenshots Gallery -->
<div class="section-card" id="screenshots">
    <h3 class="text-2xl font-bold mb-4 flex items-center">
        <span class="step-number">7</span>
        UI Screenshots & Mockups
    </h3>
    
    <div class="bg-blue-50 border-l-4 border-blue-500 p-4 rounded-r-lg mb-6">
        <p class="text-blue-900">
            <strong>📸 Note:</strong> Replace these placeholders with actual screenshots of your system.
            Recommended resolution: 1920x1080px or 1200x900px.
        </p>
    </div>

    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
        <div>
            <h4 class="font-bold mb-3">Registration Form</h4>
            <div class="screenshot-placeholder">
                <p class="text-3xl text-gray-400 mb-2">📸</p>
                <p class="text-gray-600 font-mono text-lg">[screenshot-registration-form.png]</p>
                <p class="text-sm text-gray-500 mt-2">Full registration form view</p>
            </div>
        </div>

        <div>
            <h4 class="font-bold mb-3">Dashboard with Alerts</h4>
            <div class="screenshot-placeholder">
                <p class="text-3xl text-gray-400 mb-2">📸</p>
                <p class="text-gray-600 font-mono text-lg">[screenshot-dashboard-alerts.png]</p>
                <p class="text-sm text-gray-500 mt-2">Team manager dashboard showing alerts</p>
            </div>
        </div>

        <div>
            <h4 class="font-bold mb-3">Payment Processing</h4>
            <div class="screenshot-placeholder">
                <p class="text-3xl text-gray-400 mb-2">📸</p>
                <p class="text-gray-600 font-mono text-lg">[screenshot-payment-page.png]</p>
                <p class="text-sm text-gray-500 mt-2">Payment interface with M-Pesa integration</p>
            </div>
        </div>

        <div>
            <h4 class="font-bold mb-3">Player Profile Form</h4>
            <div class="screenshot-placeholder">
                <p class="text-3xl text-gray-400 mb-2">📸</p>
                <p class="text-gray-600 font-mono text-lg">[screenshot-player-profile.png]</p>
                <p class="text-sm text-gray-500 mt-2">Player profile completion interface</p>
            </div>
        </div>
    </div>
</div>

<!-- Section 8: Team Approval Process -->
<div class="section-card" id="approval-process">
    <h3 class="text-2xl font-bold mb-4 flex items-center">
        <span class="step-number">8</span>
        Team Approval Process
    </h3>
    
    <div class="bg-blue-50 border-l-4 border-blue-500 p-4 rounded-r-lg mb-6">
        <p class="text-blue-900">
            <strong>🔐 Two-Tier Approval System:</strong> Teams must be approved before they can participate in tournaments. 
            The system supports optional two-tier approval (first approver + second approver) or single admin approval.
        </p>
    </div>

    <!-- Approval Flow Diagram -->
    <div class="mermaid bg-white p-6 rounded-lg shadow-inner">
flowchart TD
    Start([✅ Team Requirements Complete:<br/>• Payment: COMPLETED<br/>• All Players: 100% profiles<br/>• Officials: Verified])
    Start --> SubmitApproval[Team Submitted<br/>for Approval<br/>approval_status: pending]
    
    SubmitApproval --> CheckTwoTier{Tournament Has<br/>Two-Tier Approval<br/>Enabled?}
    
    %% Single Tier Path (Admin Only)
    CheckTwoTier -->|No| AdminReview[Admin/Organizer Reviews Team<br/>• Check player profiles<br/>• Verify documents<br/>• Review payment]
    
    AdminReview --> AdminDecision{Admin<br/>Decision?}
    AdminDecision -->|Approve| AdminApproves[Admin Approves<br/>• approval_status: approved<br/>• approved_at timestamp<br/>• approved_by: admin_id]
    AdminDecision -->|Reject| AdminRejects[Admin Rejects<br/>• approval_status: rejected<br/>• rejection_reason recorded<br/>• rejected_by: admin_id]
    
    %% Two-Tier Path
    CheckTwoTier -->|Yes| FirstReview[First Approver Reviews Team<br/>• Designated first_approver_id<br/>• Reviews documentation]
    
    FirstReview --> FirstDecision{First Approver<br/>Decision?}
    FirstDecision -->|Reject| FirstRejects[First Approver Rejects<br/>• approval_status: rejected<br/>• rejection_reason recorded<br/>• rejected_by: first_approver_id]
    
    FirstDecision -->|Approve| FirstApproves[First Approver Approves<br/>• first_approved_by: approver_id<br/>• first_approved_at timestamp<br/>• approval_status: first_approved]
    
    FirstApproves --> NotifyFirstApproval[📧 Send Notifications:<br/>• Team notified of first approval<br/>• Second approver notified to review]
    
    NotifyFirstApproval --> SecondReview[Second Approver Reviews Team<br/>• Designated second_approver_id<br/>• Final verification]
    
    SecondReview --> SecondDecision{Second Approver<br/>Decision?}
    SecondDecision -->|Reject| SecondRejects[Second Approver Rejects<br/>• approval_status: rejected<br/>• rejection_reason recorded<br/>• rejected_by: second_approver_id]
    
    SecondDecision -->|Approve| SecondApproves[Second Approver Approves<br/>• second_approved_by: approver_id<br/>• second_approved_at timestamp<br/>• approval_status: approved]
    
    %% Admin Bypass Option
    SubmitApproval -.->|Admin Bypass| AdminBypass[Admin Can Approve Anytime<br/>Regardless of tier status<br/>• Overrides approval process]
    FirstApproves -.->|Admin Bypass| AdminBypass
    AdminBypass --> AdminDirectApprove[Admin Approval<br/>• approval_status: approved<br/>• Bypasses remaining tiers]
    AdminDirectApprove --> FinalApproved
    
    %% Final States
    AdminApproves --> FinalApproved[✅ Team Fully Approved<br/>• Can participate in tournament<br/>• Access to all features<br/>• Listed in tournament roster]
    SecondApproves --> FinalApproved
    
    AdminRejects --> Rejected[❌ Team Rejected<br/>• Cannot participate<br/>• Reason provided to manager<br/>• Can fix issues and resubmit]
    FirstRejects --> Rejected
    SecondRejects --> Rejected
    
    FinalApproved --> NotifyApproved[📧 Send Notifications:<br/>• TeamApprovedNotification to manager<br/>• TeamApprovedMemberNotification to players<br/>• TeamApprovedAdminNotification]
    
    Rejected --> NotifyRejected[📧 Send Notifications:<br/>• TeamRejectedNotification to manager<br/>• Include rejection reason<br/>• TeamRejectedAdminNotification]
    
    NotifyRejected --> Resubmit{Team Manager<br/>Fixes Issues?}
    Resubmit -->|Yes| SubmitApproval
    Resubmit -->|No| EndRejected([Team Cannot Participate])
    
    NotifyApproved --> End([Team Can Participate])
    
    style Start fill:#4CAF50,stroke:#2E7D32,color:#fff
    style SubmitApproval fill:#FFC107,stroke:#F57C00,color:#000
    style FirstApproves fill:#2196F3,stroke:#1565C0,color:#fff
    style SecondApproves fill:#9C27B0,stroke:#6A1B9A,color:#fff
    style AdminApproves fill:#00BCD4,stroke:#00838F,color:#fff
    style AdminBypass fill:#FF9800,stroke:#F57C00,color:#fff
    style FinalApproved fill:#4CAF50,stroke:#2E7D32,color:#fff
    style Rejected fill:#f44336,stroke:#c62828,color:#fff
    style End fill:#4CAF50,stroke:#2E7D32,color:#fff
    style EndRejected fill:#f44336,stroke:#c62828,color:#fff
    </div>

    <!-- Approval Status Table -->
    <div class="mt-6 overflow-x-auto">
        <table class="w-full bg-white rounded-lg shadow">
            <thead class="bg-gray-100">
                <tr>
                    <th class="px-4 py-3 text-left font-semibold">Approval Status</th>
                    <th class="px-4 py-3 text-left font-semibold">Description</th>
                    <th class="px-4 py-3 text-left font-semibold">Next Step</th>
                    <th class="px-4 py-3 text-left font-semibold">Can Participate?</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-gray-200">
                <tr class="hover:bg-gray-50">
                    <td class="px-4 py-3">
                        <span class="bg-yellow-100 px-3 py-1 rounded font-semibold">PENDING</span>
                    </td>
                    <td class="px-4 py-3">Team submitted, awaiting first approval</td>
                    <td class="px-4 py-3 text-sm">First approver or admin reviews</td>
                    <td class="px-4 py-3 text-center">❌ No</td>
                </tr>
                <tr class="hover:bg-gray-50">
                    <td class="px-4 py-3">
                        <span class="bg-blue-100 px-3 py-1 rounded font-semibold">FIRST_APPROVED</span>
                    </td>
                    <td class="px-4 py-3">First approver approved, awaiting second approval</td>
                    <td class="px-4 py-3 text-sm">Second approver reviews</td>
                    <td class="px-4 py-3 text-center">❌ No</td>
                </tr>
                <tr class="hover:bg-gray-50">
                    <td class="px-4 py-3">
                        <span class="bg-purple-100 px-3 py-1 rounded font-semibold">UNDER_REVIEW</span>
                    </td>
                    <td class="px-4 py-3">Currently being reviewed by an approver</td>
                    <td class="px-4 py-3 text-sm">Wait for approver decision</td>
                    <td class="px-4 py-3 text-center">❌ No</td>
                </tr>
                <tr class="hover:bg-gray-50">
                    <td class="px-4 py-3">
                        <span class="bg-green-100 px-3 py-1 rounded font-semibold">APPROVED</span>
                    </td>
                    <td class="px-4 py-3">Fully approved (both tiers or admin approved)</td>
                    <td class="px-4 py-3 text-sm">Team can participate</td>
                    <td class="px-4 py-3 text-center">✅ Yes</td>
                </tr>
                <tr class="hover:bg-gray-50">
                    <td class="px-4 py-3">
                        <span class="bg-red-100 px-3 py-1 rounded font-semibold">REJECTED</span>
                    </td>
                    <td class="px-4 py-3">Rejected by an approver with reason</td>
                    <td class="px-4 py-3 text-sm">Fix issues and resubmit</td>
                    <td class="px-4 py-3 text-center">❌ No</td>
                </tr>
            </tbody>
        </table>
    </div>

    <!-- Approval Scenarios -->
    <div class="mt-6 grid grid-cols-1 md:grid-cols-3 gap-4">
        <div class="bg-blue-50 rounded-lg p-4 border-2 border-blue-300">
            <h4 class="font-bold text-blue-700 mb-3">📋 Single-Tier Approval</h4>
            <div class="space-y-2 text-sm text-gray-700">
                <div class="bg-white rounded p-2">
                    <strong>When:</strong> Two-tier disabled
                </div>
                <div class="bg-white rounded p-2">
                    <strong>Who:</strong> Admin/Organizer only
                </div>
                <div class="bg-white rounded p-2">
                    <strong>Steps:</strong> 1 approval needed
                </div>
                <div class="bg-white rounded p-2">
                    <strong>Timeline:</strong> Faster (1-2 days)
                </div>
            </div>
        </div>

        <div class="bg-purple-50 rounded-lg p-4 border-2 border-purple-300">
            <h4 class="font-bold text-purple-700 mb-3">📋📋 Two-Tier Approval</h4>
            <div class="space-y-2 text-sm text-gray-700">
                <div class="bg-white rounded p-2">
                    <strong>When:</strong> Two-tier enabled
                </div>
                <div class="bg-white rounded p-2">
                    <strong>Who:</strong> First approver → Second approver
                </div>
                <div class="bg-white rounded p-2">
                    <strong>Steps:</strong> 2 approvals needed
                </div>
                <div class="bg-white rounded p-2">
                    <strong>Timeline:</strong> Longer (2-4 days)
                </div>
            </div>
        </div>

        <div class="bg-orange-50 rounded-lg p-4 border-2 border-orange-300">
            <h4 class="font-bold text-orange-700 mb-3">⚡ Admin Bypass</h4>
            <div class="space-y-2 text-sm text-gray-700">
                <div class="bg-white rounded p-2">
                    <strong>When:</strong> Any time
                </div>
                <div class="bg-white rounded p-2">
                    <strong>Who:</strong> Admin/Super Admin only
                </div>
                <div class="bg-white rounded p-2">
                    <strong>Steps:</strong> Direct approval
                </div>
                <div class="bg-white rounded p-2">
                    <strong>Timeline:</strong> Instant
                </div>
            </div>
        </div>
    </div>

    <!-- Approval Notifications -->
    <div class="mt-6 notification-box">
        <p class="font-bold text-green-800 mb-3">📧 Approval Notifications:</p>
        <div class="overflow-x-auto">
            <table class="w-full bg-white rounded-lg">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-3 py-2 text-left text-sm font-semibold">Event</th>
                        <th class="px-3 py-2 text-left text-sm font-semibold">Recipient</th>
                        <th class="px-3 py-2 text-left text-sm font-semibold">Notification</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-100">
                    <tr>
                        <td class="px-3 py-2 text-sm">First Approval</td>
                        <td class="px-3 py-2 text-sm">Team Manager</td>
                        <td class="px-3 py-2 text-xs"><code>TeamFirstApprovedNotification</code></td>
                    </tr>
                    <tr>
                        <td class="px-3 py-2 text-sm">First Approval</td>
                        <td class="px-3 py-2 text-sm">Second Approver</td>
                        <td class="px-3 py-2 text-xs"><code>TeamAwaitingSecondApprovalNotification</code></td>
                    </tr>
                    <tr>
                        <td class="px-3 py-2 text-sm">Second Approval</td>
                        <td class="px-3 py-2 text-sm">Team Manager & Members</td>
                        <td class="px-3 py-2 text-xs"><code>TeamApprovedNotification</code></td>
                    </tr>
                    <tr>
                        <td class="px-3 py-2 text-sm">Admin Approval</td>
                        <td class="px-3 py-2 text-sm">Team Manager & Members</td>
                        <td class="px-3 py-2 text-xs"><code>TeamApprovedNotification</code></td>
                    </tr>
                    <tr>
                        <td class="px-3 py-2 text-sm">Rejection</td>
                        <td class="px-3 py-2 text-sm">Team Manager</td>
                        <td class="px-3 py-2 text-xs"><code>TeamRejectedNotification</code></td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Screenshot Placeholders -->
    <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mt-6">
        <div class="screenshot-placeholder-sm">
            <p class="text-xl text-gray-400 mb-2">📸</p>
            <p class="text-gray-600 font-mono">[screenshot-team-approval-interface.png]</p>
            <p class="text-xs text-gray-500 mt-2">Team approval interface for approvers</p>
        </div>
        <div class="screenshot-placeholder-sm">
            <p class="text-xl text-gray-400 mb-2">📸</p>
            <p class="text-gray-600 font-mono">[screenshot-team-approval-status.png]</p>
            <p class="text-xs text-gray-500 mt-2">Team approval status in manager dashboard</p>
        </div>
    </div>

    <!-- Important Notes -->
    <div class="mt-6 warning-box">
        <p class="font-bold text-yellow-900 mb-2">⚠️ Important Notes:</p>
        <ul class="space-y-2 text-yellow-800">
            <li class="flex items-start">
                <span class="text-yellow-600 mr-2">•</span>
                <span><strong>Admin Bypass:</strong> Admins and super admins can approve teams at any stage, skipping the two-tier process</span>
            </li>
            <li class="flex items-start">
                <span class="text-yellow-600 mr-2">•</span>
                <span><strong>Rejection:</strong> Any approver can reject. Team manager receives reason and can fix issues to resubmit</span>
            </li>
            <li class="flex items-start">
                <span class="text-yellow-600 mr-2">•</span>
                <span><strong>Requirements:</strong> Payment and player profiles must be 100% complete before approval process begins</span>
            </li>
            <li class="flex items-start">
                <span class="text-yellow-600 mr-2">•</span>
                <span><strong>Configuration:</strong> Tournament organizers enable/disable two-tier approval per tournament</span>
            </li>
        </ul>
    </div>
</div>

<!-- Summary Card -->
<div class="section-card bg-gradient-to-r from-blue-50 to-purple-50">
    <h3 class="text-2xl font-bold mb-4">📚 Quick Reference Summary</h3>
    
    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
        <div class="bg-white rounded-lg p-4 shadow">
            <p class="text-3xl font-bold text-blue-600 mb-2">10</p>
            <p class="text-gray-700">Main Steps</p>
        </div>
        <div class="bg-white rounded-lg p-4 shadow">
            <p class="text-3xl font-bold text-green-600 mb-2">~75</p>
            <p class="text-gray-700">Notifications Sent</p>
        </div>
        <div class="bg-white rounded-lg p-4 shadow">
            <p class="text-3xl font-bold text-purple-600 mb-2">5</p>
            <p class="text-gray-700">Approval Statuses</p>
        </div>
    </div>

    <div class="mt-6 p-4 bg-white rounded-lg">
        <p class="font-semibold text-gray-800 mb-2">🎯 Key Takeaways:</p>
        <ul class="space-y-2 text-gray-700">
            <li class="flex items-start">
                <span class="text-green-500 mr-2">•</span>
                <span>Registration creates team, adds players/officials, but requires post-registration completion</span>
            </li>
            <li class="flex items-start">
                <span class="text-blue-500 mr-2">•</span>
                <span>Multiple decision points check for existing users/teams to prevent duplicates</span>
            </li>
            <li class="flex items-start">
                <span class="text-purple-500 mr-2">•</span>
                <span>Comprehensive notification system keeps all stakeholders informed</span>
            </li>
            <li class="flex items-start">
                <span class="text-orange-500 mr-2">•</span>
                <span>Team not ready for review until payment + profiles + verification complete</span>
            </li>
        </ul>
    </div>
</div>

<?php /**PATH D:\E - STARTUPS\WORK FOLDERS\PERSONAL\the-milimus-tournament\resources\views\documentation\partials\team-registration.blade.php ENDPATH**/ ?>