<?php

use Illuminate\Support\Facades\Route;
use Inertia\Inertia;
use App\Http\Controllers\Admin\TournamentAdminController;
use App\Http\Controllers\Admin\PlayerAdminController;
use App\Http\Controllers\Admin\TeamAdminController;
use App\Http\Controllers\Admin\BracketAdminController;
use App\Http\Controllers\Admin\MatchAdminController;
use App\Http\Controllers\Admin\RoleAdminController;
use App\Http\Controllers\Admin\UserAdminController;
use App\Http\Controllers\Admin\PaymentAdminController;
use App\Http\Controllers\Admin\PermissionAdminController;
use App\Http\Controllers\MediaController;
use App\Http\Controllers\SystemMaintenanceController;

// Frontend public routes
Route::get('/', [App\Http\Controllers\Frontend\HomeController::class, 'index'])->name('home');
Route::get('/about', [App\Http\Controllers\Frontend\HomeController::class, 'about'])->name('about');
Route::get('/founder', [App\Http\Controllers\Frontend\HomeController::class, 'founder'])->name('founder');
Route::get('/fixtures', [App\Http\Controllers\Frontend\HomeController::class, 'fixtures'])->name('fixtures');
Route::get('/contact', [App\Http\Controllers\Frontend\HomeController::class, 'contact'])->name('contact');
Route::post('/contact', [App\Http\Controllers\Frontend\HomeController::class, 'contactSubmit'])->name('contact.submit');
Route::get('/rules', [App\Http\Controllers\Frontend\HomeController::class, 'rules'])->name('rules');
Route::get('/prizes', [App\Http\Controllers\Frontend\HomeController::class, 'prizes'])->name('prizes');
Route::get('/certificates', [App\Http\Controllers\Frontend\HomeController::class, 'certificates'])->name('certificates');
Route::get('/certificates/verify', [App\Http\Controllers\Frontend\HomeController::class, 'certificateVerification'])->name('certificates.verify');

// Digital ID Certificate Routes
Route::get('/certificates/id-front', function () {
    return view('certificates.id-front');
})->name('certificates.id-front');
Route::get('/certificates/id-back', function () {
    return view('certificates.id-back');
})->name('certificates.id-back');
Route::get('/players/id', function () {
    return view('players.id');
})->name('certificates.id');


// Certificate Verification API Routes
Route::prefix('api/certificates')->group(function () {
    Route::post('/verify', [App\Http\Controllers\CertificateVerificationController::class, 'verify'])->name('api.certificates.verify');
    Route::post('/bulk-verify', [App\Http\Controllers\CertificateVerificationController::class, 'bulkVerify'])->name('api.certificates.bulk-verify');
    Route::get('/statistics', [App\Http\Controllers\CertificateVerificationController::class, 'statistics'])->name('api.certificates.statistics');
});
Route::get('/help', [App\Http\Controllers\Frontend\HomeController::class, 'help'])->name('help');
Route::get('/faq', [App\Http\Controllers\Frontend\HomeController::class, 'faq'])->name('faq');
Route::get('/tech-support', [App\Http\Controllers\Frontend\HomeController::class, 'techSupport'])->name('tech-support');
Route::get('/privacy', [App\Http\Controllers\Frontend\HomeController::class, 'privacy'])->name('privacy');
Route::get('/terms', [App\Http\Controllers\Frontend\HomeController::class, 'terms'])->name('terms');
Route::get('/cookies', [App\Http\Controllers\Frontend\HomeController::class, 'cookies'])->name('cookies');
Route::get('/how-to-register', [App\Http\Controllers\Frontend\HomeController::class, 'howToRegister'])->name('how-to-register');
Route::get('/gallery', [App\Http\Controllers\Frontend\HomeController::class, 'gallery'])->name('gallery');
Route::get('/vlog', [App\Http\Controllers\Frontend\HomeController::class, 'vlog'])->name('vlog');
Route::get('/news', [App\Http\Controllers\Frontend\HomeController::class, 'news'])->name('news');
Route::get('/news/{id}', [App\Http\Controllers\Frontend\HomeController::class, 'newsArticle'])->name('news.article');
Route::get('/founders-message', [App\Http\Controllers\Frontend\HomeController::class, 'foundersMessage'])->name('founders-message');

// Teams public routes
Route::get('/teams', [App\Http\Controllers\Frontend\HomeController::class, 'teams'])->name('teams.index');
Route::get('/teams/{team}', [App\Http\Controllers\Frontend\HomeController::class, 'team'])->name('teams.show');
// Toast test route (for development)
Route::get('/toast-test', function () {
    return Inertia::render('ToastTest');
})->name('toast.test');

// SVG-based Certificate Routes
Route::get('/certificate', [App\Http\Controllers\SvgCertificateController::class, 'previewCertificate'])->name('certificate');
Route::get('/certificate/preview', [App\Http\Controllers\SvgCertificateController::class, 'previewCertificate'])->name('certificate.preview');
Route::get('/certificate/generate', [App\Http\Controllers\SvgCertificateController::class, 'generateCertificate'])->name('certificate.generate');
Route::get('/certificate/player/{playerId?}', [App\Http\Controllers\SvgCertificateController::class, 'generatePlayerCertificate'])->name('certificate.player');

// HTML Certificate Routes (Participation Certificates)
Route::get('/html-certificate', [App\Http\Controllers\HtmlCertificateController::class, 'previewCertificate'])->name('html-certificate');
Route::get('/html-certificate/preview', [App\Http\Controllers\HtmlCertificateController::class, 'previewCertificate'])->name('html-certificate.preview');
Route::get('/html-certificate/generate', [App\Http\Controllers\HtmlCertificateController::class, 'generateCertificate'])->name('html-certificate.generate');

// Player Participation Certificate Routes
Route::get('/certificates/player/participation', [App\Http\Controllers\HtmlCertificateController::class, 'generatePlayerCertificate'])->name('certificates.player.participation');
Route::get('/certificates/player/participation/pdf', [App\Http\Controllers\HtmlCertificateController::class, 'generatePlayerCertificatePdf'])->name('certificates.player.participation.pdf');

// Team Participation Certificate Routes
Route::get('/certificates/team/participation', [App\Http\Controllers\HtmlCertificateController::class, 'generateTeamCertificate'])->name('certificates.team.participation');
Route::get('/certificates/team/participation/pdf', [App\Http\Controllers\HtmlCertificateController::class, 'generateTeamCertificatePdf'])->name('certificates.team.participation.pdf');

// Bulk Certificate Generation
Route::post('/certificates/bulk-generate', [App\Http\Controllers\HtmlCertificateController::class, 'bulkGenerate'])->name('certificates.bulk-generate');

// Test session messages
Route::get('/toast-test/success', function () {
    return redirect()->to('/toast-test')->with('success', 'This is a success message from Laravel!');
})->name('toast.test.success');

Route::get('/toast-test/error', function () {
    return redirect()->to('/toast-test')->with('error', 'This is an error message from Laravel!');
})->name('toast.test.error');

Route::get('/toast-test/warning', function () {
    return redirect()->to('/toast-test')->with('warning', 'This is a warning message from Laravel!');
})->name('toast.test.warning');

Route::get('/toast-test/info', function () {
    return redirect()->to('/toast-test')->with('info', 'This is an info message from Laravel!');
})->name('toast.test.info');

// Test redirect back with error
Route::get('/toast-test/redirect-back', function () {
    return redirect()->back()->with('error', 'This is a redirect back error message!');
})->name('toast.test.redirect.back');

// Session debug page
Route::get('/session-debug', function () {
    return Inertia::render('SessionDebug');
})->name('session.debug');

// Test redirect to session debug with error
Route::get('/session-debug/error', function () {
    return redirect()->to('/session-debug')->with('error', 'This is an error message for session debug!');
})->name('session.debug.error');


// Player registration
Route::get('/player-register', [App\Http\Controllers\Frontend\PlayerController::class, 'register'])->name('player.register');
Route::post('/player-register', [App\Http\Controllers\Frontend\PlayerController::class, 'store'])->name('player.register.submit');

// Profile and payment routes
Route::middleware(['auth'])->group(function () {
    Route::get('/profile/complete', [App\Http\Controllers\ProfileController::class, 'showComplete'])->name('profile.complete');
    Route::post('/profile/complete', [App\Http\Controllers\ProfileController::class, 'updateComplete'])->name('profile.complete.update');
    Route::get('/payment/required', [App\Http\Controllers\ProfileController::class, 'showPaymentRequired'])->name('payment.required');
    
    // Team invitation routes
    Route::get('/team-invitation/{invitationId}', [App\Http\Controllers\TeamInvitationController::class, 'show'])->name('team.invitation.show');
    Route::post('/team-invitation/{invitationId}/accept', [App\Http\Controllers\TeamInvitationController::class, 'accept'])->name('team.invitation.accept');
    Route::post('/team-invitation/{invitationId}/decline', [App\Http\Controllers\TeamInvitationController::class, 'decline'])->name('team.invitation.decline');
    
    // Password change routes
    Route::get('/password/change/verify', [App\Http\Controllers\Auth\AuthenticatedSessionController::class, 'showPasswordChangeVerify'])->name('password.change.verify');
    Route::post('/password/change/verify', [App\Http\Controllers\Auth\AuthenticatedSessionController::class, 'verifyPasswordChangeOtp'])->name('password.change.verify.submit');
    Route::get('/password/change/form', [App\Http\Controllers\Auth\AuthenticatedSessionController::class, 'showPasswordChangeForm'])->name('password.change.form');
    Route::post('/password/change/form', [App\Http\Controllers\Auth\AuthenticatedSessionController::class, 'updatePassword'])->name('password.change.submit');
});

// OTP verification routes (public)
Route::get('/otp/player/verify', [App\Http\Controllers\OtpController::class, 'showPlayerVerification'])->name('otp.player.verify');
Route::post('/otp/player/verify', [App\Http\Controllers\OtpController::class, 'verifyPlayer'])->name('otp.player.verify.submit');
Route::get('/otp/official/verify', [App\Http\Controllers\OtpController::class, 'showOfficialVerification'])->name('otp.official.verify');
Route::post('/otp/official/verify', [App\Http\Controllers\OtpController::class, 'verifyOfficial'])->name('otp.official.verify.submit');
Route::post('/otp/player/resend', [App\Http\Controllers\OtpController::class, 'resendPlayerOtp'])->name('otp.player.resend');
Route::post('/otp/official/resend', [App\Http\Controllers\OtpController::class, 'resendOfficialOtp'])->name('otp.official.resend');
Route::get('/otp/success', [App\Http\Controllers\OtpController::class, 'showSuccess'])->name('otp.success');

// Payment routes
Route::middleware(['auth'])->group(function () {
    Route::post('/payment/initiate', [App\Http\Controllers\PaymentController::class, 'initiatePayment'])->name('payment.initiate');
    Route::get('/payment/{payment}/status', [App\Http\Controllers\PaymentController::class, 'checkPaymentStatus'])->name('payment.status');
    Route::post('/payment/poll-status', [App\Http\Controllers\PaymentController::class, 'pollPaymentStatus'])->name('payment.poll-status');
    Route::get('/payment/history', [App\Http\Controllers\PaymentController::class, 'paymentHistory'])->name('payment.history');
    Route::post('/payment/{payment}/retry', [App\Http\Controllers\PaymentController::class, 'retryPayment'])->name('payment.retry');
    Route::get('/otp/team/status', [App\Http\Controllers\OtpController::class, 'getTeamVerificationStatus'])->name('otp.team.status');
});

// M-Pesa callback (public)


Route::middleware(['auth', 'verified'])->group(function () {
    Route::get('dashboard', [App\Http\Controllers\Admin\DashboardController::class, 'index'])->name('dashboard');
    Route::get('analytics', [App\Http\Controllers\Admin\AnalyticsController::class, 'index'])->name('analytics');

    // Admin routes
    Route::prefix('admin')->group(function () {
        // Admin Dashboard - accessible to all authenticated users
        Route::get('dashboard', [App\Http\Controllers\Admin\DashboardController::class, 'index'])->name('admin.dashboard');
        
        Route::get('migrate-force', function () {
            try {
                \Artisan::call('migrate', [
                    '--force' => true,
                ]);
                $output = \Artisan::output();
                return back()->with('success', "Force migration completed successfully.<br><pre>$output</pre>");
            } catch (\Exception $e) {
                return back()->with('error', "Migration failed: " . $e->getMessage());
            }
        })->name('admin.migrate-force');
        
        // Tournament Management Routes
        Route::middleware(['permission:tournaments.create'])->group(function () {
            Route::get('tournaments/create', [TournamentAdminController::class, 'create'])->name('admin.tournaments.create');
            Route::post('tournaments', [TournamentAdminController::class, 'store'])->name('admin.tournaments.store');
        });
        
        Route::middleware(['permission:tournaments.edit'])->group(function () {
            Route::get('tournaments/{tournament}/edit', [TournamentAdminController::class, 'edit'])->name('admin.tournaments.edit');
            Route::put('tournaments/{tournament}', [TournamentAdminController::class, 'update'])->name('admin.tournaments.update');
        });
        
        Route::middleware(['permission:tournaments.delete'])->group(function () {
            Route::delete('tournaments/{tournament}', [TournamentAdminController::class, 'destroy'])->name('admin.tournaments.destroy');
            Route::delete('tournaments', [TournamentAdminController::class, 'destroyMultiple'])->name('admin.tournaments.destroyMultiple');
        });
        
        // Tournament team registration routes
        Route::middleware(['permission:tournaments.edit'])->group(function () {
            Route::get('tournaments/{tournament}/register-teams', [TournamentAdminController::class, 'registerTeams'])->name('admin.tournaments.register-teams');
            Route::post('tournaments/{tournament}/register-teams', [TournamentAdminController::class, 'registerTeamsStore'])->name('admin.tournaments.register-teams.store');
            Route::delete('tournaments/{tournament}/teams/{team}/unregister', [TournamentAdminController::class, 'unregisterTeam'])->name('admin.tournaments.unregister-team');
        });
        
        // Tournament participants management routes
        Route::middleware(['permission:tournaments.view'])->group(function () {
            Route::get('tournaments/participants/{tournament}', [TournamentAdminController::class, 'participants'])->name('admin.tournaments.participants');
        });
        
        Route::middleware(['permission:tournaments.edit'])->group(function () {
            Route::put('tournaments/{tournament}/participants/{team}/status', [TournamentAdminController::class, 'updateParticipantStatus'])->name('admin.tournaments.participants.update-status');
            Route::post('tournaments/{tournament}/participants/bulk-action', [TournamentAdminController::class, 'bulkActionParticipants'])->name('admin.tournaments.participants.bulk-action');
        });

        // Tournament approval routes
        Route::middleware(['permission:tournaments.first_approve_participants'])->group(function () {
            Route::post('tournaments/{tournament}/participants/{team}/first-approve', [TournamentAdminController::class, 'firstApproveParticipant'])->name('admin.tournaments.participants.first-approve');
        });
        
        Route::middleware(['permission:tournaments.second_approve_participants'])->group(function () {
            Route::post('tournaments/{tournament}/participants/{team}/second-approve', [TournamentAdminController::class, 'secondApproveParticipant'])->name('admin.tournaments.participants.second-approve');
        });
        
        Route::middleware(['permission:tournaments.approve_participants'])->group(function () {
            Route::post('tournaments/{tournament}/participants/{team}/reject', [TournamentAdminController::class, 'rejectParticipant'])->name('admin.tournaments.participants.reject');
        });

        // Helper route for getting users by role
        Route::get('tournaments/users-by-role', [TournamentAdminController::class, 'getUsersByRole'])->name('admin.tournaments.users-by-role');
        
        Route::middleware(['permission:tournaments.view'])->group(function () {
            Route::get('tournaments/{tournament}/participants/{team}/detail', [TournamentAdminController::class, 'participantDetail'])->name('admin.tournaments.participant-detail');
        });

        // Tournament Matches Routes
        Route::middleware(['permission:tournaments.view'])->group(function () {
            Route::get('tournaments/{tournament}/matches', [TournamentAdminController::class, 'matches'])->name('admin.tournaments.matches');
        });
        
        Route::middleware(['permission:tournaments.edit'])->group(function () {
            Route::put('tournaments/{tournament}/matches/{match}/status', [TournamentAdminController::class, 'updateMatchStatus'])->name('admin.tournaments.matches.update-status');
            Route::post('tournaments/{tournament}/matches/bulk-action', [TournamentAdminController::class, 'bulkActionMatches'])->name('admin.tournaments.matches.bulk-action');
        });

        // Tournament Brackets Routes
        Route::middleware(['permission:tournaments.view'])->group(function () {
            Route::get('tournaments/{tournament}/brackets', [TournamentAdminController::class, 'brackets'])->name('admin.tournaments.brackets');
        });
        
        Route::middleware(['permission:tournaments.edit'])->group(function () {
            Route::post('tournaments/{tournament}/brackets/generate', [TournamentAdminController::class, 'generateBracket'])->name('admin.tournaments.brackets.generate');
            Route::post('tournaments/{tournament}/brackets/auto-advance', [TournamentAdminController::class, 'autoAdvanceBracket'])->name('admin.tournaments.brackets.auto-advance');
        });

        // Tournament Statistics Routes
        Route::middleware(['permission:tournaments.view'])->group(function () {
            Route::get('tournaments/{tournament}/statistics', [TournamentAdminController::class, 'statistics'])->name('admin.tournaments.statistics');
        });

        // Tournament Certificate Routes
        Route::middleware(['permission:tournaments.view'])->group(function () {
            Route::get('tournaments/{tournament}/certificates/{team}', [TournamentAdminController::class, 'generateCertificate'])->name('admin.tournaments.certificate');
            Route::post('tournaments/{tournament}/certificates/bulk', [TournamentAdminController::class, 'bulkGenerateCertificates'])->name('admin.tournaments.certificates.bulk');
        });

        Route::middleware(['permission:tournaments.view'])->group(function () {
            Route::get('tournaments', [TournamentAdminController::class, 'index'])->name('admin.tournaments.index');
            Route::get('tournaments/{tournament}', [TournamentAdminController::class, 'show'])->name('admin.tournaments.show');
        });

        // Player Management Routes
        Route::middleware(['permission:players.create'])->group(function () {
            Route::get('players/create', [PlayerAdminController::class, 'create'])->name('admin.players.create');
            Route::post('players', [PlayerAdminController::class, 'store'])->name('admin.players.store');
        });
        
        Route::middleware(['permission:players.view'])->group(function () {
            Route::get('players', [PlayerAdminController::class, 'index'])->name('admin.players.index');
            Route::get('players/{player}', [PlayerAdminController::class, 'show'])->name('admin.players.show');
            Route::get('players/{player}/digital-id', [PlayerAdminController::class, 'viewDigitalId'])->name('admin.players.digital-id');
            Route::get('players/{player}/digital-id/print', [PlayerAdminController::class, 'printDigitalId'])->name('admin.players.digital-id.print');
            Route::get('players/{player}/id-card', [PlayerAdminController::class, 'viewIdCard'])->name('admin.players.id-card');
            Route::get('players/{player}/certificate', [PlayerAdminController::class, 'generateCertificate'])->name('admin.players.certificate');
            Route::get('players/{player}/certificate/print', [PlayerAdminController::class, 'printCertificate'])->name('admin.players.certificate.print');
            Route::get('players/{player}/certificate/download', [PlayerAdminController::class, 'downloadCertificate'])->name('admin.players.certificate.download');
            Route::get('players/{player}/certificate/new', [PlayerAdminController::class, 'generateNewCertificate'])->name('admin.players.certificate.new');
        });
        
        
        
        Route::middleware(['permission:players.edit'])->group(function () {
            Route::get('players/{player}/edit', [PlayerAdminController::class, 'edit'])->name('admin.players.edit');
            Route::put('players/{player}', [PlayerAdminController::class, 'update'])->name('admin.players.update');
            Route::post('players/{player}/digital-id', [PlayerAdminController::class, 'generateDigitalId'])->name('admin.players.digital-id.generate');
            Route::post('players/{player}/digital-id/resend', [PlayerAdminController::class, 'resendDigitalId'])->name('admin.players.digital-id.resend');
        });
        
        Route::middleware(['permission:players.delete'])->group(function () {
            Route::delete('players/{player}', [PlayerAdminController::class, 'destroy'])->name('admin.players.destroy');
            Route::delete('players', [PlayerAdminController::class, 'destroyMultiple'])->name('admin.players.destroyMultiple');
        });

        // Team Management Routes
        Route::middleware(['permission:teams.view'])->group(function () {
            Route::get('teams', [TeamAdminController::class, 'index'])->name('admin.teams.index');
        });
        
        Route::middleware(['permission:teams.create'])->group(function () {
            Route::post('teams', [TeamAdminController::class, 'store'])->name('admin.teams.store');
        });
        
        Route::middleware(['permission:teams.create'])->group(function () {
            Route::get('teams/create', [TeamAdminController::class, 'create'])->name('admin.teams.create');
        });
        
        Route::middleware(['permission:teams.view'])->group(function () {
            Route::get('teams/{team}', [TeamAdminController::class, 'show'])->name('admin.teams.show');
        });
        
        Route::middleware(['permission:teams.edit'])->group(function () {
            Route::get('teams/{team}/edit', [TeamAdminController::class, 'edit'])->name('admin.teams.edit');
            Route::put('teams/{team}', [TeamAdminController::class, 'update'])->name('admin.teams.update');
        });
        
        Route::middleware(['permission:teams.delete'])->group(function () {
            Route::delete('teams/{team}', [TeamAdminController::class, 'destroy'])->name('admin.teams.destroy');
            Route::delete('teams', [TeamAdminController::class, 'destroyMultiple'])->name('admin.teams.destroyMultiple');
        });

        // Team Approval Routes
        Route::middleware(['permission:teams.approve'])->group(function () {
            Route::post('teams/{team}/approve', [TeamAdminController::class, 'approve'])->name('admin.teams.approve');
            Route::post('teams/{team}/reject', [TeamAdminController::class, 'reject'])->name('admin.teams.reject');
            Route::post('teams/{team}/first-approve', [TeamAdminController::class, 'firstApprove'])->name('admin.teams.first-approve');
            Route::post('teams/{team}/second-approve', [TeamAdminController::class, 'secondApprove'])->name('admin.teams.second-approve');
            Route::post('teams/bulk-approve', [TeamAdminController::class, 'bulkApprove'])->name('admin.teams.bulk-approve');
            
            // Enhanced approval routes
            Route::get('teams/{team}/approval-view', [TeamAdminController::class, 'approvalView'])->name('admin.teams.approval-view');
            Route::post('teams/{team}/players/{player}/approve', [TeamAdminController::class, 'approvePlayer'])->name('admin.teams.player.approve');
            Route::post('teams/{team}/players/{player}/reject', [TeamAdminController::class, 'rejectPlayer'])->name('admin.teams.player.reject');
            Route::post('teams/{team}/players/bulk-approve', [TeamAdminController::class, 'bulkApprovePlayers'])->name('admin.teams.players.bulk-approve');
        });

        // Team Payment Routes
        Route::middleware(['permission:teams.manage_payments'])->group(function () {
            Route::post('teams/{team}/payments/manual', [TeamAdminController::class, 'addManualPayment'])->name('admin.teams.payments.manual');
        });

        // Match Management Routes
        Route::middleware(['permission:matches.view'])->group(function () {
            Route::get('matches', [MatchAdminController::class, 'index'])->name('admin.matches.index');
        });
        
        Route::middleware(['permission:matches.create'])->group(function () {
            Route::get('matches/create', [MatchAdminController::class, 'create'])->name('admin.matches.create');
            Route::post('matches', [MatchAdminController::class, 'store'])->name('admin.matches.store');
        });
        
        Route::middleware(['permission:matches.view'])->group(function () {
            Route::get('matches/{match}', [MatchAdminController::class, 'show'])->name('admin.matches.show');
        });
        
        Route::middleware(['permission:matches.edit'])->group(function () {
            Route::get('matches/{match}/edit', [MatchAdminController::class, 'edit'])->name('admin.matches.edit');
            Route::put('matches/{match}', [MatchAdminController::class, 'update'])->name('admin.matches.update');
        });
        
        Route::middleware(['permission:matches.delete'])->group(function () {
            Route::delete('matches/{match}', [MatchAdminController::class, 'destroy'])->name('admin.matches.destroy');
            Route::delete('matches', [MatchAdminController::class, 'destroyMultiple'])->name('admin.matches.destroyMultiple');
        });
        
        // Enhanced match management routes
        Route::middleware(['permission:matches.start'])->group(function () {
            Route::post('matches/{match}/start', [MatchAdminController::class, 'startMatch'])->name('admin.matches.start');
            Route::post('matches/{match}/pause', [MatchAdminController::class, 'pauseMatch'])->name('admin.matches.pause');
            Route::post('matches/{match}/resume', [MatchAdminController::class, 'resumeMatch'])->name('admin.matches.resume');
        });
        
        Route::middleware(['permission:matches.complete'])->group(function () {
            Route::post('matches/{match}/complete', [MatchAdminController::class, 'completeMatch'])->name('admin.matches.complete');
            Route::patch('matches/{match}/score', [MatchAdminController::class, 'updateScore'])->name('admin.matches.score');
        });
        
        Route::middleware(['permission:matches.verify'])->group(function () {
            Route::post('matches/{match}/verify', [MatchAdminController::class, 'verifyMatch'])->name('admin.matches.verify');
        });
        
        Route::middleware(['permission:matches.manage'])->group(function () {
            Route::post('matches/{match}/archive', [MatchAdminController::class, 'archiveMatch'])->name('admin.matches.archive');
            Route::post('matches/{match}/unarchive', [MatchAdminController::class, 'unarchiveMatch'])->name('admin.matches.unarchive');
            Route::post('matches/update-multiple', [MatchAdminController::class, 'updateMultiple'])->name('admin.matches.updateMultiple');
        });

        // Role management routes - Admin onle        
        Route::middleware(['permission:roles.create'])->group(function () {
            Route::get('roles/create', [RoleAdminController::class, 'create'])->name('admin.roles.create');
            Route::post('roles', [RoleAdminController::class, 'store'])->name('admin.roles.store');
        });
        
        Route::middleware(['permission:roles.edit'])->group(function () {
            Route::get('roles/{role}/edit', [RoleAdminController::class, 'edit'])->name('admin.roles.edit');
            Route::put('roles/{role}', [RoleAdminController::class, 'update'])->name('admin.roles.update');
            Route::patch('roles/{role}/toggle-status', [RoleAdminController::class, 'toggleStatus'])->name('admin.roles.toggle-status');
        });
        
        Route::middleware(['permission:roles.delete'])->group(function () {
            Route::delete('roles/{role}', [RoleAdminController::class, 'destroy'])->name('admin.roles.destroy');
            Route::post('roles/bulk-update', [RoleAdminController::class, 'bulkUpdate'])->name('admin.roles.bulk-update');
            Route::post('roles/bulk-delete', [RoleAdminController::class, 'bulkDelete'])->name('admin.roles.bulk-delete');
        });
        
        Route::middleware(['permission:roles.assign'])->group(function () {
            Route::post('roles/{role}/assign-users', [RoleAdminController::class, 'assignUsers'])->name('admin.roles.assignUsers');
            Route::post('roles/{role}/remove-users', [RoleAdminController::class, 'removeUsers'])->name('admin.roles.removeUsers');
        });
        
        Route::middleware(['permission:roles.view'])->group(function () {
            Route::get('roles', [RoleAdminController::class, 'index'])->name('admin.roles.index');
            Route::get('roles/{role}', [RoleAdminController::class, 'show'])->name('admin.roles.show');
        });
        
        Route::middleware(['permission:users.create'])->group(function () {
            Route::get('users/create', [UserAdminController::class, 'create'])->name('admin.users.create');
            Route::post('users', [UserAdminController::class, 'store'])->name('admin.users.store');
        });
        
        Route::middleware(['permission:users.edit'])->group(function () {
            Route::get('users/{user}/edit', [UserAdminController::class, 'edit'])->name('admin.users.edit');
            Route::put('users/{user}', [UserAdminController::class, 'update'])->name('admin.users.update');
        });
        
        Route::middleware(['permission:users.delete'])->group(function () {
            Route::delete('users/{user}', [UserAdminController::class, 'destroy'])->name('admin.users.destroy');
            Route::post('users/bulk-delete', [UserAdminController::class, 'bulkDelete'])->name('admin.users.bulkDelete');
        });
        
        Route::middleware(['permission:users.manage'])->group(function () {
            Route::post('users/{user}/assign-roles', [UserAdminController::class, 'assignRoles'])->name('admin.users.assignRoles');
            Route::post('users/{user}/remove-roles', [UserAdminController::class, 'removeRoles'])->name('admin.users.removeRoles');
        });
        
        Route::middleware(['permission:users.impersonate'])->group(function () {
            Route::post('users/{user}/impersonate', [UserAdminController::class, 'impersonate'])->name('admin.users.impersonate');
        });

         // User management routes - Admin only
         Route::middleware(['permission:users.view'])->group(function () {
            Route::get('users', [UserAdminController::class, 'index'])->name('admin.users.index');
            Route::get('users/{user}', [UserAdminController::class, 'show'])->name('admin.users.show');
        });

        // Payment management routes - Admin only
        Route::middleware(['permission:payments.view'])->group(function () {
            Route::get('payments', [PaymentAdminController::class, 'index'])->name('admin.payments.index');
            Route::get('payments/{payment}', [PaymentAdminController::class, 'show'])->name('admin.payments.show');
        });

        // Permission management routes - Super Admin only
        Route::middleware(['permission:permissions.create'])->group(function () {
            Route::get('permissions/create', [PermissionAdminController::class, 'create'])->name('admin.permissions.create');
            Route::post('permissions', [PermissionAdminController::class, 'store'])->name('admin.permissions.store');
        });
        
        Route::middleware(['permission:permissions.edit'])->group(function () {
            Route::get('permissions/{permission}/edit', [PermissionAdminController::class, 'edit'])->name('admin.permissions.edit');
            Route::put('permissions/{permission}', [PermissionAdminController::class, 'update'])->name('admin.permissions.update');
            Route::post('permissions/bulk-update', [PermissionAdminController::class, 'bulkUpdate'])->name('admin.permissions.bulk-update');
        });
        
        Route::middleware(['permission:permissions.delete'])->group(function () {
            Route::delete('permissions/{permission}', [PermissionAdminController::class, 'destroy'])->name('admin.permissions.destroy');
            Route::post('permissions/bulk-delete', [PermissionAdminController::class, 'bulkDelete'])->name('admin.permissions.bulk-delete');
        });
        
        Route::middleware(['permission:permissions.assign'])->group(function () {
            Route::post('permissions/assign-to-role', [PermissionAdminController::class, 'assignToRole'])->name('admin.permissions.assign-to-role');
            Route::post('permissions/remove-from-role', [PermissionAdminController::class, 'removeFromRole'])->name('admin.permissions.remove-from-role');
        });

        // Role permission assignment routes - Admin only
        Route::middleware(['permission:roles.assign'])->group(function () {
            Route::post('roles/{role}/assign-permissions', [RoleAdminController::class, 'assignPermissions'])->name('admin.roles.assign-permissions');
            Route::post('roles/{role}/remove-permissions', [RoleAdminController::class, 'removePermissions'])->name('admin.roles.remove-permissions');
            Route::post('roles/{role}/sync-permissions', [RoleAdminController::class, 'syncPermissions'])->name('admin.roles.sync-permissions');
        });

        Route::middleware(['permission:permissions.view'])->group(function () {
            Route::get('permissions', [PermissionAdminController::class, 'index'])->name('admin.permissions.index');
            Route::get('permissions/{permission}', [PermissionAdminController::class, 'show'])->name('admin.permissions.show');
        });
        
        Route::middleware(['permission:emails.create'])->group(function () {
            Route::get('settings/emails/create', [App\Http\Controllers\Admin\EmailSettingsController::class, 'create'])->name('admin.settings.emails.create');
            Route::post('settings/emails', [App\Http\Controllers\Admin\EmailSettingsController::class, 'store'])->name('admin.settings.emails.store');
        });
        
        Route::middleware(['permission:emails.edit'])->group(function () {
            Route::get('settings/emails/{emailCredential}/edit', [App\Http\Controllers\Admin\EmailSettingsController::class, 'edit'])->name('admin.settings.emails.edit');
            Route::put('settings/emails/{emailCredential}', [App\Http\Controllers\Admin\EmailSettingsController::class, 'update'])->name('admin.settings.emails.update');
            Route::patch('settings/emails/{emailCredential}/toggle-status', [App\Http\Controllers\Admin\EmailSettingsController::class, 'toggleStatus'])->name('admin.settings.emails.toggle-status');
            Route::post('settings/emails/{emailCredential}/test-connection', [App\Http\Controllers\Admin\EmailSettingsController::class, 'testConnection'])->name('admin.settings.emails.test-connection');
        });
        
        Route::middleware(['permission:emails.delete'])->group(function () {
            Route::delete('settings/emails/{emailCredential}', [App\Http\Controllers\Admin\EmailSettingsController::class, 'destroy'])->name('admin.settings.emails.destroy');
            Route::post('settings/emails/bulk-update', [App\Http\Controllers\Admin\EmailSettingsController::class, 'bulkUpdate'])->name('admin.settings.emails.bulk-update');
            Route::post('settings/emails/bulk-delete', [App\Http\Controllers\Admin\EmailSettingsController::class, 'bulkDelete'])->name('admin.settings.emails.bulk-delete');
        });
        
        Route::middleware(['permission:emails.assign'])->group(function () {
            Route::post('settings/emails/{emailCredential}/assign-users', [App\Http\Controllers\Admin\EmailSettingsController::class, 'assignUsers'])->name('admin.settings.emails.assign-users');
            Route::post('settings/emails/{emailCredential}/remove-users', [App\Http\Controllers\Admin\EmailSettingsController::class, 'removeUsers'])->name('admin.settings.emails.remove-users');
            Route::post('settings/emails/{emailCredential}/update-user-permissions', [App\Http\Controllers\Admin\EmailSettingsController::class, 'updateUserPermissions'])->name('admin.settings.emails.update-user-permissions');
            Route::get('settings/emails/{emailCredential}/available-users', [App\Http\Controllers\Admin\EmailSettingsController::class, 'getAvailableUsers'])->name('admin.settings.emails.available-users');
            Route::get('settings/emails/{emailCredential}/assigned-users', [App\Http\Controllers\Admin\EmailSettingsController::class, 'getAssignedUsers'])->name('admin.settings.emails.assigned-users');
        });

         // Email management routes - Admin only
         Route::middleware(['permission:emails.view'])->group(function () {
            Route::get('settings/emails', [App\Http\Controllers\Admin\EmailSettingsController::class, 'index'])->name('admin.settings.emails.index');
            Route::get('settings/emails/{emailCredential}', [App\Http\Controllers\Admin\EmailSettingsController::class, 'show'])->name('admin.settings.emails.show');
        });
        
        // Stop impersonation route - no permission required since user is already impersonating
        Route::post('users/stop-impersonating', [UserAdminController::class, 'stopImpersonating'])->name('admin.users.stopImpersonating');
        
        Route::middleware(['permission:users.view'])->group(function () {
            Route::get('users/export', [UserAdminController::class, 'export'])->name('admin.users.export');
        });

        // Queue & Notifications Monitor - Admin only
        Route::middleware(['permission:settings.view'])->group(function () {
            Route::get('queue-monitor', [App\Http\Controllers\Admin\QueueMonitorController::class, 'index'])->name('admin.queue-monitor');
        });

        // Media test route - Admin only
        Route::middleware(['permission:media.view'])->group(function () {
            Route::get('media-test', function () {
                return Inertia::render('admin/media-test');
            })->name('admin.media-test');
        });

        // Frontend Content Management Routes - Media permissions required
        Route::prefix('frontend')->middleware(['permission:media.manage'])->group(function () {
            // Hero Slides
            Route::get('hero-slides', [App\Http\Controllers\Admin\Frontend\HeroSlideAdminController::class, 'index'])->name('admin.frontend.hero-slides.index');
            Route::get('hero-slides/create', [App\Http\Controllers\Admin\Frontend\HeroSlideAdminController::class, 'create'])->name('admin.frontend.hero-slides.create');
            Route::post('hero-slides', [App\Http\Controllers\Admin\Frontend\HeroSlideAdminController::class, 'store'])->name('admin.frontend.hero-slides.store');
            Route::get('hero-slides/{slide}/edit', [App\Http\Controllers\Admin\Frontend\HeroSlideAdminController::class, 'edit'])->name('admin.frontend.hero-slides.edit');
            Route::put('hero-slides/{slide}', [App\Http\Controllers\Admin\Frontend\HeroSlideAdminController::class, 'update'])->name('admin.frontend.hero-slides.update');
            Route::delete('hero-slides/{slide}', [App\Http\Controllers\Admin\Frontend\HeroSlideAdminController::class, 'destroy'])->name('admin.frontend.hero-slides.destroy');

            // News Articles
            Route::get('news-articles', [App\Http\Controllers\Admin\Frontend\NewsArticleAdminController::class, 'index'])->name('admin.frontend.news-articles.index');
            Route::get('news-articles/create', [App\Http\Controllers\Admin\Frontend\NewsArticleAdminController::class, 'create'])->name('admin.frontend.news-articles.create');
            Route::post('news-articles', [App\Http\Controllers\Admin\Frontend\NewsArticleAdminController::class, 'store'])->name('admin.frontend.news-articles.store');
            Route::get('news-articles/{article}/edit', [App\Http\Controllers\Admin\Frontend\NewsArticleAdminController::class, 'edit'])->name('admin.frontend.news-articles.edit');
            Route::put('news-articles/{article}', [App\Http\Controllers\Admin\Frontend\NewsArticleAdminController::class, 'update'])->name('admin.frontend.news-articles.update');
            Route::delete('news-articles/{article}', [App\Http\Controllers\Admin\Frontend\NewsArticleAdminController::class, 'destroy'])->name('admin.frontend.news-articles.destroy');
            Route::patch('news-articles/{article}/toggle-featured', [App\Http\Controllers\Admin\Frontend\NewsArticleAdminController::class, 'toggleFeatured'])->name('admin.frontend.news-articles.toggle-featured');

            // Sponsors
            Route::get('sponsors', [App\Http\Controllers\Admin\Frontend\SponsorAdminController::class, 'index'])->name('admin.frontend.sponsors.index');
            Route::get('sponsors/create', [App\Http\Controllers\Admin\Frontend\SponsorAdminController::class, 'create'])->name('admin.frontend.sponsors.create');
            Route::post('sponsors', [App\Http\Controllers\Admin\Frontend\SponsorAdminController::class, 'store'])->name('admin.frontend.sponsors.store');
            Route::get('sponsors/{sponsor}/edit', [App\Http\Controllers\Admin\Frontend\SponsorAdminController::class, 'edit'])->name('admin.frontend.sponsors.edit');
            Route::put('sponsors/{sponsor}', [App\Http\Controllers\Admin\Frontend\SponsorAdminController::class, 'update'])->name('admin.frontend.sponsors.update');
            Route::delete('sponsors/{sponsor}', [App\Http\Controllers\Admin\Frontend\SponsorAdminController::class, 'destroy'])->name('admin.frontend.sponsors.destroy');

            // Testimonials
            Route::get('testimonials', [App\Http\Controllers\Admin\Frontend\TestimonialAdminController::class, 'index'])->name('admin.frontend.testimonials.index');
            Route::get('testimonials/create', [App\Http\Controllers\Admin\Frontend\TestimonialAdminController::class, 'create'])->name('admin.frontend.testimonials.create');
            Route::post('testimonials', [App\Http\Controllers\Admin\Frontend\TestimonialAdminController::class, 'store'])->name('admin.frontend.testimonials.store');
            Route::get('testimonials/{testimonial}/edit', [App\Http\Controllers\Admin\Frontend\TestimonialAdminController::class, 'edit'])->name('admin.frontend.testimonials.edit');
            Route::put('testimonials/{testimonial}', [App\Http\Controllers\Admin\Frontend\TestimonialAdminController::class, 'update'])->name('admin.frontend.testimonials.update');
            Route::delete('testimonials/{testimonial}', [App\Http\Controllers\Admin\Frontend\TestimonialAdminController::class, 'destroy'])->name('admin.frontend.testimonials.destroy');

            // Gallery Images
            Route::get('gallery', [App\Http\Controllers\Admin\Frontend\GalleryImageAdminController::class, 'index'])->name('admin.frontend.gallery.index');
            Route::get('gallery/create', [App\Http\Controllers\Admin\Frontend\GalleryImageAdminController::class, 'create'])->name('admin.frontend.gallery.create');
            Route::post('gallery', [App\Http\Controllers\Admin\Frontend\GalleryImageAdminController::class, 'store'])->name('admin.frontend.gallery.store');
            Route::get('gallery/bulk-create', [App\Http\Controllers\Admin\Frontend\GalleryImageAdminController::class, 'bulkCreate'])->name('admin.frontend.gallery.bulk-create');
            Route::post('gallery/bulk-store', [App\Http\Controllers\Admin\Frontend\GalleryImageAdminController::class, 'bulkStore'])->name('admin.frontend.gallery.bulk-store');
            Route::get('gallery/{image}/edit', [App\Http\Controllers\Admin\Frontend\GalleryImageAdminController::class, 'edit'])->name('admin.frontend.gallery.edit');
            Route::put('gallery/{image}', [App\Http\Controllers\Admin\Frontend\GalleryImageAdminController::class, 'update'])->name('admin.frontend.gallery.update');
            Route::delete('gallery/{image}', [App\Http\Controllers\Admin\Frontend\GalleryImageAdminController::class, 'destroy'])->name('admin.frontend.gallery.destroy');

            // Vlog Videos
            Route::middleware(['permission:vlog.view'])->group(function () {
                Route::get('vlog', [App\Http\Controllers\Admin\Frontend\VlogVideoAdminController::class, 'index'])->name('admin.frontend.vlog.index');
            });
            
            Route::middleware(['permission:vlog.create'])->group(function () {
                Route::get('vlog/create', [App\Http\Controllers\Admin\Frontend\VlogVideoAdminController::class, 'create'])->name('admin.frontend.vlog.create');
                Route::post('vlog', [App\Http\Controllers\Admin\Frontend\VlogVideoAdminController::class, 'store'])->name('admin.frontend.vlog.store');
            });
            
            Route::middleware(['permission:vlog.edit'])->group(function () {
                Route::get('vlog/{vlogVideo}/edit', [App\Http\Controllers\Admin\Frontend\VlogVideoAdminController::class, 'edit'])->name('admin.frontend.vlog.edit');
                Route::put('vlog/{vlogVideo}', [App\Http\Controllers\Admin\Frontend\VlogVideoAdminController::class, 'update'])->name('admin.frontend.vlog.update');
            });
            
            Route::middleware(['permission:vlog.delete'])->group(function () {
                Route::delete('vlog/{id}/delete', [App\Http\Controllers\Admin\Frontend\VlogVideoAdminController::class, 'destroy'])->name('admin.frontend.vlog.destroy');
                Route::post('vlog/{id}/restore', [App\Http\Controllers\Admin\Frontend\VlogVideoAdminController::class, 'restore'])->name('admin.frontend.vlog.restore');
                Route::delete('vlog/{id}/force-delete', [App\Http\Controllers\Admin\Frontend\VlogVideoAdminController::class, 'forceDelete'])->name('admin.frontend.vlog.force-delete');
            });

            // Tournament Highlights
            Route::get('tournament-highlights', [App\Http\Controllers\Admin\Frontend\TournamentHighlightAdminController::class, 'index'])->name('admin.frontend.tournament-highlights.index');
            Route::get('tournament-highlights/create', [App\Http\Controllers\Admin\Frontend\TournamentHighlightAdminController::class, 'create'])->name('admin.frontend.tournament-highlights.create');
            Route::post('tournament-highlights', [App\Http\Controllers\Admin\Frontend\TournamentHighlightAdminController::class, 'store'])->name('admin.frontend.tournament-highlights.store');
            Route::get('tournament-highlights/{tournamentHighlight}/edit', [App\Http\Controllers\Admin\Frontend\TournamentHighlightAdminController::class, 'edit'])->name('admin.frontend.tournament-highlights.edit');
            Route::put('tournament-highlights/{tournamentHighlight}', [App\Http\Controllers\Admin\Frontend\TournamentHighlightAdminController::class, 'update'])->name('admin.frontend.tournament-highlights.update');
            Route::delete('tournament-highlights/{tournamentHighlight}', [App\Http\Controllers\Admin\Frontend\TournamentHighlightAdminController::class, 'destroy'])->name('admin.frontend.tournament-highlights.destroy');
            Route::patch('tournament-highlights/{tournamentHighlight}/toggle-status', [App\Http\Controllers\Admin\Frontend\TournamentHighlightAdminController::class, 'toggleStatus'])->name('admin.frontend.tournament-highlights.toggle-status');
            Route::post('tournament-highlights/update-sort-order', [App\Http\Controllers\Admin\Frontend\TournamentHighlightAdminController::class, 'updateSortOrder'])->name('admin.frontend.tournament-highlights.update-sort-order');
            Route::post('tournament-highlights/bulk-update', [App\Http\Controllers\Admin\Frontend\TournamentHighlightAdminController::class, 'bulkUpdate'])->name('admin.frontend.tournament-highlights.bulk-update');
        });
        
        // Media Management
        Route::prefix('media')->name('admin.media.')->group(function () {
            Route::get('/', [App\Http\Controllers\Admin\MediaAdminController::class, 'index'])->name('index');
            Route::get('/{media}', [App\Http\Controllers\Admin\MediaAdminController::class, 'show'])->name('show');
            Route::get('/{media}/edit', [App\Http\Controllers\Admin\MediaAdminController::class, 'edit'])->name('edit');
            Route::put('/{media}', [App\Http\Controllers\Admin\MediaAdminController::class, 'update'])->name('update');
            Route::delete('/{media}', [App\Http\Controllers\Admin\MediaAdminController::class, 'destroy'])->name('destroy');
            Route::delete('/', [App\Http\Controllers\Admin\MediaAdminController::class, 'bulkDestroy'])->name('bulk-destroy');
        });

        // Tournament Settings Routes
        Route::middleware(['permission:settings.manage'])->group(function () {
            Route::get('tournament-settings', [App\Http\Controllers\Admin\TournamentSettingsController::class, 'index'])->name('admin.tournament-settings.index');
            Route::put('tournament-settings', [App\Http\Controllers\Admin\TournamentSettingsController::class, 'update'])->name('admin.tournament-settings.update');
        });

        // Bracket Management Routes
        
        Route::middleware(['permission:brackets.create'])->group(function () {
            Route::post('brackets', [BracketAdminController::class, 'store'])->name('admin.brackets.store');
            Route::post('tournaments/{tournament}/generate-bracket', [BracketAdminController::class, 'generateBracket'])->name('admin.brackets.generate');
            Route::get('tournaments/{tournament}/participants', [BracketAdminController::class, 'getParticipants'])->name('admin.brackets.participants');
        });
        Route::middleware(['permission:brackets.edit'])->group(function () {
            Route::get('brackets/{bracket}/edit', [BracketAdminController::class, 'edit'])->name('admin.brackets.edit');
            Route::put('brackets/{bracket}', [BracketAdminController::class, 'update'])->name('admin.brackets.update');
            Route::post('brackets/{bracket}/advance-round', [BracketAdminController::class, 'advanceRound'])->name('admin.brackets.advance');
        });
        
        Route::middleware(['permission:brackets.delete'])->group(function () {
            Route::delete('brackets/{bracket}', [BracketAdminController::class, 'destroy'])->name('admin.brackets.destroy');
            Route::delete('brackets', [BracketAdminController::class, 'destroyMultiple'])->name('admin.brackets.destroyMultiple');
        });

        Route::middleware(['permission:brackets.view'])->group(function () {
            Route::get('brackets', [BracketAdminController::class, 'index'])->name('admin.brackets.index');
            Route::get('brackets/{bracket}', [BracketAdminController::class, 'show'])->name('admin.brackets.show');
        });
        
        
        // Settings - Admin only
        Route::middleware(['permission:settings.view'])->group(function () {
            Route::get('settings', [App\Http\Controllers\Admin\SettingsController::class, 'index'])->name('admin.settings');
            Route::get('settings/email-status', [App\Http\Controllers\Admin\SettingsController::class, 'getEmailStatus'])->name('admin.settings.email-status');
        });
        
        Route::middleware(['permission:settings.edit'])->group(function () {
            Route::put('settings', [App\Http\Controllers\Admin\SettingsController::class, 'update'])->name('admin.settings.update');
            Route::post('settings/test-email', [App\Http\Controllers\Admin\SettingsController::class, 'sendTestEmail'])->name('admin.settings.test-email');
            Route::post('settings/test-smtp', [App\Http\Controllers\Admin\SettingsController::class, 'testSmtpConnection'])->name('admin.settings.test-smtp');
        });
        
        Route::middleware(['permission:settings.system'])->group(function () {
            Route::post('settings/run-command', [App\Http\Controllers\Admin\SettingsController::class, 'runCommand'])->name('admin.settings.run-command');
            
            // Queue management routes
            Route::get('settings/queue-status', [App\Http\Controllers\Admin\SettingsController::class, 'getQueueStatus'])->name('admin.settings.queue-status');
            Route::post('settings/process-queue', [App\Http\Controllers\Admin\SettingsController::class, 'processQueue'])->name('admin.settings.process-queue');
        });
        
        // Analytics - Admin and Organizer only
        Route::middleware(['permission:analytics.view'])->group(function () {
            Route::get('analytics', [App\Http\Controllers\Admin\AnalyticsController::class, 'index'])->name('admin.analytics');
        });

        // FAQ Management Routes        
        Route::middleware(['permission:faqs.create'])->group(function () {
            Route::get('faqs/create', [App\Http\Controllers\Admin\FaqController::class, 'create'])->name('admin.faqs.create');
            Route::post('faqs', [App\Http\Controllers\Admin\FaqController::class, 'store'])->name('admin.faqs.store');
        });
        
        Route::middleware(['permission:faqs.edit'])->group(function () {
            Route::get('faqs/{faq}/edit', [App\Http\Controllers\Admin\FaqController::class, 'edit'])->name('admin.faqs.edit');
            Route::put('faqs/{faq}', [App\Http\Controllers\Admin\FaqController::class, 'update'])->name('admin.faqs.update');
            Route::patch('faqs/{faq}/toggle-status', [App\Http\Controllers\Admin\FaqController::class, 'toggleStatus'])->name('admin.faqs.toggle-status');
        });
        
        Route::middleware(['permission:faqs.delete'])->group(function () {
            Route::delete('faqs/{faq}', [App\Http\Controllers\Admin\FaqController::class, 'destroy'])->name('admin.faqs.destroy');
            Route::post('faqs/bulk-action', [App\Http\Controllers\Admin\FaqController::class, 'bulkAction'])->name('admin.faqs.bulk-action');
        });

        Route::middleware(['permission:faqs.view'])->group(function () {
            Route::get('faqs', [App\Http\Controllers\Admin\FaqController::class, 'index'])->name('admin.faqs.index');
            Route::get('faqs/{faq}', [App\Http\Controllers\Admin\FaqController::class, 'show'])->name('admin.faqs.show');
        });

        // Prize Awards Management Routes
        Route::middleware(['permission:prize_awards.create'])->group(function () {
            Route::get('prize-awards/create', [App\Http\Controllers\Admin\PrizeAwardController::class, 'create'])->name('admin.prize-awards.create');
            Route::post('prize-awards', [App\Http\Controllers\Admin\PrizeAwardController::class, 'store'])->name('admin.prize-awards.store');
        });

        Route::middleware(['permission:prize_awards.edit'])->group(function () {
            Route::get('prize-awards/{prizeAward}/edit', [App\Http\Controllers\Admin\PrizeAwardController::class, 'edit'])->name('admin.prize-awards.edit');
            Route::put('prize-awards/{prizeAward}', [App\Http\Controllers\Admin\PrizeAwardController::class, 'update'])->name('admin.prize-awards.update');
            Route::patch('prize-awards/{prizeAward}/toggle-status', [App\Http\Controllers\Admin\PrizeAwardController::class, 'toggleStatus'])->name('admin.prize-awards.toggle-status');
        });

        Route::middleware(['permission:prize_awards.delete'])->group(function () {
            Route::delete('prize-awards/{prizeAward}', [App\Http\Controllers\Admin\PrizeAwardController::class, 'destroy'])->name('admin.prize-awards.destroy');
            Route::post('prize-awards/bulk-action', [App\Http\Controllers\Admin\PrizeAwardController::class, 'bulkAction'])->name('admin.prize-awards.bulk-action');
        });

        Route::middleware(['permission:prize_awards.view'])->group(function () {
            Route::get('prize-awards', [App\Http\Controllers\Admin\PrizeAwardController::class, 'index'])->name('admin.prize-awards.index');
            Route::get('prize-awards/{prizeAward}', [App\Http\Controllers\Admin\PrizeAwardController::class, 'show'])->name('admin.prize-awards.show');
        });
    });

    // Player Portal Routes - Player role required
Route::prefix('player')->middleware(['role:player', 'verified'])->group(function () {
    Route::get('tournaments', [App\Http\Controllers\Player\PlayerPortalController::class, 'tournaments'])->name('player.tournaments');
    Route::get('team', [App\Http\Controllers\Player\PlayerPortalController::class, 'team'])->name('player.team');
    Route::get('matches', [App\Http\Controllers\Player\PlayerPortalController::class, 'matches'])->name('player.matches');
    Route::get('profile', [App\Http\Controllers\Player\PlayerPortalController::class, 'profile'])->name('player.profile');
    Route::put('profile', [App\Http\Controllers\Player\PlayerPortalController::class, 'updateProfile'])->name('player.profile.update');
    Route::get('performance', [App\Http\Controllers\Player\PlayerPortalController::class, 'performance'])->name('player.performance');
});

// API Routes for Payment Processing
Route::prefix('api')->group(function () {
    Route::prefix('payments')->group(function () {
        Route::post('initiate', [App\Http\Controllers\Api\PaymentController::class, 'initiate'])->name('api.payments.initiate');
        Route::get('status/{transactionId}', [App\Http\Controllers\Api\PaymentController::class, 'status'])->name('api.payments.status');
        Route::get('/', [App\Http\Controllers\Api\PaymentController::class, 'index'])->name('api.payments.index');
        Route::post('{transactionId}/refund', [App\Http\Controllers\Api\PaymentController::class, 'refund'])->name('api.payments.refund');
    });
});
});

// Media Management Routes - Media permissions required
Route::prefix('media')->middleware(['auth', 'verified', 'permission:media.view'])->group(function () {
    Route::get('/', [MediaController::class, 'index'])->name('media.index');
    Route::get('/collections', [MediaController::class, 'collections'])->name('media.collections');
    Route::get('/{media}', [MediaController::class, 'show'])->name('media.show');
    
    Route::middleware(['permission:media.upload'])->group(function () {
        Route::post('/upload', [MediaController::class, 'upload'])->name('media.upload');
    });
    
    Route::middleware(['permission:media.edit'])->group(function () {
        Route::put('/{media}', [MediaController::class, 'update'])->name('media.update');
    });
    
    Route::middleware(['permission:media.delete'])->group(function () {
        Route::delete('/{media}', [MediaController::class, 'destroy'])->name('media.destroy');
        Route::delete('/bulk/delete', [MediaController::class, 'bulkDelete'])->name('media.bulk-delete');
    });
});

// Serve media files (public access)
Route::get('/media/serve/{media}', [MediaController::class, 'serve'])->name('media.serve');

// Team Manager routes
Route::prefix('team')->middleware(['auth', 'role:team_manager'])->group(function () {
    Route::get('/profile', [App\Http\Controllers\TeamManager\TeamManagerController::class, 'profile'])->name('team.profile');
    Route::match(['put', 'post'], '/profile', [App\Http\Controllers\TeamManager\TeamManagerController::class, 'updateProfile'])->name('team.profile.update');
    
    Route::get('/players', [App\Http\Controllers\TeamManager\TeamManagerController::class, 'players'])->name('team.players');
    Route::get('/players/create', [App\Http\Controllers\TeamManager\TeamManagerController::class, 'createPlayer'])->name('team.players.create');
    Route::post('/players', [App\Http\Controllers\TeamManager\TeamManagerController::class, 'storePlayer'])->name('team.players.store');
    Route::get('/players/id-cards', [App\Http\Controllers\TeamManager\TeamManagerController::class, 'showPlayerIdCards'])->name('team.players.id-cards');
    Route::post('/players/id-cards', [App\Http\Controllers\TeamManager\TeamManagerController::class, 'generateIdCards'])->name('team.players.id-cards.generate');
    Route::post('/players/id-cards/download', [App\Http\Controllers\TeamManager\TeamManagerController::class, 'downloadIdCards'])->name('team.players.id-cards.download');
    Route::get('/players/{player}', [App\Http\Controllers\TeamManager\TeamManagerController::class, 'showPlayerProfile'])->name('team.players.profile');
    Route::post('/players/{player}/profile', [App\Http\Controllers\TeamManager\TeamManagerController::class, 'updatePlayerProfile'])->name('team.players.update-profile');
    Route::get('/players/{player}/certificate', [App\Http\Controllers\TeamManager\TeamManagerController::class, 'downloadCertificate'])->name('team.players.certificate');
    Route::get('/players/{player}/certificate/pdf', [App\Http\Controllers\TeamManager\TeamManagerController::class, 'generateCertificatePdf'])->name('team.players.certificate.pdf');
    Route::get('/players/{player}/certificate/view', [App\Http\Controllers\TeamManager\TeamManagerController::class, 'showPlayerCertificate'])->name('team.players.certificate.view');
    
    // Team Certificate Routes
    Route::get('/certificate', [App\Http\Controllers\TeamManager\TeamManagerController::class, 'showTeamCertificate'])->name('team.certificate.view');
    Route::get('/certificate/pdf', [App\Http\Controllers\TeamManager\TeamManagerController::class, 'generateTeamCertificatePdf'])->name('team.certificate.pdf');
    Route::post('/players/add', [App\Http\Controllers\TeamManager\TeamManagerController::class, 'addPlayer'])->name('team.players.add');
    Route::put('/players/{player}', [App\Http\Controllers\TeamManager\TeamManagerController::class, 'updatePlayer'])->name('team.players.update');
    Route::delete('/players/{player}', [App\Http\Controllers\TeamManager\TeamManagerController::class, 'removePlayer'])->name('team.players.remove');
    
    Route::get('/tournaments', [App\Http\Controllers\TeamManager\TeamManagerController::class, 'tournaments'])->name('team.tournaments');
    Route::post('/tournaments/register', [App\Http\Controllers\TeamManager\TeamManagerController::class, 'registerForTournament'])->name('team.tournaments.register');
    
    Route::get('/matches', [App\Http\Controllers\TeamManager\TeamManagerController::class, 'matches'])->name('team.matches');
    Route::get('/matches/{match}', [App\Http\Controllers\TeamManager\TeamManagerController::class, 'showMatch'])->name('team.matches.show');
    
    Route::get('/payments', [App\Http\Controllers\TeamManager\TeamManagerController::class, 'payments'])->name('team.payments');
    Route::post('/payments/{payment}/process', [App\Http\Controllers\TeamManager\TeamManagerController::class, 'processPayment'])->name('team.payments.process');
    
    Route::get('/analytics', [App\Http\Controllers\TeamManager\TeamManagerController::class, 'analytics'])->name('team.analytics');
    
    // Formation Management Routes
    Route::get('/formations', [App\Http\Controllers\TeamManager\FormationController::class, 'index'])->name('team.formations');
    Route::get('/formations/create', [App\Http\Controllers\TeamManager\FormationController::class, 'create'])->name('team.formations.create');
    Route::post('/formations', [App\Http\Controllers\TeamManager\FormationController::class, 'store'])->name('team.formations.store');
    Route::get('/formations/{formation}', [App\Http\Controllers\TeamManager\FormationController::class, 'show'])->name('team.formations.show');
    Route::get('/formations/{formation}/edit', [App\Http\Controllers\TeamManager\FormationController::class, 'edit'])->name('team.formations.edit');
    Route::put('/formations/{formation}', [App\Http\Controllers\TeamManager\FormationController::class, 'update'])->name('team.formations.update');
    Route::delete('/formations/{formation}', [App\Http\Controllers\TeamManager\FormationController::class, 'destroy'])->name('team.formations.destroy');
    Route::post('/formations/{formation}/set-default', [App\Http\Controllers\TeamManager\FormationController::class, 'setDefault'])->name('team.formations.set-default');
});

// Queue trigger routes (for external cron services)
Route::prefix('queue')->group(function () {
    Route::get('/status', [App\Http\Controllers\QueueTriggerController::class, 'status'])->name('queue.status');
    Route::post('/trigger', [App\Http\Controllers\QueueTriggerController::class, 'trigger'])->name('queue.trigger');
});

// System Maintenance Routes (accessible separately from the system)
Route::prefix('system/maintenance')->name('system.maintenance.')->group(function () {
    Route::get('/', [SystemMaintenanceController::class, 'index'])->name('index');
    Route::get('/test-cron', [SystemMaintenanceController::class, 'testCron'])->name('test-cron');
    Route::get('/optimize', [SystemMaintenanceController::class, 'optimize'])->name('optimize');
    Route::get('/full-optimize', [SystemMaintenanceController::class, 'fullOptimize'])->name('full-optimize');
    Route::get('/logs', [SystemMaintenanceController::class, 'viewLogs'])->name('logs');
    Route::post('/clear-cache', [SystemMaintenanceController::class, 'clearCache'])->name('clear-cache');
    Route::post('/test-email', [SystemMaintenanceController::class, 'sendTestEmail'])->name('test-email');
});

// Documentation Routes
Route::get('/documentation/walkthrough', function () {
    return view('documentation.system-walkthrough');
})->name('documentation.walkthrough');

require __DIR__.'/settings.php';
require __DIR__.'/auth.php';
