<?php

use App\Http\Controllers\Settings\PasswordController;
use App\Http\Controllers\Settings\ProfileController;
use App\Http\Controllers\Admin\NotificationSettingsController;
use App\Http\Controllers\User\NotificationPreferencesController;
use Illuminate\Support\Facades\Route;
use Inertia\Inertia;

Route::middleware('auth')->group(function () {
    Route::redirect('settings', '/settings/profile');

    Route::get('settings/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('settings/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('settings/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');

    Route::get('settings/password', [PasswordController::class, 'edit'])->name('password.edit');

    Route::put('settings/password', [PasswordController::class, 'update'])
        ->middleware('throttle:6,1')
        ->name('password.update');

    Route::get('settings/appearance', function () {
        return Inertia::render('settings/appearance');
    })->name('appearance');

    // User notification preferences
    Route::prefix('settings/notifications')->name('notifications.preferences.')->group(function () {
        Route::get('/', [NotificationPreferencesController::class, 'index'])->name('index');
        Route::post('/', [NotificationPreferencesController::class, 'update'])->name('update');
        Route::post('/category/{category}', [NotificationPreferencesController::class, 'toggleCategory'])->name('toggle-category');
        Route::post('/notification/{notificationType}', [NotificationPreferencesController::class, 'toggleNotification'])->name('toggle-notification');
        Route::post('/reset', [NotificationPreferencesController::class, 'reset'])->name('reset');
    });
});

// Admin notification settings
Route::middleware(['auth', 'role:admin,super_admin'])->prefix('admin')->name('admin.')->group(function () {
    Route::prefix('settings/notifications')->name('notifications.')->group(function () {
        Route::get('/', [NotificationSettingsController::class, 'index'])->name('index');
        Route::put('/{setting}', [NotificationSettingsController::class, 'update'])->name('update');
        Route::post('/bulk-update', [NotificationSettingsController::class, 'bulkUpdate'])->name('bulk-update');
        Route::post('/category/{category}/toggle', [NotificationSettingsController::class, 'toggleCategory'])->name('toggle-category');
        Route::post('/sync', [NotificationSettingsController::class, 'sync'])->name('sync');
        Route::get('/stats', [NotificationSettingsController::class, 'stats'])->name('stats');
    });
});
