<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\TournamentController;
use App\Http\Controllers\PlayerController;
use App\Http\Controllers\TeamController;
use App\Http\Controllers\GameMatchController;
use App\Http\Controllers\BracketController;

// Route::apiResource('tournaments', TournamentController::class);
// Route::apiResource('players', PlayerController::class);
// Route::apiResource('teams', TeamController::class);
// Route::apiResource('game-matches', GameMatchController::class);
// Route::apiResource('brackets', BracketController::class);

// Tournament additional routes
Route::get('tournaments/{tournament}/participants', [TournamentController::class, 'participants']);
Route::get('tournaments/{tournament}/matches', [TournamentController::class, 'matches']);
Route::get('tournaments/{tournament}/brackets', [TournamentController::class, 'brackets']);
Route::get('tournaments/{tournament}/statistics', [TournamentController::class, 'statistics']);

// Player additional routes
Route::get('players/{player}/matches', [PlayerController::class, 'matches']);
Route::get('players/{player}/statistics', [PlayerController::class, 'statistics']);
Route::get('players/{player}/tournament-history', [PlayerController::class, 'tournamentHistory']);

// Team additional routes
Route::get('teams/{team}/members', [TeamController::class, 'members']);
Route::post('teams/{team}/members', [TeamController::class, 'addMember']);
Route::delete('teams/{team}/members', [TeamController::class, 'removeMember']);
Route::get('teams/{team}/matches', [TeamController::class, 'matches']);
Route::get('teams/{team}/statistics', [TeamController::class, 'statistics']);
Route::get('teams/{team}/roster', [TeamController::class, 'roster']);

// GameMatch additional routes
Route::post('game-matches/{gameMatch}/start', [GameMatchController::class, 'startMatch']);
Route::patch('game-matches/{gameMatch}/score', [GameMatchController::class, 'updateScore']);
Route::post('game-matches/{gameMatch}/complete', [GameMatchController::class, 'completeMatch']);
Route::get('game-matches/upcoming', [GameMatchController::class, 'upcomingMatches']);
Route::get('game-matches/live', [GameMatchController::class, 'liveMatches']);
Route::get('game-matches/recent', [GameMatchController::class, 'recentMatches']);

// Bracket additional routes
Route::get('brackets/{bracket}/matches', [BracketController::class, 'matches']);
Route::get('brackets/{bracket}/rounds', [BracketController::class, 'rounds']);
Route::post('brackets/{bracket}/generate', [BracketController::class, 'generateBracket']);
Route::post('brackets/{bracket}/advance-round', [BracketController::class, 'advanceRound']);
Route::get('brackets/{bracket}/statistics', [BracketController::class, 'statistics']); 


Route::any('/callback', [App\Http\Controllers\PaymentController::class, 'mpesaCallback'])->name('payment.mpesa.callback');