<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Email Test Results - System Maintenance</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100">
    <div class="min-h-screen py-8">
        <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
            <!-- Header -->
            <div class="bg-white shadow rounded-lg p-6 mb-6">
                <div class="flex justify-between items-center">
                    <div>
                        <h1 class="text-3xl font-bold text-gray-900">📧 Email Test Results</h1>
                        <p class="mt-2 text-gray-600">Email configuration test</p>
                    </div>
                    <a href="{{ route('system.maintenance.index') }}" class="bg-blue-500 hover:bg-blue-600 text-white px-4 py-2 rounded transition">
                        ← Back to Dashboard
                    </a>
                </div>
            </div>

            <!-- Result Status -->
            <div class="bg-{{ $status === 'success' ? 'green' : 'red' }}-100 border border-{{ $status === 'success' ? 'green' : 'red' }}-200 rounded-lg p-6 mb-6">
                <div class="flex items-center">
                    <span class="text-5xl mr-4">{{ $status === 'success' ? '✅' : '❌' }}</span>
                    <div class="flex-1">
                        <div class="text-{{ $status === 'success' ? 'green' : 'red' }}-900 font-bold text-xl">
                            {{ $status === 'success' ? 'Email Sent Successfully!' : 'Email Failed' }}
                        </div>
                        <div class="text-{{ $status === 'success' ? 'green' : 'red' }}-800 mt-2">
                            {{ $message }}
                        </div>
                    </div>
                </div>
            </div>

            <!-- Email Details -->
            <div class="bg-white shadow rounded-lg p-6 mb-6">
                <h2 class="text-2xl font-bold mb-4">📊 Email Configuration</h2>
                <div class="space-y-3">
                    <div class="flex justify-between py-2 border-b">
                        <span class="font-bold">Mail Driver:</span>
                        <span class="font-mono">{{ $mail_driver ?? 'N/A' }}</span>
                    </div>
                    @if(isset($mail_host))
                    <div class="flex justify-between py-2 border-b">
                        <span class="font-bold">SMTP Host:</span>
                        <span class="font-mono">{{ $mail_host }}</span>
                    </div>
                    @endif
                    <div class="flex justify-between py-2 border-b">
                        <span class="font-bold">Execution Time:</span>
                        <span class="font-mono {{ $execution_time > 5 ? 'text-red-600' : 'text-green-600' }}">
                            {{ $execution_time }}s
                            @if($execution_time > 5)
                                <span class="text-xs">(Consider using faster SMTP)</span>
                            @endif
                        </span>
                    </div>
                    <div class="flex justify-between py-2">
                        <span class="font-bold">Status:</span>
                        <span class="font-mono {{ $status === 'success' ? 'text-green-600' : 'text-red-600' }}">
                            {{ strtoupper($status) }}
                        </span>
                    </div>
                </div>
            </div>

            @if($status === 'error')
            <!-- Error Details -->
            <div class="bg-red-50 border border-red-200 rounded-lg p-6 mb-6">
                <h2 class="text-2xl font-bold text-red-900 mb-4">❌ Error Details</h2>
                <div class="bg-red-100 p-4 rounded font-mono text-sm text-red-800">
                    {{ $error }}
                </div>

                <div class="mt-4">
                    <h3 class="font-bold text-red-900 mb-2">Common Solutions:</h3>
                    <ul class="list-disc list-inside space-y-1 text-red-800 text-sm">
                        <li>Check SMTP credentials in .env file</li>
                        <li>Verify MAIL_HOST, MAIL_PORT, MAIL_USERNAME, MAIL_PASSWORD</li>
                        <li>Ensure MAIL_ENCRYPTION is set (tls or ssl)</li>
                        <li>Check if port is blocked by firewall</li>
                        <li>Try using a different mail service (Mailgun, SendGrid)</li>
                    </ul>
                </div>
            </div>
            @endif

            <!-- Speed Recommendations -->
            <div class="bg-blue-50 border border-blue-200 rounded-lg p-6">
                <h2 class="text-2xl font-bold text-blue-900 mb-4">⚡ Speed Recommendations</h2>
                
                @if($execution_time > 5)
                <div class="bg-yellow-100 border border-yellow-300 rounded p-4 mb-4">
                    <p class="text-yellow-900 font-bold">⚠️ Email sending is slow ({{ $execution_time }}s)</p>
                    <p class="text-yellow-800 text-sm mt-2">Consider switching to a faster mail service:</p>
                </div>
                @endif

                <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                    <div class="bg-white p-4 rounded border-2 {{ $execution_time < 2 ? 'border-green-500' : 'border-gray-200' }}">
                        <div class="font-bold text-green-900">Mailgun</div>
                        <div class="text-2xl font-bold text-green-600 my-2">< 1s</div>
                        <div class="text-sm text-gray-600">Fastest option</div>
                        <div class="text-sm text-green-600 mt-2">Free: 5,000/month</div>
                    </div>
                    <div class="bg-white p-4 rounded border-2 {{ $execution_time >= 2 && $execution_time < 4 ? 'border-green-500' : 'border-gray-200' }}">
                        <div class="font-bold text-blue-900">SendGrid</div>
                        <div class="text-2xl font-bold text-blue-600 my-2">1-2s</div>
                        <div class="text-sm text-gray-600">Very fast</div>
                        <div class="text-sm text-blue-600 mt-2">Free: 100/day</div>
                    </div>
                    <div class="bg-white p-4 rounded border-2 {{ $execution_time >= 4 ? 'border-yellow-500' : 'border-gray-200' }}">
                        <div class="font-bold text-yellow-900">Gmail SMTP</div>
                        <div class="text-2xl font-bold text-yellow-600 my-2">4-6s</div>
                        <div class="text-sm text-gray-600">Slower but free</div>
                        <div class="text-sm text-yellow-600 mt-2">Limit: 500/day</div>
                    </div>
                </div>

                <div class="mt-4 text-sm text-blue-800">
                    <p class="font-bold">Full optimization guide: EMAIL_OPTIMIZATION.md</p>
                </div>
            </div>

            <!-- Actions -->
            <div class="mt-6 flex gap-4">
                <a href="{{ route('system.maintenance.index') }}" class="bg-gray-500 hover:bg-gray-600 text-white px-6 py-3 rounded transition">
                    🏠 Back to Dashboard
                </a>
                <form action="{{ route('system.maintenance.test-email') }}" method="POST" class="inline">
                    @csrf
                    <button type="submit" class="bg-blue-500 hover:bg-blue-600 text-white px-6 py-3 rounded transition">
                        🔄 Send Another Test
                    </button>
                </form>
            </div>
        </div>
    </div>
</body>
</html>

