<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Quick Optimization - System Maintenance</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100">
    <div class="min-h-screen py-8">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <!-- Header -->
            <div class="bg-white shadow rounded-lg p-6 mb-6">
                <div class="flex justify-between items-center">
                    <div>
                        <h1 class="text-3xl font-bold text-gray-900">⚡ Quick Optimization Results</h1>
                        <p class="mt-2 text-gray-600">Completed at {{ $timestamp }}</p>
                    </div>
                    <a href="{{ route('system.maintenance.index') }}" class="bg-blue-500 hover:bg-blue-600 text-white px-4 py-2 rounded transition">
                        ← Back to Dashboard
                    </a>
                </div>
            </div>

            <!-- Summary -->
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-6">
                <div class="bg-green-100 rounded-lg p-6">
                    <div class="text-green-800 text-sm font-bold">Steps Completed</div>
                    <div class="text-3xl font-bold text-green-900 mt-2">
                        {{ collect($steps)->where('status', 'success')->count() }} / {{ count($steps) }}
                    </div>
                </div>
                <div class="bg-blue-100 rounded-lg p-6">
                    <div class="text-blue-800 text-sm font-bold">Execution Time</div>
                    <div class="text-3xl font-bold text-blue-900 mt-2">
                        {{ $executionTime }}s
                    </div>
                </div>
            </div>

            <!-- Optimization Steps -->
            <div class="bg-white shadow rounded-lg p-6 mb-6">
                <h2 class="text-2xl font-bold mb-4">🔧 Optimization Steps</h2>
                <div class="space-y-3">
                    @foreach($steps as $step)
                    <div class="flex items-center justify-between p-4 rounded border {{ 
                        $step['status'] === 'success' ? 'bg-green-50 border-green-200' : 
                        ($step['status'] === 'warning' ? 'bg-yellow-50 border-yellow-200' : 'bg-red-50 border-red-200') 
                    }}">
                        <div class="flex items-center flex-1">
                            <span class="text-2xl mr-3">
                                @if($step['status'] === 'success') ✅ @elseif($step['status'] === 'warning') ⚠️ @else ❌ @endif
                            </span>
                            <div>
                                <div class="font-bold {{ 
                                    $step['status'] === 'success' ? 'text-green-900' : 
                                    ($step['status'] === 'warning' ? 'text-yellow-900' : 'text-red-900') 
                                }}">
                                    {{ $step['step'] }}
                                </div>
                                <div class="text-sm {{ 
                                    $step['status'] === 'success' ? 'text-green-700' : 
                                    ($step['status'] === 'warning' ? 'text-yellow-700' : 'text-red-700') 
                                }}">
                                    {{ $step['output'] }}
                                </div>
                            </div>
                        </div>
                        <span class="px-3 py-1 rounded text-xs font-bold {{ 
                            $step['status'] === 'success' ? 'bg-green-200 text-green-800' : 
                            ($step['status'] === 'warning' ? 'bg-yellow-200 text-yellow-800' : 'bg-red-200 text-red-800') 
                        }}">
                            {{ strtoupper($step['status']) }}
                        </span>
                    </div>
                    @endforeach
                </div>
            </div>

            <!-- Next Steps -->
            <div class="bg-blue-50 border border-blue-200 rounded-lg p-6 mb-6">
                <h2 class="text-2xl font-bold text-blue-900 mb-4">📝 What Was Optimized</h2>
                <ul class="list-disc list-inside space-y-2 text-blue-800">
                    <li>Application cache cleared and recached</li>
                    <li>Configuration files cached for faster access (10-15ms per request)</li>
                    <li>Routes cached for faster routing (15-20ms per request)</li>
                    <li>Views compiled for faster rendering (20-30ms per request)</li>
                    <li>Composer autoloader optimized (5-10ms per request)</li>
                    <li>Queue workers signaled to restart</li>
                </ul>
            </div>

            <!-- Performance Tips -->
            <div class="bg-yellow-50 border border-yellow-200 rounded-lg p-6">
                <h2 class="text-2xl font-bold text-yellow-900 mb-4">💡 Performance Tips</h2>
                <ul class="list-disc list-inside space-y-2 text-yellow-800">
                    <li>Use Redis for cache and sessions (set CACHE_DRIVER=redis)</li>
                    <li>Enable OPcache in PHP for 3-5x faster execution</li>
                    <li>Enable GZIP compression on your web server</li>
                    <li>Use CDN for static assets</li>
                    <li>Run optimization after each deployment</li>
                </ul>
            </div>

            <!-- Actions -->
            <div class="mt-6 flex gap-4">
                <a href="{{ route('system.maintenance.optimize') }}" class="bg-green-500 hover:bg-green-600 text-white px-6 py-3 rounded transition">
                    🔄 Optimize Again
                </a>
                <a href="{{ route('system.maintenance.full-optimize') }}" class="bg-purple-500 hover:bg-purple-600 text-white px-6 py-3 rounded transition">
                    🚀 Run Full Optimization
                </a>
                <a href="{{ route('system.maintenance.index') }}" class="bg-gray-500 hover:bg-gray-600 text-white px-6 py-3 rounded transition">
                    🏠 Back to Dashboard
                </a>
            </div>
        </div>
    </div>
</body>
</html>

