<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Digital IDs - Multiple Players</title>

    <!-- count number of players and set the number of rows and columns Each player has two columns -->
    <style>
        .multi-player-container {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            grid-template-rows: repeat({{ $rows ?? 1 }}, 1fr);
            gap: 10px;
            margin: 0 auto;
            page-break-inside: avoid;
        }

        /* Print styles */
        @media print {
            body {
                background: white;
                padding: 0;
            }
            
            .multi-player-container {
                gap: 10px;
                max-width: none;
                width: 100%;
            }
        }

        /* Responsive adjustments */
        @media (max-width: 768px) {
            .multi-player-container {
                grid-template-columns: 1fr;
                gap: 20px;
            }
        }
    </style>
</head>
<body>
    @php 
        if (!isset($players) || empty($players)) {
            $players = [
                [
                    'name' => $player_name ?? 'Victor Kipkoech',
                    'email' => $player_email ?? 'th@gmail.com',
                    'phone' => $player_phone ?? '0718258849',
                    'type' => $player_type ?? 'Amateur',
                    'tournament' => $tournament_edition ?? '1st Edition',
                    'verification_status' => $verification_status ?? 'Pending',
                    'registration_status' => $registration_status ?? 'Registered',
                    'id' => $player_id ?? '001',
                    'tournament_year' => $tournament_year ?? '2025',
                    'generated' => $generated_date ?? 'September 20, 2025',
                    'valid_until' => $valid_until_date ?? 'September 20, 2027',
                    'barcode' => $barcode_text ?? 'ID-' . ($player_id ?? '001') . '-' . ($tournament_year ?? '2025'),
                    'digital_id' => $digital_id ?? 'PID-000001-D0AE7056',
                    'validity_period' => $validity_period ?? '2 Years',
                    'registration' => $registration ?? 'Aug 14, 2025',
                    'photo' => $photo ?? asset('player.jpg'),
                ]            
            ];
        }
    @endphp
    <div class="multi-player-container">
            @foreach ($players as $player)
                <table style="width: 100%;">
                    <tr>
                        <td style="width: 45%; margin: auto 0;">
                            @include('players.id-front',['player' => $player])
                        </td>
                        <td style="width: 45%; margin: auto 0;">
                            @include('players.id-back',['player' => $player])
                        </td>
                    </tr>
                </table>
            @endforeach
    </div>
</body>
</html>
