
    <style>
       
        .id-front-card-container {
            width: 400px;
            height: 582px; /* 400 * 3.64 / 2.5 = 582px to maintain aspect ratio */
            position: relative;
            background-image: url("{{ asset('id-front.jpg') }}");
            background-size: 400px 582px;
            background-position: center;
            background-repeat: no-repeat;
        }  

        .tournament-text {
            color: #ffffff;
            text-shadow: 1px 1px 2px rgba(0, 0, 0, 0.5);
        }

        .tournament-title {
            font-size: 12px;
            font-weight: 700;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            margin-bottom: 2px;
        }

        .tournament-subtitle {
            font-size: 10px;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.3px;
            margin-bottom: 2px;
        }

        .tournament-motto {
            font-size: 8px;
            font-weight: 400;
            text-transform: uppercase;
            letter-spacing: 0.2px;
            color: #d52f20;
        }

        /* Photo placeholder */
        .photo-section {
            position: absolute;
            top: 137px;
            left: 35%;
            right: 45%;
            z-index: 3;
        }

  

        .photo-placeholder img {
            width: 127px;
            height: 127px;
        }

        .photo-placeholder::after {
            content: '';
            position: absolute;
            font-size: 24px;
            color: #cccccc;
            opacity: 0.7;
        }

        /* Player information section */
        .player-info-section {
            position: absolute;
            top: 266px;
            left: 10px;
            right: 6px;
            z-index: 3;
        }

        .player-name {
            font-family: 'Segoe UI', serif;
            font-size: 20px;
            font-weight: 700;
            color: #2d3748;
            text-align: center;
            margin-bottom: 20px;
            text-shadow: 1px 1px 2px rgba(255, 255, 255, 0.8);
        }

    

        .detail-row {
            width: 100%;
            margin-bottom: 8px;
            font-size: 17px;
            clear: both;
        }
        
        .detail-row:after {
            content: "";
            display: table;
            clear: both;
        }

        .detail-row:last-child {
            margin-bottom: 0;
        }

        .detail-label {
            font-weight: 600;
            color: #4a5568;
            display: inline-block;
            width: 38%;
            vertical-align: top;
        }

        .detail-value {
            color: #2d3748;
            text-align: right;
            display: inline-block;
            width: 58%;
            vertical-align: top;
        }

        .status-pending {
            color: #e53e3e;
            font-weight: 600;
        }

        .status-registered {
            color: #38a169;
            font-weight: 600;
        }

        /* Barcode section */
        .barcode-section {
            position: absolute;
            bottom: 44px;
            left: 50%;
            transform: translateX(-50%);
            z-index: 3;
            text-align: center;
        }

        .barcode {
            width: 200px;
            height: 40px;
            background: #2d3748;
            position: relative;
            overflow: hidden;
            background-image: repeating-linear-gradient(
                90deg,
                #ffffff 0px,
                #ffffff 2px,
                #2d3748 2px,
                #2d3748 4px
            );
        }

        .barcode-text {
            font-size: 10px;
            color: #4a5568;
            font-weight: 600;
        }

        /* Footer section */
        .footer-section {
            position: absolute;
            bottom: 6px;
            left: 10px;
            right: 10px;
            z-index: 3;
        }

        .footer-dates {
            position: absolute;
            width: 100%;
            font-size: 12px;
            color: #4a5568;
            overflow: hidden;
            
        }

        .date-item-left {
            display: inline-block;
            margin-bottom: 5px;
            vertical-align: top;
        }

        .date-item-right {
            display: inline-block;
            margin-bottom: 5px;
            vertical-align: top;
        }

        .date-label {
            font-weight: 600;
            margin-bottom: 2px;
        }

        .date-value {
            color: #2d3748;
        }

        .valid-until-label {
            color: #206633;
            font-weight: 700;
        }    

        .corner-decoration.top-left {
            top: 10px;
            left: 10px;
        }

        .corner-decoration.top-right {
            top: 10px;
            right: 10px;
        }

        .corner-decoration.bottom-left {
            bottom: 10px;
            left: 10px;
        }

        .corner-decoration.bottom-right {
            bottom: 10px;
            right: 10px;
        }

        /* Print styles */
        @media print {
            body {
                background: white;
                padding: 0;
            }
            
            .id-front-card-container {
                box-shadow: none;
                border-radius: 0;
                width: 100%;
                height: 100vh;
            }
        }

        /* Responsive adjustments */
        @media (max-width: 480px) {
            .id-front-card-container {
                max-width: 350px;
            }
            
            .player-info-section {
                left: 15px;
                right: 15px;
            }
            
            .footer-section {
                left: 15px;
                right: 15px;
            }
        }

        @media (max-width: 360px) {
            .id-front-card-container {
                max-width: 320px;
            }
            
            .player-name {
                font-size: 18px;
            }
            
            .detail-row {
                font-size: 11px;
            }
        }
    </style>

    <div class="id-front-card-container">
        

        <!-- Header section over background image -->
  

        <!-- Photo placeholder -->
        <div class="photo-section">
            <div class="photo-placeholder">
                @if(isset($player['photo']) && $player['photo'])
                    <img src="{{ $player['photo'] }}" alt="{{ $player['photo'] }}">
                @else
                    <img src="{{ asset('player.jpg') }}">
                @endif
            </div>
        </div>

        <!-- Player information section -->
        <div class="player-info-section">
            <div class="player-name">{{ $player['name'] ?? 'Victor Kipkoech' }}</div>
            
            <div class="player-details">
                <div class="detail-row">
                    <span class="detail-label">Tournament:</span>
                    <span class="detail-value">{{ $player['tournament'] ?? '1st Edition' }}</span>
                </div>
                <div class="detail-row">
                    <span class="detail-label">Email:</span>
                    <span class="detail-value">{{ $player['email'] ?? 'kivoech@gmail.com' }}</span>
                </div>
                <div class="detail-row">
                    <span class="detail-label">Phone:</span>
                    <span class="detail-value">{{ $player['phone'] ?? '07182588 49' }}</span>
                </div>
                <div class="detail-row">
                    <span class="detail-label">Player Type:</span>
                    <span class="detail-value">{{ $player['type'] ?? 'Amateur' }}</span>
                </div>
                <div class="detail-row">
                    <span class="detail-label">Verification:</span>
                    <span class="detail-value status-pending">{{ $player['verification_status'] ?? 'Pending' }}</span>
                </div>
                <!-- <div class="detail-row">
                    <span class="detail-label">Status:</span>
                    <span class="detail-value status-registered">{{ $player['registration_status'] ?? 'Registered' }}</span>
                </div> -->
            </div>
        </div>

        <!-- Barcode section -->
        <div class="barcode-section">
            <div class="barcode"></div>
            <div class="barcode-text">{{ $player['barcode'] ?? 'ID-' . ($player['id'] ?? '001') . '-' . ($player['tournament_year'] ?? '2025') }}</div>
        </div>

        <!-- Footer section -->
     
        <div class="footer-section">
            <table style="width: 100%;">
                <tr>
                    <td style="text-align: left;">Generated:<br><strong style="color: #d52f20;">{{ $player['generated'] ?? 'September 20, 2025' }}</strong></td>
                    <td style="text-align: right;">Valid Until: <br><strong style="color: #2b672f;">{{ $player['valid_until'] ?? 'September 20, 2027' }}</strong></td>
                </tr>
            </table>               
        </div>
    </div>

