
    <style>

        .id-back-card-container {
            width: 400px;
            height: 582px; /* 400 * 3.64 / 2.5 = 582px to maintain aspect ratio */
            position: relative;
            background-image: url("{{ asset('id-back.jpg') }}");
            background-size: 400px 582px;
            background-position: center;
            background-repeat: no-repeat;
            
        }

        /* Tournament Info Section */
        .tournament-info-section {
            position: absolute;
            top: 10px;
            left: 10px;
            right: 6px;
            z-index: 3;
        }

        .section-heading {
            font-size: 16px;
            font-weight: 700;
            margin-bottom: 15px;
            text-transform: uppercase;
            letter-spacing: 1px;
        }

        .tournament-info-heading {
            color: #8B4513; /* Reddish-brown color */
        }

        .security-features-heading {
            color: #206633; /* Dark green color */
            margin-top: 25px;
        }

        .info-grid {
            width: 100%;
        }

        .info-row {
            width: 100%;
            margin-bottom: 8px;
            font-size: 14px;
            clear: both;
        }
        
        .info-row:after {
            content: "";
            display: table;
            clear: both;
        }

        .info-label {
            font-weight: 600;
            color: #2d3748;
            display: inline-block;
            width: 48%;
            vertical-align: top;
        }

        .info-value {
            color: #4a5568;
            font-weight: 400;
            display: inline-block;
            width: 50%;
            text-align: right;
            vertical-align: top;
        }

        /* QR Code Section */
        .qr-section {
            position: absolute;
            bottom: 31px;
            left: 44px;
            z-index: 3;
        }

        .qr-code {
            width: 124px;
            height: 124px;
            background: #ffffff;
            border: 2px solid #2d3748;
            text-align: center;
            padding: 0;
        }

        .qr-code img {
            width: 120px;
            height: 120px;
            margin: 2px;
        }

        .qr-placeholder {
            
        }

        /* Tournament Branding Section */
        .tournament-branding {
            position: absolute;
            bottom: 30px;
            right: 30px;
            z-index: 3;
            text-align: center;
        }

        .tournament-logo {
            width: 60px;
            height: 60px;
            background: #ffffff;
            border: 2px solid #e0e0e0;
            text-align: center;
            margin: 0 auto 10px;
            padding: 7px;
        }

        .tournament-logo img {
            width: 45px;
            height: 45px;
        }

        .tournament-text {
            color: #ffffff;
            text-shadow: 1px 1px 2px rgba(0, 0, 0, 0.5);
        }

        .tournament-name {
            font-size: 14px;
            font-weight: 700;
            text-transform: uppercase;
            letter-spacing: 1px;
            margin-bottom: 4px;
        }

        .tournament-subtitle {
            font-size: 10px;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            margin-bottom: 4px;
        }

        .tournament-motto {
            font-size: 8px;
            font-weight: 400;
            text-transform: uppercase;
            letter-spacing: 0.3px;
            color: #d52f20;
        }

        /* Print styles */
        @media print {
            body {
                background: white;
                padding: 0;
            }
            
            .id-back-card-container {
                box-shadow: none;
                border-radius: 0;
                width: 100%;
                height: 100vh;
            }
        }

        /* Responsive adjustments */
        @media (max-width: 480px) {
            .id-back-card-container {
                max-width: 350px;
            }
            
            .tournament-info-section {
                left: 15px;
                right: 15px;
            }
            
            .qr-section {
                left: 20px;
                bottom: 30px;
            }
            
            .tournament-branding {
                right: 20px;
                bottom: 20px;
            }
        }

        @media (max-width: 360px) {
            .id-back-card-container {
                max-width: 320px;
            }
            
            .section-heading {
                font-size: 14px;
            }
            
            .info-row {
                font-size: 12px;
            }
            
            .qr-code {
                width: 70px;
                height: 70px;
            }
            
            .tournament-logo {
                width: 50px;
                height: 50px;
            }
            
            .tournament-logo img {
                width: 35px;
                height: 35px;
            }
        }
    </style>
    <div class="id-back-card-container">
        <!-- Tournament Info Section -->
        <div class="tournament-info-section">
            <div class="section-heading tournament-info-heading">Tournament Info</div>
            <div class="info-grid">
                <div class="info-row">
                    <span class="info-label">Tournament:</span>
                    <span class="info-value">{{ $player['tournament'] ?? '1st Edition' }}</span>
                </div>
                <div class="info-row">
                    <span class="info-label">Registration:</span>
                    <span class="info-value">{{ $player['registration'] ?? 'Aug 14, 2025' }}</span>
                </div>
                <div class="info-row">
                    <span class="info-label">Player ID:</span>
                    <span class="info-value">{{ $player['id'] ?? '3' }}</span>
                </div>
                <div class="info-row">
                    <span class="info-label">Digital ID:</span>
                    <span class="info-value">{{ $player['digital_id'] ?? 'PID-000003-D0AE7056' }}</span>
                </div>
                <div class="info-row">
                    <span class="info-label">Validity:</span>
                    <span class="info-value">{{ $player['validity_period'] ?? '2 Years' }}</span>
                </div>
            </div>

            <div class="section-heading security-features-heading">Security Features</div>
            <div class="info-grid">
                <div class="info-row">
                    <span class="info-label">Unique Identifier:</span>
                    <span class="info-value">Each ID is globally unique</span>
                </div>
                <div class="info-row">
                    <span class="info-label">QR Verification:</span>
                    <span class="info-value">Verify authenticity via QR</span>
                </div>
                <div class="info-row">
                    <span class="info-label">Encrypted Data:</span>
                    <span class="info-value">Secure data at rest and in transit</span>
                </div>
                <div class="info-row">
                    <span class="info-label">Validation:</span>
                    <span class="info-value">Real-time validation on scan</span>
                </div>
            </div>
        </div>

        <!-- QR Code Section -->
        <div class="qr-section">
            <div class="qr-code">
                @if(isset($qr_code) && $qr_code)
                    <img src="{{ $qr_code }}" alt="QR Code" />
                @else
                    <div class="qr-placeholder"></div>
                @endif
            </div>
        </div>        
    </div>