<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Certificate of Participation - {{ $player_name ?? $team_name ?? 'Participant' }}</title>
    <style>       

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Montserrat-Regular', Arial, sans-serif;
            margin: 0;
            padding: 0;
            background-color: #f5f5f5;
        }

        .certificate-container {
            width: 100%; /* A4 landscape width */
            height: 100%; /* A4 landscape height */
            position: relative;
            background-image: url("{{ asset('Certificate.jpg') }}");
            background-size: cover;
            background-position: center;
            background-repeat: no-repeat;
            overflow: hidden;
            margin: 0 auto;
        }

        /* Text overlay styles */
        .text-overlay {
            position: absolute;
            width: 100%;
            height: 100%;
            z-index: 10;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
        }

        /* Main content area */
        .main-content {
            position: absolute;
            top: 70%; /* 350px / 595px = 58.8% */
            left: 50%;
            transform: translate(-50%, -50%);
            text-align: center;
            width: 85%;
            max-width: 600px;
        }


        /* Player name */
        .recipient-name {
            font-family: 'Segoe UI', cursive;
            font-size: 36px;
            color: #2b672f;
            font-weight: bold;
            margin: 15px 0;
            text-shadow: 2px 2px 4px rgba(255, 255, 255, 0.8);
            line-height: 1.1;
        }

        /* Team name (if provided) */
        .team-name {
            font-family: 'Montserrat-SemiBold', sans-serif;
            font-size: 16px;
            color: #4f585a;
            margin: 8px 0;
            text-shadow: 1px 1px 2px rgba(255, 255, 255, 0.8);
        }

        /* Description text */
        .description-text {
            font-family: 'Segoe UI', sans-serif;
            font-size: 14px;
            color: #4f585a;
            line-height: 1.6;
            margin: 20px 0;
            text-shadow: 1px 1px 2px rgba(255, 255, 255, 0.8);
            max-width: 500px;
            margin-left: auto;
            margin-right: auto;
        }

        /* QR Code section */
        .qr-section {
            position: absolute;
            bottom: 20.2%; /* 120px / 595px = 20.2% */
            left: 50%;
            transform: translateX(-50%);
            text-align: center;
            z-index: 15;
        }

        .qr-code {
            width: 80px;
            height: 80px;
            background: white;
            border: 2px solid #ddd;
            border-radius: 8px;
            padding: 5px;
            margin-bottom: 8px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
        }

        .qr-code img {
            width: 100%;
            height: 100%;
            object-fit: contain;
        }

        .qr-text {
            font-family: 'Montserrat-Regular', sans-serif;
            font-size: 10px;
            color: #666666;
            text-shadow: 1px 1px 2px rgba(255, 255, 255, 0.8);
        }

        /* Footer section */
        .footer-section {
            position: absolute;
            bottom: 40px; /* 6.7% of 595px */
            width: 100%;
            display: flex;
            justify-content: space-between;
            padding: 0 60px;
            z-index: 15;
        }

        .certificate-id-text, .generated-date-text {
            font-family: 'Montserrat-Regular', sans-serif;
            float: left;
            font-size: 12px;
            line-height: 1.4;
            text-shadow: 1px 1px 2px rgba(255, 255, 255, 0.8);
        }

        .certificate-id-label {
            font-family: 'Montserrat-Bold', sans-serif;          
            color: #d52f20;
            font-weight: 700;
        }

        .certificate-id-value {
            font-family: 'Montserrat-Regular', sans-serif;         
            color: #50585a;
        }

        .generated-date-label {
            font-family: 'Montserrat-Bold', sans-serif;
            color: #2b672f;
            font-weight: 700;
        }

        .generated-date-value {
            font-family: 'Montserrat-Regular', sans-serif;          
            color: #50585a;
        }

        /* Print styles for PDF generation */
        @media print {
            body {
                background: white;
                padding: 0;
                margin: 0;
            }
            
            .certificate-container {
                width: 100%;
                height: 100vh;
            }
        }
    </style>
</head>
<body>
    <div class="certificate-container">
        <div class="text-overlay">
                        
            <!-- Main Content -->
            <div class="main-content">                
                <h2 class="recipient-name">{{ $player_name ?? $team_name ?? 'Participant Name' }}</h2>
                @if(isset($team_name) && $team_name && !isset($player_name))
                    <div class="team-name">Team Certificate</div>
                @elseif(isset($team_name) && $team_name && isset($player_name))
                    <div class="team-name">{{ $team_name }}</div>
                @endif
                <p class="description-text">
                    {{ $description ?? 'This certificate is awarded for participation in The Milimus Tournament.' }}
                </p>
            </div>
            
            <!-- QR Code Section - HIDDEN -->
            <div class="qr-section" style="display: none;">
                <div class="qr-code">
                    <img src="{{ $qr_code_url ?? 'https://api.qrserver.com/v1/create-qr-code/?size=100x100&data=Certificate' }}" alt="QR Code" />
                </div>
                <div class="qr-text">Certificate Verification</div>
            </div>

            <div class="footer-section">
                <table style="width: 100%;">
                    <tr>
                        <td>
                        Certificate ID: <strong style="color: #d52f20;">{{ $digital_id ?? 'CERT-000075-770DE884' }}</strong>
                        </td>
                        <td>
                        Generated on: <strong style="color: #2b672f;">{{ $issued_date ?? now()->format('F j, Y') }}</strong>
                        </td>
                    </tr>
                </table>               
            </div>
        </div>
    </div>
</body>
</html>