@extends('emails.layouts.modern')

@section('title', 'Player Registration - Email Verification')

@section('header-title', 'Email Verification')
@section('header-subtitle', 'Complete Your Player Registration')

@section('content')
    <div class="content-section">
        <h2 class="section-title">Hello {{ $player->name }}! 👋</h2>
        <p class="section-text">
            Congratulations! You have been successfully registered as a player for <strong>{{ $team->name }}</strong> in the Milimus Tournament.
        </p>
    </div>

    <div class="info-box">
        <div class="info-box-content">
            <h3 class="info-title">Your Team Details</h3>
            <div class="info-text">
                <strong>Team:</strong> {{ $team->name }}<br>
                <strong>Position:</strong> {{ $player->football_position }}<br>
                @if($player->jersey_number)
                <strong>Jersey Number:</strong> {{ $player->jersey_number }}<br>
                @endif
                @if($player->is_team_captain)
                <strong>Role:</strong> <span style="color: #dc2626; font-weight: 600;">Team Captain</span>
                @endif
            </div>
        </div>
    </div>

    <div class="content-section">
        <h3 class="section-title">Verify Your Email Address</h3>
        <p class="section-text">
            To complete your registration and participate in the tournament, please verify your email address using the OTP code below:
        </p>
        
        <div class="otp-container">
            <div class="otp-code">{{ $otp }}</div>
        </div>
        
        <p class="section-text" style="text-align: center; font-size: 14px; color: #6b7280;">
            Enter this code in the verification form to activate your account
        </p>
    </div>

    <div class="warning-box">
        <h4 style="color: #92400e; margin: 0 0 10px 0; font-weight: 600;">⚠️ Important Information</h4>
        <ul class="styled-list" style="margin: 0;">
            <li style="color: #92400e;">This OTP code will expire in <strong>24 hours</strong></li>
            <li style="color: #92400e;">Email verification is <strong>mandatory</strong> to participate in the tournament</li>
            <li style="color: #92400e;">You will receive login credentials after successful verification</li>
            <li style="color: #92400e;">Password change will be required on your first login</li>
        </ul>
    </div>

    <div class="content-section">
        <h3 class="section-title">What's Next?</h3>
        <ul class="styled-list">
            <li>Verify your email using the OTP code above</li>
            <li>Check your email for login credentials</li>
            <li>Log in to your player portal</li>
            <li>Complete your player profile</li>
            <li>Stay updated on tournament schedules and announcements</li>
        </ul>
    </div>

    <div class="content-section" style="text-align: center; margin-top: 40px;">
        <p class="section-text" style="color: #6b7280; font-size: 14px;">
            If you did not expect this email or believe it was sent in error, please contact the tournament organizers immediately at 
            <a href="tel:0729565643" style="color: #16a34a; text-decoration: none;">0729565643</a>
        </p>
    </div>
@endsection