@component('mail::message')
# Verification Code - Team Official

Hello **{{ $official->name }}**,

Here is your verification code to complete your team official assignment for **{{ $team->name }}**.

@component('mail::panel')
## Your Verification Code

**{{ $otp }}**

This code will expire on {{ $expiresAt->format('F j, Y \a\t g:i A T') }}
@endcomponent

## How to Verify

1. Click the verification button below
2. Enter the 6-digit code: **{{ $otp }}**
3. Complete your profile setup

@component('mail::button', ['url' => $verificationUrl])
Verify Now
@endcomponent

## Security Notice

- This code is valid for 24 hours only
- Do not share this code with anyone
- If you didn't request this verification, please ignore this email
- For security reasons, you can only use this code once

## Assignment Details

- **Team:** {{ $team->name }}
- **Your Role:** {{ ucfirst($official->role) }}
- **Assignment Date:** {{ $official->created_at->format('F j, Y') }}

If you need assistance or have questions about your assignment, please contact our support team.

Thanks,<br>
{{ config('app.name') }} Team
@endcomponent