@extends('emails.layouts.modern')

@section('title', 'Official Registration - Email Verification')

@section('header-title', 'Official Verification')
@section('header-subtitle', 'Complete Your Official Registration')

@section('content')
    <div class="content-section">
        <h2 class="section-title">Welcome {{ $official->name }}! 🏆</h2>
        <p class="section-text">
            You have been registered as a team official for <strong>{{ $team->name }}</strong> in the Milimus Tournament. Your expertise and leadership are valued in making this tournament a success.
        </p>
    </div>

    <div class="info-box">
        <div class="info-box-content">
            <h3 class="info-title">Your Official Details</h3>
            <div class="info-text">
                <strong>Team:</strong> {{ $team->name }}<br>
                <strong>Role:</strong> {{ $official->role }}<br>
                @if($official->qualifications)
                <strong>Qualifications:</strong> {{ $official->qualifications }}<br>
                @endif
                <strong>Contact:</strong> {{ $official->phone }}
            </div>
        </div>
    </div>

    <div class="content-section">
        <h3 class="section-title">Verify Your Email Address</h3>
        <p class="section-text">
            To complete your registration and access the official's portal, please verify your email address using the OTP code below:
        </p>
        
        <div class="otp-container">
            <div class="otp-code">{{ $otp }}</div>
        </div>
        
        <p class="section-text" style="text-align: center; font-size: 14px; color: #6b7280;">
            Enter this code in the verification form to activate your official account
        </p>
    </div>

    <div class="warning-box">
        <h4 style="color: #92400e; margin: 0 0 10px 0; font-weight: 600;">⚠️ Official Responsibilities</h4>
        <ul class="styled-list" style="margin: 0;">
            <li style="color: #92400e;">This OTP code expires in <strong>24 hours</strong></li>
            <li style="color: #92400e;">Email verification is required to access official tools</li>
            <li style="color: #92400e;">You'll receive secure login credentials after verification</li>
            <li style="color: #92400e;">Password change required on first login for security</li>
        </ul>
    </div>

    <div class="content-section">
        <h3 class="section-title">Your Official Access Includes</h3>
        <ul class="styled-list">
            <li>Team management dashboard</li>
            <li>Player roster and statistics</li>
            <li>Match schedules and updates</li>
            <li>Tournament announcements</li>
            <li>Communication tools</li>
            <li>Certificate and awards tracking</li>
        </ul>
    </div>

    <div class="info-box" style="background: linear-gradient(135deg, #f0fdf4 0%, #dcfce7 100%); border-color: #22c55e;">
        <div class="info-box-content">
            <h3 class="info-title" style="color: #15803d;">🎯 Tournament Mission</h3>
            <p class="info-text" style="color: #166534;">
                As an official, you play a crucial role in our mission to develop community football, 
                support youth talent, and create lasting positive impact in our village. Thank you for 
                being part of this meaningful journey.
            </p>
        </div>
    </div>

    <div class="content-section" style="text-align: center; margin-top: 40px;">
        <p class="section-text" style="color: #6b7280; font-size: 14px;">
            Questions about your official role? Contact Tournament Director Fadhili Milimu at 
            <a href="tel:0729565643" style="color: #16a34a; text-decoration: none; font-weight: 600;">0729565643</a>
        </p>
    </div>
@endsection