<!-- Team Management Documentation -->

<div class="section-card">
    <h2 class="text-4xl font-bold mb-6">👥 Team Management Workflow</h2>
    
    <div class="bg-blue-50 border-l-4 border-blue-500 p-6 rounded-r-lg mb-6">
        <p class="text-lg text-blue-900 font-semibold">📖 What You'll Learn</p>
        <ul class="mt-3 space-y-2 text-blue-800">
            <li>✅ Managing team information and settings after registration</li>
            <li>✅ Adding and removing team members</li>
            <li>✅ Manager assignment and transfer process</li>
            <li>✅ Team status lifecycle and transitions</li>
            <li>✅ Player roster management and max players</li>
            <li>✅ All notifications sent during team management events</li>
        </ul>
    </div>
</div>

<!-- Overview -->
<div class="section-card">
    <h3 class="text-2xl font-bold mb-4 flex items-center">
        <span class="step-number">1</span>
        Overview
    </h3>
    
    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
        <div>
            <h4 class="font-bold text-lg mb-3 text-blue-600">👥 What is Team Management?</h4>
            <p class="text-gray-700 leading-relaxed">
                Team management handles all operations related to existing teams including updating team information, 
                managing members, changing captains, controlling team status, and maintaining player rosters throughout 
                the team's participation in tournaments.
            </p>
        </div>

        <div>
            <h4 class="font-bold text-lg mb-3 text-green-600">👥 Who Can Manage Teams?</h4>
            <ul class="space-y-2 text-gray-700">
                <li class="flex items-start">
                    <span class="text-green-500 mr-2">•</span>
                    <span><strong>Team Manager:</strong> Full team management access</span>
                </li>
                <li class="flex items-start">
                    <span class="text-green-500 mr-2">•</span>
                    <span><strong>Team Manager:</strong> Designated team administrators</span>
                </li>
                <li class="flex items-start">
                    <span class="text-green-500 mr-2">•</span>
                    <span><strong>Admins/Organizers:</strong> Can manage all teams</span>
                </li>
            </ul>
        </div>

        <div>
            <h4 class="font-bold text-lg mb-3 text-purple-600">⚙️ Management Operations</h4>
            <ul class="space-y-2 text-gray-700">
                <li class="flex items-start">
                    <span class="text-purple-500 mr-2">•</span>
                    <span>Update team info (name, description, logo)</span>
                </li>
                <li class="flex items-start">
                    <span class="text-purple-500 mr-2">•</span>
                    <span>Add/remove team members</span>
                </li>
                <li class="flex items-start">
                    <span class="text-purple-500 mr-2">•</span>
                    <span>Change team captain</span>
                </li>
                <li class="flex items-start">
                    <span class="text-purple-500 mr-2">•</span>
                    <span>Manage max players limit</span>
                </li>
                <li class="flex items-start">
                    <span class="text-purple-500 mr-2">•</span>
                    <span>Control team status</span>
                </li>
            </ul>
        </div>

        <div>
            <h4 class="font-bold text-lg mb-3 text-orange-600">🎭 Team Statuses</h4>
            <ul class="space-y-2 text-gray-700">
                <li class="flex items-start">
                    <span class="bg-green-100 px-2 py-1 rounded text-sm font-semibold">ACTIVE</span>
                    <span class="ml-2 text-sm">Can participate</span>
                </li>
                <li class="flex items-start">
                    <span class="bg-red-100 px-2 py-1 rounded text-sm font-semibold">ELIMINATED</span>
                    <span class="ml-2 text-sm">Out of tournament</span>
                </li>
                <li class="flex items-start">
                    <span class="bg-gray-100 px-2 py-1 rounded text-sm font-semibold">WITHDRAWN</span>
                    <span class="ml-2 text-sm">Voluntarily left</span>
                </li>
            </ul>
        </div>
    </div>
</div>

<!-- Team Lifecycle Diagram -->
<div class="section-card">
    <h3 class="text-2xl font-bold mb-4 flex items-center">
        <span class="step-number">2</span>
        Team Management Lifecycle
    </h3>

    <div class="mermaid bg-white p-6 rounded-lg shadow-inner">
flowchart TD
    Start([✅ Team Created &<br/>Registration Complete])
    Start --> ActiveTeam[Team Status: ACTIVE<br/>• Registered for tournament<br/>• Manager assigned<br/>• Players added<br/>• Payment pending/completed]
    
    ActiveTeam --> ManagementOps{Team Management<br/>Operations}
    
    %% Update Team Info
    ManagementOps -->|Update Info| UpdateInfo[Update Team Information<br/>• Name, description<br/>• Logo, location<br/>• Contact details]
    UpdateInfo --> NotifyUpdate[📧 Send Notifications:<br/>• TeamUpdatedNotification to members<br/>• TeamUpdatedAdminNotification]
    NotifyUpdate --> ManagementOps
    
    %% Add Member
    ManagementOps -->|Add Member| CheckMember{Member Already<br/>on Team?}
    CheckMember -->|Yes| ErrorDuplicate[❌ Error: Member<br/>Already Exists]
    ErrorDuplicate --> ManagementOps
    CheckMember -->|No| CheckMaxPlayers{Max Players<br/>Reached?}
    CheckMaxPlayers -->|Yes| ErrorMax[❌ Error: Team Full]
    ErrorMax --> ManagementOps
    CheckMaxPlayers -->|No| AddMember[Add Member to Team<br/>• Create player record<br/>• Link to team]
    AddMember --> NotifyNewMember[📧 Send Notifications:<br/>• TeamPlayerAddedNotification to captain<br/>• TeamNewMemberNotification to members<br/>• TeamMemberWelcomeNotification to new member]
    NotifyNewMember --> ManagementOps
    
    %% Remove Member
    ManagementOps -->|Remove Member| CheckManager{Is Member<br/>the Manager?}
    CheckManager -->|Yes| ErrorManager[❌ Error: Cannot Remove<br/>Manager - Reassign First]
    ErrorManager --> ManagementOps
    CheckManager -->|No| RemoveMember[Remove Member<br/>• Detach from team<br/>• Update player status]
    RemoveMember --> NotifyRemoved[📧 Send Notifications:<br/>• TeamPlayerRemovedNotification to captain<br/>• TeamMemberLeftNotification to member]
    NotifyRemoved --> ManagementOps
    
    %% Change Manager
    ManagementOps -->|Change Manager| SelectNewManager[Select New Manager<br/>from Team Members]
    SelectNewManager --> NotifyOldManager[📧 Notify Old Manager:<br/>• TeamManagerRemovedNotification]
    NotifyOldManager --> AssignNewManager[Assign New Manager<br/>• Update captain_id<br/>• Grant permissions]
    AssignNewManager --> NotifyNewManager[📧 Notify New Manager:<br/>• TeamManagerAssignedNotification<br/>Send to Members:<br/>• TeamManagerChangedNotification<br/>To Admins:<br/>• TeamManagerChangedAdminNotification]
    NotifyNewManager --> ManagementOps
    
    %% Change Status
    ManagementOps -->|Change Status| UpdateStatus{New Status?}
    UpdateStatus -->|Eliminated| SetEliminated[Status: ELIMINATED<br/>• Team out of tournament<br/>• Cannot play more matches]
    UpdateStatus -->|Withdrawn| SetWithdrawn[Status: WITHDRAWN<br/>• Team voluntarily left<br/>• Forfeit remaining matches]
    UpdateStatus -->|Active| SetActive[Status: ACTIVE<br/>• Re-activate team<br/>• Can participate again]
    
    SetEliminated --> NotifyStatus[📧 TeamStatusChangedNotification<br/>to members and admins]
    SetWithdrawn --> NotifyStatus
    SetActive --> NotifyStatus
    NotifyStatus --> ManagementOps
    
    %% Delete Team
    ManagementOps -->|Delete Team| ConfirmDelete{Admin Confirms<br/>Deletion?}
    ConfirmDelete -->|No| ManagementOps
    ConfirmDelete -->|Yes| SoftDelete[Soft Delete Team<br/>• Set deleted_at timestamp<br/>• Preserve data<br/>• Can be restored]
    SoftDelete --> NotifyDeleted[📧 Send Notifications:<br/>• TeamDeletedNotification to captain<br/>• TeamDeletedMemberNotification to members<br/>• TeamDeletedAdminNotification to admins]
    NotifyDeleted --> DeletedState[Team Status: DELETED<br/>• Not visible to users<br/>• Data preserved<br/>• Can be restored by admin]
    
    %% Restore Team
    DeletedState -->|Admin Restores| RestoreTeam[Restore Team<br/>• Clear deleted_at<br/>• Reactivate status]
    RestoreTeam --> NotifyRestored[📧 Send Notifications:<br/>• TeamRestoredNotification to captain<br/>• TeamRestoredMemberNotification to members<br/>• TeamRestoredAdminNotification to admins]
    NotifyRestored --> ActiveTeam
    
    DeletedState -->|Permanent Delete| PermanentDelete[❌ Permanent Deletion<br/>• Cannot be undone]
    PermanentDelete --> End([Team Removed])
    
    ManagementOps -->|Continue| ActiveTeam
    
    style Start fill:#4CAF50,stroke:#2E7D32,color:#fff
    style ActiveTeam fill:#4CAF50,stroke:#2E7D32,color:#fff
    style ErrorDuplicate fill:#f44336,stroke:#c62828,color:#fff
    style ErrorMax fill:#f44336,stroke:#c62828,color:#fff
    style ErrorManager fill:#f44336,stroke:#c62828,color:#fff
    style SetEliminated fill:#f44336,stroke:#c62828,color:#fff
    style SetWithdrawn fill:#FFC107,stroke:#F57C00,color:#000
    style SoftDelete fill:#9E9E9E,stroke:#616161,color:#fff
    style DeletedState fill:#9E9E9E,stroke:#616161,color:#fff
    style End fill:#f44336,stroke:#c62828,color:#fff
    </div>
</div>

<!-- Member Management -->
<div class="section-card">
    <h3 class="text-2xl font-bold mb-4 flex items-center">
        <span class="step-number">3</span>
        Team Member Management
    </h3>

    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
        <!-- Adding Members -->
        <div class="bg-green-50 rounded-lg p-4 border-2 border-green-300">
            <h4 class="font-bold text-green-700 mb-3">➕ Adding Team Members</h4>
            
            <div class="space-y-2 text-sm text-gray-700">
                <div class="bg-white rounded p-3">
                    <strong>Step 1:</strong> Manager navigates to team players page
                </div>
                <div class="bg-white rounded p-3">
                    <strong>Step 2:</strong> Click "Add Player" button
                </div>
                <div class="bg-white rounded p-3">
                    <strong>Step 3:</strong> Fill player information form
                </div>
                <div class="bg-white rounded p-3">
                    <strong>Step 4:</strong> System validates:
                    <ul class="ml-4 mt-1 list-disc">
                        <li>Player not already on team</li>
                        <li>Max players limit not reached</li>
                        <li>Email is unique</li>
                    </ul>
                </div>
                <div class="bg-white rounded p-3">
                    <strong>Step 5:</strong> Create player record and send notifications
                </div>
            </div>

            <div class="notification-box mt-3">
                <p class="font-bold text-green-800 text-xs mb-2">📧 Notifications:</p>
                <div class="text-xs space-y-1">
                    <div><code>TeamPlayerAddedNotification</code> → Manager</div>
                    <div><code>TeamNewMemberNotification</code> → Members</div>
                    <div><code>TeamMemberWelcomeNotification</code> → New Member</div>
                </div>
            </div>
        </div>

        <!-- Removing Members -->
        <div class="bg-red-50 rounded-lg p-4 border-2 border-red-300">
            <h4 class="font-bold text-red-700 mb-3">➖ Removing Team Members</h4>
            
            <div class="space-y-2 text-sm text-gray-700">
                <div class="bg-white rounded p-3">
                    <strong>Step 1:</strong> Manager selects member to remove
                </div>
                <div class="bg-white rounded p-3">
                    <strong>Step 2:</strong> System checks if member is captain
                </div>
                <div class="bg-white rounded p-3">
                    <strong>Decision:</strong>
                    <ul class="ml-4 mt-1">
                        <li>✓ Regular member → Can remove</li>
                        <li>✗ Manager → Must reassign captain first</li>
                    </ul>
                </div>
                <div class="bg-white rounded p-3">
                    <strong>Step 3:</strong> Confirm removal
                </div>
                <div class="bg-white rounded p-3">
                    <strong>Step 4:</strong> Detach member and send notifications
                </div>
            </div>

            <div class="notification-box mt-3">
                <p class="font-bold text-green-800 text-xs mb-2">📧 Notifications:</p>
                <div class="text-xs space-y-1">
                    <div><code>TeamPlayerRemovedNotification</code> → Manager</div>
                    <div><code>TeamMemberLeftNotification</code> → Removed Member</div>
                </div>
            </div>
        </div>
    </div>

    <div class="screenshot-placeholder mt-4">
        <p class="text-2xl text-gray-400 mb-2">📸</p>
        <p class="text-gray-600 font-mono text-lg">[screenshot-team-member-management.png]</p>
        <p class="text-sm text-gray-500 mt-2">Team member management interface</p>
    </div>
</div>

<!-- Manager Transfer Process -->
<div class="section-card">
    <h3 class="text-2xl font-bold mb-4 flex items-center">
        <span class="step-number">4</span>
        Manager Transfer Process
    </h3>

    <div class="mermaid bg-white p-6 rounded-lg shadow-inner">
graph LR
    A[Current Manager<br/>Wants to Transfer] --> B[Select New Manager<br/>from Team Members]
    B --> C{New Manager<br/>Accepts?}
    C -->|No| D[Transfer Cancelled]
    C -->|Yes| E[Send Invitation<br/>TeamManagerInvitationNotification]
    E --> F[New Manager<br/>Accepts Invitation]
    F --> G[Update Team Record<br/>• captain_id changed<br/>• Permissions transferred]
    G --> H[📧 Notify Old Manager<br/>TeamManagerRemovedNotification]
    H --> I[📧 Notify New Manager<br/>TeamManagerAssignedNotification]
    I --> J[📧 Notify All Members<br/>TeamManagerChangedNotification]
    J --> K[📧 Notify Admins<br/>TeamManagerChangedAdminNotification]
    K --> L[Manager Transfer Complete<br/>New captain has full access]
    
    style A fill:#FFC107,stroke:#F57C00,color:#000
    style D fill:#f44336,stroke:#c62828,color:#fff
    style G fill:#2196F3,stroke:#1565C0,color:#fff
    style L fill:#4CAF50,stroke:#2E7D32,color:#fff
    </div>

    <div class="decision-box mt-4">
        <p class="font-bold text-blue-800 mb-2">🔐 Manager Permissions & Responsibilities</p>
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mt-3">
            <div class="bg-white rounded-lg p-3">
                <p class="font-semibold text-blue-700 mb-2">Manager Can:</p>
                <ul class="text-sm space-y-1 text-gray-700">
                    <li>✓ Add/remove team members</li>
                    <li>✓ Update team information</li>
                    <li>✓ Manage player profiles</li>
                    <li>✓ Complete payments</li>
                    <li>✓ Transfer captaincy</li>
                    <li>✓ Withdraw from tournament</li>
                </ul>
            </div>
            <div class="bg-white rounded-lg p-3">
                <p class="font-semibold text-red-700 mb-2">Manager Cannot:</p>
                <ul class="text-sm space-y-1 text-gray-700">
                    <li>✗ Delete team permanently</li>
                    <li>✗ Change tournament registration</li>
                    <li>✗ Approve other teams</li>
                    <li>✗ Modify match results</li>
                </ul>
            </div>
        </div>
    </div>

    <div class="screenshot-placeholder-sm mt-4">
        <p class="text-xl text-gray-400 mb-2">📸</p>
        <p class="text-gray-600 font-mono">[screenshot-captain-transfer.png]</p>
        <p class="text-xs text-gray-500 mt-2">Manager transfer interface and confirmation</p>
    </div>
</div>

<!-- Team Settings Management -->
<div class="section-card">
    <h3 class="text-2xl font-bold mb-4 flex items-center">
        <span class="step-number">5</span>
        Team Settings & Configuration
    </h3>

    <div class="bg-purple-50 rounded-lg p-6">
        <h4 class="font-bold text-purple-900 mb-4">⚙️ Configurable Team Settings</h4>
        
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
            <div class="bg-white rounded-lg p-4">
                <p class="font-semibold text-gray-800 mb-3">Roster Settings:</p>
                <ul class="space-y-2 text-sm text-gray-700">
                    <li class="flex justify-between items-center">
                        <span><strong>Max Players:</strong></span>
                        <span class="font-mono">11 - 23</span>
                    </li>
                    <li class="flex justify-between items-center">
                        <span><strong>Min Players:</strong></span>
                        <span class="font-mono">11 (fixed)</span>
                    </li>
                    <li class="flex justify-between items-center">
                        <span><strong>Current Players:</strong></span>
                        <span class="text-blue-600 font-semibold">Dynamic</span>
                    </li>
                </ul>

                <div class="notification-box mt-3">
                    <p class="text-xs font-semibold mb-1">When max_players changed:</p>
                    <div class="text-xs"><code>TeamMaxPlayersChangedNotification</code></div>
                </div>
            </div>

            <div class="bg-white rounded-lg p-4">
                <p class="font-semibold text-gray-800 mb-3">Notification Settings:</p>
                <ul class="space-y-2 text-sm text-gray-700">
                    <li class="flex items-center">
                        <input type="checkbox" checked disabled class="mr-2">
                        <span><strong>Match Updates:</strong> Receive match notifications</span>
                    </li>
                    <li class="flex items-center">
                        <input type="checkbox" checked disabled class="mr-2">
                        <span><strong>Tournament Updates:</strong> Receive tournament notifications</span>
                    </li>
                </ul>
                <p class="text-xs text-gray-600 mt-2">
                    Team-level notification preferences (in addition to individual user preferences)
                </p>
            </div>
        </div>
    </div>

    <div class="screenshot-placeholder-sm mt-4">
        <p class="text-xl text-gray-400 mb-2">📸</p>
        <p class="text-gray-600 font-mono">[screenshot-team-settings.png]</p>
        <p class="text-xs text-gray-500 mt-2">Team settings and configuration page</p>
    </div>
</div>

<!-- Team Notification Matrix -->
<div class="section-card">
    <h3 class="text-2xl font-bold mb-4 flex items-center">
        <span class="step-number">6</span>
        Team Management Notification Matrix
    </h3>
    
    <div class="overflow-x-auto">
        <table class="w-full bg-white rounded-lg shadow">
            <thead class="bg-gray-100">
                <tr>
                    <th class="px-4 py-3 text-left font-semibold">Event</th>
                    <th class="px-4 py-3 text-left font-semibold">Recipient</th>
                    <th class="px-4 py-3 text-left font-semibold">Notification</th>
                    <th class="px-4 py-3 text-center font-semibold">Priority</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-gray-200">
                <tr class="hover:bg-gray-50">
                    <td class="px-4 py-3">Team Updated</td>
                    <td class="px-4 py-3">Members</td>
                    <td class="px-4 py-3"><code class="text-xs">TeamUpdatedNotification</code></td>
                    <td class="px-4 py-3 text-center"><span class="bg-gray-100 px-2 py-1 rounded text-xs">Low</span></td>
                </tr>
                <tr class="hover:bg-gray-50 bg-blue-50">
                    <td class="px-4 py-3">New Member Added</td>
                    <td class="px-4 py-3">Manager</td>
                    <td class="px-4 py-3"><code class="text-xs">TeamPlayerAddedNotification</code></td>
                    <td class="px-4 py-3 text-center"><span class="bg-blue-100 px-2 py-1 rounded text-xs">Default</span></td>
                </tr>
                <tr class="hover:bg-gray-50 bg-blue-50">
                    <td class="px-4 py-3">New Member Added</td>
                    <td class="px-4 py-3">All Members</td>
                    <td class="px-4 py-3"><code class="text-xs">TeamNewMemberNotification</code></td>
                    <td class="px-4 py-3 text-center"><span class="bg-blue-100 px-2 py-1 rounded text-xs">Default</span></td>
                </tr>
                <tr class="hover:bg-gray-50 bg-blue-50">
                    <td class="px-4 py-3">New Member Added</td>
                    <td class="px-4 py-3">New Member</td>
                    <td class="px-4 py-3"><code class="text-xs">TeamMemberWelcomeNotification</code></td>
                    <td class="px-4 py-3 text-center"><span class="bg-yellow-100 px-2 py-1 rounded text-xs">High</span></td>
                </tr>
                <tr class="hover:bg-gray-50">
                    <td class="px-4 py-3">Member Removed</td>
                    <td class="px-4 py-3">Manager</td>
                    <td class="px-4 py-3"><code class="text-xs">TeamPlayerRemovedNotification</code></td>
                    <td class="px-4 py-3 text-center"><span class="bg-blue-100 px-2 py-1 rounded text-xs">Default</span></td>
                </tr>
                <tr class="hover:bg-gray-50">
                    <td class="px-4 py-3">Member Removed</td>
                    <td class="px-4 py-3">Removed Member</td>
                    <td class="px-4 py-3"><code class="text-xs">TeamMemberLeftNotification</code></td>
                    <td class="px-4 py-3 text-center"><span class="bg-yellow-100 px-2 py-1 rounded text-xs">High</span></td>
                </tr>
                <tr class="hover:bg-gray-50 bg-green-50">
                    <td class="px-4 py-3">Manager Changed</td>
                    <td class="px-4 py-3">Old Manager</td>
                    <td class="px-4 py-3"><code class="text-xs">TeamManagerRemovedNotification</code></td>
                    <td class="px-4 py-3 text-center"><span class="bg-yellow-100 px-2 py-1 rounded text-xs">High</span></td>
                </tr>
                <tr class="hover:bg-gray-50 bg-green-50">
                    <td class="px-4 py-3">Manager Changed</td>
                    <td class="px-4 py-3">New Manager</td>
                    <td class="px-4 py-3"><code class="text-xs">TeamManagerAssignedNotification</code></td>
                    <td class="px-4 py-3 text-center"><span class="bg-yellow-100 px-2 py-1 rounded text-xs">High</span></td>
                </tr>
                <tr class="hover:bg-gray-50 bg-green-50">
                    <td class="px-4 py-3">Manager Changed</td>
                    <td class="px-4 py-3">All Members</td>
                    <td class="px-4 py-3"><code class="text-xs">TeamManagerChangedNotification</code></td>
                    <td class="px-4 py-3 text-center"><span class="bg-blue-100 px-2 py-1 rounded text-xs">Default</span></td>
                </tr>
                <tr class="hover:bg-gray-50 bg-green-50">
                    <td class="px-4 py-3">Manager Changed</td>
                    <td class="px-4 py-3">Admins</td>
                    <td class="px-4 py-3"><code class="text-xs">TeamManagerChangedAdminNotification</code></td>
                    <td class="px-4 py-3 text-center"><span class="bg-blue-100 px-2 py-1 rounded text-xs">Default</span></td>
                </tr>
                <tr class="hover:bg-gray-50 bg-purple-50">
                    <td class="px-4 py-3">Status Changed</td>
                    <td class="px-4 py-3">Members</td>
                    <td class="px-4 py-3"><code class="text-xs">TeamStatusChangedNotification</code></td>
                    <td class="px-4 py-3 text-center"><span class="bg-yellow-100 px-2 py-1 rounded text-xs">High</span></td>
                </tr>
                <tr class="hover:bg-gray-50 bg-red-50">
                    <td class="px-4 py-3">Team Deleted</td>
                    <td class="px-4 py-3">Manager</td>
                    <td class="px-4 py-3"><code class="text-xs">TeamDeletedNotification</code></td>
                    <td class="px-4 py-3 text-center"><span class="bg-yellow-100 px-2 py-1 rounded text-xs">High</span></td>
                </tr>
                <tr class="hover:bg-gray-50 bg-red-50">
                    <td class="px-4 py-3">Team Deleted</td>
                    <td class="px-4 py-3">Members</td>
                    <td class="px-4 py-3"><code class="text-xs">TeamDeletedMemberNotification</code></td>
                    <td class="px-4 py-3 text-center"><span class="bg-yellow-100 px-2 py-1 rounded text-xs">High</span></td>
                </tr>
                <tr class="hover:bg-gray-50 bg-red-50">
                    <td class="px-4 py-3">Team Deleted</td>
                    <td class="px-4 py-3">Admins</td>
                    <td class="px-4 py-3"><code class="text-xs">TeamDeletedAdminNotification</code></td>
                    <td class="px-4 py-3 text-center"><span class="bg-blue-100 px-2 py-1 rounded text-xs">Default</span></td>
                </tr>
                <tr class="hover:bg-gray-50">
                    <td class="px-4 py-3">Team Restored</td>
                    <td class="px-4 py-3">Manager</td>
                    <td class="px-4 py-3"><code class="text-xs">TeamRestoredNotification</code></td>
                    <td class="px-4 py-3 text-center"><span class="bg-blue-100 px-2 py-1 rounded text-xs">Default</span></td>
                </tr>
                <tr class="hover:bg-gray-50">
                    <td class="px-4 py-3">Team Restored</td>
                    <td class="px-4 py-3">Members</td>
                    <td class="px-4 py-3"><code class="text-xs">TeamRestoredMemberNotification</code></td>
                    <td class="px-4 py-3 text-center"><span class="bg-blue-100 px-2 py-1 rounded text-xs">Default</span></td>
                </tr>
                <tr class="hover:bg-gray-50">
                    <td class="px-4 py-3">Max Players Changed</td>
                    <td class="px-4 py-3">Members</td>
                    <td class="px-4 py-3"><code class="text-xs">TeamMaxPlayersChangedNotification</code></td>
                    <td class="px-4 py-3 text-center"><span class="bg-gray-100 px-2 py-1 rounded text-xs">Low</span></td>
                </tr>
            </tbody>
        </table>
    </div>
</div>

<!-- Team Status Management -->
<div class="section-card">
    <h3 class="text-2xl font-bold mb-4 flex items-center">
        <span class="step-number">7</span>
        Team Status Management
    </h3>

    <div class="mermaid bg-white p-6 rounded-lg shadow-inner">
stateDiagram-v2
    [*] --> Active: Team Registered
    Active --> Eliminated: Knocked Out<br/>of Tournament
    Active --> Withdrawn: Voluntary<br/>Withdrawal
    Eliminated --> [*]: Tournament<br/>Complete
    Withdrawn --> [*]: Permanent<br/>Exit
    Active --> Active: Ongoing<br/>Participation
    
    note right of Active
        Team can:
        • Play matches
        • Add/remove members
        • Update information
    end note
    
    note right of Eliminated
        Team is:
        • Out of tournament
        • Cannot play matches
        • Data preserved
    end note
    
    note right of Withdrawn
        Team has:
        • Left voluntarily
        • Forfeited matches
        • Cannot rejoin
    end note
    </div>

    <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mt-6">
        <div class="screenshot-placeholder-sm">
            <p class="text-xl text-gray-400 mb-2">📸</p>
            <p class="text-gray-600 font-mono">[screenshot-team-dashboard.png]</p>
            <p class="text-xs text-gray-500 mt-2">Team management dashboard</p>
        </div>
        <div class="screenshot-placeholder-sm">
            <p class="text-xl text-gray-400 mb-2">📸</p>
            <p class="text-gray-600 font-mono">[screenshot-team-roster.png]</p>
            <p class="text-xs text-gray-500 mt-2">Team roster management view</p>
        </div>
    </div>
</div>

<!-- Summary -->
<div class="section-card bg-gradient-to-r from-green-50 to-blue-50">
    <h3 class="text-2xl font-bold mb-4">📚 Quick Reference Summary</h3>
    
    <div class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-6">
        <div class="bg-white rounded-lg p-4 shadow">
            <p class="text-3xl font-bold text-green-600 mb-2">3</p>
            <p class="text-gray-700">Team Statuses</p>
        </div>
        <div class="bg-white rounded-lg p-4 shadow">
            <p class="text-3xl font-bold text-blue-600 mb-2">~16</p>
            <p class="text-gray-700">Notification Types</p>
        </div>
        <div class="bg-white rounded-lg p-4 shadow">
            <p class="text-3xl font-bold text-purple-600 mb-2">11-23</p>
            <p class="text-gray-700">Players Per Team</p>
        </div>
        <div class="bg-white rounded-lg p-4 shadow">
            <p class="text-3xl font-bold text-orange-600 mb-2">5+</p>
            <p class="text-gray-700">Management Operations</p>
        </div>
    </div>

    <div class="bg-white rounded-lg p-6">
        <p class="font-semibold text-gray-800 mb-3">🎯 Key Takeaways:</p>
        <ul class="space-y-2 text-gray-700">
            <li class="flex items-start">
                <span class="text-green-500 mr-2">•</span>
                <span>Team captains have full control over team operations including member management and settings</span>
            </li>
            <li class="flex items-start">
                <span class="text-blue-500 mr-2">•</span>
                <span>Manager transfer requires acceptance from new captain and triggers multiple notifications</span>
            </li>
            <li class="flex items-start">
                <span class="text-purple-500 mr-2">•</span>
                <span>Team deletion is soft delete (preserves data) and can be restored by admins</span>
            </li>
            <li class="flex items-start">
                <span class="text-orange-500 mr-2">•</span>
                <span>All team changes trigger notifications to captain, members, and admins for transparency</span>
            </li>
        </ul>
    </div>
</div>

