<!-- Player Management Documentation -->

<div class="section-card">
    <h2 class="text-4xl font-bold mb-6">⚽ Player Management Workflow</h2>
    
    <div class="bg-blue-50 border-l-4 border-blue-500 p-6 rounded-r-lg mb-6">
        <p class="text-lg text-blue-900 font-semibold">📖 What You'll Learn</p>
        <ul class="mt-3 space-y-2 text-blue-800">
            <li>✅ Player profile creation and completion requirements</li>
            <li>✅ Profile completeness validation (8 required fields)</li>
            <li>✅ Verification process with OTP and ID documents</li>
            <li>✅ Digital ID card generation and distribution</li>
            <li>✅ Player status lifecycle and transitions</li>
            <li>✅ All notifications sent during player journey</li>
        </ul>
    </div>
</div>

<!-- Overview -->
<div class="section-card">
    <h3 class="text-2xl font-bold mb-4 flex items-center">
        <span class="step-number">1</span>
        Overview
    </h3>
    
    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
        <div>
            <h4 class="font-bold text-lg mb-3 text-blue-600">⚽ What is Player Management?</h4>
            <p class="text-gray-700 leading-relaxed">
                Player management handles the complete player lifecycle from initial registration through 
                profile completion, verification, digital ID generation, and ongoing status management. 
                Players must complete their profiles to participate in tournaments.
            </p>
        </div>

        <div>
            <h4 class="font-bold text-lg mb-3 text-green-600">👥 Who Manages Players?</h4>
            <ul class="space-y-2 text-gray-700">
                <li class="flex items-start">
                    <span class="text-green-500 mr-2">•</span>
                    <span><strong>Players Themselves:</strong> Complete their own profiles</span>
                </li>
                <li class="flex items-start">
                    <span class="text-green-500 mr-2">•</span>
                    <span><strong>Team Managers:</strong> Add players, monitor completion</span>
                </li>
                <li class="flex items-start">
                    <span class="text-green-500 mr-2">•</span>
                    <span><strong>Admins:</strong> Verify, approve, manage all players</span>
                </li>
            </ul>
        </div>

        <div>
            <h4 class="font-bold text-lg mb-3 text-purple-600">📋 Required Profile Fields (8)</h4>
            <div class="grid grid-cols-2 gap-2">
                <div class="bg-purple-50 rounded p-2 text-sm">✓ Full Name</div>
                <div class="bg-purple-50 rounded p-2 text-sm">✓ Phone Number</div>
                <div class="bg-purple-50 rounded p-2 text-sm">✓ Date of Birth</div>
                <div class="bg-purple-50 rounded p-2 text-sm">✓ Gender</div>
                <div class="bg-purple-50 rounded p-2 text-sm">✓ Playing Position</div>
                <div class="bg-purple-50 rounded p-2 text-sm">✓ ID Number</div>
                <div class="bg-purple-50 rounded p-2 text-sm col-span-2">✓ ID Photos (Front & Back)</div>
            </div>
        </div>

        <div>
            <h4 class="font-bold text-lg mb-3 text-orange-600">⏱️ Typical Timeline</h4>
            <ul class="space-y-2 text-gray-700">
                <li class="flex justify-between">
                    <span>Player Creation:</span>
                    <span class="font-semibold">Instant</span>
                </li>
                <li class="flex justify-between">
                    <span>Profile Completion:</span>
                    <span class="font-semibold">5-10 minutes</span>
                </li>
                <li class="flex justify-between">
                    <span>Verification:</span>
                    <span class="font-semibold">Instant</span>
                </li>
                <li class="flex justify-between">
                    <span>Digital ID Generation:</span>
                    <span class="font-semibold">2-5 seconds</span>
                </li>
            </ul>
        </div>
    </div>
</div>

<!-- Player Lifecycle Diagram -->
<div class="section-card">
    <h3 class="text-2xl font-bold mb-4 flex items-center">
        <span class="step-number">2</span>
        Complete Player Lifecycle
    </h3>

    <div class="mermaid bg-white p-6 rounded-lg shadow-inner">
flowchart TD
    Start([👤 Player Created During<br/>Team Registration])
    Start --> InitialState[Initial State:<br/>• profile_complete: false<br/>• verification_status: pending<br/>• OTP generated]
    
    InitialState --> NotifyCreated[📧 Send Notifications:<br/>• PlayerRegisteredNotification<br/>• TeamPlayerAddedNotification<br/>• PlayerRegisteredAdminNotification]
    
    NotifyCreated --> Dashboard[Player Sees Dashboard<br/>with Profile Alert]
    
    Dashboard --> CheckProfile{Profile<br/>Complete?}
    CheckProfile -->|No| ShowAlert[🚨 Show Incomplete<br/>Profile Alert]
    ShowAlert --> PlayerFills[Player Fills Profile Form]
    
    PlayerFills --> ValidateFields{All 8 Required<br/>Fields Filled?}
    ValidateFields -->|No| ValidationError[⚠️ Show Missing Fields]
    ValidationError --> PlayerFills
    
    ValidateFields -->|Yes| CheckID{ID Photos<br/>Uploaded?}
    CheckID -->|No| UploadPrompt[Prompt to Upload<br/>Front & Back ID]
    UploadPrompt --> PlayerFills
    
    CheckID -->|Yes| SaveProfile[Save Profile<br/>• profile_complete: true<br/>• Calculate completeness: 100%]
    
    SaveProfile --> TriggerVerification[Trigger Verification Process]
    
    TriggerVerification --> GenerateDigitalID[Generate Digital ID<br/>• Create unique ID number<br/>• Generate QR code<br/>• Create PDF card]
    
    GenerateDigitalID --> NotifyVerified[📧 Send Notifications:<br/>• PlayerVerificationUpdatedNotification<br/>• PlayerDigitalIdGeneratedNotification PDF<br/>• PlayerDigitalIdGeneratedAdminNotification]
    
    NotifyVerified --> StatusActive[Player Status: ACTIVE<br/>• Can participate in tournaments<br/>• Digital ID available<br/>• Profile visible]
    
    StatusActive --> OngoingManagement{Ongoing<br/>Management}
    
    OngoingManagement -->|Status Change| ChangeStatus[Admin Changes Status<br/>active → inactive/suspended]
    ChangeStatus --> NotifyStatusChange[📧 PlayerStatusChangedNotification]
    NotifyStatusChange --> OngoingManagement
    
    OngoingManagement -->|Rating Update| UpdateRating[Match Results Update<br/>Player Ratings]
    UpdateRating --> NotifyRating[📧 PlayerRatingUpdatedNotification]
    NotifyRating --> OngoingManagement
    
    OngoingManagement -->|Profile Update| UpdateProfile[Player Updates Profile<br/>Information]
    UpdateProfile --> OngoingManagement
    
    OngoingManagement -->|Complete| End([Player Fully Managed])
    
    CheckProfile -->|Yes| StatusActive
    
    style Start fill:#4CAF50,stroke:#2E7D32,color:#fff
    style InitialState fill:#FFC107,stroke:#F57C00,color:#000
    style SaveProfile fill:#2196F3,stroke:#1565C0,color:#fff
    style GenerateDigitalID fill:#9C27B0,stroke:#6A1B9A,color:#fff
    style StatusActive fill:#4CAF50,stroke:#2E7D32,color:#fff
    style ValidationError fill:#f44336,stroke:#c62828,color:#fff
    style End fill:#4CAF50,stroke:#2E7D32,color:#fff
    </div>
</div>

<!-- Profile Completion Requirements -->
<div class="section-card">
    <h3 class="text-2xl font-bold mb-4 flex items-center">
        <span class="step-number">3</span>
        Profile Completion Requirements
    </h3>
    
    <div class="bg-purple-50 rounded-lg p-6 mb-6">
        <h4 class="font-bold text-purple-900 mb-4">✅ 8 Required Fields</h4>
        
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
            <div class="bg-white rounded-lg p-4">
                <p class="font-semibold text-gray-800 mb-3">Personal Information:</p>
                <ul class="space-y-2 text-gray-700 text-sm">
                    <li class="flex items-center">
                        <span class="w-6 h-6 bg-green-500 rounded-full flex items-center justify-center text-white text-xs mr-2">1</span>
                        <span><strong>Full Name:</strong> Player's complete name</span>
                    </li>
                    <li class="flex items-center">
                        <span class="w-6 h-6 bg-green-500 rounded-full flex items-center justify-center text-white text-xs mr-2">2</span>
                        <span><strong>Phone Number:</strong> Valid contact number</span>
                    </li>
                    <li class="flex items-center">
                        <span class="w-6 h-6 bg-green-500 rounded-full flex items-center justify-center text-white text-xs mr-2">3</span>
                        <span><strong>Date of Birth:</strong> For age verification</span>
                    </li>
                    <li class="flex items-center">
                        <span class="w-6 h-6 bg-green-500 rounded-full flex items-center justify-center text-white text-xs mr-2">4</span>
                        <span><strong>Gender:</strong> Male/Female/Other</span>
                    </li>
                </ul>
            </div>

            <div class="bg-white rounded-lg p-4">
                <p class="font-semibold text-gray-800 mb-3">Football & ID Information:</p>
                <ul class="space-y-2 text-gray-700 text-sm">
                    <li class="flex items-center">
                        <span class="w-6 h-6 bg-purple-500 rounded-full flex items-center justify-center text-white text-xs mr-2">5</span>
                        <span><strong>Playing Position:</strong> Goalkeeper, Defender, etc.</span>
                    </li>
                    <li class="flex items-center">
                        <span class="w-6 h-6 bg-purple-500 rounded-full flex items-center justify-center text-white text-xs mr-2">6</span>
                        <span><strong>ID Number:</strong> National ID or Passport</span>
                    </li>
                    <li class="flex items-center">
                        <span class="w-6 h-6 bg-purple-500 rounded-full flex items-center justify-center text-white text-xs mr-2">7</span>
                        <span><strong>ID Photo (Front):</strong> Clear scan/photo</span>
                    </li>
                    <li class="flex items-center">
                        <span class="w-6 h-6 bg-purple-500 rounded-full flex items-center justify-center text-white text-xs mr-2">8</span>
                        <span><strong>ID Photo (Back):</strong> Clear scan/photo</span>
                    </li>
                </ul>
            </div>
        </div>
    </div>

    <div class="decision-box">
        <p class="font-bold text-blue-800 mb-2">🎯 Profile Completeness Calculation</p>
        <div class="bg-white rounded-lg p-4 mt-3">
            <p class="text-gray-700 mb-3">System calculates completeness percentage:</p>
            <div class="font-mono text-sm bg-gray-50 rounded p-3">
                <p>completeness = (completed_fields / total_fields) × 100</p>
                <p class="mt-2 text-blue-600">Example: 8/8 required fields = 100% complete ✅</p>
                <p class="text-red-600">Example: 6/8 required fields = 75% incomplete ❌</p>
            </div>
        </div>
    </div>

    <div class="screenshot-placeholder mt-4">
        <p class="text-2xl text-gray-400 mb-2">📸</p>
        <p class="text-gray-600 font-mono text-lg">[screenshot-player-profile-form.png]</p>
        <p class="text-sm text-gray-500 mt-2">Player profile completion form interface</p>
    </div>
</div>

<!-- Verification & Digital ID -->
<div class="section-card">
    <h3 class="text-2xl font-bold mb-4 flex items-center">
        <span class="step-number">4</span>
        Verification & Digital ID Generation
    </h3>

    <div class="mermaid bg-white p-6 rounded-lg shadow-inner">
graph LR
    A[Profile 100% Complete] --> B{Auto-Verification<br/>Triggered}
    B --> C[Verify All Fields<br/>Present]
    C --> D{ID Photos<br/>Valid?}
    D -->|No| E[Verification: PENDING]
    D -->|Yes| F[Verification: VERIFIED]
    F --> G[Generate Digital ID<br/>• Unique ID number<br/>• QR code<br/>• Profile photo<br/>• Validity dates]
    G --> H[Create PDF Card<br/>A4 Landscape Format]
    H --> I[Store PDF in System]
    I --> J[📧 Send Notifications<br/>with PDF Attachment]
    J --> K[Player Receives<br/>Digital ID Card]
    K --> L[Digital ID Available<br/>in Dashboard]
    
    style A fill:#4CAF50,stroke:#2E7D32,color:#fff
    style F fill:#4CAF50,stroke:#2E7D32,color:#fff
    style E fill:#FFC107,stroke:#F57C00,color:#000
    style G fill:#9C27B0,stroke:#6A1B9A,color:#fff
    style K fill:#4CAF50,stroke:#2E7D32,color:#fff
    </div>

    <div class="notification-box mt-4">
        <p class="font-bold text-green-800 mb-2">📧 Notifications on Digital ID Generation:</p>
        <div class="grid grid-cols-1 md:grid-cols-3 gap-3">
            <div class="bg-white rounded p-3">
                <p class="font-semibold text-sm">To Player:</p>
                <code class="text-xs">PlayerVerificationUpdatedNotification</code>
            </div>
            <div class="bg-white rounded p-3">
                <p class="font-semibold text-sm">To Player:</p>
                <code class="text-xs">PlayerDigitalIdGeneratedNotification</code>
                <p class="text-xs text-gray-600 mt-1">(with PDF attachment)</p>
            </div>
            <div class="bg-white rounded p-3">
                <p class="font-semibold text-sm">To Admins:</p>
                <code class="text-xs">PlayerDigitalIdGeneratedAdminNotification</code>
            </div>
        </div>
    </div>

    <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mt-4">
        <div class="screenshot-placeholder-sm">
            <p class="text-xl text-gray-400 mb-2">📸</p>
            <p class="text-gray-600 font-mono">[screenshot-id-upload-interface.png]</p>
            <p class="text-xs text-gray-500 mt-2">ID document upload interface</p>
        </div>
        <div class="screenshot-placeholder-sm">
            <p class="text-xl text-gray-400 mb-2">📸</p>
            <p class="text-gray-600 font-mono">[screenshot-digital-id-card.png]</p>
            <p class="text-xs text-gray-500 mt-2">Generated digital ID card sample</p>
        </div>
    </div>
</div>

<!-- Player Status Management -->
<div class="section-card">
    <h3 class="text-2xl font-bold mb-4 flex items-center">
        <span class="step-number">5</span>
        Player Status Management
    </h3>

    <div class="mermaid bg-white p-6 rounded-lg shadow-inner">
stateDiagram-v2
    [*] --> Pending: Player Created
    Pending --> Active: Profile Complete<br/>& Verified
    Active --> Inactive: Admin Deactivates<br/>or Player Request
    Inactive --> Active: Admin Reactivates
    Active --> Suspended: Rules Violation<br/>or Misconduct
    Suspended --> Active: Suspension Lifted
    Active --> [*]: Player Deleted
    Inactive --> [*]: Player Deleted
    Suspended --> [*]: Player Deleted
    
    note right of Active
        Can participate in:
        • Tournaments
        • Matches
        • Team activities
    end note
    
    note right of Suspended
        Temporarily banned:
        • Cannot play matches
        • Cannot join teams
        • Profile visible
    end note
    </div>

    <div class="mt-6 overflow-x-auto">
        <table class="w-full bg-white rounded-lg shadow">
            <thead class="bg-gray-100">
                <tr>
                    <th class="px-4 py-3 text-left font-semibold">Status</th>
                    <th class="px-4 py-3 text-left font-semibold">Description</th>
                    <th class="px-4 py-3 text-left font-semibold">Capabilities</th>
                    <th class="px-4 py-3 text-left font-semibold">Notification</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-gray-200">
                <tr class="hover:bg-gray-50">
                    <td class="px-4 py-3">
                        <span class="bg-yellow-100 px-3 py-1 rounded font-semibold">PENDING</span>
                    </td>
                    <td class="px-4 py-3">Profile incomplete, awaiting completion</td>
                    <td class="px-4 py-3 text-sm">Cannot participate until profile complete</td>
                    <td class="px-4 py-3 text-sm">PlayerRegisteredNotification</td>
                </tr>
                <tr class="hover:bg-gray-50">
                    <td class="px-4 py-3">
                        <span class="bg-green-100 px-3 py-1 rounded font-semibold">ACTIVE</span>
                    </td>
                    <td class="px-4 py-3">Profile complete, verified, can play</td>
                    <td class="px-4 py-3 text-sm">Full access to all features</td>
                    <td class="px-4 py-3 text-sm">PlayerStatusChangedNotification</td>
                </tr>
                <tr class="hover:bg-gray-50">
                    <td class="px-4 py-3">
                        <span class="bg-gray-100 px-3 py-1 rounded font-semibold">INACTIVE</span>
                    </td>
                    <td class="px-4 py-3">Temporarily deactivated by admin or player</td>
                    <td class="px-4 py-3 text-sm">Cannot join matches or tournaments</td>
                    <td class="px-4 py-3 text-sm">PlayerStatusChangedNotification</td>
                </tr>
                <tr class="hover:bg-gray-50">
                    <td class="px-4 py-3">
                        <span class="bg-red-100 px-3 py-1 rounded font-semibold">SUSPENDED</span>
                    </td>
                    <td class="px-4 py-3">Suspended due to violations</td>
                    <td class="px-4 py-3 text-sm">Banned from all activities</td>
                    <td class="px-4 py-3 text-sm">PlayerStatusChangedNotification</td>
                </tr>
            </tbody>
        </table>
    </div>

    <div class="screenshot-placeholder-sm mt-4">
        <p class="text-xl text-gray-400 mb-2">📸</p>
        <p class="text-gray-600 font-mono">[screenshot-player-verification-status.png]</p>
        <p class="text-xs text-gray-500 mt-2">Player verification and status dashboard</p>
    </div>
</div>

<!-- Notification Matrix -->
<div class="section-card">
    <h3 class="text-2xl font-bold mb-4 flex items-center">
        <span class="step-number">6</span>
        Player Notification Matrix
    </h3>
    
    <div class="overflow-x-auto">
        <table class="w-full bg-white rounded-lg shadow">
            <thead class="bg-gray-100">
                <tr>
                    <th class="px-4 py-3 text-left font-semibold">Event</th>
                    <th class="px-4 py-3 text-left font-semibold">Recipient</th>
                    <th class="px-4 py-3 text-left font-semibold">Notification</th>
                    <th class="px-4 py-3 text-center font-semibold">Priority</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-gray-200">
                <tr class="hover:bg-gray-50">
                    <td class="px-4 py-3">Player Created</td>
                    <td class="px-4 py-3">Player</td>
                    <td class="px-4 py-3"><code class="text-xs">PlayerRegisteredNotification</code></td>
                    <td class="px-4 py-3 text-center"><span class="bg-blue-100 px-2 py-1 rounded text-xs">Default</span></td>
                </tr>
                <tr class="hover:bg-gray-50">
                    <td class="px-4 py-3">Player Created</td>
                    <td class="px-4 py-3">Team Manager</td>
                    <td class="px-4 py-3"><code class="text-xs">TeamPlayerAddedNotification</code></td>
                    <td class="px-4 py-3 text-center"><span class="bg-blue-100 px-2 py-1 rounded text-xs">Default</span></td>
                </tr>
                <tr class="hover:bg-gray-50">
                    <td class="px-4 py-3">Player Created</td>
                    <td class="px-4 py-3">Admins</td>
                    <td class="px-4 py-3"><code class="text-xs">PlayerRegisteredAdminNotification</code></td>
                    <td class="px-4 py-3 text-center"><span class="bg-blue-100 px-2 py-1 rounded text-xs">Default</span></td>
                </tr>
                <tr class="hover:bg-gray-50 bg-green-50">
                    <td class="px-4 py-3">Profile Verified</td>
                    <td class="px-4 py-3">Player</td>
                    <td class="px-4 py-3"><code class="text-xs">PlayerVerificationUpdatedNotification</code></td>
                    <td class="px-4 py-3 text-center"><span class="bg-blue-100 px-2 py-1 rounded text-xs">Default</span></td>
                </tr>
                <tr class="hover:bg-gray-50 bg-green-50">
                    <td class="px-4 py-3">Digital ID Generated</td>
                    <td class="px-4 py-3">Player</td>
                    <td class="px-4 py-3"><code class="text-xs">PlayerDigitalIdGeneratedNotification</code></td>
                    <td class="px-4 py-3 text-center"><span class="bg-yellow-100 px-2 py-1 rounded text-xs">High</span></td>
                </tr>
                <tr class="hover:bg-gray-50 bg-green-50">
                    <td class="px-4 py-3">Digital ID Generated</td>
                    <td class="px-4 py-3">Admins</td>
                    <td class="px-4 py-3"><code class="text-xs">PlayerDigitalIdGeneratedAdminNotification</code></td>
                    <td class="px-4 py-3 text-center"><span class="bg-blue-100 px-2 py-1 rounded text-xs">Default</span></td>
                </tr>
                <tr class="hover:bg-gray-50 bg-purple-50">
                    <td class="px-4 py-3">Status Changed</td>
                    <td class="px-4 py-3">Player</td>
                    <td class="px-4 py-3"><code class="text-xs">PlayerStatusChangedNotification</code></td>
                    <td class="px-4 py-3 text-center"><span class="bg-blue-100 px-2 py-1 rounded text-xs">Default</span></td>
                </tr>
                <tr class="hover:bg-gray-50 bg-purple-50">
                    <td class="px-4 py-3">Status Changed</td>
                    <td class="px-4 py-3">Admins</td>
                    <td class="px-4 py-3"><code class="text-xs">PlayerStatusChangedAdminNotification</code></td>
                    <td class="px-4 py-3 text-center"><span class="bg-blue-100 px-2 py-1 rounded text-xs">Default</span></td>
                </tr>
                <tr class="hover:bg-gray-50">
                    <td class="px-4 py-3">Rating Updated</td>
                    <td class="px-4 py-3">Player</td>
                    <td class="px-4 py-3"><code class="text-xs">PlayerRatingUpdatedNotification</code></td>
                    <td class="px-4 py-3 text-center"><span class="bg-gray-100 px-2 py-1 rounded text-xs">Low</span></td>
                </tr>
            </tbody>
        </table>
    </div>

    <div class="screenshot-placeholder-sm mt-4">
        <p class="text-xl text-gray-400 mb-2">📸</p>
        <p class="text-gray-600 font-mono">[screenshot-player-list.png]</p>
        <p class="text-xs text-gray-500 mt-2">Team player list with completion status</p>
    </div>
</div>

<!-- Summary -->
<div class="section-card bg-gradient-to-r from-purple-50 to-blue-50">
    <h3 class="text-2xl font-bold mb-4">📚 Quick Reference Summary</h3>
    
    <div class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-6">
        <div class="bg-white rounded-lg p-4 shadow">
            <p class="text-3xl font-bold text-purple-600 mb-2">8</p>
            <p class="text-gray-700">Required Fields</p>
        </div>
        <div class="bg-white rounded-lg p-4 shadow">
            <p class="text-3xl font-bold text-green-600 mb-2">100%</p>
            <p class="text-gray-700">Completeness Needed</p>
        </div>
        <div class="bg-white rounded-lg p-4 shadow">
            <p class="text-3xl font-bold text-blue-600 mb-2">~8</p>
            <p class="text-gray-700">Notification Types</p>
        </div>
        <div class="bg-white rounded-lg p-4 shadow">
            <p class="text-3xl font-bold text-orange-600 mb-2">4</p>
            <p class="text-gray-700">Player Statuses</p>
        </div>
    </div>

    <div class="bg-white rounded-lg p-6">
        <p class="font-semibold text-gray-800 mb-3">🎯 Key Takeaways:</p>
        <ul class="space-y-2 text-gray-700">
            <li class="flex items-start">
                <span class="text-green-500 mr-2">•</span>
                <span>Players created with incomplete profiles cannot participate until 100% complete</span>
            </li>
            <li class="flex items-start">
                <span class="text-blue-500 mr-2">•</span>
                <span>ID document upload is mandatory for verification and digital ID generation</span>
            </li>
            <li class="flex items-start">
                <span class="text-purple-500 mr-2">•</span>
                <span>Digital ID cards are automatically generated and emailed upon profile completion</span>
            </li>
            <li class="flex items-start">
                <span class="text-orange-500 mr-2">•</span>
                <span>Player status changes trigger notifications to player, captain, and admins</span>
            </li>
        </ul>
    </div>
</div>

