<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Certificate of Participation - {{ $player_name ?? 'Player' }}</title>
    <style>       

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Montserrat-Regular', Arial, sans-serif;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            background-color: #f5f5f5;
            padding: 20px;
        }

        .certificate-container {
            width: 100%;
            max-width: 842px; /* A4 landscape width */
            aspect-ratio: 842 / 595; /* Maintain A4 landscape proportions */
            position: relative;
            background-image: url("{{ asset('Certificate.jpg') }}");
            background-size: cover;
            background-position: center;
            background-repeat: no-repeat;
            box-shadow: 0 15px 35px rgba(0, 0, 0, 0.2);
            border-radius: 8px;
            overflow: hidden;
            margin: 0 auto;
        }

        /* Text overlay styles */
        .text-overlay {
            position: absolute;
            width: 100%;
            height: 100%;
            z-index: 10;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
        }

        /* Certificate title */
        .certificate-title {
            font-family: 'Montserrat-Bold', sans-serif;
            font-size: clamp(18px, 3.3vw, 28px); /* Responsive font size */
            color: #ffffff;
            text-transform: uppercase;
            letter-spacing: clamp(1px, 0.4vw, 3px);
            text-align: center;
            margin-bottom: 8px;
            text-shadow: 2px 2px 4px rgba(0, 0, 0, 0.5);
            position: absolute;
            top: 13.4%; /* 80px / 595px = 13.4% */
            left: 50%;
            transform: translateX(-50%);
        }

        .certificate-subtitle {
            font-family: 'Montserrat-Bold', sans-serif;
            font-size: clamp(14px, 2.4vw, 20px); /* Responsive font size */
            color: #ffffff;
            text-transform: uppercase;
            letter-spacing: clamp(1px, 0.3vw, 2px);
            text-align: center;
            text-shadow: 2px 2px 4px rgba(0, 0, 0, 0.5);
            position: absolute;
            top: 20.2%; /* 120px / 595px = 20.2% */
            left: 50%;
            transform: translateX(-50%);
        }

        /* Main content area */
        .main-content {
            position: absolute;
            top: 70%; /* 350px / 595px = 58.8% */
            left: 50%;
            transform: translate(-50%, -50%);
            text-align: center;
            width: 85%;
            max-width: 600px;
        }

        /* "This is to certify that" text */
        .certify-text {
            font-family: 'Montserrat-Bold', sans-serif;
            font-size: clamp(12px, 2.1vw, 18px); /* Responsive font size */
            color: #4f585a;
            text-transform: uppercase;
            letter-spacing: clamp(0.5px, 0.1vw, 1px);
            margin-bottom: clamp(10px, 1.7vw, 20px);
            text-shadow: 1px 1px 2px rgba(255, 255, 255, 0.8);
        }

        /* Player name */
        .recipient-name {
            font-family: 'Segoe UI', cursive;
            font-size: clamp(24px, 4.7vw, 40px); /* Responsive font size */
            color: #2b672f;
            font-weight: bold;
            margin: clamp(10px, 1.7vw, 20px) 0;
            text-shadow: 2px 2px 4px rgba(255, 255, 255, 0.8);
            line-height: 1.1;
        }

        /* Team name (if provided) */
        .team-name {
            font-family: 'Montserrat-SemiBold', sans-serif;
            font-size: clamp(12px, 1.9vw, 18px); /* Responsive font size */
            color: #4f585a;
            margin: clamp(5px, 0.8vw, 10px) 0;
            text-shadow: 1px 1px 2px rgba(255, 255, 255, 0.8);
        }

        /* Description text */
        .description-text {
            font-family: 'Segoe UI', sans-serif;
            font-size: clamp(10px, 1.7vw, 15px); /* Responsive font size */
            color: #4f585a;
            line-height: 1.6;
            margin: clamp(15px, 2.5vw, 30px) 0;
            text-shadow: 1px 1px 2px rgba(255, 255, 255, 0.8);
            max-width: 500px;
            margin-left: auto;
            margin-right: auto;
        }

        /* QR Code section */
        .qr-section {
            position: absolute;
            bottom: 20.2%; /* 120px / 595px = 20.2% */
            left: 50%;
            transform: translateX(-50%);
            text-align: center;
            z-index: 15;
        }

        .qr-code {
            width: clamp(60px, 9.5vw, 80px); /* Responsive QR code size */
            height: clamp(60px, 9.5vw, 80px);
            background: white;
            border: 2px solid #ddd;
            border-radius: 8px;
            padding: 5px;
            margin-bottom: clamp(4px, 0.7vw, 8px);
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
        }

        .qr-code img {
            width: 100%;
            height: 100%;
            object-fit: contain;
        }

        .qr-text {
            font-family: 'Montserrat-Regular', sans-serif;
            font-size: clamp(8px, 1.2vw, 10px); /* Responsive font size */
            color: #666666;
            text-shadow: 1px 1px 2px rgba(255, 255, 255, 0.8);
        }

        /* Footer section */
        .footer-section {
            position: absolute;
            bottom: 6.7%; /* 40px / 595px = 6.7% */
            width: 100%;
            display: flex;
            justify-content: space-between;
            padding: 0 clamp(30px, 7.1vw, 60px); /* Responsive padding */
            z-index: 15;
        }

        .certificate-id-text, .generated-date-text {
            font-family: 'Montserrat-Regular', sans-serif;
            font-size: clamp(10px, 1.7vw, 14px); /* Responsive font size */
            line-height: 1.4;
            text-shadow: 1px 1px 2px rgba(255, 255, 255, 0.8);
        }

        .certificate-id-label {
            font-family: 'Montserrat-Bold', sans-serif;
            color: #d52f20;
            font-weight: 700;
        }

        .certificate-id-value {
            font-family: 'Montserrat-Regular', sans-serif;
            color: #50585a;
        }

        .generated-date-label {
            font-family: 'Montserrat-Bold', sans-serif;
            color: #2b672f;
            font-weight: 700;
        }

        .generated-date-value {
            font-family: 'Montserrat-Regular', sans-serif;
            color: #50585a;
        }

        /* Tournament name overlay */
        .tournament-name {
            position: absolute;
            top: 26.9%; /* 160px / 595px = 26.9% */
            left: 50%;
            transform: translateX(-50%);
            font-family: 'Montserrat-SemiBold', sans-serif;
            font-size: clamp(12px, 1.9vw, 16px); /* Responsive font size */
            color: #2b672f;
            text-transform: uppercase;
            letter-spacing: clamp(0.5px, 0.1vw, 1px);
            text-shadow: 1px 1px 2px rgba(255, 255, 255, 0.8);
        }

        /* Player details section */
        .player-details {
            position: absolute;
            top: 33.6%; /* 200px / 595px = 33.6% */
            right: clamp(30px, 7.1vw, 60px); /* Responsive positioning */
            background: rgba(255, 255, 255, 0.9);
            padding: clamp(8px, 1.4vw, 15px); /* Responsive padding */
            border-radius: 8px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            z-index: 15;
            min-width: clamp(150px, 23.8vw, 200px); /* Responsive width */
        }

        .detail-item {
            margin: clamp(4px, 0.7vw, 8px) 0;
            font-size: clamp(8px, 1.2vw, 12px); /* Responsive font size */
        }

        .detail-label {
            font-family: 'Montserrat-Bold', sans-serif;
            color: #333;
            font-weight: 600;
        }

        .detail-value {
            font-family: 'Montserrat-Regular', sans-serif;
            color: #666;
            margin-left: 5px;
        }

        /* Print styles */
        @media print {
            body {
                background: white;
                padding: 0;
            }
            
            .certificate-container {
                box-shadow: none;
                border-radius: 0;
                width: 100%;
                height: 100vh;
            }
        }

        /* Responsive adjustments */
        @media (max-width: 768px) {
            body {
                padding: 10px;
            }
            
            .certificate-container {
                width: 100%;
                max-width: 100%;
                aspect-ratio: 842/595;
            }
            
            .main-content {
                width: 90%;
                top: 70%;
            }
            
            .player-details {
                position: static;
                margin: 20px auto;
                max-width: 90%;
                width: 100%;
                top: auto;
                right: auto;
            }
            
            .footer-section {
                /* flex-direction: column; */
                gap: 10px;
                align-items: center;
                text-align: center;
                bottom: 5%;
            }
        }

        @media (max-width: 480px) {
            .certificate-title {
                font-size: clamp(16px, 4vw, 20px);
            }
            
            .certificate-subtitle {
                font-size: clamp(12px, 3vw, 16px);
            }
            
            .recipient-name {
                font-size: clamp(20px, 6vw, 32px);
            }
            
            .main-content {
                top: 70%;
                width: 95%;
            }
            
            .qr-section {
                bottom: 25%;
            }
            
            .qr-code {
                width: clamp(50px, 12vw, 70px);
                height: clamp(50px, 12vw, 70px);
            }
        }

        @media (max-width: 320px) {
            .certificate-container {
                aspect-ratio: 842/595;
                min-height: 200px;
            }
            
            .main-content {
                top: 70%;
            }
            
            .player-details {
                padding: 8px;
                margin: 10px auto;
            }
            
            .detail-item {
                font-size: 10px;
            }
        }
    </style>
</head>
<body>
    <div class="certificate-container">
        <div class="text-overlay">
            
            <!-- Main Content -->
            <div class="main-content">
                <h2 class="recipient-name">{{ $player_name ?? 'Player Name' }}</h2>
                @if(isset($team_name) && $team_name)
                    <div class="team-name">{{ $team_name }}</div>
                @endif
                <p class="description-text">
                    {{ $description ?? '' }}
                </p>
            </div>

            <div class="footer-section">
                <div class="certificate-id-text">
                    <div class="certificate-id-label">Certificate ID:</div>
                    <div class="certificate-id-value">{{ $digital_id ?? 'CERT-000075-770DE884' }}</div>
                </div>
                <div class="generated-date-text">
                 <div class="generated-date-label">Generated on</div>
                    <div class="generated-date-value">{{ $issued_date ?? now()->format('F j, Y') }}</div>
                </div>
            </div>
        </div>
    </div>
</body>
</html>