<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Certificate of Participation</title>
    <style>
        @font-face {
            font-family: 'Montserrat-SemiBold';
            src: url('{{ public_path('fonts/Montserrat-SemiBold.ttf') }}') format('truetype');
            font-weight: 600;
            font-style: normal;
        }
        @font-face {
            font-family: 'Montserrat-Bold';
            src: url('{{ public_path('fonts/Montserrat-Bold.ttf') }}') format('truetype');
            font-weight: 700;
            font-style: normal;
        }
        @font-face {
            font-family: 'Montserrat-Regular';
            src: url('{{ public_path('fonts/Montserrat-Regular.ttf') }}') format('truetype');
            font-weight: 400;
            font-style: normal;
        }
        @font-face {
            font-family: 'Niladan Bila Script';
            src: url('{{ public_path('fonts/NiladanBilaScript.ttf') }}') format('truetype');
            font-weight: normal;
            font-style: normal;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Montserrat-Regular', Arial, sans-serif;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            background-color: #f5f5f5;
            padding: 20px;
        }

        .certificate-container {
            width: 842px; /* A4 landscape width */
            height: 595px; /* A4 landscape height */
            position: relative;
            background-image: url("/Certificate.jpg");
            background-size: cover;
            background-position: center;
            background-repeat: no-repeat;
            box-shadow: 0 15px 35px rgba(0, 0, 0, 0.2);
            border-radius: 8px;
            overflow: hidden;
        }

        /* Text overlay styles */
        .text-overlay {
            position: absolute;
            width: 100%;
            height: 100%;
            z-index: 10;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
        }

        /* Certificate title */
        .certificate-title {
            font-family: 'Montserrat-Bold', sans-serif;
            font-size: 28px;
            color: #ffffff;
            text-transform: uppercase;
            letter-spacing: 3px;
            text-align: center;
            margin-bottom: 8px;
            text-shadow: 2px 2px 4px rgba(0, 0, 0, 0.5);
            position: absolute;
            top: 80px;
            left: 50%;
            transform: translateX(-50%);
        }

        .certificate-subtitle {
            font-family: 'Montserrat-Bold', sans-serif;
            font-size: 20px;
            color: #ffffff;
            text-transform: uppercase;
            letter-spacing: 2px;
            text-align: center;
            text-shadow: 2px 2px 4px rgba(0, 0, 0, 0.5);
            position: absolute;
            top: 120px;
            left: 50%;
            transform: translateX(-50%);
        }

        /* Main content area */
        .main-content {
            position: absolute;
            top: 70%;
            left: 50%;
            transform: translate(-50%, -50%);
            text-align: center;
            width: 80%;
            max-width: 600px;
        }

        /* "This is to certify that" text */
        .certify-text {
            font-family: 'Montserrat-Bold', sans-serif;
            font-size: 18px;
            color: #4f585a;
            text-transform: uppercase;
            letter-spacing: 1px;
            margin-bottom: 20px;
            text-shadow: 1px 1px 2px rgba(255, 255, 255, 0.8);
        }

        /* Recipient name */
        .recipient-name {
            font-family: 'Segoe UI', cursive;
            font-size: 40px;
            color: #2b672f;
            font-weight: bold;
            margin: 20px 0;
            text-shadow: 2px 2px 4px rgba(255, 255, 255, 0.8);
            line-height: 1.1;
        }

        /* Description text */
        .description-text {
            font-family: 'Segoe UI', sans-serif;
            font-size: 15px;
            color: #4f585a;
            line-height: 1.6;
            margin: 30px 0;
            text-shadow: 1px 1px 2px rgba(255, 255, 255, 0.8);
            max-width: 500px;
            margin-left: auto;
            margin-right: auto;
        }

        /* QR Code section */
        .qr-section {
            position: absolute;
            bottom: 120px;
            left: 50%;
            transform: translateX(-50%);
            text-align: center;
            z-index: 15;
        }

        .qr-code {
            width: 80px;
            height: 80px;
            background: white;
            border: 2px solid #ddd;
            border-radius: 8px;
            padding: 5px;
            margin-bottom: 8px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
        }

        .qr-code img {
            width: 100%;
            height: 100%;
            object-fit: contain;
        }

        .qr-text {
            font-family: 'Montserrat-Regular', sans-serif;
            font-size: 10px;
            color: #666666;
            text-shadow: 1px 1px 2px rgba(255, 255, 255, 0.8);
        }

        /* Footer section */
        .footer-section {
            position: absolute;
            bottom: 40px;
            width: 100%;
            display: flex;
            justify-content: space-between;
            padding: 0 60px;
            z-index: 15;
        }

        .certificate-id-text, .generated-date-text {
            font-family: 'Montserrat-Regular', sans-serif;
            font-size: 14px;
            line-height: 1.4;
            text-shadow: 1px 1px 2px rgba(255, 255, 255, 0.8);
        }

        .certificate-id-label {
            font-family: 'Montserrat-Bold', sans-serif;
            color: #d52f20;
            font-weight: 700;
        }

        .certificate-id-value {
            font-family: 'Montserrat-Regular', sans-serif;
            color: #50585a;
        }

        .generated-date-label {
            font-family: 'Montserrat-Bold', sans-serif;
            color: #2b672f;
            font-weight: 700;
        }

        .generated-date-value {
            font-family: 'Montserrat-Regular', sans-serif;
            color: #50585a;
        }

        /* Tournament name overlay */
        .tournament-name {
            position: absolute;
            top: 160px;
            left: 50%;
            transform: translateX(-50%);
            font-family: 'Montserrat-SemiBold', sans-serif;
            font-size: 16px;
            color: #2b672f;
            text-transform: uppercase;
            letter-spacing: 1px;
            text-shadow: 1px 1px 2px rgba(255, 255, 255, 0.8);
        }

        /* Print styles */
        @media print {
            body {
                background: white;
                padding: 0;
            }
            
            .certificate-container {
                box-shadow: none;
                border-radius: 0;
                width: 100%;
                height: 100vh;
            }
        }

        /* Responsive adjustments */
        @media (max-width: 900px) {
            .certificate-container {
                width: 100%;
                height: auto;
                aspect-ratio: 842/595;
                max-width: 100%;
            }
            
            .recipient-name {
                font-size: 48px;
            }
            
            .certificate-title {
                font-size: 24px;
            }
            
            .certificate-subtitle {
                font-size: 18px;
            }
        }
    </style>
</head>
<body>
    <div class="certificate-container">
        <div class="text-overlay">

            
            <!-- Main Content -->
            <div class="main-content">
                <h2 class="recipient-name">{{ $recipient['name'] ?? 'Victor Kipkoech' }}</h2>
                <p class="description-text">
                    <!-- {{ $description ?? 'has successfully participated in the 1st Edition tournament held from August 3, 2025 to August 31, 2025 and has demonstrated exceptional sportsmanship, skill, and dedication throughout the competition.' }} -->
                </p>
            </div>
            
            <!-- QR Code Section -->
            <!-- <div class="qr-section">
                <div class="qr-code">
                    <img src="{{ $qrCodeUrl ?? 'https://api.qrserver.com/v1/create-qr-code/?size=100x100&data=https://example.com/verify/CERT-000075-770DE884' }}" alt="QR Code">
                </div>
                <p class="qr-text">Scan to verify authenticity</p>
            </div> -->
            
            <!-- Footer Section -->
            <div class="footer-section">
                <div class="certificate-id-text">
                    <div class="certificate-id-label">Certificate ID:</div>
                    <div class="certificate-id-value">{{ $certificateId ?? 'CERT-000075-770DE884' }}</div>
                </div>
                <div class="generated-date-text">
                    <div class="generated-date-label">Generated on</div>
                    <div class="generated-date-value">{{ $generatedAt ?? 'September 20, 2025' }}</div>
                </div>
            </div>
        </div>
    </div>
</body>
</html>