<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" @class(['dark' => ($appearance ?? 'system') == 'dark'])>
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">

        {{-- Inline script to detect system dark mode preference and apply it immediately --}}
        <script>
            (function() {
                const appearance = '{{ $appearance ?? "system" }}';

                if (appearance === 'system') {
                    const prefersDark = window.matchMedia('(prefers-color-scheme: dark)').matches;

                    if (prefersDark) {
                        document.documentElement.classList.add('dark');
                    }
                }
            })();
        </script>

        {{-- LIGHT MODE OVERRIDE - Comment out this entire script block to disable light mode forcing --}}
        <script>
            (function() {
                // Force light mode - remove dark class if present
                document.documentElement.classList.remove('dark');
                
                // Override localStorage to force light mode
                const originalSetItem = localStorage.setItem;
                localStorage.setItem = function(key, value) {
                    if (key === 'appearance') {
                        // Force light mode in localStorage
                        originalSetItem.call(this, key, 'light');
                    } else {
                        originalSetItem.call(this, key, value);
                    }
                };
                
                // Set appearance to light in localStorage
                localStorage.setItem('appearance', 'light');
                
                // Prevent dark mode from being added back
                const originalAddClass = document.documentElement.classList.add;
                document.documentElement.classList.add = function(...classes) {
                    const filteredClasses = classes.filter(cls => cls !== 'dark');
                    if (filteredClasses.length > 0) {
                        originalAddClass.apply(this, filteredClasses);
                    }
                };
                
                // Override the applyTheme function if it exists
                if (window.applyTheme) {
                    const originalApplyTheme = window.applyTheme;
                    window.applyTheme = function(appearance) {
                        // Always force light mode regardless of input
                        document.documentElement.classList.remove('dark');
                    };
                }
                
                // Override initializeTheme function
                window.initializeTheme = function() {
                    // Force light mode and prevent dark mode
                    document.documentElement.classList.remove('dark');
                    localStorage.setItem('appearance', 'light');
                };
                
                // Override matchMedia for prefers-color-scheme to always return false
                const originalMatchMedia = window.matchMedia;
                window.matchMedia = function(query) {
                    if (query === '(prefers-color-scheme: dark)') {
                        return {
                            matches: false,
                            addEventListener: function() {},
                            removeEventListener: function() {}
                        };
                    }
                    return originalMatchMedia.call(this, query);
                };
            })();
        </script>

        {{-- Inline style to set the HTML background color based on our theme in app.css --}}
        <style>
            html {
                background-color: oklch(1 0 0);
            }

            html.dark {
                background-color: oklch(0.145 0 0);
            }
        </style>

        <title inertia>The Milimus Tournament</title>

        <meta name="csrf-token" content="{{ csrf_token() }}">

        {{-- Include app settings (favicon, meta tags, SEO) --}}
        <x-app-settings />

        <link rel="preconnect" href="https://fonts.bunny.net">
        <link href="https://fonts.bunny.net/css?family=instrument-sans:400,500,600" rel="stylesheet" />

        @routes
        @viteReactRefresh
        @vite(['resources/js/app.tsx', "resources/js/pages/{$page['component']}.tsx"])
        @inertiaHead
    </head>
    <body class="font-sans antialiased">
        @inertia
    </body>
</html>
