import { LucideIcon } from 'lucide-react';
import type { Config } from 'ziggy-js';

export interface Auth {
    user: User;
    impersonation?: {
        is_impersonating: boolean;
        impersonated_user: {
            id: number;
            name: string;
            email: string;
        };
        original_user: {
            id: number;
            name: string;
            email: string;
        };
    };
}

export interface BreadcrumbItem {
    title: string;
    href: string;
}

export interface NavGroup {
    title: string;
    items: NavItem[];
}

export interface NavItem {
    title: string;
    href: string;
    icon?: LucideIcon | null;
    isActive?: boolean;
    children?: NavItem[];
    permission?: string | string[];
}

export interface SharedData {
    name: string;
    quote: { message: string; author: string };
    auth: Auth;
    ziggy: Config & { location: string };
    sidebarOpen: boolean;
    [key: string]: unknown;
}

export interface User {
    id: number;
    name: string;
    email: string;
    avatar?: string;
    email_verified_at: string | null;
    created_at: string;
    updated_at: string;
    [key: string]: unknown; // This allows for additional properties...
}

// Frontend Content Types
export interface NewsArticle {
    id?: number;
    title: string;
    excerpt: string;
    content: string;
    category: string;
    author: string;
    author_image: string;
    date: string;
    read_time: number;
    image: string;
    tags: string[];
    featured: boolean;
    status: string;
    published_at: string;
    meta_description: string;
    meta_keywords: string;
    views?: number;
    likes?: number;
    created_at?: string;
}

export interface GalleryImage {
    id?: number;
    src: string;
    alt: string;
    title: string;
    description: string;
    category: string;
    edition: string;
    height: number;
    photographer: string;
    date_taken: string;
    status: string;
    sort_order: number;
    featured: boolean;
    created_at?: string;
}

export interface Testimonial {
    id?: number;
    name: string;
    role: string;
    team: string;
    image: string;
    rating: number;
    quote: string;
    achievement: string;
    year: number;
    sort_order: number;
    status: string;
    active: boolean;
    featured: boolean;
    created_at?: string;
}

export interface Sponsor {
    id?: number;
    name: string;
    category: string;
    logo: string;
    description: string;
    tier: string;
    website_url: string;
    contact_email: string;
    contact_phone: string;
    sort_order: number;
    status: string;
    active: boolean;
    created_at?: string;
}

export interface TournamentHighlight {
    id?: number;
    icon: string;
    title: string;
    description: string;
    value: string;
    color: string;
    sort_order: number;
    status?: string;
    active: boolean;
    created_at?: string;
    updated_at?: string;
}
