import React from "react";
import { router } from "@inertiajs/react";
import { Button } from "@/components/ui/button";
import Header from "@/components/frontend/layout/Header";
import Footer from "@/components/frontend/sections/Footer";
import { CheckCircle, Mail, Shield } from "lucide-react";

const OtpSuccess = ({ type }) => {
  const isPlayer = type === 'player';
  const isOfficial = type === 'official';

  return (
    <>
      <Header />
      <div className="min-h-screen bg-gradient-to-br from-green-50 to-gray-50 py-8">
        <div className="container mx-auto px-4 max-w-md">
          <div className="text-center mb-8">
            <div className="w-20 h-20 bg-green-600 rounded-full flex items-center justify-center mx-auto mb-4">
              <CheckCircle className="h-10 w-10 text-white" />
            </div>
            <h1 className="text-3xl font-bold text-gray-900">Email Verified!</h1>
            <p className="text-gray-600 mt-2">Your email has been successfully verified</p>
          </div>

          <div className="bg-white rounded-lg shadow-xl border border-gray-200 p-8">
            <div className="text-center space-y-6">
              <div className="p-4 bg-green-50 border border-green-200 rounded-lg">
                <CheckCircle className="h-12 w-12 text-green-600 mx-auto mb-4" />
                <h3 className="text-lg font-semibold text-green-900 mb-2">
                  {isPlayer ? 'Player Email Verified' : 'Official Email Verified'}
                </h3>
                <p className="text-green-800">
                  {isPlayer 
                    ? 'You have successfully verified your email as a team player.'
                    : 'You have successfully verified your email as a team official.'
                  }
                </p>
              </div>

              <div className="space-y-4">
                <div className="p-4 bg-blue-50 border border-blue-200 rounded-lg">
                  <div className="flex items-center space-x-3 mb-3">
                    <Mail className="h-5 w-5 text-blue-600" />
                    <h4 className="font-medium text-blue-900">What happens next?</h4>
                  </div>
                  <ul className="text-sm text-blue-800 space-y-2">
                    <li>• You will receive login credentials via email</li>
                    <li>• You must change your password on first login</li>
                    <li>• Complete your profile information</li>
                    <li>• Wait for team captain to complete payment</li>
                    <li>• Access the tournament system after payment</li>
                  </ul>
                </div>

                <div className="p-4 bg-yellow-50 border border-yellow-200 rounded-lg">
                  <div className="flex items-center space-x-3 mb-3">
                    <Shield className="h-5 w-5 text-yellow-600" />
                    <h4 className="font-medium text-yellow-900">Important Notes</h4>
                  </div>
                  <ul className="text-sm text-yellow-800 space-y-1">
                    <li>• Check your email for login credentials</li>
                    <li>• Contact your team captain if you have issues</li>
                    <li>• Keep your login credentials secure</li>
                    <li>• You cannot access the system until payment is complete</li>
                  </ul>
                </div>
              </div>

              <div className="space-y-3">
                <Button
                  onClick={() => router.visit(route('login'))}
                  className="w-full bg-green-600 hover:bg-green-700 text-white"
                >
                  Go to Login
                </Button>
                
                <Button
                  variant="outline"
                  onClick={() => router.visit(route('home'))}
                  className="w-full"
                >
                  Back to Home
                </Button>
              </div>
            </div>
          </div>
        </div>
      </div>
      <Footer />
    </>
  );
};

export default OtpSuccess; 