import { Head } from "@inertiajs/react";
import Header from "@/components/frontend/layout/Header";
import Footer from "@/components/frontend/sections/Footer";
import { Shield, Users, Trophy, Clock, AlertTriangle, CheckCircle, XCircle, Info } from "lucide-react";

const Rules = () => {
  const sections = [
    {
      id: "general",
      title: "General Rules",
      icon: Shield,
      rules: [
        "All participants must be registered and approved before the tournament begins",
        "Teams must have a minimum of 11 players and a maximum of 25 players",
        "All players must be at least 16 years old and provide valid identification",
        "Teams must have a designated captain and manager",
        "All participants must agree to abide by the tournament's code of conduct",
        "Any form of discrimination, harassment, or unsportsmanlike conduct will result in immediate disqualification"
      ]
    },
    {
      id: "registration",
      title: "Registration & Eligibility",
      icon: Users,
      rules: [
        "Registration must be completed at least 7 days before the tournament start date",
        "All team members must provide valid government-issued identification",
        "Players can only be registered for one team per tournament",
        "Team registration fees must be paid in full before the deadline",
        "Late registrations may be accepted at the discretion of tournament organizers",
        "Teams must submit their final squad list 48 hours before the first match"
      ]
    },
    {
      id: "competition",
      title: "Competition Format",
      icon: Trophy,
      rules: [
        "Tournament will follow FIFA rules and regulations",
        "Matches will be 90 minutes (45 minutes per half) with a 15-minute break",
        "Extra time will be played if necessary (2 x 15 minutes)",
        "Penalty shootouts will determine winners if scores remain level after extra time",
        "Teams will be seeded based on previous tournament performance",
        "Group stage followed by knockout rounds"
      ]
    },
    {
      id: "matchday",
      title: "Match Day Procedures",
      icon: Clock,
      rules: [
        "Teams must arrive at least 30 minutes before kickoff",
        "Players must present valid identification before each match",
        "Substitutions are limited to 5 players per match",
        "Injured players must be replaced within 5 minutes or the team plays with 10 players",
        "Match officials' decisions are final and binding",
        "Teams must provide their own equipment (jerseys, boots, shin guards)"
      ]
    },
    {
      id: "discipline",
      title: "Disciplinary Actions",
      icon: AlertTriangle,
      rules: [
        "Yellow cards: Warning, accumulation may lead to suspension",
        "Red cards: Immediate ejection and minimum 1-match suspension",
        "Violent conduct: Minimum 3-match suspension",
        "Unsportsmanlike behavior: Warning or suspension",
        "Appeals process available within 24 hours of disciplinary action",
        "Tournament organizers reserve the right to impose additional sanctions"
      ]
    },
    {
      id: "prizes",
      title: "Prizes & Awards",
      icon: Trophy,
      rules: [
        "Champions: Trophy, medals, and cash prize",
        "Runners-up: Medals and cash prize",
        "Third place: Medals and cash prize",
        "Individual awards: Best Player, Top Scorer, Best Goalkeeper",
        "Fair Play Award: Team with best disciplinary record",
        "All prizes subject to verification and may be withheld pending investigation"
      ]
    }
  ];

  const getIconColor = (iconName: string) => {
    const colors = {
      Shield: "text-blue-600 bg-blue-100",
      Users: "text-green-600 bg-green-100", 
      Trophy: "text-yellow-600 bg-yellow-100",
      Clock: "text-purple-600 bg-purple-100",
      AlertTriangle: "text-red-600 bg-red-100",
      Info: "text-gray-600 bg-gray-100"
    };
    return colors[iconName as keyof typeof colors] || "text-gray-600 bg-gray-100";
  };

  return (
    <>
      <Head title="Rules & Regulations - Tournament" />
    <Header />
      
      <div className="min-h-screen bg-gray-50">
        <div className="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8 py-12">
          {/* Header */}
          <div className="text-center mb-12">
            <div className="inline-flex items-center justify-center w-16 h-16 bg-blue-100 rounded-full mb-6">
              <Shield className="w-8 h-8 text-blue-600" />
            </div>
            <h1 className="text-4xl font-bold text-gray-900 mb-4">Rules & Regulations</h1>
            <p className="text-lg text-gray-600 max-w-3xl mx-auto">
              Comprehensive guidelines and regulations for all tournament participants. 
              Please read carefully and ensure full compliance.
            </p>
          </div>

          {/* Important Notice */}
          <div className="bg-gradient-to-r from-blue-50 to-purple-50 border border-blue-200 rounded-lg p-6 mb-12">
            <div className="flex items-start space-x-4">
              <div className="flex-shrink-0">
                <Info className="w-6 h-6 text-blue-600 mt-1" />
              </div>
              <div>
                <h3 className="text-lg font-semibold text-blue-900 mb-2">Important Notice</h3>
                <p className="text-blue-800">
                  These rules and regulations are binding for all participants. By registering for the tournament, 
                  you agree to comply with all stated rules. Failure to adhere to these regulations may result in 
                  disqualification or other disciplinary actions.
                </p>
              </div>
            </div>
          </div>

          {/* Rules Sections */}
          <div className="space-y-8">
            {sections.map((section, index) => (
              <div key={section.id} className="bg-white rounded-lg shadow-lg overflow-hidden">
                <div className="bg-gradient-to-r from-gray-50 to-gray-100 px-6 py-4 border-b border-gray-200">
                  <div className="flex items-center space-x-4">
                    <div className={`p-3 rounded-lg ${getIconColor(section.title)}`}>
                      <section.icon className="w-6 h-6" />
                    </div>
                    <div>
                      <h2 className="text-2xl font-bold text-gray-900">{section.title}</h2>
                      <p className="text-gray-600">Section {index + 1} of {sections.length}</p>
                    </div>
                  </div>
                </div>
                
                <div className="p-6">
                  <div className="space-y-4">
                    {section.rules.map((rule, ruleIndex) => (
                      <div key={ruleIndex} className="flex items-start space-x-3">
                        <div className="flex-shrink-0 mt-1">
                          <CheckCircle className="w-5 h-5 text-green-500" />
                        </div>
                        <p className="text-gray-700 leading-relaxed">{rule}</p>
                      </div>
                    ))}
                  </div>
                </div>
              </div>
            ))}
          </div>

          {/* Additional Information */}
          {/* <div className="mt-12 bg-white rounded-lg shadow-lg p-8">
            <h2 className="text-2xl font-bold text-gray-900 mb-6">Additional Information</h2>
            
            <div className="grid grid-cols-1 md:grid-cols-2 gap-8">
              <div>
                <h3 className="text-lg font-semibold text-gray-900 mb-4">Contact Information</h3>
                <div className="space-y-3">
                  <div className="flex items-center space-x-3">
                    <div className="w-2 h-2 bg-blue-500 rounded-full"></div>
                    <span className="text-gray-700">Tournament Director: John Smith</span>
                  </div>
                  <div className="flex items-center space-x-3">
                    <div className="w-2 h-2 bg-blue-500 rounded-full"></div>
                    <span className="text-gray-700">Email: director@tournament.com</span>
                  </div>
                  <div className="flex items-center space-x-3">
                    <div className="w-2 h-2 bg-blue-500 rounded-full"></div>
                    <span className="text-gray-700">Phone: 07XX XXX XXX</span>
                  </div>
                </div>
              </div>
              
              <div>
                <h3 className="text-lg font-semibold text-gray-900 mb-4">Important Dates</h3>
                <div className="space-y-3">
                  <div className="flex items-center space-x-3">
                    <div className="w-2 h-2 bg-green-500 rounded-full"></div>
                    <span className="text-gray-700">Registration Deadline: March 15, 2024</span>
                  </div>
                  <div className="flex items-center space-x-3">
                    <div className="w-2 h-2 bg-green-500 rounded-full"></div>
                    <span className="text-gray-700">Tournament Start: April 1, 2024</span>
                  </div>
                  <div className="flex items-center space-x-3">
                    <div className="w-2 h-2 bg-green-500 rounded-full"></div>
                    <span className="text-gray-700">Tournament End: April 30, 2024</span>
                  </div>
                </div>
              </div>
            </div>
          </div> */}

          {/* Disclaimer */}
          <div className="mt-8 bg-yellow-50 border border-yellow-200 rounded-lg p-6">
            <div className="flex items-start space-x-4">
              <div className="flex-shrink-0">
                <AlertTriangle className="w-6 h-6 text-yellow-600 mt-1" />
              </div>
              <div>
                <h3 className="text-lg font-semibold text-yellow-900 mb-2">Disclaimer</h3>
                <p className="text-yellow-800">
                  Tournament organizers reserve the right to modify these rules at any time. 
                  Participants will be notified of any changes with reasonable notice. 
                  The organizers' decisions on all matters relating to the tournament are final.
                </p>
              </div>
            </div>
          </div>
      </div>
    </div>

    <Footer />
  </>
);
};

export default Rules; 