import Header from "@/components/frontend/layout/Header";
import HeroSection from "@/components/frontend/sections/HeroSection";
import FeaturesSection from "@/components/frontend/sections/FeaturesSection";
import VideoCTASection from "@/components/frontend/sections/VideoCTASection";
import TournamentHighlightsSection from "@/components/frontend/sections/TournamentHighlightsSection";
import SponsorsSection from "@/components/frontend/sections/SponsorsSection";
import TestimonialsSection from "@/components/frontend/sections/TestimonialsSection";
import NewsSection from "@/components/frontend/sections/NewsSection";
import CallToActionSection from "@/components/frontend/sections/CallToActionSection";
import Footer from "@/components/frontend/sections/Footer";
import FKFComplianceSection from "@/components/frontend/sections/FKFComplianceSection";
import FKFComplianceShowcase from "@/components/frontend/sections/FKFComplianceShowcase";

interface IndexProps {
  heroSlides: any[];
  newsArticles: any[];
  tournamentHighlights: any[];
  tournamentAchievements: any[];
  sponsors: any[];
  testimonials: any[];
  tournamentStats: any[];
  featuredVlog?: any;
}

const Index = ({ 
  heroSlides, 
  newsArticles, 
  tournamentHighlights, 
  tournamentAchievements, 
  sponsors, 
  testimonials, 
  tournamentStats,
  featuredVlog
}: IndexProps) => {
  return (
    <div className="min-h-screen bg-background">
      <Header />
      <main>
        <HeroSection heroSlides={heroSlides} />
        <VideoCTASection featuredVlog={featuredVlog} />
        <TournamentHighlightsSection 
          highlights={tournamentHighlights} 
          achievements={tournamentAchievements}
          stats={tournamentStats}
        />
        <SponsorsSection sponsors={sponsors} />
        <TestimonialsSection testimonials={testimonials} />
        <NewsSection newsArticles={newsArticles} />
        <FKFComplianceShowcase />
        <CallToActionSection />
      </main>
      <Footer />
    </div>
  );
};

export default Index;
