import React from 'react';
import Header from "@/components/frontend/layout/Header";
import Footer from "@/components/frontend/sections/Footer";
import { Quote, Trophy, Users, Calendar, Heart, Target, Award, Phone, Mail, MapPin } from "lucide-react";

const FoundersMessage = () => {
  const founders = [
    {
      name: "Dr. Lilian Milimu",
      role: "Co-Founder",
      image: "/images/founders/lilian-milimu.jpg" // Placeholder
    },
    {
      name: "Fadhili Milimu",
      role: "Founder & Tournament Director",
      image: "/images/founders/fadhili-milimu.jpg", // Placeholder
      contact: {
        phone: "0729565643",
        email: "fadhili@themilimus.co.ke"
      }
    }
  ];

  const tournamentStats = [
    { year: "2021", teams: "8 Men, 2 Ladies", spectators: "500", status: "Completed" },
    { year: "2022", teams: "10 Men, 2 Ladies", spectators: "1,200", status: "Completed" },
    { year: "2023", teams: "12 Men, 4 Ladies", spectators: "2,000-3,000", status: "In Progress" }
  ];

  const tournamentCommittee = [
    { name: "Fadhili Masitsa Milimu", role: "Sponsor & Contact Person", phone: "0729565643", email: "fadhili@themilimus.co.ke" },
    { name: "Hillary Shisiali", role: "Chairman", phone: "0723780305", email: "hillary@themilimus.co.ke" },
    { name: "Simon Shitakule", role: "Finance Manager", phone: "0740085697", email: "simon@themilimus.co.ke" },
    { name: "Rodgers Indeche", role: "Coordinator and Organiser", phone: "0714465830", email: "rogers@themilimus.co.ke" },
    { name: "Nelson Afwayi", role: "Official", phone: "0725459767", email: "nelson@themilimus.co.ke" },
    { name: "Godfrey Shamala", role: "Official", phone: "0790012568", email: "godfrey@themilimus.co.ke" }
  ];

  return (
    <div className="min-h-screen bg-background">
      <Header />
      
      {/* Hero Section */}
      <section className="relative flex items-center justify-center h-[300px] md:h-[400px] bg-gradient-to-br from-primary/80 to-secondary/80 overflow-hidden">
        <img
          src="/images/hero-bg.jpg"
          alt="Founder's Message Hero"
          className="absolute inset-0 w-full h-full object-cover opacity-10 pointer-events-none select-none"
        />
        <div className="absolute inset-0 bg-gradient-to-b from-black/60 to-black/80" />
        <div className="relative z-10 text-center text-white flex flex-col items-center justify-center w-full">
          <Quote className="mx-auto mb-4 h-12 w-12 text-yellow-400" />
          <h1 className="text-4xl md:text-5xl font-extrabold drop-shadow mb-2">Founder's Message</h1>
          <p className="text-lg md:text-xl max-w-2xl mx-auto drop-shadow">
            A legacy of community development through football
          </p>
        </div>
      </section>

      {/* Founders Section */}
      <section className="py-16 bg-white">
        <div className="max-w-6xl mx-auto px-4">
          <div className="text-center mb-12">
            <h2 className="text-3xl font-bold text-gray-900 mb-4">Meet Our Founders</h2>
            <p className="text-lg text-gray-600">Dedicated to transforming communities through sports</p>
          </div>

          <div className="grid md:grid-cols-2 gap-8 mb-16">
            {founders.map((founder, index) => (
              <div key={index} className="bg-gradient-to-br from-green-50 to-blue-50 rounded-xl p-8 border border-gray-200">
                <div className="flex items-center space-x-4 mb-6">
                  <div className="w-20 h-20 bg-gradient-to-br from-primary to-secondary rounded-full flex items-center justify-center">
                    <span className="text-white text-2xl font-bold">
                      {founder.name.split(' ').map(n => n[0]).join('')}
                    </span>
                  </div>
                  <div>
                    <h3 className="text-2xl font-bold text-gray-900">{founder.name}</h3>
                    <p className="text-primary font-semibold">{founder.role}</p>
                  </div>
                </div>
                {founder.contact && (
                  <div className="space-y-2 text-sm text-gray-600">
                    <div className="flex items-center space-x-2">
                      <Phone className="h-4 w-4" />
                      <span>{founder.contact.phone}</span>
                    </div>
                    <div className="flex items-center space-x-2">
                      <Mail className="h-4 w-4" />
                      <span>{founder.contact.email}</span>
                    </div>
                  </div>
                )}
              </div>
            ))}
          </div>
        </div>
      </section>

      {/* Main Message Section */}
      <section className="py-16 bg-gray-50">
        <div className="max-w-7xl mx-auto px-4">
          <div className="bg-white rounded-xl shadow-lg p-8 md:p-12">
            <div className="flex items-center space-x-3 mb-8">
              <Quote className="h-8 w-8 text-primary" />
              <h2 className="text-3xl font-bold text-gray-900">A Message from Our Founder</h2>
            </div>

            <div className="prose prose-lg max-w-none text-gray-700 space-y-6">
              <p className="text-lg leading-relaxed">
                I am writing in regards to a tournament sponsorship request I am placing and future partnership on the subject tournament which is normally held annually with this year being the third.
              </p>

              <div className="bg-blue-50 border-l-4 border-blue-400 p-6 rounded-r-lg">
                <h3 className="text-xl font-semibold text-blue-900 mb-3">Our Motivation</h3>
                <p className="text-blue-800">
                  The motivation to start this tournament in my village which has gained popularity over the last three years was motivated by the loss of my dad way back in 2021 March which occurred abruptly and he was one of the instrumental person in changing our village to a more literate and little known village to the world by establishing a prayer mountain where people all over the world come and pray on that mountain as they seek for blessing and it has remain to be a milestone to the village, he was also instrumental in educating the youth who were less fortunate.
                </p>
              </div>

              <p>
                So upon his death I was faced with a hard task as the first born on what I will do to remember this honourable man and the Idea of having a football tournament was born in 2021 December where until now I have been financing it myself without any support financially from any one.
              </p>

              <h3 className="text-2xl font-bold text-gray-900 mt-8 mb-4">The Reason Behind This Tournament</h3>
              <p>
                The reason behind this tournament beside the inspiration from my late dad was motivated by the below issues at hand:
              </p>

              <div className="grid md:grid-cols-2 gap-6 mt-6">
                <div className="bg-green-50 p-6 rounded-lg">
                  <h4 className="font-semibold text-green-800 mb-2 flex items-center">
                    <Heart className="h-5 w-5 mr-2" />
                    Community Development
                  </h4>
                  <p className="text-green-700 text-sm">
                    My village has really been neglected to the extent that children are dropping out of school and one of my initiatives is to form a foundation in memory of my dad to support the needy in the community through schools but leverage on sports to enable them also achieve their dream.
                  </p>
                </div>

                <div className="bg-yellow-50 p-6 rounded-lg">
                  <h4 className="font-semibold text-yellow-800 mb-2 flex items-center">
                    <Target className="h-5 w-5 mr-2" />
                    Youth Empowerment
                  </h4>
                  <p className="text-yellow-700 text-sm">
                    The level of drop out in schools by young people is very high due to drugs and lack of school fees and in my village football is everything so the best way to keep this young generation busy is through such sports by having a tournament where teams within my community can meet and play against each other through a noble course.
                  </p>
                </div>

                <div className="bg-red-50 p-6 rounded-lg">
                  <h4 className="font-semibold text-red-800 mb-2 flex items-center">
                    <Users className="h-5 w-5 mr-2" />
                    Social Issues
                  </h4>
                  <p className="text-red-700 text-sm">
                    Level of GBV and girls being impregnated is very high and this is due to the fact that the literacy level is very low and many girls and dropping out of school due to pregnancy and youngs boys dropping out due to drugs or becoming boda boda guys its leading our village backwards, so I felt this tournament will have a positive impact to the society and the village at large and true to it it has over the last three years.
                  </p>
                </div>

                <div className="bg-blue-50 p-6 rounded-lg">
                  <h4 className="font-semibold text-blue-800 mb-2 flex items-center">
                    <Trophy className="h-5 w-5 mr-2" />
                    Talent Development
                  </h4>
                  <p className="text-blue-700 text-sm">
                    Above all western region is the hub of football talent, with a good case one of my village High school called Shanderema boys reached Finals and became second after playing with St. Anthony Boys Kitale and also represented Kenya and some of the boys there were playing under the kenya under 18 in the current concluded Cecafa.
                  </p>
                </div>
              </div>

              <div className="bg-gradient-to-r from-primary to-secondary p-6 rounded-lg text-white">
                <h3 className="text-xl font-bold mb-3">Tournament Growth</h3>
                <div className="grid md:grid-cols-3 gap-4 text-center">
                  {tournamentStats.map((stat, index) => (
                    <div key={index} className="bg-white/10 rounded-lg p-4">
                      <div className="text-2xl font-bold">{stat.year}</div>
                      <div className="text-sm opacity-90">{stat.teams}</div>
                      <div className="text-sm opacity-90">{stat.spectators} spectators</div>
                      <div className="text-xs opacity-75">{stat.status}</div>
                    </div>
                  ))}
                </div>
              </div>

              <div className="bg-gray-50 p-6 rounded-lg">
                <h3 className="text-xl font-bold text-gray-900 mb-4">Current Status</h3>
                <p>
                  We now in the 3rd edition which will kick off this month effective 18th December 2023 to 1st January 2024 with expected attendance of almost 2000 to 3000 spectators and 12 teams for men and 4 teams for ladies as shown below, we have also been given the affiliation letter from FKF to legitimately conduct the tournament.
                </p>
              </div>

              <div className="bg-yellow-50 border-l-4 border-yellow-400 p-6 rounded-r-lg">
                <h3 className="text-xl font-bold text-yellow-900 mb-3">Financial Commitment</h3>
                <p className="text-yellow-800">
                  As the main sponsor I have been able to meet the budget 80% and the tournament is set pending few areas specifically on the award part, public address system, security and other minor logistics issues given the total budget for the tournament is estimated to cost around kshs 450,000/= and have been able to fund myself financially, not easy but worth the course and a lot of sacrifice has gone to this tournament to ensure its a success.
                </p>
              </div>

              <div className="bg-green-50 border-l-4 border-green-400 p-6 rounded-r-lg">
                <h3 className="text-xl font-bold text-green-900 mb-3">Future Vision</h3>
                <p className="text-green-800">
                  My aim is to have this tournament take place annually in December every year, all i need is support from established key players in football like potential sponsors whom I have been able to identify if possible to be my key partner with an agreement.
                </p>
              </div>
            </div>
          </div>
        </div>
      </section>

      {/* Tournament Committee */}
      <section className="py-16 bg-white">
        <div className="max-w-6xl mx-auto px-4">
          <div className="text-center mb-12">
            <h2 className="text-3xl font-bold text-gray-900 mb-4">Tournament Committee</h2>
            <p className="text-lg text-gray-600">Dedicated team working to make the tournament a success</p>
          </div>

          <div className="grid md:grid-cols-2 lg:grid-cols-3 gap-6">
            {tournamentCommittee.map((member, index) => (
              <div key={index} className="bg-gray-50 rounded-lg p-6 border border-gray-200">
                <h3 className="font-semibold text-gray-900 mb-1">{member.name}</h3>
                <p className="text-primary text-sm mb-3">{member.role}</p>
                <div className="flex items-center space-x-2 text-sm text-gray-600">
                  <Phone className="h-4 w-4" />
                  <a href={`tel:${member.phone}`} className="hover:underline">{member.phone}</a>
                </div>
                <div className="flex items-center space-x-2 text-sm text-gray-600">
                  <Mail className="h-4 w-4" />
                  <a href={`mailto:${member.email}`} className="hover:underline">{member.email}</a>
                </div>
              </div>
            ))}
          </div>
        </div>
      </section>

      {/* Call to Action */}
      <section className="py-16 bg-gradient-to-r from-primary/10 to-secondary/10">
        <div className="max-w-4xl mx-auto text-center px-4">
          <h2 className="text-3xl font-bold text-gray-900 mb-4">Support Our Mission</h2>
          <p className="text-lg text-gray-700 mb-8">
            Join us in transforming communities through football and youth development. 
            Your support can make a lasting impact on the lives of young people in our village.
          </p>
          <div className="flex flex-col sm:flex-row gap-4 justify-center">
            <a 
              href="/register-team" 
              className="inline-block px-8 py-3 rounded-full bg-gradient-to-r from-primary to-secondary text-white font-bold text-lg shadow hover:from-secondary hover:to-primary transition-colors"
            >
              Register Your Team
            </a>
            <a 
              href="/contact" 
              className="inline-block px-8 py-3 rounded-full bg-white text-primary font-bold text-lg shadow border border-primary hover:bg-primary hover:text-white transition-colors"
            >
              Contact Us
            </a>
          </div>
        </div>
      </section>

      <Footer />
    </div>
  );
};

export default FoundersMessage;