import Header from "@/components/frontend/layout/Header";
import Footer from "@/components/frontend/sections/Footer";
import { Quote, Heart, Trophy, Users, Target, Award, Star, ArrowRight, Phone, Mail, MapPin } from "lucide-react";
import { Button } from "@/components/ui/button";
import { Card, CardContent } from "@/components/ui/card";
import { Badge } from "@/components/ui/badge";

const Founder = () => {
  return (
    <div className="min-h-screen bg-background">
      <Header />
      
      <main>
        {/* Hero Section */}
        <section className="relative bg-gradient-to-br from-primary/10 via-primary/5 to-background py-20">
          <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div className="text-center">
              <Badge variant="secondary" className="mb-4">
                <Quote className="w-4 h-4 mr-2" />
                A Message from Our Founder
              </Badge>
              <h1 className="text-4xl md:text-6xl font-bold text-foreground mb-6">
                Welcome to The Milimus Tournament
              </h1>
              <p className="text-xl text-muted-foreground max-w-3xl mx-auto">
                Where passion meets competition, and dreams become reality. 
                Join us in celebrating the beautiful game and building a stronger community.
              </p>
            </div>
          </div>
        </section>

        {/* Founder's Message */}
        <section className="py-20">
          <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div className="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
              {/* Founder Image */}
              <div className="relative">
                <div className="aspect-square rounded-2xl bg-gradient-to-br from-primary/20 to-primary/10 overflow-hidden">
                  <div className="w-full h-full flex items-center justify-center">
                    <div className="text-center">
                      <div className="w-32 h-32 mx-auto mb-4 rounded-full bg-primary/20 flex items-center justify-center">
                        <Trophy className="w-16 h-16 text-primary" />
                      </div>
                      <h3 className="text-2xl font-bold text-foreground">John Milimus</h3>
                      <p className="text-muted-foreground">Founder & Tournament Director</p>
                    </div>
                  </div>
                </div>
              </div>

              {/* Message Content */}
              <div className="space-y-6">
                <div className="flex items-center gap-2 mb-6">
                  <Quote className="w-8 h-8 text-primary" />
                  <h2 className="text-3xl font-bold text-foreground">A Personal Message</h2>
                </div>
                
                <div className="space-y-4 text-lg text-muted-foreground leading-relaxed">
                  <p>
                    Dear Football Enthusiasts and Community Members,
                  </p>
                  
                  <p>
                    It is with immense pride and excitement that I welcome you to The Milimus Tournament. 
                    What started as a simple dream to bring our community together through the beautiful 
                    game has grown into something truly special.
                  </p>
                  
                  <p>
                    Football has always been more than just a sport to me. It's a language that transcends 
                    barriers, a passion that unites people from all walks of life, and a platform for 
                    building lasting friendships and memories.
                  </p>
                  
                  <p>
                    Our tournament is not just about competition – it's about celebrating the spirit of 
                    sportsmanship, fostering community bonds, and creating opportunities for young talents 
                    to shine. Every match, every goal, and every moment of camaraderie contributes to 
                    making our community stronger and more vibrant.
                  </p>
                  
                  <p>
                    I want to express my deepest gratitude to all the players, teams, sponsors, volunteers, 
                    and supporters who have made this tournament possible. Your enthusiasm and dedication 
                    inspire us to keep improving and expanding this platform year after year.
                  </p>
                  
                  <p>
                    As we continue this journey together, I invite you to not only participate in the 
                    tournament but to become part of our growing football family. Let's create memories 
                    that will last a lifetime and build a legacy that future generations will be proud of.
                  </p>
                  
                  <p className="font-semibold text-foreground">
                    Thank you for being part of this incredible journey.
                  </p>
                  
                  <p className="text-primary font-medium">
                    Warm regards,<br />
                    John Milimus
                  </p>
                </div>
              </div>
            </div>
          </div>
        </section>

        {/* Vision & Values */}
        <section className="py-20 bg-muted/30">
          <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div className="text-center mb-16">
              <h2 className="text-3xl md:text-4xl font-bold text-foreground mb-4">
                Our Vision & Values
              </h2>
              <p className="text-xl text-muted-foreground max-w-3xl mx-auto">
                The principles that guide our tournament and shape our community
              </p>
            </div>

            <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
              <Card className="text-center p-6">
                <CardContent className="p-0">
                  <div className="w-16 h-16 mx-auto mb-4 rounded-full bg-primary/10 flex items-center justify-center">
                    <Heart className="w-8 h-8 text-primary" />
                  </div>
                  <h3 className="text-xl font-bold text-foreground mb-3">Community First</h3>
                  <p className="text-muted-foreground">
                    Building strong bonds and fostering a sense of belonging through shared passion for football.
                  </p>
                </CardContent>
              </Card>

              <Card className="text-center p-6">
                <CardContent className="p-0">
                  <div className="w-16 h-16 mx-auto mb-4 rounded-full bg-primary/10 flex items-center justify-center">
                    <Target className="w-8 h-8 text-primary" />
                  </div>
                  <h3 className="text-xl font-bold text-foreground mb-3">Excellence</h3>
                  <p className="text-muted-foreground">
                    Striving for the highest standards in organization, fair play, and sportsmanship.
                  </p>
                </CardContent>
              </Card>

              <Card className="text-center p-6">
                <CardContent className="p-0">
                  <div className="w-16 h-16 mx-auto mb-4 rounded-full bg-primary/10 flex items-center justify-center">
                    <Users className="w-8 h-8 text-primary" />
                  </div>
                  <h3 className="text-xl font-bold text-foreground mb-3">Inclusivity</h3>
                  <p className="text-muted-foreground">
                    Welcoming players of all skill levels and backgrounds to participate and grow together.
                  </p>
                </CardContent>
              </Card>

              <Card className="text-center p-6">
                <CardContent className="p-0">
                  <div className="w-16 h-16 mx-auto mb-4 rounded-full bg-primary/10 flex items-center justify-center">
                    <Award className="w-8 h-8 text-primary" />
                  </div>
                  <h3 className="text-xl font-bold text-foreground mb-3">Recognition</h3>
                  <p className="text-muted-foreground">
                    Celebrating achievements and providing opportunities for talent to be discovered.
                  </p>
                </CardContent>
              </Card>

              <Card className="text-center p-6">
                <CardContent className="p-0">
                  <div className="w-16 h-16 mx-auto mb-4 rounded-full bg-primary/10 flex items-center justify-center">
                    <Star className="w-8 h-8 text-primary" />
                  </div>
                  <h3 className="text-xl font-bold text-foreground mb-3">Inspiration</h3>
                  <p className="text-muted-foreground">
                    Motivating the next generation to pursue their dreams in football and beyond.
                  </p>
                </CardContent>
              </Card>

              <Card className="text-center p-6">
                <CardContent className="p-0">
                  <div className="w-16 h-16 mx-auto mb-4 rounded-full bg-primary/10 flex items-center justify-center">
                    <Trophy className="w-8 h-8 text-primary" />
                  </div>
                  <h3 className="text-xl font-bold text-foreground mb-3">Legacy</h3>
                  <p className="text-muted-foreground">
                    Creating lasting memories and traditions that will be cherished for years to come.
                  </p>
                </CardContent>
              </Card>
            </div>
          </div>
        </section>

        {/* Call to Action */}
        <section className="py-20">
          <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div className="text-center">
              <h2 className="text-3xl md:text-4xl font-bold text-foreground mb-6">
                Join Our Football Family
              </h2>
              <p className="text-xl text-muted-foreground mb-8 max-w-2xl mx-auto">
                Ready to be part of something special? Register your team today and experience 
                the magic of The Milimus Tournament.
              </p>
              
              <div className="flex flex-col sm:flex-row gap-4 justify-center">
                <Button size="lg" className="bg-primary hover:bg-primary/90">
                  Register Your Team
                  <ArrowRight className="w-4 h-4 ml-2" />
                </Button>
                <Button variant="outline" size="lg">
                  Learn More About Us
                </Button>
              </div>
            </div>
          </div>
        </section>

        {/* Contact Information */}
        <section className="py-20 bg-muted/30">
          <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div className="text-center mb-12">
              <h2 className="text-3xl font-bold text-foreground mb-4">
                Get in Touch
              </h2>
              <p className="text-xl text-muted-foreground">
                Have questions or want to learn more? We'd love to hear from you.
              </p>
            </div>

            <div className="grid grid-cols-1 md:grid-cols-3 gap-8">
              <Card className="text-center p-6">
                <CardContent className="p-0">
                  <div className="w-12 h-12 mx-auto mb-4 rounded-full bg-primary/10 flex items-center justify-center">
                    <Phone className="w-6 h-6 text-primary" />
                  </div>
                  <h3 className="text-lg font-semibold text-foreground mb-2">Call Us</h3>
                  <p className="text-muted-foreground">+254 700 000 000</p>
                </CardContent>
              </Card>

              <Card className="text-center p-6">
                <CardContent className="p-0">
                  <div className="w-12 h-12 mx-auto mb-4 rounded-full bg-primary/10 flex items-center justify-center">
                    <Mail className="w-6 h-6 text-primary" />
                  </div>
                  <h3 className="text-lg font-semibold text-foreground mb-2">Email Us</h3>
                  <p className="text-muted-foreground">info@milimustournament.com</p>
                </CardContent>
              </Card>

              <Card className="text-center p-6">
                <CardContent className="p-0">
                  <div className="w-12 h-12 mx-auto mb-4 rounded-full bg-primary/10 flex items-center justify-center">
                    <MapPin className="w-6 h-6 text-primary" />
                  </div>
                  <h3 className="text-lg font-semibold text-foreground mb-2">Visit Us</h3>
                  <p className="text-muted-foreground">Nairobi, Kenya</p>
                </CardContent>
              </Card>
            </div>
          </div>
        </section>
      </main>

      <Footer />
    </div>
  );
};

export default Founder;