import Header from "@/components/frontend/layout/Header";
import Footer from "@/components/frontend/sections/Footer";
import { Input } from "@/components/ui/input";
import { Button } from "@/components/ui/button";
import { Mail, Phone, MapPin, Send, Users, MessageCircle } from "lucide-react";
import React, { useState } from "react";
import { contactInfo } from "@/lib/data";


const Contact = () => {
  const [submitted, setSubmitted] = useState(false);

  return (
    <div className="min-h-screen bg-background">
      <Header />
      {/* Hero Section (Uniform with About Us) */}
      <section className="relative flex items-center justify-center h-[380px] md:h-[480px] bg-gradient-to-br from-primary/90 to-secondary/90 overflow-hidden">
        <img
          src="/lovable-uploads/18075074-5322-458c-b0cf-a75db311c3c0.png"
          alt="Contact Hero"
          className="absolute inset-0 w-full h-full object-cover opacity-20 pointer-events-none select-none scale-110"
        />
        <div className="absolute inset-0 bg-gradient-to-b from-black/60 to-black/80" />
        <div className="relative z-10 text-center text-white flex flex-col items-center justify-center w-full animate-fade-in-up">
          <Mail className="mx-auto mb-4 h-16 w-16 text-green-700 animate-bounce-gentle" />
          <h1 className="text-5xl md:text-6xl font-extrabold drop-shadow mb-4 tracking-tight">Contact Us</h1>
          <p className="text-xl md:text-2xl max-w-2xl mx-auto drop-shadow font-medium">
            We're here to help! Reach out for support, partnership, or general inquiries.
          </p>
        </div>
      </section>
      {/* Main Content Cards */}
      <section className="max-w-5xl mx-auto py-12 px-4 grid md:grid-cols-3 gap-8">
        {/* Contact Info Card */}
        <div className="col-span-1 bg-white/95 rounded-2xl shadow-xl p-8 flex flex-col gap-6 justify-center border border-primary/10 hover:shadow-2xl transition-shadow duration-300">
          <h2 className="text-xl font-bold text-primary mb-4 flex items-center gap-2"><MessageCircle className="h-5 w-5" /> Get in Touch</h2>
          {contactInfo.map((item, i) => (
            <div key={i} className="flex items-center gap-3">
              <item.icon className="h-6 w-6 text-primary" />
              <div>
                <div className="text-gray-700 font-semibold">{item.label}</div>
                <div className="text-gray-500 text-sm">{item.value}</div>
              </div>
            </div>
          ))}
          <div className="mt-8 text-gray-400 text-xs">
            Our team will get back to you within 24 hours.
          </div>
        </div>
        {/* Contact Form Card */}
        <div className="col-span-2 flex flex-col justify-center">
          <div className="bg-white/95 rounded-2xl shadow-xl p-8 border border-secondary/10 hover:shadow-2xl transition-shadow duration-300">
            <h2 className="text-2xl font-bold text-secondary mb-6 flex items-center gap-2"><Mail className="h-6 w-6" /> Send a Message</h2>
            {submitted ? (
              <div className="text-center py-12">
                <div className="flex flex-col items-center gap-4">
                  <Send className="h-10 w-10 text-primary animate-bounce-gentle" />
                  <div className="text-2xl font-bold text-primary">Thank you!</div>
                  <div className="text-gray-700">Your message has been sent. We'll get back to you soon.</div>
                  <Button variant="outline" className="mt-4" onClick={() => setSubmitted(false)}>Send Another</Button>
                </div>
              </div>
            ) : (
              <form
                className="space-y-6"
                onSubmit={e => {
                  e.preventDefault();
                  setSubmitted(true);
                }}
              >
                <div className="grid grid-cols-1 md:grid-cols-2 gap-4">
                  <div>
                    <label className="block text-gray-700 font-medium mb-1" htmlFor="name">Your Name</label>
                    <Input id="name" type="text" placeholder="Enter your name" required />
                  </div>
                  <div>
                    <label className="block text-gray-700 font-medium mb-1" htmlFor="email">Your Email</label>
                    <Input id="email" type="email" placeholder="Enter your email" required />
                  </div>
                </div>
                <div>
                  <label className="block text-gray-700 font-medium mb-1" htmlFor="subject">Subject</label>
                  <Input id="subject" type="text" placeholder="Subject" required />
                </div>
                <div>
                  <label className="block text-gray-700 font-medium mb-1" htmlFor="message">Your Message</label>
                  <textarea id="message" className="w-full border rounded px-3 py-2 min-h-[100px] focus:ring-2 focus:ring-primary/30" rows={4} placeholder="Type your message..." required />
                </div>
                <Button type="submit" className="w-full flex items-center justify-center gap-2 bg-gradient-to-r from-primary to-secondary text-white font-bold text-lg shadow hover:from-secondary hover:to-primary transition-colors">
                  <Send className="h-5 w-5" /> Send Message
                </Button>
              </form>
            )}
          </div>
        </div>
      </section>
      {/* Map or Illustration Card (optional, placeholder) */}
      {/* <section className="max-w-5xl mx-auto px-4 pb-16">
        <div className="bg-white/95 rounded-2xl shadow-xl p-8 flex flex-col md:flex-row items-center gap-8 border border-primary/10 hover:shadow-2xl transition-shadow duration-300">
          <div className="flex-1">
            <h3 className="text-xl font-bold text-primary mb-2">Visit Us</h3>
            <p className="text-gray-700 mb-2">Nairobi, Kenya</p>
            <p className="text-gray-500 text-sm">We welcome you to our offices for any in-person inquiries or partnership discussions. Please schedule an appointment in advance.</p>
          </div>
          <div className="flex-1 w-full h-48 md:h-40 rounded-xl overflow-hidden bg-gray-100 flex items-center justify-center">
          
            <span className="text-gray-400">[Map or Illustration Here]</span>
          </div>
        </div>
      </section> */}
      <Footer />
    </div>
  );
};

export default Contact; 