import Header from "@/components/frontend/layout/Header";
import Footer from "@/components/frontend/sections/Footer";
import { Trophy, Users, Award, Star, Quote, Calendar, ShieldCheck, Globe, TrendingUp, UserCircle } from "lucide-react";

interface TournamentAchievement {
  year: number;
  title: string;
  description: string;
  participants: string;
}

interface Testimonial {
  name: string;
  role: string;
  team: string;
  image: string;
  rating: number;
  quote: string;
  achievement: string;
}

interface TournamentStat {
  label: string;
  value: string;
  icon: string;
}

interface TournamentHighlight {
  icon: string;
  title: string;
  description: string;
  value: string;
  color: string;
}

interface Sponsor {
  name: string;
  category: string;
  logo: string;
  description: string;
  tier: string;
}

interface TimelineItem {
  year: number;
  event: string;
  icon: string;
}

interface WhyJoinItem {
  title: string;
  desc: string;
  icon: string;
}

interface GalleryImage {
  src: string;
  alt: string;
}

interface Organizer {
  name: string;
  role: string;
  img: string;
}

interface AboutProps {
  tournamentAchievements: TournamentAchievement[];
  testimonials: Testimonial[];
  tournamentStats: TournamentStat[];
  tournamentHighlights: TournamentHighlight[];
  sponsors: Sponsor[];
  timeline: TimelineItem[];
  whyJoin: WhyJoinItem[];
  galleryImages: GalleryImage[];
  organizers: Organizer[];
}

const About = ({ 
  tournamentAchievements, 
  testimonials, 
  tournamentStats, 
  tournamentHighlights, 
  sponsors, 
  timeline, 
  whyJoin, 
  galleryImages, 
  organizers 
}: AboutProps) => {
  // Icon mapping for dynamic icons
  const getIconComponent = (iconName: string) => {
    const iconMap: { [key: string]: any } = {
      'Trophy': Trophy,
      'Users': Users,
      'Award': Award,
      'ShieldCheck': ShieldCheck,
      'TrendingUp': TrendingUp,
      'UserCircle': UserCircle,
    };
    return iconMap[iconName] || Trophy;
  };

  return (
    <div className="min-h-screen bg-background">
      <Header />
      {/* Hero Section */}
      <section className="relative flex items-center justify-center h-[380px] md:h-[480px] bg-gradient-to-br from-primary/90 to-secondary/90 overflow-hidden">
        <img src="/images/logo.jpg"
          alt="Tournament Hero"
          className="absolute inset-0 w-full h-full object-cover opacity-20 pointer-events-none select-none scale-110"
        />
        <div className="absolute inset-0 bg-gradient-to-b from-black/60 to-black/80" />
        <div className="relative z-10 text-center text-white flex flex-col items-center justify-center w-full animate-fade-in-up">
          <Trophy className="mx-auto mb-4 h-16 w-16 text-green-700 animate-bounce-gentle" />
          <h1 className="text-5xl md:text-6xl font-extrabold drop-shadow mb-4 tracking-tight">The Milimus Tournament</h1>
          <p className="text-xl md:text-2xl max-w-2xl mx-auto drop-shadow font-medium">
            The region's premier football event, uniting teams, fans, and communities in the spirit of sportsmanship and excellence.
          </p>
        </div>
      </section>
      
      {/* Stats Section */}
      {/* <section className="w-full bg-gradient-to-r from-primary/10 to-secondary/10 py-10 md:py-16">
        <div className="max-w-7xl px-4 sm:px-6 lg:px-8 mx-auto flex flex-wrap justify-center gap-8 md:gap-16">
          {tournamentStats.map((stat, i) => (
            <div key={i} className="flex flex-col items-center">
              <div className="text-4xl mb-2">{stat.icon}</div>
              <div className="text-3xl md:text-4xl font-bold text-secondary mb-1">{stat.value}</div>
              <div className="text-gray-700 text-lg font-medium">{stat.label}</div>
            </div>
          ))}
        </div>
      </section> */}

      {/* Why Join Section */}
      <section className="max-w-6xl mx-auto py-16 px-4">
        <h2 className="text-3xl md:text-4xl font-bold text-center mb-10 text-primary">Why Join Us?</h2>
        <div className="grid grid-cols-1 md:grid-cols-4 gap-8">
          {whyJoin.map((item, i) => {
            const IconComponent = getIconComponent(item.icon);
            return (
              <div key={i} className="bg-white rounded-2xl shadow-lg p-8 flex flex-col items-center text-center hover:shadow-2xl transition-shadow duration-300 group">
                <IconComponent className="h-10 w-10 mb-4 text-secondary group-hover:scale-110 transition-transform" />
                <div className="text-xl font-semibold mb-2 text-primary group-hover:text-secondary">{item.title}</div>
                <div className="text-gray-600 text-base">{item.desc}</div>
              </div>
            );
          })}
        </div>
      </section>

      {/* Mission & Vision Section */}
      <section className="flex flex-col items-center justify-center py-12 px-2 bg-gradient-to-br from-primary/5 to-secondary/5">
        <div className="w-full max-w-7xl bg-white rounded-2xl shadow-xl p-8 md:p-12 mb-2 relative z-20 animate-fade-in-up">
          <div className="flex flex-col md:flex-row md:items-center md:space-x-8">
            <div>
              <h2 className="text-2xl md:text-3xl font-bold text-secondary mb-2">What Makes Us Unique?</h2>
              <ul className="list-disc pl-6 text-gray-700 space-y-2 text-lg">
                  <li className="flex items-center gap-2"><Star className="h-5 w-5 text-yellow-400" />Open to all registered teams and players, regardless of background.</li>
                <li className="flex items-center gap-2"><Star className="h-5 w-5 text-yellow-400" />Professional officiating and state-of-the-art facilities.</li>
                <li className="flex items-center gap-2"><Star className="h-5 w-5 text-yellow-400" />Comprehensive support for teams, including registration, fixtures, and certificates.</li>
                <li className="flex items-center gap-2"><Star className="h-5 w-5 text-yellow-400" />Attractive prizes and recognition for outstanding performance.</li>
                <li className="flex items-center gap-2"><Star className="h-5 w-5 text-yellow-400" />Commitment to fair play, safety, and community engagement.</li>
              </ul>
            </div>
          </div>
        </div>
      </section>

      <section className="py-20">
          <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div className="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
              {/* Founder Image */}
              <div className="relative">
                <div className="aspect-square rounded-2xl bg-gradient-to-br from-primary/20 to-primary/10 overflow-hidden">
                  <div className="w-full h-full flex items-center justify-center">
                    <div className="text-center">
                      <div className="w-32 h-32 mx-auto mb-4 rounded-full bg-primary/20 flex items-center justify-center">
                        <Trophy className="w-16 h-16 text-primary" />
                      </div>
                      <h3 className="text-2xl font-bold text-foreground">Fadhili Milimu</h3>
                      <p className="text-muted-foreground">Founder & Tournament Director</p>
                      <p className="text-sm text-muted-foreground mt-1">0729565643</p>
                    </div>
                  </div>
                </div>
              </div>

              {/* Message Content */}
              <div className="space-y-6">
                <div className="flex items-center gap-2 mb-6">
                  <Quote className="w-8 h-8 text-primary" />
                  <h2 className="text-3xl font-bold text-foreground">Message from Our Founder</h2>
                </div>
                
                <div className="space-y-4 text-lg text-muted-foreground leading-relaxed">
                  <p>
                    Dear Football Enthusiasts and Community Members,
                  </p>
                  
                  <p>
                    The motivation to start this tournament in my village which has gained popularity over the last three years was motivated by the loss of my dad way back in 2021 March. He was instrumental in changing our village to a more literate and little known village to the world by establishing a prayer mountain where people all over the world come and pray as they seek for blessing.
                  </p>
                  
                  <p>
                    Upon his death I was faced with a hard task as the first born on what I will do to remember this honourable man. The idea of having a football tournament was born in 2021 December where until now I have been financing it myself without any support financially from anyone.
                  </p>
                  
                  <p>
                    My village has really been neglected to the extent that children are dropping out of school. One of my initiatives is to form a foundation in memory of my dad to support the needy in the community through schools but leverage on sports to enable them also achieve their dream.
                  </p>
                  
                  <p>
                    In my village football is everything, so the best way to keep this young generation busy is through such sports by having a tournament where teams within my community can meet and play against each other through a noble course.
                  </p>
                  
                  <div className="bg-primary/10 p-4 rounded-lg border-l-4 border-primary">
                    <p className="font-semibold text-foreground">
                      Tournament Growth: From 500 spectators in 2021 to over 2,000 expected in 2023
                    </p>
                    <p className="text-sm mt-2">
                      • 2021: 8 Men's teams, 2 Ladies' teams, 500 spectators<br/>
                      • 2022: 10 Men's teams, 2 Ladies' teams, 1,200 spectators<br/>
                      • 2023: 12 Men's teams, 4 Ladies' teams, 2,000-3,000 expected spectators
                    </p>
                  </div>
                  
                  <p className="font-semibold text-foreground">
                    My aim is to have this tournament take place annually in December every year. All I need is support from established partners to make this tournament a success and give our community the recognition it deserves.
                  </p>
                  
                  <p className="text-primary font-medium">
                    <a href="/founders-message" className="text-primary font-medium hover:underline hover:text-secondary">Read the complete founder's message</a>
                  </p>
                </div>
              </div>
            </div>
          </div>
        </section>

      {/* Tournament Highlights Gallery */}
      <section className="max-w-6xl mx-auto py-16 px-4">
        <h2 className="text-2xl md:text-3xl font-bold text-center mb-6 text-primary">Tournament Highlights</h2>
        <div className="overflow-x-auto">
          <div className="flex md:grid md:grid-cols-3 gap-4 min-w-[600px] md:min-w-0">
            {galleryImages.map((image, i) => (
              <div key={i} className="overflow-hidden rounded-xl shadow hover:scale-105 transition-transform duration-300 bg-gray-100 relative group">
                <img src={image.src} alt={image.alt} className="w-full h-40 object-cover group-hover:opacity-80 transition-opacity" />
                <div className="absolute inset-0 bg-black/20 opacity-0 group-hover:opacity-100 transition-opacity flex items-center justify-center">
                  <span className="text-white text-lg font-semibold">{image.alt}</span>
                </div>
              </div>
            ))}
          </div>
        </div>
      </section>

      {/* Timeline Section */}
      <section className="max-w-7xl mx-auto py-16 px-4">
        <h2 className="text-2xl md:text-3xl font-bold text-center mb-10 text-secondary">Our Journey</h2>
        <div className="relative flex flex-col md:flex-row items-center justify-center gap-8 md:gap-0">
          {/* Timeline line evenly spaced */}
          <div className="hidden md:block absolute left-0 right-0 top-1/2 h-1 bg-gradient-to-r from-primary to-secondary z-0 flex justify-center space-evenly" style={{transform: 'translateY(-50%)', marginLeft: '10%', marginRight: '10%'}} />
          {timeline.map((item, i) => {
            const IconComponent = getIconComponent(item.icon);
            return (
              <div key={i} className="relative z-10 flex flex-col items-center md:w-1/5 w-full mb-12 md:mb-0 group">
                {/* Icon and year badge */}
                <div className="flex flex-col items-center mb-2">
                  <div className="bg-gradient-to-br from-primary to-secondary text-white rounded-full w-16 h-16 flex items-center justify-center text-3xl shadow-lg border-4 border-white group-hover:scale-110 transition-transform">
                    <IconComponent className="h-8 w-8" />
                  </div>
                  <div className="mt-2 px-3 py-1 rounded-full bg-primary/90 text-white text-sm font-bold shadow">{item.year}</div>
                </div>
                {/* Event card */}
                <div className="bg-white rounded-xl shadow-lg p-4 mt-4 w-full max-w-xs text-center border border-gray-100 animate-fade-in-up group-hover:shadow-2xl transition-shadow duration-300">
                  <div className="text-gray-700 text-base font-medium">{item.event}</div>
                </div>
                {/* Connecting line for mobile */}
                {i < timeline.length - 1 && (
                  <div className="block md:hidden w-1 h-8 bg-gradient-to-b from-primary to-secondary my-2" />
                )}
              </div>
            );
          })}
        </div>
      </section>

      {/* Organizers Section */}
      {/* <section className="max-w-6xl mx-auto py-16 px-4">
        <h2 className="text-2xl md:text-3xl font-bold text-center mb-10 text-primary">Meet the Organizers</h2>
        <div className="grid grid-cols-1 md:grid-cols-3 gap-8">
          {organizers.map((org, i) => (
            <div key={i} className="bg-white rounded-2xl shadow-lg p-8 flex flex-col items-center text-center hover:shadow-2xl transition-shadow duration-300">
              <img src={org.img} alt={org.name} className="w-20 h-20 rounded-full mb-4 border-2 border-primary object-cover" />
              <div className="text-xl font-semibold mb-1 text-primary">{org.name}</div>
              <div className="text-gray-600 text-base mb-2">{org.role}</div>
              <UserCircle className="h-6 w-6 text-secondary" />
            </div>
          ))}
        </div>
      </section> */}

      {/* Testimonials */}
      <section className="max-w-6xl mx-auto py-16 px-4">
        <h2 className="text-2xl md:text-3xl font-bold text-center mb-6 text-secondary">What People Are Saying</h2>
        <div className="grid md:grid-cols-3 gap-6">
          {testimonials.map((t, i) => (
            <div key={i} className="bg-gradient-to-br from-primary/10 to-secondary/10 rounded-xl shadow-lg p-6 flex flex-col items-center text-center border border-gray-100 hover:shadow-2xl transition-shadow duration-300">
              <Quote className="h-6 w-6 text-primary mb-2" />
              <img src={t.image} alt={t.name} className="w-24 h-24 rounded-full mb-3 border-2 border-primary object-cover" />
              <p className="text-gray-700 italic mb-3">"{t.quote}"</p>
              <div className="font-semibold text-primary">{t.name}</div>
              <div className="text-sm text-gray-500">{t.team}</div>
            </div>
          ))}
        </div>
      </section>

      {/* Sponsors Section */}
      {/* <section className="max-w-6xl mx-auto py-16 px-4">
        <h2 className="text-2xl md:text-3xl font-bold text-center mb-10 text-primary">Our Partners & Sponsors</h2>
        <div className="grid grid-cols-2 md:grid-cols-4 gap-8 items-center justify-center">
          {sponsors.map((s, i) => (
            <div key={i} className="flex flex-col items-center">
              <div className="text-4xl mb-2">{s.logo}</div>
              <div className="text-gray-700 text-base font-medium">{s.name}</div>
            </div>
          ))}
        </div>
      </section> */}

      {/* Call to Action */}
      <section className="py-16 bg-gradient-to-r from-primary/20 to-secondary/20">
        <div className="max-w-2xl mx-auto text-center">
          <h2 className="text-2xl md:text-3xl font-bold mb-4 text-primary">Ready to Join the Action?</h2>
          <p className="mb-6 text-lg text-gray-700">Register your team today and be part of the most exciting football tournament of the year!</p>
          <a href="/register" className="inline-block px-8 py-3 rounded-full bg-gradient-to-r from-primary to-secondary text-white font-bold text-lg shadow hover:from-secondary hover:to-primary transition-colors">Register Now</a>
        </div>
      </section>
      <Footer />
    </div>
  );
};

export default About; 