import React from 'react';
import { Head } from '@inertiajs/react';
import AppLayout from '@/layouts/app-layout';
import UsersTable from '@/components/users/users-table';

interface Props {
  users: {
    data: any[];
    current_page: number;
    last_page: number;
    per_page: number;
    total: number;
  };
  roles: any[];
  filters: {
    search: string;
    role: string;
    status: string;
    sort_by: string;
    sort_order: string;
  };
}

const UsersIndex: React.FC<Props> = ({ users, roles, filters }) => {
  return (
    <AppLayout breadcrumbs={[{ title: 'Users', href: '/admin/users' }]}> 
      <Head title="Users Management" />
      
      <div className="space-y-6 p-4 flex flex-col gap-4">
        {/* Header */}
       
        {/* Users Table */}
        <UsersTable
          users={users}
          roles={roles}
          filters={filters}
        />
      </div>
    </AppLayout>
  );
};

export default UsersIndex; 