import React, { useState } from 'react';
import { Head } from '@inertiajs/react';
import { router } from '@inertiajs/react';
import { Button } from '@/components/ui/button';
import { ArrowLeft, Save, UserPlus } from 'lucide-react';
import AppLayout from '@/layouts/app-layout';
import UserForm from '@/components/users/user-form';

interface Props {
  roles: any[];
}

const CreateUser: React.FC<Props> = ({ roles }) => {
  const [isSubmitting, setIsSubmitting] = useState(false);
  const [errors, setErrors] = useState<any>({});
  const [form, setForm] = useState({
    name: '',
    email: '',
    password: '',
    password_confirmation: '',
    roles: [],
    email_verified_at: true,
    send_welcome_email: true,
    // KYC fields
    phone: '',
    id_number: '',
    passport_number: '',
    date_of_birth: '',
    gender: '',
    nationality: '',
    county: '',
    sub_county: '',
    ward: '',
    address: '',
    postal_code: '',
    occupation: '',
    employer: '',
    emergency_contact_name: '',
    emergency_contact_phone: '',
    emergency_contact_relationship: '',
    bio: '',
    kyc_status: 'not_submitted',
    kyc_notes: '',
  });

  const handleSubmit = (e: React.FormEvent) => {
    e.preventDefault();
    setIsSubmitting(true);
    setErrors({});

    router.post(route('admin.users.store'), form, {
      onSuccess: () => {
        setIsSubmitting(false);
      },
      onError: (errors) => {
        setErrors(errors);
        setIsSubmitting(false);
      },
    });
  };

  return (
    <AppLayout breadcrumbs={[{ title: 'Users', href: '/admin/users' }]}> 
      <Head title="Create User" />
      
      <div className="space-y-6 p-4 flex flex-col gap-4">
        {/* Header */}
        <div className="flex items-center gap-4">
          <Button
            variant="outline"
            size="sm"
            onClick={() => router.get(route('admin.users.index'))}
          >
            <ArrowLeft className="w-4 h-4 mr-2" />
            Back to Users
          </Button>
          
        </div>

        {/* Form */}
        <form onSubmit={handleSubmit} className="space-y-6">
          <UserForm
            form={form}
            setForm={setForm}
            errors={errors}
            roles={roles}
            isEditing={false}
          />

          {/* Submit Actions */}
          <div className="flex items-center justify-end gap-4 p-6 bg-muted/50 rounded-lg">
            <Button
              type="button"
              variant="outline"
              onClick={() => router.get(route('admin.users.index'))}
              disabled={isSubmitting}
            >
              Cancel
            </Button>
            <Button 
              type="submit" 
              disabled={isSubmitting}
              className="bg-green-600 hover:bg-green-700"
            >
              <Save className="w-4 h-4 mr-2" />
              {isSubmitting ? 'Creating...' : 'Create User'}
            </Button>
          </div>
        </form>
      </div>
        </AppLayout>
  );
};

export default CreateUser; 