import React from 'react';
import { Head, router } from '@inertiajs/react';
import AppLayout from '@/layouts/app-layout';
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from '@/components/ui/card';
import RoleForm from './form';

interface Permission {
  id: number;
  name: string;
  display_name: string;
  description: string;
  category: string;
  is_system: boolean;
  is_active: boolean;
}

interface Props {
  permissions: Record<string, Permission[]>;
  categories: Record<string, string>;
}

const RoleCreate: React.FC<Props> = ({ permissions, categories }) => {
  const handleSubmit = (data: any) => {
    router.post(route('admin.roles.store'), data, {
      onSuccess: () => {
        // Redirect will be handled by the controller
      },
      onError: (errors) => {
        console.error('Validation errors:', errors);
      }
    });
  };

  const handleCancel = () => {
    router.visit(route('admin.roles.index'));
  };

  return (
    <AppLayout breadcrumbs={[
      { title: 'Roles', href: '/admin/roles' },
      { title: 'Create Role', href: '/admin/roles/create' }
    ]}>
      <Head title="Create Role" />
      
      <div className="space-y-6 p-4">
        <div>
          <h1 className="text-3xl font-bold">Create New Role</h1>
          <p className="text-muted-foreground">
            Create a new role with specific permissions and settings
          </p>
        </div>

        <Card>
          <CardHeader>
            <CardTitle>Role Configuration</CardTitle>
            <CardDescription>
              Fill in the details below to create a new role. All fields marked with * are required.
            </CardDescription>
          </CardHeader>
          <CardContent>
            <RoleForm
              permissions={permissions}
              categories={categories}
              isEditing={false}
              onSubmit={handleSubmit}
              onCancel={handleCancel}
            />
          </CardContent>
        </Card>
      </div>
    </AppLayout>
  );
};

export default RoleCreate;
