import React from 'react';
import AppLayout from '@/layouts/app-layout';
import MediaManager from '@/components/MediaManager';
import { Button } from '@/components/ui/button';
import { MediaFile } from '@/types/media';

const MediaTestPage = () => {
  const handleFileSelect = (file: any) => {
    alert(`Selected: ${file.name}`);
  };

  const handleMultipleSelect = (files: MediaFile | MediaFile[]) => {
    alert(`Selected ${files.length} files`);
  };

  return (
    <AppLayout> 
      <div className="space-y-6 p-6">
        

        <div className="grid grid-cols-1 md:grid-cols-2 gap-6">
          {/* Single File Selection */}
          <div className="border rounded-lg p-4">
            <h2 className="text-lg font-semibold mb-3">Single File Selection</h2>
            <MediaManager
              onSelect={handleFileSelect}
              multiple={false}
              acceptedTypes={['image/*']}
              className="w-full"
            />
          </div>

          {/* Multiple File Selection */}
          <div className="border rounded-lg p-4">
            <h2 className="text-lg font-semibold mb-3">Multiple File Selection</h2>
            <MediaManager
              onSelect={handleMultipleSelect}
              multiple={true}
              maxFiles={5}
              acceptedTypes={['image/*', 'video/*']}
              className="w-full"
            />
          </div>

          {/* Custom Trigger */}
          <div className="border rounded-lg p-4">
            <h2 className="text-lg font-semibold mb-3">Custom Trigger</h2>
            <MediaManager
              trigger={
                <Button variant="destructive">
                  Upload Images
                </Button>
              }
              onSelect={handleFileSelect}
              acceptedTypes={['image/*']}
            />
          </div>

          {/* Document Upload */}
          <div className="border rounded-lg p-4">
            <h2 className="text-lg font-semibold mb-3">Document Upload</h2>
            <MediaManager
              onSelect={handleFileSelect}
              acceptedTypes={['application/pdf', 'text/*']}
              collection="documents"
              className="w-full"
            />
          </div>
        </div>

        <div className="border rounded-lg p-4">
          <h2 className="text-lg font-semibold mb-3">All File Types</h2>
          <MediaManager
            onSelect={handleMultipleSelect}
            multiple={true}
            maxFiles={10}
            className="w-full"
          />
        </div>
      </div>
    </AppLayout>
  );
};

export default MediaTestPage; 