import React from 'react';
import { Head } from '@inertiajs/react';
import AppLayout from '@/layouts/app-layout';
import VlogVideoForm from './form';

interface VlogVideo {
  id: number;
  title: string;
  description?: string;
  platform: string;
  video_url: string;
  thumbnail_url?: string;
  duration?: number;
  views?: number;
  likes?: number;
  category: string;
  tags?: string[];
  featured: boolean;
  status: string;
  published_at?: string;
  sort_order: number;
}

interface Props {
  vlogVideo: VlogVideo;
  categories: Record<string, string>;
  platforms: Record<string, string>;
}

const VlogVideoEdit = ({ vlogVideo, categories, platforms }: Props) => {
  return (
    <AppLayout>
      <Head title="Edit Vlog Video" />
      <VlogVideoForm 
        vlogVideo={vlogVideo} 
        categories={categories} 
        platforms={platforms} 
      />
    </AppLayout>
  );
};

export default VlogVideoEdit; 
